% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perm.net.links.single.R
\name{perm.net.links.single}
\alias{perm.net.links.single}
\title{Matrix edge permutations}
\usage{
perm.net.links.single(
  M,
  sym = FALSE,
  erase.diag = TRUE,
  nperm,
  progress = TRUE
)
}
\arguments{
\item{M}{a square adjacency matrix .}

\item{sym}{if \emph{true} will vectorize only the lower triangle.}

\item{erase.diag}{if \emph{true} will not keep the diagonal of the matrix.}

\item{nperm}{number of permutations wanted.}

\item{progress}{a boolean indicating if the permutation process has to be visible.}
}
\value{
list of square  matrices of length nperm + 1.
}
\description{
Permute matrix links.
}
\details{
Edge permutations can be used to create random networks based on the observed network. Such permutation method is useful when analysing patterns of interactions such as assortativity.
}
\author{
Sebastian Sosa, Ivan Puga-Gonzalez.
}
\keyword{internal}
