/*******************************************************************************
 * Copyright (C) 2004-2007 Intel Corp. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *   - Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 * 
 *   - Redistributions in binary form must reproduce the above copyright notice,
 *     this list of conditions and the following disclaimer in the documentation
 *     and/or other materials provided with the distribution.
 * 
 *   - Neither the name of Intel Corp. nor the names of its
 *     contributors may be used to endorse or promote products derived from this
 *     software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL Intel Corp. OR THE CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *******************************************************************************/

// Define an Interface Guid for HECI device class.
// This GUID is used to register (IoRegisterDeviceInterface)
// an instance of an interface so that user application
// can control the HECI device.
//

// GUID definition are required to be outside of header inclusion pragma to avoid
// error during precompiled headers.
//

#ifndef __HECI_IF_H__
#define __HECI_IF_H__

typedef enum _HECI_STATUS{

	HECI_STATUS_OK		= 0x0,
	HECI_STATUS_GENERAL_ERROR	= 0x2000,
	HECI_STATUS_LOCATE_DEVICE_ERROR,
	HECI_STATUS_MEMORY_ACCESS_ERROR,
	HECI_STATUS_WRITE_REGISTER_ERROR,
	HECI_STATUS_MEMORY_ALLOCATION_ERROR,
	HECI_STATUS_BUFFER_OVEREFLOW_ERROR,
	HECI_STATUS_NOT_ENOUGH_MEMORY,
	HECI_STATUS_MSG_TRANSMISSION_ERROR,
	HECI_STATUS_VERSION_MISMATCH,
	HECI_STATUS_UNEXPECTED_INTERRUPT_REASON,
	HECI_STATUS_TIMEOUT_ERROR,
	HECI_STATUS_UNEXPECTED_RESPONSE,
	HECI_STATUS_UNKNOWN_MESSAGE,
	HECI_STATUS_CANNOT_FOUND_HOST_CLIENT,
	HECI_STATUS_CANNOT_FOUND_ME_CLIENT,
	HECI_STATUS_CLIENT_ALREADY_CONNECTED,
	HECI_STATUS_NO_FREE_CONNECTION,
	HECI_STATUS_ILLEGAL_PARAMETER,
	HECI_STATUS_FLOW_CONTROL_ERROR,
	HECI_STATUS_NO_MESSAGE,
	HECI_STATUS_BUFFER_TOO_LARGE,
	HECI_STATUS_BUFFER_TOO_SMALL,
	HECI_STATUS_BUFFER_NOT_EMPTY,
	NUM_OF_HECI_STATUSES
}HECI_STATUS;



#define DEFINE_GUID(n,l,w1,w2,b1,b2,b3,b4,b5,b6,b7,b8) extern const GUID n = {l,w1,w2,{b1,b2,b3,b4,b5,b6,b7,b8}}




#define FILE_DEVICE_HECI  0x8000

// Define Interface reference/dereference routines for
// Interfaces exported by IRP_MN_QUERY_INTERFACE

#define HECI_IOCTL(index) \
	CTL_CODE(FILE_DEVICE_HECI, index, METHOD_BUFFERED, FILE_READ_DATA)

#define IOCTL_HECI_GET_VERSION \
	CTL_CODE(FILE_DEVICE_HECI, 0x800, METHOD_BUFFERED, FILE_READ_ACCESS|FILE_WRITE_ACCESS)
#define IOCTL_HECI_CONNECT_CLIENT \
	CTL_CODE(FILE_DEVICE_HECI, 0x801, METHOD_BUFFERED, FILE_READ_ACCESS|FILE_WRITE_ACCESS)
#define IOCTL_HECI_WD \
	CTL_CODE(FILE_DEVICE_HECI, 0x802, METHOD_BUFFERED, FILE_READ_ACCESS|FILE_WRITE_ACCESS)

#pragma pack(1)
typedef struct _HECI_VERSION
{
	UINT8 major;
	UINT8 minor;
	UINT8 hotfix;
	UINT16 build;
} HECI_VERSION;

typedef struct _HECI_CLIENT
{
	UINT32                  MaxMessageLength;
	UINT8                   ProtocolVersion;
} HECI_CLIENT;


#pragma pack( )


#endif // __HECI_IF_H__
