
package ONVIF::Device::Elements::SetRelayOutputSettings;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'http://www.onvif.org/ver10/device/wsdl' }

__PACKAGE__->__set_name('SetRelayOutputSettings');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();

use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    SOAP::WSDL::XSD::Typelib::ComplexType
);

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %RelayOutputToken_of :ATTR(:get<RelayOutputToken>);
my %Properties_of :ATTR(:get<Properties>);

__PACKAGE__->_factory(
    [ qw(        RelayOutputToken
        Properties

    ) ],
    {
        'RelayOutputToken' => \%RelayOutputToken_of,
        'Properties' => \%Properties_of,
    },
    {
        'RelayOutputToken' => 'ONVIF::Device::Types::ReferenceToken',
        'Properties' => 'ONVIF::Device::Types::RelayOutputSettings',
    },
    {

        'RelayOutputToken' => 'RelayOutputToken',
        'Properties' => 'Properties',
    }
);

} # end BLOCK







} # end of BLOCK



1;


=pod

=head1 NAME

ONVIF::Device::Elements::SetRelayOutputSettings

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
SetRelayOutputSettings from the namespace http://www.onvif.org/ver10/device/wsdl.







=head1 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * RelayOutputToken

 $element->set_RelayOutputToken($data);
 $element->get_RelayOutputToken();




=item * Properties

 $element->set_Properties($data);
 $element->get_Properties();





=back


=head1 METHODS

=head2 new

 my $element = ONVIF::Device::Elements::SetRelayOutputSettings->new($data);

Constructor. The following data structure may be passed to new():

 {
   RelayOutputToken => $some_value, # ReferenceToken
   Properties =>  { # ONVIF::Device::Types::RelayOutputSettings
     Mode => $some_value, # RelayMode
     DelayTime =>  $some_value, # duration
     IdleState => $some_value, # RelayIdleState
   },
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

