/*
 * YICS: Connect a FICS interface to the Yahoo! Chess server.
 * Copyright (C) 2004  Chris Howie
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef _UTIL_H
#define _UTIL_H

#include "types.h"

extern unsigned i64_t htonll(unsigned i64_t);
#define ntohll(x) htonll(x)

#define phandle(x) (((x) == NULL) ? "[EMPTY]" : (x)->handle)

/*
 * strncpy doesn't null-terminate the string if it's too big.  This is, IMHO,
 * stupid.  This macro makes up for it.
 */
#define mstrncpy(dest,src,n) (strncpy((dest), (src), (n) - 1) \
		+ (0 & (((n) == 0) ? 0 : (dest[(n) - 1] = '\0'))))

/*
 * strncat takes the n parameter to mean the number of bytes to be written,
 * not the size of the string.  This is, IMHO, also stupid.
 *
 * Here, n specifies the size of dest.
 */
#define mstrncat(dest,src,n) strncat((dest), (src), (n) - strlen(dest) - 1)

extern char *ltrim(char *);
extern char *rtrim(char *);
#define trim(x) rtrim(ltrim(x))

extern String *ltrimString(String *);
extern String *rtrimString(String *);
#define trimString(x) rtrimString(ltrimString(x))

extern char   *packutf(char *, const char *, unsigned short);
extern String *packutfString(String *, const String *);
extern String *packutfStringP(String *, const String *);
extern char   *unpackutf(char *, const char *);
extern String *unpackutfString(String *, const String *);
extern String *unpackutfStringP(String *, String *);

extern char *uppercase(char *);
extern char *lowercase(char *);
extern int istrcmp(const char *, const char *);

extern int columns(char **);
extern bool isnumeric(const char *);
extern int s_strcmp(const void *, const void *);
extern int s_istrcmp(const void *, const void *);

extern i64_t gettimeofdayll(void);
extern i64_t timeleft(Table *, int);
extern char *fmttime_ms(i64_t);

#ifndef _YICS_POSIX
extern int gettimeofday(struct timeval * p, void * z);
#endif

#ifndef __GNUC__
extern char * optarg;
extern int optind;
extern int getopt (int argc, char * argv[], const char * optstr);
#endif

#endif
