/* xdaliclock - a melting digital clock
 * Copyright (c) 1991-2013 Jamie Zawinski <jwz@jwz.org>
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.  No representations are made about the suitability of this
 * software for any purpose.  It is provided "as is" without express or
 * implied warranty.
 */

#import "DaliPhoneAppDelegate.h"
#import "DaliClockView.h"

char *progname = "Dali Clock";   // digital.c wants this for error messages.

@implementation DaliPhoneAppDelegate

@synthesize window;
@synthesize contentView;


- (void)applicationDidFinishLaunching:(UIApplication *)application
{
  NSUserDefaults *defs = [NSUserDefaults standardUserDefaults];
  [DaliClockView registerDefaults:defs];

  // This does nothing, but suppresses a warning.
  [window setRootViewController: [[UIViewController alloc] init]];

  // Enable notification events (before creating the View)
  [[UIDevice currentDevice] beginGeneratingDeviceOrientationNotifications];

  contentView = [[DaliClockView alloc] initWithFrame:[window frame]];

  // Attach notification events to the view.
  [[NSNotificationCenter defaultCenter]
    addObserver:contentView
    selector:@selector(didRotate:)
    name:UIDeviceOrientationDidChangeNotification object:nil];

  [window addSubview:contentView];
  [window makeKeyAndVisible];

  // After the window is visible, so that we get motion events.
  [contentView becomeFirstResponder];

  /* Display the date every minute-and-a-bit.  That way it doesn't show up
     on the same second each minute.
   */
  [contentView setAutoDate:67];
}


- (void)applicationWillResignActive:(UIApplication *)app
{
  [contentView setScreenLocked:YES];
}


- (void)applicationDidBecomeActive:(UIApplication *)app
{
  [contentView setScreenLocked:NO];
}

- (void)applicationDidEnterBackground:(UIApplication *)application
{
  [contentView setScreenLocked:YES];
}


- (void)dealloc {
  [contentView release];
  [window release];
  [super dealloc];
}

@end
