#ifndef _HASHTABLE_H_
#define _HASHTABLE_H_

/*
 * hashtable.h
 *
 * a simple chaining hashtable interface
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

//
//	htable_t:	the hashtable struct
//	table:		an array of chained list ptrs
//	num_buckets:	the number of hashing 'buckets' in the table
//	size:		the hashtable's current size
//	hashcode:	ptr to a func that returns an int for hashable objs
//	compare:	func returns 0 if obj1 and obj2 are "equal"
//
typedef struct htable {
	struct list **table;
	int num_buckets;
	int size;
	int (*hashcode)(void *obj);
	int (*compare)(void *obj1, void *obj2);
} htable_t;

typedef struct list {
	void *info;
	struct list *lptr;
} ht_list_t;

//
//	ht_init:	initialize new hashtable
//		create hashtable of size buckets, using hashcode and
//		compare as hashing and comparing funcs, resp.
htable_t* ht_init(int size, int(*hashcode)(void *obj),
		int(*compare)(void *obj1, void *obj2));

//
//	ht_reset:	reset a hash table
//		delete all entries in ht
void ht_reset(htable_t *ht);

//
//	ht_find:	find object in hashtable
//		searches for obj in ht, returns either a ptr or NULL	
void *ht_find(void *obj, htable_t *ht);

//
//	ht_insert:	insert item into hashtable
//		insert obj into ht
void ht_insert(void *obj, htable_t *ht);

//
//	ht_remove:	remove item from hashtable
//		remove obj (if found) from ht
void ht_remove(void *obj, htable_t *ht);

//
//	ht_iter:	iterate items of a hashtable
//		iterate across ht, return a linked list of items
ht_list_t *ht_iter(htable_t *ht);

//
//	ht_free_iter:	free an iterated list of items
//		free l, and all ht_list_t entries underneath l
void ht_free_iter(ht_list_t *l);
#endif 
