#!/usr/bin/env python

# This file is part of Window-Switch.
# Copyright (c) 2009-2013 Antoine Martin <antoine@nagafix.co.uk>
# Window-Switch is released under the terms of the GNU GPL v3

import pygtk
pygtk.require("2.0")
import gtk

from winswitch.virt.nx_client_base import NXClientBase
from winswitch.virt.client_options_base import ClientOptionsBase
from winswitch.virt.options_common import BANDWIDTH
from winswitch.virt.nx_common import get_line_speed_str, BANDWIDTH_OPTIONS


class	NXClientUtil(NXClientBase, ClientOptionsBase):
	"""
	Adds clipboard and fullscreen widget options to NXClientBase
	"""


	def	__init__(self, update_session_status, notify_callback):
		NXClientBase.__init__(self, update_session_status, notify_callback)

	def get_bandwidth_widget(self, server, current_options, change_cb=None):
		""" A combo box where users can select the bandwidth """
		cb = gtk.combo_box_new_text()
		current_bw_value = get_line_speed_str(server.line_speed)
		if current_options and BANDWIDTH in current_options:
			try:
				current_bw_value = current_options[BANDWIDTH]
			except:
				pass
		i = 0
		for v in BANDWIDTH_OPTIONS:
			cb.append_text(v)
			if v==current_bw_value:
				cb.set_active(i)
			i += 1
		self.setup_combo_callback(cb, BANDWIDTH, change_cb)
		return cb

	def get_options_widgets(self, server, server_command, shadowed_session=None, current_options=None, default_options=None, change_cb=None):
		""" NX options: clipboard, fullscreen, bandwidth """
		options = self.get_options(current_options, default_options)
		widgets = [
					("Clipboard Sharing", self.get_clipboard_widget(server, options, change_cb)),
					("Display Fullscreen", self.get_fullscreen_widget(server, options, change_cb)),
					("Bandwidth", self.get_bandwidth_widget(server, options, change_cb))
				]
		if default_options is not None:	#not in edit mode
			self.add_timezone_locale_widgets(widgets, self.settings, server, options, change_cb)
			self.add_screen_size_widget(widgets, server, server_command, shadowed_session, options, change_cb)
		return widgets
