/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jxc;

import com.sun.mirror.apt.AnnotationProcessorFactory;
import com.sun.tools.jxc.Messages;
import com.sun.tools.jxc.apt.Options;
import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.api.util.APTClassLoader;
import com.sun.tools.xjc.api.util.ToolsJarNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaGenerator {
    private static final String[] packagePrefixes = new String[]{"com.sun.tools.jxc.", "com.sun.tools.xjc.", "com.sun.istack.tools.", "com.sun.tools.apt.", "com.sun.tools.javac.", "com.sun.tools.javadoc.", "com.sun.mirror."};

    public static void main(String[] args) throws Exception {
        System.exit(SchemaGenerator.run(args));
    }

    public static int run(String[] args) throws Exception {
        try {
            ClassLoader cl = SchemaGenerator.class.getClassLoader();
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
            APTClassLoader classLoader = new APTClassLoader(cl, packagePrefixes);
            return SchemaGenerator.run(args, classLoader);
        }
        catch (UnsupportedClassVersionError e) {
            System.err.println("schemagen requires JDK 5.0 or later. Please download it from http://java.sun.com/j2se/1.5/");
            return -1;
        }
        catch (ToolsJarNotFoundException e) {
            System.err.println(e.getMessage());
            return -1;
        }
    }

    public static int run(String[] args, ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Options options = new Options();
        if (args.length == 0) {
            SchemaGenerator.usage();
            return -1;
        }
        for (String arg : args) {
            if (arg.equals("-help")) {
                SchemaGenerator.usage();
                return -1;
            }
            if (!arg.equals("-version")) continue;
            System.out.println(Messages.VERSION.format(new Object[0]));
            return -1;
        }
        try {
            options.parseArguments(args);
        }
        catch (BadCommandLineException e) {
            System.out.println(e.getMessage());
            System.out.println();
            SchemaGenerator.usage();
            return -1;
        }
        Class<?> schemagenRunner = classLoader.loadClass(Runner.class.getName());
        Method mainMethod = schemagenRunner.getDeclaredMethod("main", String[].class);
        ArrayList<String> aptargs = new ArrayList<String>();
        if (SchemaGenerator.hasClass(options.arguments)) {
            aptargs.add("-XclassesAsDecls");
        }
        if (options.classpath != null) {
            aptargs.add("-cp");
            aptargs.add(options.classpath);
        }
        if (options.targetDir != null) {
            aptargs.add("-d");
            aptargs.add(options.targetDir.getPath());
        }
        aptargs.addAll(options.arguments);
        String[] argsarray = aptargs.toArray(new String[aptargs.size()]);
        return (Integer)mainMethod.invoke(null, new Object[]{argsarray});
    }

    private static boolean hasClass(List<String> args) {
        for (String arg : args) {
            if (arg.endsWith(".java")) continue;
            return true;
        }
        return false;
    }

    private static void usage() {
        System.out.println(Messages.USAGE.format(new Object[0]));
    }

    public static final class Runner {
        public static int main(String[] args) throws Exception {
            ClassLoader cl = Runner.class.getClassLoader();
            Class<?> apt = cl.loadClass("com.sun.tools.apt.Main");
            Method processMethod = apt.getMethod("process", AnnotationProcessorFactory.class, String[].class);
            return (Integer)processMethod.invoke(null, new com.sun.tools.jxc.apt.SchemaGenerator(), args);
        }
    }
}

