/*******************************************************************************
 * Part of "Intel(R) Active Management Technology (Intel(R) AMT)
 *                   User Notification Service (UNS)"
 *
 * Copyright (c) 2007 Intel Corp.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification.
 * 2. Redistributions in binary form must reproduce at minimum a disclaimer
 *    substantially similar to the "NO WARRANTY" disclaimer below
 *    ("Disclaimer") and any redistribution must be conditioned upon
 *    including a substantially similar Disclaimer requirement for further
 *    binary redistribution.
 * 3. Neither the names of the above-listed copyright holders nor the names
 *    of any contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * Alternatively, this software may be distributed under the terms of the
 * GNU General Public License ("GPL") version 2 as published by the Free
 * Software Foundation.
 *
 * NO WARRANTY
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *******************************************************************************/

//----------------------------------------------------------------------------
//
//  File:       EndpointReference.h
//
//  Contents:   C++ representation of an EndpointReference type
//
//----------------------------------------------------------------------------
#ifndef __ENDPOINT_REF_H
#define __ENDPOINT_REF_H

#include <map>
#include "Serializable.h"
#include "Deserializable.h"

using namespace std;

namespace CimClassNamespace
{
#define NameValuePairs map<string, string>

	class SelectorSet : public Serializable, public DeSerializable
	{
	public:
		NameValuePairs Selectors;
		SelectorSet();
		virtual ~SelectorSet();
		void SerializeMembers(XMLElement& elem) const;
		void SetValue(const XMLElement& elem);
	};

	class ReferenceParameters : public Serializable, public DeSerializable
	{
	private:
		string uri;
		SelectorSet Selectors;
	public:
		ReferenceParameters();
		virtual ~ReferenceParameters();
		void SerializeMembers(XMLElement& elem) const;
		NameValuePairs GetSelectors() const;
		void SetSelectors(const NameValuePairs &sel);
		void SetValue(const XMLElement& elem);
		void SetUri(const string& uri);
		string GetUri() const;
	};

	class EndpointReference : public Serializable, public DeSerializable
	{
	private:
		string eprName;
		string add;
		ReferenceParameters ref;
	public:
		EndpointReference(const string& name = "EndpointReference",
			const string& ns = "", const string& pref = "");
		virtual ~EndpointReference();
		string GetEPRName() const;
		void SetName(const string &name);
		void SetAddress(const string &add);
		string GetAddress() const;
		void SerializeMembers(XMLElement& elem) const;
		void SetValue(const XMLElement& elem);
		NameValuePairs GetSelectors() const;
		string GetResourceURI() const;
		void SetResourceUri(const string& uri);
		void SetSelectors(const NameValuePairs &sel);
		bool CompareResourceURI(const string &uri) const;
	};

	class ResourceCreated : public EndpointReference
	{
	public:
		ResourceCreated();
		virtual ~ResourceCreated();
	};
} //CimClassNamespace
#endif
