/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef AREAINTERFACE_H
#define AREAINTERFACE_H

#include <QObject>
#include <QtDBus>
#include "../universalinterface.h"

class AreaInterface : public QObject
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.ukui.ukcc.session.Area")
    Q_PROPERTY(QStringList formatCountryList READ getFormatCountryList)
    Q_PROPERTY(QStringList calendarList READ getCalendarList)
    Q_PROPERTY(QStringList firstDayList READ getFirstDayList)
    Q_PROPERTY(QStringList dateFormatList READ getDateFormatList)
    Q_PROPERTY(QStringList timeFormatList READ getTimeFormatList)
    Q_PROPERTY(QStringList languageList READ getLanguageList)
    Q_PROPERTY(QStringList showLanguageList READ getShowLanguageList)
    Q_PROPERTY(QString formatCountry READ getFormatCountry)
    Q_PROPERTY(QString calendar READ getCalendar)
    Q_PROPERTY(QString firstDay READ getFirstDay)
    Q_PROPERTY(QString dateFormat READ getDateFormat)
    Q_PROPERTY(QString timeFormat READ getTimeFormat)
    Q_PROPERTY(QString language READ getLanguage)

public:
     AreaInterface();
    ~AreaInterface();

protected:
    // 对属性的访问函数
    const QStringList getFormatCountryList();
    const QStringList getCalendarList();
    const QStringList getFirstDayList();
    const QStringList getDateFormatList();
    const QStringList getTimeFormatList();
    const QStringList getLanguageList();
    const QStringList getShowLanguageList();
    const QString getFormatCountry();
    const QString getCalendar();
    const QString getFirstDay();
    const QString getDateFormat();
    const QString getTimeFormat();
    const QString getLanguage();

public Q_SLOTS:
    /**
     * @brief 修改输入法
     *
     * @param inputMethodName 输入法名称
     * @param add 添加/移除
     */
    void changeInputMethod(const QString &inputMethod, const bool &add);

    /**
     * @brief 查询输入法是否已经添加
     *
     * @param inputMethodName 输入法名称
     * @return bool 返回输入法是否已经添加
     */
    bool isAddedInputMethod(const QString &inputMethod);

    // 对属性的设置函数
    void setFormatCountry(const QString &formatCountry);
    void setCalendar(const QString &calendar);
    void setFirstDay(const QString &firstDay);
    void setDateFormat(const QString &dateFormat);
    void setTimeFormat(const QString &timeFormat);
    void setShowLanguageList(const QStringList &languageList);
    void setLanguage(const QString &languageCode);

Q_SIGNALS:
    void changed(QString keyName);

private:
    void reloadInputMethodConfig();

    // 设置和获取gsetting的string类型的键值
    const QString gsettingGet(const QString &key) const;
    void gsettingSet(const QString &key, const QString &value);

private:
    const QString SHOW_LANGUAGE_KEY = QString("showlanguage");
    const QString FCITX_CONFIG_FILE = QDir::homePath() + "/.config/fcitx/profile";
    const QString CALENDAR_KEY      = QString("calendar");
    const QString FIRST_DAY_KEY     = QString("firstday");
    const QString DATE_FORMATE_KEY  = QString("date");
    const QString TIME_FORMAT_KEY   = QString("hoursystem");

private:
    QGSettings     *ukccPanelGsettings = nullptr;
    QDBusInterface *accountInterface   = nullptr;
    QDBusInterface *fcitxInterface     = nullptr;
    QGSettings     *styleGsettings     = nullptr;
private:
    QStringList mFormatCountryList = {};
    QStringList mCalendarList      = {};
    QStringList mFirstDayList      = {};
    QStringList mDateFormatList    = {};
    QStringList mtimeFormatList    = {};
    QStringList mShowLanguageList  = {};
    QStringList mLanguageList      = {};
    QString     mLanguage          = "";
    QString     mFormatCountry     = "";
    QString     mCalendar          = "";
    QString     mFirstDay          = "";
    QString     mDateFormat        = "";
    QString     mTimeFormat        = "";
};

#endif // AREAINTERFACE_H
