/*
 * Copyright(C) 1999-2021 National Technology & Engineering Solutions
 * of Sandia, LLC (NTESS).  Under the terms of Contract DE-NA0003525 with
 * NTESS, the U.S. Government retains certain rights in this software.
 *
 * See packages/seacas/LICENSE for details
 */
#ifndef EXODIFF_UTIL_H
#define EXODIFF_UTIL_H

#include <fmt/color.h>
#include <sstream>
#include <string>

int    name_length();
char **get_name_array(int size, int length);
void   free_name_array(char **names, int size);

void Error(const std::string &x);
void Error(std::ostringstream &buf);
void Warning(const std::string &x);
void ERR_OUT(std::ostringstream &buf);
void DIFF_OUT(std::ostringstream &buf, fmt::detail::color_type color = fmt::color::red);
void DIFF_OUT(const std::string &buf, fmt::detail::color_type color = fmt::color::red);

#endif
