#ifndef RBGEN_ISVD_MULTISDBUDV_H
#define RBGEN_ISVD_MULTISDBUDV_H

#include "RBGen_ISVDMultiSDB.h"
#include "RBGen_ISVDUDV.h"

namespace RBGen {

  //! IncSVD method implementing UDV storage with multiple steepest descent (variant B) passes.
  class ISVD_MultiSDBUDV : public virtual ISVDUDV, public virtual ISVDMultiSDB {
    public:
      //! @name Constructor/Destructor.
      //@{

      //! Default constructor.
      ISVD_MultiSDBUDV();

      //! Destructor.
      virtual ~ISVD_MultiSDBUDV() {};
      //@}

      //! @name Set Methods
      //@{

      //! Initialize the method with the given parameter list and snapshot set.
      void Initialize( const Teuchos::RCP< Teuchos::ParameterList >& params,
          const Teuchos::RCP< const Epetra_MultiVector >& init,
          const Teuchos::RCP< RBGen::FileIOHandler< Epetra_Operator > >& fileio = Teuchos::null );

      //@}
  };

} // end of RBGen namespace

#endif // RBGEN_ISVD_MULTISDBUDV_H
