-- Topal: GPG/GnuPG and Alpine/Pine integration
-- Copyright (C) 2001--2017  Phillip J. Brooke
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License version 3 as
-- published by the Free Software Foundation.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

with Keys;

package Externals.GPG is

   -- This returns the return value of GPG.
   -- This function also cleans up the error file to remove
   -- `gpg: Invalid passphrase; please try again ...' messages.
   -- ONLY USED FOR RECEIVING!
   function GPG_Tee (Input_File      : String;
                     Output_File     : String;
                     Err_File        : String;
		     Status_Filename : String) return Integer;
   function GPGSM_Tee (Input_File      : String;
		       Output_File     : String;
		       Err_File        : String;
		       Encoding_Arg    : String;
		       Status_Filename : String;
		       Verify          : Boolean) return Integer;

   -- This returns the return value of GPG.
   -- This function also cleans up the error file to remove
   -- `gpg: Invalid passphrase; please try again ...' messages.
   -- ONLY USED FOR RECEIVING (VERIFYING)!
   function GPG_Verify_Tee (Input_File      : String;
                            Sig_File        : String;
                            Output_File     : String;
                            Err_File        : String;
			    Status_Filename : String) return Integer;
   function GPGSM_Verify_Tee (Input_File      : String;
                              Sig_File        : String;
                              Output_File     : String;
                              Err_File        : String;
			      Status_Filename : String) return Integer;

   -- Determine the Micalg code from a file.
   Unrecognised_Micalg : exception;
   
   -- From the actual signature file.
   function Micalg_From_Filename (Sigfile : in String) return String;
   -- From the status-fd output.
   function Micalg_From_Status (Status_Filename : in String) return String;
   
   -- Search for Code in a status-fd file.
   function Grep_Status (Status_Filename : String;
			 Code            : String) return Boolean;

   -- Wrapper for GPG sending.
   GPG_Failed          : exception;

   -- The args should for GPG should be complete (except for the
   --  leading gpg).  The Out_Filename is for checking for the
   --  existence of an output file.  Status_Filename is where GnuPG's
   --  --status-fd output should be directed.
   -- ONLY USED FOR SENDING!
   procedure GPG_Wrap (Args            : in String;
                       Out_Filename    : in String;
		       Status_Filename : in String);
   procedure GPGSM_Wrap (Args            : in String;
			 Out_Filename    : in String;
			 Status_Filename : in String;
			 No_Exception    : in Boolean := False);
   
   -- A variant of GPGSM_Wrap.  We use this to allow us to fallback to
   --  using OpenSSL if GPGSM is whinging about unusable keys.
   procedure GPGSM_Wrap_Encrypt (Out_Filename    : in String;
				 Status_Filename : in String;
				 In_Filename     : in String;
				 Send_Keys       : in Keys.Key_List);
   
   -- Find a given key(s); dump into the Target filename.
   procedure Findkey (Key    : in String;
                      Target : in String;
		      SMIME  : in Boolean);

   -- Find a given secret key(s); dump into the Target filename.
   procedure Findkey_Secret (Key    : in String;
                             Target : in String;
			     SMIME  : in Boolean);

   -- List the details of a given key(s); dump into the Target filename.
   procedure Listkey (Key    : in String;
                      Target : in String;
		      SMIME  : in Boolean);

   -- View (with a pager) the given key(s); optionally verbosely.
   procedure Viewkey (Key     : in String;
                      Verbose : in Boolean;
		      SMIME   : in Boolean);
   
   -- Extract the uid's from a gpgsm -k $key.
   procedure Brief_View_SMIME_Key (Key    : in String;
				   Target : in String);
     
end Externals.GPG;
