C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=MOBRES,SSI=0
C
                     SUBROUTINE MOBRES
C                    *****************
C
C     -------------------------------------------------------------
     *(NPOINS,NBRESS,NRESCS,VRESCS,NREFS,
     * NODERC,NFRESC,VFRESC,NELERC,NDMASS,NREFAL,NELEUS,ITRAV1)
C     -------------------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C      FONCTION :                                                      *
C      ---------  AFFECTATION RESISTANCES DE CONTACT AUX 2 BOUTS       *
C                 DES 2 SOLIDES EN TRANSLATION                         *
C                                                                      *
C-----------------------------------------------------------------------
C		    (*)    (*)			ARGUMENTS
C   .___________.______._______________________________________________.
C   !    NOM    ! TYPE !MODE!                    ROLE                  !
C   !___________!______!____!__________________________________________!
C   !   NDIM    !   E  ! D  ! DIMENSION DU PROBLEME                    !
C   !   NPOINS  !   E  ! D  ! NOMBRE DE NOEUDS DU MAILLAGE             !
C   !   NBRESS  !   E  ! D  ! NB DE NOEUDS SOLIDES AVEC RES DE CONTACT !
C   !   NRESCS  !   E  ! D  ! NOEUDS AVEC RESISTANCE DE CONTACT        !
C   !   VRESCS  !  TR  ! M  ! CL SUR LES NOEUDS SOLIDES RES DE CONTACT !
C   !   NREFS   !  TE  ! D  ! REFERENCES NOEUDS SOLIDES                !
C   !  NODERC   !  TE  ! D  ! TABLE DES ELEMENTS SURF AVEC REST DE CONT!
C   !  NFRESC   !  TE  ! D  ! NUM DES FACES REST DE CONT DANS NODEUS   !
C   !  VFRESC   !  TR  ! M  ! RESISTANCES CONTACT SUR LES FACES        !
C   !  NELERC   !   E  ! D  ! NOMBRE D'ELETS AVEC RESTANCE DE CONTACT  !
C   !  NDMASS   !   E  ! D  ! NOMBRE DE NOEUDS DES ELTS AVEC RESIST    !
C   !  NREFAL   !  TE  ! D  ! REFERENCES DES FACES                     !
C   !  NELEUS   !   E  ! D  ! NOMBRE D'ELEMENTS SURF DE TYPE FLUX      !
C   !  ITRAV1   !  TE  ! A  ! TABLEAU DE TRAVAIL                       !
C   !___________!______!____!__________________________________________!
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELE(S)    : ----
C                                     
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELANT(S)  : RESSOL
C
C***********************************************************************
C
	IMPLICIT NONE
C
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "optct.h"
#include "mobil.h"
#include "xrefer.h"
C
C***********************************************************************
C
C..Variables externes
      INTEGER NPOINS,NBRESS,NRESCS(NBRESS,2),NREFS(NPOINS)
      DOUBLE PRECISION VRESCS(NBRESS,2)                                
      INTEGER NELERC,NDMASS
      INTEGER NODERC(NELERC,NDMASS)
      DOUBLE PRECISION VFRESC(NELERC,NDMASS,2)
      INTEGER NELEUS,NREFAL(NELEUS),ITRAV1(NPOINS),NFRESC(NELERC)
C
C..Variables internes
      INTEGER N,N1,NUMREF,M,NG,NL,NGC,NLC
      LOGICAL LBOUT
C
C***********************************************************************
C
C     1- CAS DES CONDITIONS AUX LIMITES PAR NOEUD
C     ===========================================
C
      IF (.NOT.LCFACE) THEN
C
      DO 100 N=1,NBRESS
C
        IF (NRESCS(N,2).EQ.-1) THEN
           VRESCS(N,1) = 0.
           VRESCS(N,2) = 0.
C
        ELSE
C
           LBOUT = .FALSE.
           NUMREF = NREFS(NRESCS(N,1))
C
           IF (NUMREF.NE.0) THEN
             DO 311 N1=1,NRFMAX
               IF (IREFMO(N1).NE.0 .AND. NUMREF.EQ.N1) THEN
                 LBOUT = .TRUE.
               ENDIF
  311       CONTINUE
           ENDIF
C
           IF (LBOUT) THEN
             VRESCS(N,2) = 65000.
           ENDIF        
        ENDIF
C 
  100 CONTINUE
C
C     2- CAS DES CONDITIONS AUX LIMITES PAR FACE
C     ==========================================
C
      ELSE
C
C       2.1- Inversion de la numerotation locale de  NRESCS
C       ---------------------------------------------------
C
        DO 210 N=1,NPOINS
          ITRAV1(N) = 0
  210   CONTINUE
C
      DO 211 N=1,NBRESS
        ITRAV1(NRESCS(N,1)) = N
  211 CONTINUE
C
C
C       2.2- Boucle sur les faces avec resistance
C       -----------------------------------------
        DO 220 N=1,NELERC
C
          NUMREF = NREFAL(NFRESC(N))
C
          LBOUT = .FALSE.
C
          IF (NUMREF.NE.0) THEN
            DO 221 N1=1,NRFMAX
              IF (IREFMO(N1).NE.0 .AND. NUMREF.EQ.N1) THEN
                LBOUT = .TRUE.
              ENDIF
  221       CONTINUE
          ENDIF
C
C
C
          IF (LBOUT) THEN
C
            DO 222 M=1,NDMASS
              NG = NODERC(N,M)
              NL = ITRAV1(NG)  
              NLC = NRESCS(NL,2)
              NGC = NRESCS(NLC,1)
C
              IF (NLC.EQ.-1) THEN
                 VFRESC(N,M,1) = 0.
                 VFRESC(N,M,2) = 0.
              ELSE
                 VFRESC(N,M,2) =  65000.
              ENDIF        
  222       CONTINUE
C
          ENDIF
C
C
  220   CONTINUE
C
C
      ENDIF
C
      RETURN
      END

