; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=riscv64 | FileCheck %s

; Make sure we use lwu for the load, and don't emit
; a sext.w for the compare. This requires isTruncateFree
; to return true for i64->i32. Otherwise we emit a
; lw and a shift pair for the zext.

define void @foo(i32* %p, i64* %q, i32* %r) {
; CHECK-LABEL: foo:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lwu a0, 0(a0)
; CHECK-NEXT:    sd a0, 0(a1)
; CHECK-NEXT:    beqz a0, .LBB0_2
; CHECK-NEXT:  # %bb.1: # %if
; CHECK-NEXT:    sw a0, 0(a2)
; CHECK-NEXT:  .LBB0_2: # %end
; CHECK-NEXT:    ret
  %a = load i32, i32* %p
  %b = zext i32 %a to i64
  store i64 %b, i64* %q
  %c = icmp ne i32 %a, 0
  br i1 %c, label %if, label %end

if:
  store i32 %a, i32* %r
  br label %end

end:
  ret void
}
