; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+d,+zfh,+experimental-zvfh,+v -target-abi=ilp32d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s
; RUN: llc -mtriple=riscv64 -mattr=+d,+zfh,+experimental-zvfh,+v -target-abi=lp64d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s

define half @extractelt_nxv1f16_0(<vscale x 1 x half> %v) {
; CHECK-LABEL: extractelt_nxv1f16_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 0, e16, mf4, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 1 x half> %v, i32 0
  ret half %r
}

define half @extractelt_nxv1f16_imm(<vscale x 1 x half> %v) {
; CHECK-LABEL: extractelt_nxv1f16_imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vslidedown.vi v8, v8, 2
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 1 x half> %v, i32 2
  ret half %r
}

define half @extractelt_nxv1f16_idx(<vscale x 1 x half> %v, i32 signext %idx) {
; CHECK-LABEL: extractelt_nxv1f16_idx:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v8, a0
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 1 x half> %v, i32 %idx
  ret half %r
}

define half @extractelt_nxv2f16_0(<vscale x 2 x half> %v) {
; CHECK-LABEL: extractelt_nxv2f16_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 0, e16, mf2, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 2 x half> %v, i32 0
  ret half %r
}

define half @extractelt_nxv2f16_imm(<vscale x 2 x half> %v) {
; CHECK-LABEL: extractelt_nxv2f16_imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf2, ta, ma
; CHECK-NEXT:    vslidedown.vi v8, v8, 2
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 2 x half> %v, i32 2
  ret half %r
}

define half @extractelt_nxv2f16_idx(<vscale x 2 x half> %v, i32 signext %idx) {
; CHECK-LABEL: extractelt_nxv2f16_idx:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf2, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v8, a0
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 2 x half> %v, i32 %idx
  ret half %r
}

define half @extractelt_nxv4f16_0(<vscale x 4 x half> %v) {
; CHECK-LABEL: extractelt_nxv4f16_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 0, e16, m1, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 4 x half> %v, i32 0
  ret half %r
}

define half @extractelt_nxv4f16_imm(<vscale x 4 x half> %v) {
; CHECK-LABEL: extractelt_nxv4f16_imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, m1, ta, ma
; CHECK-NEXT:    vslidedown.vi v8, v8, 2
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 4 x half> %v, i32 2
  ret half %r
}

define half @extractelt_nxv4f16_idx(<vscale x 4 x half> %v, i32 signext %idx) {
; CHECK-LABEL: extractelt_nxv4f16_idx:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, m1, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v8, a0
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 4 x half> %v, i32 %idx
  ret half %r
}

define half @extractelt_nxv8f16_0(<vscale x 8 x half> %v) {
; CHECK-LABEL: extractelt_nxv8f16_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 0, e16, m2, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 8 x half> %v, i32 0
  ret half %r
}

define half @extractelt_nxv8f16_imm(<vscale x 8 x half> %v) {
; CHECK-LABEL: extractelt_nxv8f16_imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, m2, ta, ma
; CHECK-NEXT:    vslidedown.vi v8, v8, 2
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 8 x half> %v, i32 2
  ret half %r
}

define half @extractelt_nxv8f16_idx(<vscale x 8 x half> %v, i32 signext %idx) {
; CHECK-LABEL: extractelt_nxv8f16_idx:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, m2, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v8, a0
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 8 x half> %v, i32 %idx
  ret half %r
}

define half @extractelt_nxv16f16_0(<vscale x 16 x half> %v) {
; CHECK-LABEL: extractelt_nxv16f16_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 0, e16, m4, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 16 x half> %v, i32 0
  ret half %r
}

define half @extractelt_nxv16f16_imm(<vscale x 16 x half> %v) {
; CHECK-LABEL: extractelt_nxv16f16_imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, m4, ta, ma
; CHECK-NEXT:    vslidedown.vi v8, v8, 2
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 16 x half> %v, i32 2
  ret half %r
}

define half @extractelt_nxv16f16_idx(<vscale x 16 x half> %v, i32 signext %idx) {
; CHECK-LABEL: extractelt_nxv16f16_idx:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, m4, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v8, a0
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 16 x half> %v, i32 %idx
  ret half %r
}

define half @extractelt_nxv32f16_0(<vscale x 32 x half> %v) {
; CHECK-LABEL: extractelt_nxv32f16_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 0, e16, m8, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 32 x half> %v, i32 0
  ret half %r
}

define half @extractelt_nxv32f16_imm(<vscale x 32 x half> %v) {
; CHECK-LABEL: extractelt_nxv32f16_imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, m8, ta, ma
; CHECK-NEXT:    vslidedown.vi v8, v8, 2
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 32 x half> %v, i32 2
  ret half %r
}

define half @extractelt_nxv32f16_idx(<vscale x 32 x half> %v, i32 signext %idx) {
; CHECK-LABEL: extractelt_nxv32f16_idx:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, m8, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v8, a0
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 32 x half> %v, i32 %idx
  ret half %r
}

define float @extractelt_nxv1f32_0(<vscale x 1 x float> %v) {
; CHECK-LABEL: extractelt_nxv1f32_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 0, e32, mf2, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 1 x float> %v, i32 0
  ret float %r
}

define float @extractelt_nxv1f32_imm(<vscale x 1 x float> %v) {
; CHECK-LABEL: extractelt_nxv1f32_imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vslidedown.vi v8, v8, 2
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 1 x float> %v, i32 2
  ret float %r
}

define float @extractelt_nxv1f32_idx(<vscale x 1 x float> %v, i32 signext %idx) {
; CHECK-LABEL: extractelt_nxv1f32_idx:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v8, a0
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 1 x float> %v, i32 %idx
  ret float %r
}

define float @extractelt_nxv2f32_0(<vscale x 2 x float> %v) {
; CHECK-LABEL: extractelt_nxv2f32_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 0, e32, m1, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 2 x float> %v, i32 0
  ret float %r
}

define float @extractelt_nxv2f32_imm(<vscale x 2 x float> %v) {
; CHECK-LABEL: extractelt_nxv2f32_imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, m1, ta, ma
; CHECK-NEXT:    vslidedown.vi v8, v8, 2
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 2 x float> %v, i32 2
  ret float %r
}

define float @extractelt_nxv2f32_idx(<vscale x 2 x float> %v, i32 signext %idx) {
; CHECK-LABEL: extractelt_nxv2f32_idx:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, m1, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v8, a0
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 2 x float> %v, i32 %idx
  ret float %r
}

define float @extractelt_nxv4f32_0(<vscale x 4 x float> %v) {
; CHECK-LABEL: extractelt_nxv4f32_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 0, e32, m2, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 4 x float> %v, i32 0
  ret float %r
}

define float @extractelt_nxv4f32_imm(<vscale x 4 x float> %v) {
; CHECK-LABEL: extractelt_nxv4f32_imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, m2, ta, ma
; CHECK-NEXT:    vslidedown.vi v8, v8, 2
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 4 x float> %v, i32 2
  ret float %r
}

define float @extractelt_nxv4f32_idx(<vscale x 4 x float> %v, i32 signext %idx) {
; CHECK-LABEL: extractelt_nxv4f32_idx:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, m2, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v8, a0
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 4 x float> %v, i32 %idx
  ret float %r
}

define float @extractelt_nxv8f32_0(<vscale x 8 x float> %v) {
; CHECK-LABEL: extractelt_nxv8f32_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 0, e32, m4, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 8 x float> %v, i32 0
  ret float %r
}

define float @extractelt_nxv8f32_imm(<vscale x 8 x float> %v) {
; CHECK-LABEL: extractelt_nxv8f32_imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, m4, ta, ma
; CHECK-NEXT:    vslidedown.vi v8, v8, 2
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 8 x float> %v, i32 2
  ret float %r
}

define float @extractelt_nxv8f32_idx(<vscale x 8 x float> %v, i32 signext %idx) {
; CHECK-LABEL: extractelt_nxv8f32_idx:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, m4, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v8, a0
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 8 x float> %v, i32 %idx
  ret float %r
}

define float @extractelt_nxv16f32_0(<vscale x 16 x float> %v) {
; CHECK-LABEL: extractelt_nxv16f32_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 0, e32, m8, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 16 x float> %v, i32 0
  ret float %r
}

define float @extractelt_nxv16f32_imm(<vscale x 16 x float> %v) {
; CHECK-LABEL: extractelt_nxv16f32_imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, m8, ta, ma
; CHECK-NEXT:    vslidedown.vi v8, v8, 2
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 16 x float> %v, i32 2
  ret float %r
}

define float @extractelt_nxv16f32_idx(<vscale x 16 x float> %v, i32 signext %idx) {
; CHECK-LABEL: extractelt_nxv16f32_idx:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, m8, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v8, a0
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 16 x float> %v, i32 %idx
  ret float %r
}

define double @extractelt_nxv1f64_0(<vscale x 1 x double> %v) {
; CHECK-LABEL: extractelt_nxv1f64_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 0, e64, m1, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 1 x double> %v, i32 0
  ret double %r
}

define double @extractelt_nxv1f64_imm(<vscale x 1 x double> %v) {
; CHECK-LABEL: extractelt_nxv1f64_imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-NEXT:    vslidedown.vi v8, v8, 2
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 1 x double> %v, i32 2
  ret double %r
}

define double @extractelt_nxv1f64_idx(<vscale x 1 x double> %v, i32 signext %idx) {
; CHECK-LABEL: extractelt_nxv1f64_idx:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v8, a0
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 1 x double> %v, i32 %idx
  ret double %r
}

define double @extractelt_nxv2f64_0(<vscale x 2 x double> %v) {
; CHECK-LABEL: extractelt_nxv2f64_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 0, e64, m2, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 2 x double> %v, i32 0
  ret double %r
}

define double @extractelt_nxv2f64_imm(<vscale x 2 x double> %v) {
; CHECK-LABEL: extractelt_nxv2f64_imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m2, ta, ma
; CHECK-NEXT:    vslidedown.vi v8, v8, 2
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 2 x double> %v, i32 2
  ret double %r
}

define double @extractelt_nxv2f64_idx(<vscale x 2 x double> %v, i32 signext %idx) {
; CHECK-LABEL: extractelt_nxv2f64_idx:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m2, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v8, a0
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 2 x double> %v, i32 %idx
  ret double %r
}

define double @extractelt_nxv4f64_0(<vscale x 4 x double> %v) {
; CHECK-LABEL: extractelt_nxv4f64_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 0, e64, m4, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 4 x double> %v, i32 0
  ret double %r
}

define double @extractelt_nxv4f64_imm(<vscale x 4 x double> %v) {
; CHECK-LABEL: extractelt_nxv4f64_imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m4, ta, ma
; CHECK-NEXT:    vslidedown.vi v8, v8, 2
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 4 x double> %v, i32 2
  ret double %r
}

define double @extractelt_nxv4f64_idx(<vscale x 4 x double> %v, i32 signext %idx) {
; CHECK-LABEL: extractelt_nxv4f64_idx:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m4, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v8, a0
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 4 x double> %v, i32 %idx
  ret double %r
}

define double @extractelt_nxv8f64_0(<vscale x 8 x double> %v) {
; CHECK-LABEL: extractelt_nxv8f64_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 0, e64, m8, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 8 x double> %v, i32 0
  ret double %r
}

define double @extractelt_nxv8f64_imm(<vscale x 8 x double> %v) {
; CHECK-LABEL: extractelt_nxv8f64_imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m8, ta, ma
; CHECK-NEXT:    vslidedown.vi v8, v8, 2
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 8 x double> %v, i32 2
  ret double %r
}

define double @extractelt_nxv8f64_idx(<vscale x 8 x double> %v, i32 signext %idx) {
; CHECK-LABEL: extractelt_nxv8f64_idx:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m8, ta, ma
; CHECK-NEXT:    vslidedown.vx v8, v8, a0
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 8 x double> %v, i32 %idx
  ret double %r
}

define void @store_extractelt_nxv8f64(<vscale x 8 x double>* %x, double* %p) {
; CHECK-LABEL: store_extractelt_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl8re64.v v8, (a0)
; CHECK-NEXT:    vsetivli zero, 1, e64, m8, ta, ma
; CHECK-NEXT:    vslidedown.vi v8, v8, 1
; CHECK-NEXT:    vse64.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <vscale x 8 x double>, <vscale x 8 x double>* %x
  %b = extractelement <vscale x 8 x double> %a, i64 1
  store double %b, double* %p
  ret void
}

define void @store_vfmv_f_s_nxv8f64(<vscale x 8 x double>* %x, double* %p) {
; CHECK-LABEL: store_vfmv_f_s_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl8re64.v v8, (a0)
; CHECK-NEXT:    vsetivli zero, 1, e64, m8, ta, ma
; CHECK-NEXT:    vse64.v v8, (a1)
; CHECK-NEXT:    ret
  %a = load <vscale x 8 x double>, <vscale x 8 x double>* %x
  %b = call double @llvm.riscv.vfmv.f.s.nxv8f64(<vscale x 8 x double> %a)
  store double %b, double* %p
  ret void
}

declare double @llvm.riscv.vfmv.f.s.nxv8f64(<vscale x 8 x double>)

define float @extractelt_fadd_nxv4f32_splat(<vscale x 4 x float> %x) {
; CHECK-LABEL: extractelt_fadd_nxv4f32_splat:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lui a0, %hi(.LCPI47_0)
; CHECK-NEXT:    flw ft0, %lo(.LCPI47_0)(a0)
; CHECK-NEXT:    vsetivli zero, 1, e32, m2, ta, ma
; CHECK-NEXT:    vslidedown.vi v8, v8, 2
; CHECK-NEXT:    vfmv.f.s ft1, v8
; CHECK-NEXT:    fadd.s fa0, ft1, ft0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x float> poison, float 3.0, i32 0
  %splat = shufflevector <vscale x 4 x float> %head, <vscale x 4 x float> poison, <vscale x 4 x i32> zeroinitializer
  %bo = fadd <vscale x 4 x float> %x, %splat
  %ext = extractelement <vscale x 4 x float> %bo, i32 2
  ret float %ext
}

define float @extractelt_fsub_nxv4f32_splat(<vscale x 4 x float> %x) {
; CHECK-LABEL: extractelt_fsub_nxv4f32_splat:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lui a0, %hi(.LCPI48_0)
; CHECK-NEXT:    flw ft0, %lo(.LCPI48_0)(a0)
; CHECK-NEXT:    vsetivli zero, 1, e32, m2, ta, ma
; CHECK-NEXT:    vslidedown.vi v8, v8, 1
; CHECK-NEXT:    vfmv.f.s ft1, v8
; CHECK-NEXT:    fsub.s fa0, ft0, ft1
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x float> poison, float 3.0, i32 0
  %splat = shufflevector <vscale x 4 x float> %head, <vscale x 4 x float> poison, <vscale x 4 x i32> zeroinitializer
  %bo = fsub <vscale x 4 x float> %splat, %x
  %ext = extractelement <vscale x 4 x float> %bo, i32 1
  ret float %ext
}

define float @extractelt_fmul_nxv4f32_splat(<vscale x 4 x float> %x) {
; CHECK-LABEL: extractelt_fmul_nxv4f32_splat:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lui a0, %hi(.LCPI49_0)
; CHECK-NEXT:    flw ft0, %lo(.LCPI49_0)(a0)
; CHECK-NEXT:    vsetivli zero, 1, e32, m2, ta, ma
; CHECK-NEXT:    vslidedown.vi v8, v8, 3
; CHECK-NEXT:    vfmv.f.s ft1, v8
; CHECK-NEXT:    fmul.s fa0, ft1, ft0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x float> poison, float 3.0, i32 0
  %splat = shufflevector <vscale x 4 x float> %head, <vscale x 4 x float> poison, <vscale x 4 x i32> zeroinitializer
  %bo = fmul <vscale x 4 x float> %x, %splat
  %ext = extractelement <vscale x 4 x float> %bo, i32 3
  ret float %ext
}

define float @extractelt_fdiv_nxv4f32_splat(<vscale x 4 x float> %x) {
; CHECK-LABEL: extractelt_fdiv_nxv4f32_splat:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lui a0, %hi(.LCPI50_0)
; CHECK-NEXT:    flw ft0, %lo(.LCPI50_0)(a0)
; CHECK-NEXT:    vsetivli zero, 0, e32, m2, ta, ma
; CHECK-NEXT:    vfmv.f.s ft1, v8
; CHECK-NEXT:    fdiv.s fa0, ft1, ft0
; CHECK-NEXT:    ret
  %head = insertelement <vscale x 4 x float> poison, float 3.0, i32 0
  %splat = shufflevector <vscale x 4 x float> %head, <vscale x 4 x float> poison, <vscale x 4 x i32> zeroinitializer
  %bo = fdiv <vscale x 4 x float> %x, %splat
  %ext = extractelement <vscale x 4 x float> %bo, i32 0
  ret float %ext
}

define double @extractelt_nxv16f64_0(<vscale x 16 x double> %v) {
; CHECK-LABEL: extractelt_nxv16f64_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 0, e64, m8, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 16 x double> %v, i32 0
  ret double %r
}

define double @extractelt_nxv16f64_neg1(<vscale x 16 x double> %v) {
; CHECK-LABEL: extractelt_nxv16f64_neg1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -64
; CHECK-NEXT:    .cfi_def_cfa_offset 64
; CHECK-NEXT:    addi s0, sp, 64
; CHECK-NEXT:    .cfi_def_cfa s0, 0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    andi sp, sp, -64
; CHECK-NEXT:    addi a0, sp, 64
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a2, a1, 3
; CHECK-NEXT:    add a2, a0, a2
; CHECK-NEXT:    vs8r.v v16, (a2)
; CHECK-NEXT:    slli a1, a1, 4
; CHECK-NEXT:    add a0, a1, a0
; CHECK-NEXT:    fld fa0, -8(a0)
; CHECK-NEXT:    addi sp, s0, -64
; CHECK-NEXT:    addi sp, sp, 64
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 16 x double> %v, i32 -1
  ret double %r
}

define double @extractelt_nxv16f64_imm(<vscale x 16 x double> %v) {
; CHECK-LABEL: extractelt_nxv16f64_imm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m8, ta, ma
; CHECK-NEXT:    vslidedown.vi v8, v8, 2
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 16 x double> %v, i32 2
  ret double %r
}

define double @extractelt_nxv16f64_idx(<vscale x 16 x double> %v, i32 signext %idx) {
; CHECK-LABEL: extractelt_nxv16f64_idx:
; CHECK:       # %bb.0:
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a2, a1, 1
; CHECK-NEXT:    addi a2, a2, -1
; CHECK-NEXT:    bltu a0, a2, .LBB54_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    mv a0, a2
; CHECK-NEXT:  .LBB54_2:
; CHECK-NEXT:    addi sp, sp, -64
; CHECK-NEXT:    .cfi_def_cfa_offset 64
; CHECK-NEXT:    addi s0, sp, 64
; CHECK-NEXT:    .cfi_def_cfa s0, 0
; CHECK-NEXT:    csrr a2, vlenb
; CHECK-NEXT:    slli a2, a2, 4
; CHECK-NEXT:    sub sp, sp, a2
; CHECK-NEXT:    andi sp, sp, -64
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    addi a2, sp, 64
; CHECK-NEXT:    add a0, a2, a0
; CHECK-NEXT:    vs8r.v v8, (a2)
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    add a1, a2, a1
; CHECK-NEXT:    vs8r.v v16, (a1)
; CHECK-NEXT:    fld fa0, 0(a0)
; CHECK-NEXT:    addi sp, s0, -64
; CHECK-NEXT:    addi sp, sp, 64
; CHECK-NEXT:    ret
  %r = extractelement <vscale x 16 x double> %v, i32 %idx
  ret double %r
}
