; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefixes=CHECK,RV32I
; RUN: llc -mtriple=riscv32 -mattr=+zbb -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefixes=CHECK,RV32ZBB-ZBKB
; RUN: llc -mtriple=riscv32 -mattr=+zbkb -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefixes=CHECK,RV32ZBB-ZBKB

define i32 @andn_i32(i32 %a, i32 %b) nounwind {
; RV32I-LABEL: andn_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    not a1, a1
; RV32I-NEXT:    and a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32ZBB-ZBKB-LABEL: andn_i32:
; RV32ZBB-ZBKB:       # %bb.0:
; RV32ZBB-ZBKB-NEXT:    andn a0, a0, a1
; RV32ZBB-ZBKB-NEXT:    ret
  %neg = xor i32 %b, -1
  %and = and i32 %neg, %a
  ret i32 %and
}

define i64 @andn_i64(i64 %a, i64 %b) nounwind {
; RV32I-LABEL: andn_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    not a3, a3
; RV32I-NEXT:    not a2, a2
; RV32I-NEXT:    and a0, a2, a0
; RV32I-NEXT:    and a1, a3, a1
; RV32I-NEXT:    ret
;
; RV32ZBB-ZBKB-LABEL: andn_i64:
; RV32ZBB-ZBKB:       # %bb.0:
; RV32ZBB-ZBKB-NEXT:    andn a0, a0, a2
; RV32ZBB-ZBKB-NEXT:    andn a1, a1, a3
; RV32ZBB-ZBKB-NEXT:    ret
  %neg = xor i64 %b, -1
  %and = and i64 %neg, %a
  ret i64 %and
}

define i32 @orn_i32(i32 %a, i32 %b) nounwind {
; RV32I-LABEL: orn_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    not a1, a1
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV32ZBB-ZBKB-LABEL: orn_i32:
; RV32ZBB-ZBKB:       # %bb.0:
; RV32ZBB-ZBKB-NEXT:    orn a0, a0, a1
; RV32ZBB-ZBKB-NEXT:    ret
  %neg = xor i32 %b, -1
  %or = or i32 %neg, %a
  ret i32 %or
}

define i64 @orn_i64(i64 %a, i64 %b) nounwind {
; RV32I-LABEL: orn_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    not a3, a3
; RV32I-NEXT:    not a2, a2
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    or a1, a3, a1
; RV32I-NEXT:    ret
;
; RV32ZBB-ZBKB-LABEL: orn_i64:
; RV32ZBB-ZBKB:       # %bb.0:
; RV32ZBB-ZBKB-NEXT:    orn a0, a0, a2
; RV32ZBB-ZBKB-NEXT:    orn a1, a1, a3
; RV32ZBB-ZBKB-NEXT:    ret
  %neg = xor i64 %b, -1
  %or = or i64 %neg, %a
  ret i64 %or
}

define i32 @xnor_i32(i32 %a, i32 %b) nounwind {
; RV32I-LABEL: xnor_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    xor a0, a0, a1
; RV32I-NEXT:    not a0, a0
; RV32I-NEXT:    ret
;
; RV32ZBB-ZBKB-LABEL: xnor_i32:
; RV32ZBB-ZBKB:       # %bb.0:
; RV32ZBB-ZBKB-NEXT:    xnor a0, a0, a1
; RV32ZBB-ZBKB-NEXT:    ret
  %neg = xor i32 %a, -1
  %xor = xor i32 %neg, %b
  ret i32 %xor
}

define i64 @xnor_i64(i64 %a, i64 %b) nounwind {
; RV32I-LABEL: xnor_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    xor a1, a1, a3
; RV32I-NEXT:    xor a0, a0, a2
; RV32I-NEXT:    not a0, a0
; RV32I-NEXT:    not a1, a1
; RV32I-NEXT:    ret
;
; RV32ZBB-ZBKB-LABEL: xnor_i64:
; RV32ZBB-ZBKB:       # %bb.0:
; RV32ZBB-ZBKB-NEXT:    xnor a0, a0, a2
; RV32ZBB-ZBKB-NEXT:    xnor a1, a1, a3
; RV32ZBB-ZBKB-NEXT:    ret
  %neg = xor i64 %a, -1
  %xor = xor i64 %neg, %b
  ret i64 %xor
}

declare i32 @llvm.fshl.i32(i32, i32, i32)

define i32 @rol_i32(i32 %a, i32 %b) nounwind {
; RV32I-LABEL: rol_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    sll a2, a0, a1
; RV32I-NEXT:    neg a1, a1
; RV32I-NEXT:    srl a0, a0, a1
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    ret
;
; RV32ZBB-ZBKB-LABEL: rol_i32:
; RV32ZBB-ZBKB:       # %bb.0:
; RV32ZBB-ZBKB-NEXT:    rol a0, a0, a1
; RV32ZBB-ZBKB-NEXT:    ret
  %or = tail call i32 @llvm.fshl.i32(i32 %a, i32 %a, i32 %b)
  ret i32 %or
}

; This test is presented here in case future expansions of the Bitmanip
; extensions introduce instructions suitable for this pattern.

declare i64 @llvm.fshl.i64(i64, i64, i64)

define i64 @rol_i64(i64 %a, i64 %b) nounwind {
; CHECK-LABEL: rol_i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    slli a3, a2, 26
; CHECK-NEXT:    srli a5, a3, 31
; CHECK-NEXT:    mv a4, a1
; CHECK-NEXT:    bnez a5, .LBB7_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    mv a4, a0
; CHECK-NEXT:  .LBB7_2:
; CHECK-NEXT:    sll a3, a4, a2
; CHECK-NEXT:    bnez a5, .LBB7_4
; CHECK-NEXT:  # %bb.3:
; CHECK-NEXT:    mv a0, a1
; CHECK-NEXT:  .LBB7_4:
; CHECK-NEXT:    srli a1, a0, 1
; CHECK-NEXT:    not a5, a2
; CHECK-NEXT:    srl a1, a1, a5
; CHECK-NEXT:    or a3, a3, a1
; CHECK-NEXT:    sll a0, a0, a2
; CHECK-NEXT:    srli a1, a4, 1
; CHECK-NEXT:    srl a1, a1, a5
; CHECK-NEXT:    or a1, a0, a1
; CHECK-NEXT:    mv a0, a3
; CHECK-NEXT:    ret
  %or = tail call i64 @llvm.fshl.i64(i64 %a, i64 %a, i64 %b)
  ret i64 %or
}

declare i32 @llvm.fshr.i32(i32, i32, i32)

define i32 @ror_i32(i32 %a, i32 %b) nounwind {
; RV32I-LABEL: ror_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srl a2, a0, a1
; RV32I-NEXT:    neg a1, a1
; RV32I-NEXT:    sll a0, a0, a1
; RV32I-NEXT:    or a0, a2, a0
; RV32I-NEXT:    ret
;
; RV32ZBB-ZBKB-LABEL: ror_i32:
; RV32ZBB-ZBKB:       # %bb.0:
; RV32ZBB-ZBKB-NEXT:    ror a0, a0, a1
; RV32ZBB-ZBKB-NEXT:    ret
  %or = tail call i32 @llvm.fshr.i32(i32 %a, i32 %a, i32 %b)
  ret i32 %or
}

; This test is presented here in case future expansions of the Bitmanip
; extensions introduce instructions suitable for this pattern.

declare i64 @llvm.fshr.i64(i64, i64, i64)

define i64 @ror_i64(i64 %a, i64 %b) nounwind {
; CHECK-LABEL: ror_i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andi a5, a2, 32
; CHECK-NEXT:    mv a3, a0
; CHECK-NEXT:    beqz a5, .LBB9_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    mv a3, a1
; CHECK-NEXT:  .LBB9_2:
; CHECK-NEXT:    srl a4, a3, a2
; CHECK-NEXT:    beqz a5, .LBB9_4
; CHECK-NEXT:  # %bb.3:
; CHECK-NEXT:    mv a1, a0
; CHECK-NEXT:  .LBB9_4:
; CHECK-NEXT:    slli a0, a1, 1
; CHECK-NEXT:    not a5, a2
; CHECK-NEXT:    sll a0, a0, a5
; CHECK-NEXT:    or a0, a0, a4
; CHECK-NEXT:    srl a1, a1, a2
; CHECK-NEXT:    slli a2, a3, 1
; CHECK-NEXT:    sll a2, a2, a5
; CHECK-NEXT:    or a1, a2, a1
; CHECK-NEXT:    ret
  %or = tail call i64 @llvm.fshr.i64(i64 %a, i64 %a, i64 %b)
  ret i64 %or
}

define i32 @rori_i32_fshl(i32 %a) nounwind {
; RV32I-LABEL: rori_i32_fshl:
; RV32I:       # %bb.0:
; RV32I-NEXT:    srli a1, a0, 1
; RV32I-NEXT:    slli a0, a0, 31
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBB-ZBKB-LABEL: rori_i32_fshl:
; RV32ZBB-ZBKB:       # %bb.0:
; RV32ZBB-ZBKB-NEXT:    rori a0, a0, 1
; RV32ZBB-ZBKB-NEXT:    ret
  %1 = tail call i32 @llvm.fshl.i32(i32 %a, i32 %a, i32 31)
  ret i32 %1
}

define i32 @rori_i32_fshr(i32 %a) nounwind {
; RV32I-LABEL: rori_i32_fshr:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 1
; RV32I-NEXT:    srli a0, a0, 31
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    ret
;
; RV32ZBB-ZBKB-LABEL: rori_i32_fshr:
; RV32ZBB-ZBKB:       # %bb.0:
; RV32ZBB-ZBKB-NEXT:    rori a0, a0, 31
; RV32ZBB-ZBKB-NEXT:    ret
  %1 = tail call i32 @llvm.fshr.i32(i32 %a, i32 %a, i32 31)
  ret i32 %1
}

define i64 @rori_i64(i64 %a) nounwind {
; CHECK-LABEL: rori_i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    srli a2, a0, 1
; CHECK-NEXT:    slli a3, a1, 31
; CHECK-NEXT:    or a2, a3, a2
; CHECK-NEXT:    srli a1, a1, 1
; CHECK-NEXT:    slli a0, a0, 31
; CHECK-NEXT:    or a1, a0, a1
; CHECK-NEXT:    mv a0, a2
; CHECK-NEXT:    ret
  %1 = tail call i64 @llvm.fshl.i64(i64 %a, i64 %a, i64 63)
  ret i64 %1
}

define i64 @rori_i64_fshr(i64 %a) nounwind {
; CHECK-LABEL: rori_i64_fshr:
; CHECK:       # %bb.0:
; CHECK-NEXT:    srli a2, a1, 31
; CHECK-NEXT:    slli a3, a0, 1
; CHECK-NEXT:    or a2, a3, a2
; CHECK-NEXT:    srli a0, a0, 31
; CHECK-NEXT:    slli a1, a1, 1
; CHECK-NEXT:    or a1, a1, a0
; CHECK-NEXT:    mv a0, a2
; CHECK-NEXT:    ret
  %1 = tail call i64 @llvm.fshr.i64(i64 %a, i64 %a, i64 63)
  ret i64 %1
}

define i32 @not_shl_one_i32(i32 %x) {
; RV32I-LABEL: not_shl_one_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    li a1, 1
; RV32I-NEXT:    sll a0, a1, a0
; RV32I-NEXT:    not a0, a0
; RV32I-NEXT:    ret
;
; RV32ZBB-ZBKB-LABEL: not_shl_one_i32:
; RV32ZBB-ZBKB:       # %bb.0:
; RV32ZBB-ZBKB-NEXT:    li a1, -2
; RV32ZBB-ZBKB-NEXT:    rol a0, a1, a0
; RV32ZBB-ZBKB-NEXT:    ret
  %1 = shl i32 1, %x
  %2 = xor i32 %1, -1
  ret i32 %2
}

define i64 @not_shl_one_i64(i64 %x) {
; CHECK-LABEL: not_shl_one_i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 1
; CHECK-NEXT:    sll a2, a1, a0
; CHECK-NEXT:    addi a0, a0, -32
; CHECK-NEXT:    slti a3, a0, 0
; CHECK-NEXT:    neg a4, a3
; CHECK-NEXT:    and a2, a4, a2
; CHECK-NEXT:    sll a0, a1, a0
; CHECK-NEXT:    addi a1, a3, -1
; CHECK-NEXT:    and a1, a1, a0
; CHECK-NEXT:    not a0, a2
; CHECK-NEXT:    not a1, a1
; CHECK-NEXT:    ret
  %1 = shl i64 1, %x
  %2 = xor i64 %1, -1
  ret i64 %2
}

define i8 @srli_i8(i8 %a) nounwind {
; CHECK-LABEL: srli_i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    slli a0, a0, 24
; CHECK-NEXT:    srli a0, a0, 30
; CHECK-NEXT:    ret
  %1 = lshr i8 %a, 6
  ret i8 %1
}

; We could use sext.b+srai, but slli+srai offers more opportunities for
; comppressed instructions.
define i8 @srai_i8(i8 %a) nounwind {
; CHECK-LABEL: srai_i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    slli a0, a0, 24
; CHECK-NEXT:    srai a0, a0, 29
; CHECK-NEXT:    ret
  %1 = ashr i8 %a, 5
  ret i8 %1
}

; We could use zext.h+srli, but slli+srli offers more opportunities for
; comppressed instructions.
define i16 @srli_i16(i16 %a) nounwind {
; CHECK-LABEL: srli_i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    slli a0, a0, 16
; CHECK-NEXT:    srli a0, a0, 22
; CHECK-NEXT:    ret
  %1 = lshr i16 %a, 6
  ret i16 %1
}

; We could use sext.h+srai, but slli+srai offers more opportunities for
; comppressed instructions.
define i16 @srai_i16(i16 %a) nounwind {
; CHECK-LABEL: srai_i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    slli a0, a0, 16
; CHECK-NEXT:    srai a0, a0, 25
; CHECK-NEXT:    ret
  %1 = ashr i16 %a, 9
  ret i16 %1
}

define i1 @andn_seqz_i32(i32 %a, i32 %b) nounwind {
; RV32I-LABEL: andn_seqz_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    and a0, a0, a1
; RV32I-NEXT:    xor a0, a0, a1
; RV32I-NEXT:    seqz a0, a0
; RV32I-NEXT:    ret
;
; RV32ZBB-ZBKB-LABEL: andn_seqz_i32:
; RV32ZBB-ZBKB:       # %bb.0:
; RV32ZBB-ZBKB-NEXT:    andn a0, a1, a0
; RV32ZBB-ZBKB-NEXT:    seqz a0, a0
; RV32ZBB-ZBKB-NEXT:    ret
  %and = and i32 %a, %b
  %cmpeq = icmp eq i32 %and, %b
  ret i1 %cmpeq
}

define i1 @andn_seqz_i64(i64 %a, i64 %b) nounwind {
; RV32I-LABEL: andn_seqz_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    not a0, a0
; RV32I-NEXT:    not a1, a1
; RV32I-NEXT:    and a1, a1, a3
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    seqz a0, a0
; RV32I-NEXT:    ret
;
; RV32ZBB-ZBKB-LABEL: andn_seqz_i64:
; RV32ZBB-ZBKB:       # %bb.0:
; RV32ZBB-ZBKB-NEXT:    andn a1, a3, a1
; RV32ZBB-ZBKB-NEXT:    andn a0, a2, a0
; RV32ZBB-ZBKB-NEXT:    or a0, a0, a1
; RV32ZBB-ZBKB-NEXT:    seqz a0, a0
; RV32ZBB-ZBKB-NEXT:    ret
  %and = and i64 %a, %b
  %cmpeq = icmp eq i64 %and, %b
  ret i1 %cmpeq
}

define i1 @andn_snez_i32(i32 %a, i32 %b) nounwind {
; RV32I-LABEL: andn_snez_i32:
; RV32I:       # %bb.0:
; RV32I-NEXT:    and a0, a0, a1
; RV32I-NEXT:    xor a0, a0, a1
; RV32I-NEXT:    snez a0, a0
; RV32I-NEXT:    ret
;
; RV32ZBB-ZBKB-LABEL: andn_snez_i32:
; RV32ZBB-ZBKB:       # %bb.0:
; RV32ZBB-ZBKB-NEXT:    andn a0, a1, a0
; RV32ZBB-ZBKB-NEXT:    snez a0, a0
; RV32ZBB-ZBKB-NEXT:    ret
  %and = and i32 %a, %b
  %cmpeq = icmp ne i32 %and, %b
  ret i1 %cmpeq
}

define i1 @andn_snez_i64(i64 %a, i64 %b) nounwind {
; RV32I-LABEL: andn_snez_i64:
; RV32I:       # %bb.0:
; RV32I-NEXT:    not a0, a0
; RV32I-NEXT:    not a1, a1
; RV32I-NEXT:    and a1, a1, a3
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    snez a0, a0
; RV32I-NEXT:    ret
;
; RV32ZBB-ZBKB-LABEL: andn_snez_i64:
; RV32ZBB-ZBKB:       # %bb.0:
; RV32ZBB-ZBKB-NEXT:    andn a1, a3, a1
; RV32ZBB-ZBKB-NEXT:    andn a0, a2, a0
; RV32ZBB-ZBKB-NEXT:    or a0, a0, a1
; RV32ZBB-ZBKB-NEXT:    snez a0, a0
; RV32ZBB-ZBKB-NEXT:    ret
  %and = and i64 %a, %b
  %cmpeq = icmp ne i64 %and, %b
  ret i1 %cmpeq
}
