; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=riscv32 | FileCheck %s --check-prefixes=RV32
; RUN: llc < %s -mtriple=riscv64 | FileCheck %s --check-prefixes=RV64

define signext i32 @test1(i32 signext %x) nounwind {
; RV32-LABEL: test1:
; RV32:       # %bb.0:
; RV32-NEXT:    ori a0, a0, 31
; RV32-NEXT:    slli a0, a0, 10
; RV32-NEXT:    ret
;
; RV64-LABEL: test1:
; RV64:       # %bb.0:
; RV64-NEXT:    ori a0, a0, 31
; RV64-NEXT:    slliw a0, a0, 10
; RV64-NEXT:    ret
  %or = shl i32 %x, 10
  %shl = or i32 %or, 31744
  ret i32 %shl
}

define signext i32 @test2(i32 signext %x) nounwind {
; RV32-LABEL: test2:
; RV32:       # %bb.0:
; RV32-NEXT:    xori a0, a0, 31
; RV32-NEXT:    slli a0, a0, 10
; RV32-NEXT:    ret
;
; RV64-LABEL: test2:
; RV64:       # %bb.0:
; RV64-NEXT:    xori a0, a0, 31
; RV64-NEXT:    slliw a0, a0, 10
; RV64-NEXT:    ret
  %xor = shl i32 %x, 10
  %shl = xor i32 %xor, 31744
  ret i32 %shl
}

define i64 @test3(i64 %x) nounwind {
; RV32-LABEL: test3:
; RV32:       # %bb.0:
; RV32-NEXT:    andi a0, a0, 241
; RV32-NEXT:    slli a1, a0, 8
; RV32-NEXT:    li a0, 0
; RV32-NEXT:    ret
;
; RV64-LABEL: test3:
; RV64:       # %bb.0:
; RV64-NEXT:    andi a0, a0, 241
; RV64-NEXT:    slli a0, a0, 40
; RV64-NEXT:    ret
  %and = shl i64 %x, 40
  %shl = and i64 %and, 264982302294016
  ret i64 %shl
}

define i64 @test4(i64 %x) nounwind {
; RV32-LABEL: test4:
; RV32:       # %bb.0:
; RV32-NEXT:    ori a0, a0, 241
; RV32-NEXT:    slli a1, a0, 8
; RV32-NEXT:    li a0, 0
; RV32-NEXT:    ret
;
; RV64-LABEL: test4:
; RV64:       # %bb.0:
; RV64-NEXT:    ori a0, a0, 241
; RV64-NEXT:    slli a0, a0, 40
; RV64-NEXT:    ret
  %or = shl i64 %x, 40
  %shl = or i64 %or, 264982302294016
  ret i64 %shl
}

define i64 @test5(i64 %x) nounwind {
; RV32-LABEL: test5:
; RV32:       # %bb.0:
; RV32-NEXT:    ori a0, a0, 31
; RV32-NEXT:    slli a1, a0, 8
; RV32-NEXT:    li a0, 0
; RV32-NEXT:    ret
;
; RV64-LABEL: test5:
; RV64:       # %bb.0:
; RV64-NEXT:    ori a0, a0, 31
; RV64-NEXT:    slli a0, a0, 40
; RV64-NEXT:    ret
  %or = shl i64 %x, 40
  %shl = or i64 %or, 34084860461056
  ret i64 %shl
}

define i64 @test6(i64 %x) nounwind {
; RV32-LABEL: test6:
; RV32:       # %bb.0:
; RV32-NEXT:    xori a0, a0, 241
; RV32-NEXT:    slli a1, a0, 8
; RV32-NEXT:    li a0, 0
; RV32-NEXT:    ret
;
; RV64-LABEL: test6:
; RV64:       # %bb.0:
; RV64-NEXT:    xori a0, a0, 241
; RV64-NEXT:    slli a0, a0, 40
; RV64-NEXT:    ret
  %xor = shl i64 %x, 40
  %shl = xor i64 %xor, 264982302294016
  ret i64 %shl
}

define i64 @test7(i64 %x) nounwind {
; RV32-LABEL: test7:
; RV32:       # %bb.0:
; RV32-NEXT:    xori a0, a0, 31
; RV32-NEXT:    slli a1, a0, 8
; RV32-NEXT:    li a0, 0
; RV32-NEXT:    ret
;
; RV64-LABEL: test7:
; RV64:       # %bb.0:
; RV64-NEXT:    xori a0, a0, 31
; RV64-NEXT:    slli a0, a0, 40
; RV64-NEXT:    ret
  %xor = shl i64 %x, 40
  %shl = xor i64 %xor, 34084860461056
  ret i64 %shl
}

define i64 @test8(i64 %x) nounwind {
; RV32-LABEL: test8:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a0, a0, 1
; RV32-NEXT:    andi a1, a0, -482
; RV32-NEXT:    li a0, 0
; RV32-NEXT:    ret
;
; RV64-LABEL: test8:
; RV64:       # %bb.0:
; RV64-NEXT:    andi a0, a0, -241
; RV64-NEXT:    slli a0, a0, 33
; RV64-NEXT:    ret
  %xor = shl i64 %x, 33
  %shl = and i64 %xor, -2070174236672
  ret i64 %shl
}

define i64 @test9(i64 %x) nounwind {
; RV32-LABEL: test9:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a0, a0, 1
; RV32-NEXT:    ori a1, a0, -482
; RV32-NEXT:    li a0, 0
; RV32-NEXT:    ret
;
; RV64-LABEL: test9:
; RV64:       # %bb.0:
; RV64-NEXT:    ori a0, a0, -241
; RV64-NEXT:    slli a0, a0, 33
; RV64-NEXT:    ret
  %xor = shl i64 %x, 33
  %shl = or i64 %xor, -2070174236672
  ret i64 %shl
}

define i64 @test10(i64 %x) nounwind {
; RV32-LABEL: test10:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a0, a0, 1
; RV32-NEXT:    xori a1, a0, -482
; RV32-NEXT:    li a0, 0
; RV32-NEXT:    ret
;
; RV64-LABEL: test10:
; RV64:       # %bb.0:
; RV64-NEXT:    xori a0, a0, -241
; RV64-NEXT:    slli a0, a0, 33
; RV64-NEXT:    ret
  %xor = shl i64 %x, 33
  %shl = xor i64 %xor, -2070174236672
  ret i64 %shl
}

define signext i32 @test11(i32 signext %x) nounwind {
; RV32-LABEL: test11:
; RV32:       # %bb.0:
; RV32-NEXT:    andi a0, a0, -241
; RV32-NEXT:    slli a0, a0, 17
; RV32-NEXT:    ret
;
; RV64-LABEL: test11:
; RV64:       # %bb.0:
; RV64-NEXT:    slliw a0, a0, 17
; RV64-NEXT:    lui a1, 1040864
; RV64-NEXT:    and a0, a0, a1
; RV64-NEXT:    ret
  %or = shl i32 %x, 17
  %shl = and i32 %or, -31588352
  ret i32 %shl
}

define signext i32 @test12(i32 signext %x) nounwind {
; RV32-LABEL: test12:
; RV32:       # %bb.0:
; RV32-NEXT:    ori a0, a0, -241
; RV32-NEXT:    slli a0, a0, 17
; RV32-NEXT:    ret
;
; RV64-LABEL: test12:
; RV64:       # %bb.0:
; RV64-NEXT:    ori a0, a0, -241
; RV64-NEXT:    slli a0, a0, 17
; RV64-NEXT:    ret
  %or = shl i32 %x, 17
  %shl = or i32 %or, -31588352
  ret i32 %shl
}

define signext i32 @test13(i32 signext %x) nounwind {
; RV32-LABEL: test13:
; RV32:       # %bb.0:
; RV32-NEXT:    xori a0, a0, -241
; RV32-NEXT:    slli a0, a0, 17
; RV32-NEXT:    ret
;
; RV64-LABEL: test13:
; RV64:       # %bb.0:
; RV64-NEXT:    xori a0, a0, -241
; RV64-NEXT:    slliw a0, a0, 17
; RV64-NEXT:    ret
  %or = shl i32 %x, 17
  %shl = xor i32 %or, -31588352
  ret i32 %shl
}

; Negative test. Can't transform because the constant has a 1 in the bits
; cleared by the shl.
define signext i32 @test14(i32 signext %x) nounwind {
; RV32-LABEL: test14:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a0, a0, 10
; RV32-NEXT:    lui a1, 8
; RV32-NEXT:    addi a1, a1, -1027
; RV32-NEXT:    or a0, a0, a1
; RV32-NEXT:    ret
;
; RV64-LABEL: test14:
; RV64:       # %bb.0:
; RV64-NEXT:    slliw a0, a0, 10
; RV64-NEXT:    lui a1, 8
; RV64-NEXT:    addiw a1, a1, -1027
; RV64-NEXT:    or a0, a0, a1
; RV64-NEXT:    ret
  %or = shl i32 %x, 10
  %shl = or i32 %or, 31741
  ret i32 %shl
}

; Negative test. Can't transform because the constant has a 1 in the bits
; cleared by the shl.
define signext i32 @test15(i32 signext %x) nounwind {
; RV32-LABEL: test15:
; RV32:       # %bb.0:
; RV32-NEXT:    slli a0, a0, 10
; RV32-NEXT:    lui a1, 8
; RV32-NEXT:    addi a1, a1, -515
; RV32-NEXT:    xor a0, a0, a1
; RV32-NEXT:    ret
;
; RV64-LABEL: test15:
; RV64:       # %bb.0:
; RV64-NEXT:    slliw a0, a0, 10
; RV64-NEXT:    lui a1, 8
; RV64-NEXT:    addiw a1, a1, -515
; RV64-NEXT:    xor a0, a0, a1
; RV64-NEXT:    ret
  %xor = shl i32 %x, 10
  %shl = xor i32 %xor, 32253
  ret i32 %shl
}
