; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv64 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV64I

define i64 @icmp_eq(i64 %a, i64 %b) nounwind {
; RV64I-LABEL: icmp_eq:
; RV64I:       # %bb.0:
; RV64I-NEXT:    xor a0, a0, a1
; RV64I-NEXT:    seqz a0, a0
; RV64I-NEXT:    ret
  %1 = icmp eq i64 %a, %b
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_eq_constant(i64 %a) nounwind {
; RV64I-LABEL: icmp_eq_constant:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi a0, a0, -42
; RV64I-NEXT:    seqz a0, a0
; RV64I-NEXT:    ret
  %1 = icmp eq i64 %a, 42
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_eq_constant_2049(i64 %a) nounwind {
; RV64I-LABEL: icmp_eq_constant_2049:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a1, 1
; RV64I-NEXT:    addiw a1, a1, -2047
; RV64I-NEXT:    xor a0, a0, a1
; RV64I-NEXT:    seqz a0, a0
; RV64I-NEXT:    ret
  %1 = icmp eq i64 %a, 2049
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_eq_constant_2048(i64 %a) nounwind {
; RV64I-LABEL: icmp_eq_constant_2048:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi a0, a0, -2048
; RV64I-NEXT:    seqz a0, a0
; RV64I-NEXT:    ret
  %1 = icmp eq i64 %a, 2048
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_eq_constant_neg_2048(i64 %a) nounwind {
; RV64I-LABEL: icmp_eq_constant_neg_2048:
; RV64I:       # %bb.0:
; RV64I-NEXT:    xori a0, a0, -2048
; RV64I-NEXT:    seqz a0, a0
; RV64I-NEXT:    ret
  %1 = icmp eq i64 %a, -2048
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_eq_constant_neg_2047(i64 %a) nounwind {
; RV64I-LABEL: icmp_eq_constant_neg_2047:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi a0, a0, 2047
; RV64I-NEXT:    seqz a0, a0
; RV64I-NEXT:    ret
  %1 = icmp eq i64 %a, -2047
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_eqz(i64 %a) nounwind {
; RV64I-LABEL: icmp_eqz:
; RV64I:       # %bb.0:
; RV64I-NEXT:    seqz a0, a0
; RV64I-NEXT:    ret
  %1 = icmp eq i64 %a, 0
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_ne(i64 %a, i64 %b) nounwind {
; RV64I-LABEL: icmp_ne:
; RV64I:       # %bb.0:
; RV64I-NEXT:    xor a0, a0, a1
; RV64I-NEXT:    snez a0, a0
; RV64I-NEXT:    ret
  %1 = icmp ne i64 %a, %b
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_ne_constant(i64 %a) nounwind {
; RV64I-LABEL: icmp_ne_constant:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi a0, a0, -42
; RV64I-NEXT:    snez a0, a0
; RV64I-NEXT:    ret
  %1 = icmp ne i64 %a, 42
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_ne_constant_2049(i64 %a) nounwind {
; RV64I-LABEL: icmp_ne_constant_2049:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a1, 1
; RV64I-NEXT:    addiw a1, a1, -2047
; RV64I-NEXT:    xor a0, a0, a1
; RV64I-NEXT:    snez a0, a0
; RV64I-NEXT:    ret
  %1 = icmp ne i64 %a, 2049
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_ne_constant_2048(i64 %a) nounwind {
; RV64I-LABEL: icmp_ne_constant_2048:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi a0, a0, -2048
; RV64I-NEXT:    snez a0, a0
; RV64I-NEXT:    ret
  %1 = icmp ne i64 %a, 2048
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_ne_constant_neg_2048(i64 %a) nounwind {
; RV64I-LABEL: icmp_ne_constant_neg_2048:
; RV64I:       # %bb.0:
; RV64I-NEXT:    xori a0, a0, -2048
; RV64I-NEXT:    snez a0, a0
; RV64I-NEXT:    ret
  %1 = icmp ne i64 %a, -2048
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_ne_constant_neg_2047(i64 %a) nounwind {
; RV64I-LABEL: icmp_ne_constant_neg_2047:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi a0, a0, 2047
; RV64I-NEXT:    snez a0, a0
; RV64I-NEXT:    ret
  %1 = icmp ne i64 %a, -2047
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_nez(i64 %a) nounwind {
; RV64I-LABEL: icmp_nez:
; RV64I:       # %bb.0:
; RV64I-NEXT:    snez a0, a0
; RV64I-NEXT:    ret
  %1 = icmp ne i64 %a, 0
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_ne_neg_1(i64 %a) nounwind {
; RV64I-LABEL: icmp_ne_neg_1:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sltiu a0, a0, -1
; RV64I-NEXT:    ret
  %1 = icmp ne i64 %a, -1
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_ugt(i64 %a, i64 %b) nounwind {
; RV64I-LABEL: icmp_ugt:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sltu a0, a1, a0
; RV64I-NEXT:    ret
  %1 = icmp ugt i64 %a, %b
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_ugt_constant_zero(i64 %a) nounwind {
; RV64I-LABEL: icmp_ugt_constant_zero:
; RV64I:       # %bb.0:
; RV64I-NEXT:    snez a0, a0
; RV64I-NEXT:    ret
  %1 = icmp ugt i64 %a, 0
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_ugt_constant_2047(i64 %a) nounwind {
; RV64I-LABEL: icmp_ugt_constant_2047:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a1, 2047
; RV64I-NEXT:    sltu a0, a1, a0
; RV64I-NEXT:    ret
  %1 = icmp ugt i64 %a, 2047
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_ugt_constant_2046(i64 %a) nounwind {
; RV64I-LABEL: icmp_ugt_constant_2046:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sltiu a0, a0, 2047
; RV64I-NEXT:    xori a0, a0, 1
; RV64I-NEXT:    ret
  %1 = icmp ugt i64 %a, 2046
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_ugt_constant_neg_2049(i64 %a) nounwind {
; RV64I-LABEL: icmp_ugt_constant_neg_2049:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sltiu a0, a0, -2048
; RV64I-NEXT:    xori a0, a0, 1
; RV64I-NEXT:    ret
; 18446744073709549567 signed extend is -2049
  %1 = icmp ugt i64 %a, 18446744073709549567
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_ugt_constant_neg_2050(i64 %a) nounwind {
; RV64I-LABEL: icmp_ugt_constant_neg_2050:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a1, 1048575
; RV64I-NEXT:    addiw a1, a1, 2046
; RV64I-NEXT:    sltu a0, a1, a0
; RV64I-NEXT:    ret
; 18446744073709549566 signed extend is -2050
  %1 = icmp ugt i64 %a, 18446744073709549566
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_uge(i64 %a, i64 %b) nounwind {
; RV64I-LABEL: icmp_uge:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sltu a0, a0, a1
; RV64I-NEXT:    xori a0, a0, 1
; RV64I-NEXT:    ret
  %1 = icmp uge i64 %a, %b
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_uge_constant_zero(i64 %a) nounwind {
; RV64I-LABEL: icmp_uge_constant_zero:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a0, 1
; RV64I-NEXT:    ret
  %1 = icmp uge i64 %a, 0
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_uge_constant_2047(i64 %a) nounwind {
; RV64I-LABEL: icmp_uge_constant_2047:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sltiu a0, a0, 2047
; RV64I-NEXT:    xori a0, a0, 1
; RV64I-NEXT:    ret
  %1 = icmp uge i64 %a, 2047
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_uge_constant_2048(i64 %a) nounwind {
; RV64I-LABEL: icmp_uge_constant_2048:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a1, 2047
; RV64I-NEXT:    sltu a0, a1, a0
; RV64I-NEXT:    ret
  %1 = icmp uge i64 %a, 2048
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_uge_constant_neg_2048(i64 %a) nounwind {
; RV64I-LABEL: icmp_uge_constant_neg_2048:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sltiu a0, a0, -2048
; RV64I-NEXT:    xori a0, a0, 1
; RV64I-NEXT:    ret
; 18446744073709549568 signed extend is -2048
  %1 = icmp uge i64 %a, 18446744073709549568
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_uge_constant_neg_2049(i64 %a) nounwind {
; RV64I-LABEL: icmp_uge_constant_neg_2049:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a1, 1048575
; RV64I-NEXT:    addiw a1, a1, 2046
; RV64I-NEXT:    sltu a0, a1, a0
; RV64I-NEXT:    ret
; 18446744073709549567 signed extend is -2049
  %1 = icmp uge i64 %a, 18446744073709549567
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_ult(i64 %a, i64 %b) nounwind {
; RV64I-LABEL: icmp_ult:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sltu a0, a0, a1
; RV64I-NEXT:    ret
  %1 = icmp ult i64 %a, %b
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_ult_constant_zero(i64 %a) nounwind {
; RV64I-LABEL: icmp_ult_constant_zero:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a0, 0
; RV64I-NEXT:    ret
  %1 = icmp ult i64 %a, 0
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_ult_constant_2047(i64 %a) nounwind {
; RV64I-LABEL: icmp_ult_constant_2047:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sltiu a0, a0, 2047
; RV64I-NEXT:    ret
  %1 = icmp ult i64 %a, 2047
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_ult_constant_2048(i64 %a) nounwind {
; RV64I-LABEL: icmp_ult_constant_2048:
; RV64I:       # %bb.0:
; RV64I-NEXT:    srli a0, a0, 11
; RV64I-NEXT:    seqz a0, a0
; RV64I-NEXT:    ret
  %1 = icmp ult i64 %a, 2048
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_ult_constant_neg_2048(i64 %a) nounwind {
; RV64I-LABEL: icmp_ult_constant_neg_2048:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sltiu a0, a0, -2048
; RV64I-NEXT:    ret
; 18446744073709549568 signed extend is -2048
  %1 = icmp ult i64 %a, 18446744073709549568
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_ult_constant_neg_2049(i64 %a) nounwind {
; RV64I-LABEL: icmp_ult_constant_neg_2049:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a1, 1048575
; RV64I-NEXT:    addiw a1, a1, 2047
; RV64I-NEXT:    sltu a0, a0, a1
; RV64I-NEXT:    ret
; 18446744073709549567 signed extend is -2049
  %1 = icmp ult i64 %a, 18446744073709549567
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_ule(i64 %a, i64 %b) nounwind {
; RV64I-LABEL: icmp_ule:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sltu a0, a1, a0
; RV64I-NEXT:    xori a0, a0, 1
; RV64I-NEXT:    ret
  %1 = icmp ule i64 %a, %b
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_ule_constant_zero(i64 %a) nounwind {
; RV64I-LABEL: icmp_ule_constant_zero:
; RV64I:       # %bb.0:
; RV64I-NEXT:    seqz a0, a0
; RV64I-NEXT:    ret
  %1 = icmp ule i64 %a, 0
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_ule_constant_2046(i64 %a) nounwind {
; RV64I-LABEL: icmp_ule_constant_2046:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sltiu a0, a0, 2047
; RV64I-NEXT:    ret
  %1 = icmp ule i64 %a, 2046
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_ule_constant_2047(i64 %a) nounwind {
; RV64I-LABEL: icmp_ule_constant_2047:
; RV64I:       # %bb.0:
; RV64I-NEXT:    srli a0, a0, 11
; RV64I-NEXT:    seqz a0, a0
; RV64I-NEXT:    ret
  %1 = icmp ule i64 %a, 2047
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_ule_constant_neg_2049(i64 %a) nounwind {
; RV64I-LABEL: icmp_ule_constant_neg_2049:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sltiu a0, a0, -2048
; RV64I-NEXT:    ret
; 18446744073709549567 signed extend is -2049
  %1 = icmp ule i64 %a, 18446744073709549567
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_ule_constant_neg_2050(i64 %a) nounwind {
; RV64I-LABEL: icmp_ule_constant_neg_2050:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a1, 1048575
; RV64I-NEXT:    addiw a1, a1, 2047
; RV64I-NEXT:    sltu a0, a0, a1
; RV64I-NEXT:    ret
; 18446744073709549566 signed extend is -2050
  %1 = icmp ule i64 %a, 18446744073709549566
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_sgt(i64 %a, i64 %b) nounwind {
; RV64I-LABEL: icmp_sgt:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slt a0, a1, a0
; RV64I-NEXT:    ret
  %1 = icmp sgt i64 %a, %b
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_sgt_constant_zero(i64 %a) nounwind {
; RV64I-LABEL: icmp_sgt_constant_zero:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sgtz a0, a0
; RV64I-NEXT:    ret
  %1 = icmp sgt i64 %a, 0
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_sgt_constant_2046(i64 %a) nounwind {
; RV64I-LABEL: icmp_sgt_constant_2046:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slti a0, a0, 2047
; RV64I-NEXT:    xori a0, a0, 1
; RV64I-NEXT:    ret
  %1 = icmp sgt i64 %a, 2046
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_sgt_constant_2047(i64 %a) nounwind {
; RV64I-LABEL: icmp_sgt_constant_2047:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a1, 2047
; RV64I-NEXT:    slt a0, a1, a0
; RV64I-NEXT:    ret
  %1 = icmp sgt i64 %a, 2047
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_sgt_constant_neg_2049(i64 %a) nounwind {
; RV64I-LABEL: icmp_sgt_constant_neg_2049:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slti a0, a0, -2048
; RV64I-NEXT:    xori a0, a0, 1
; RV64I-NEXT:    ret
  %1 = icmp sgt i64 %a, -2049
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_sgt_constant_neg_2050(i64 %a) nounwind {
; RV64I-LABEL: icmp_sgt_constant_neg_2050:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a1, 1048575
; RV64I-NEXT:    addiw a1, a1, 2046
; RV64I-NEXT:    slt a0, a1, a0
; RV64I-NEXT:    ret
  %1 = icmp sgt i64 %a, -2050
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_sge(i64 %a, i64 %b) nounwind {
; RV64I-LABEL: icmp_sge:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slt a0, a0, a1
; RV64I-NEXT:    xori a0, a0, 1
; RV64I-NEXT:    ret
  %1 = icmp sge i64 %a, %b
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_sge_constant_zero(i64 %a) nounwind {
; RV64I-LABEL: icmp_sge_constant_zero:
; RV64I:       # %bb.0:
; RV64I-NEXT:    not a0, a0
; RV64I-NEXT:    srli a0, a0, 63
; RV64I-NEXT:    ret
  %1 = icmp sge i64 %a, 0
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_sge_constant_2047(i64 %a) nounwind {
; RV64I-LABEL: icmp_sge_constant_2047:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slti a0, a0, 2047
; RV64I-NEXT:    xori a0, a0, 1
; RV64I-NEXT:    ret
  %1 = icmp sge i64 %a, 2047
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_sge_constant_2048(i64 %a) nounwind {
; RV64I-LABEL: icmp_sge_constant_2048:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a1, 2047
; RV64I-NEXT:    slt a0, a1, a0
; RV64I-NEXT:    ret
  %1 = icmp sge i64 %a, 2048
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_sge_constant_neg_2047(i64 %a) nounwind {
; RV64I-LABEL: icmp_sge_constant_neg_2047:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slti a0, a0, -2047
; RV64I-NEXT:    xori a0, a0, 1
; RV64I-NEXT:    ret
  %1 = icmp sge i64 %a, -2047
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_sge_constant_neg_2048(i64 %a) nounwind {
; RV64I-LABEL: icmp_sge_constant_neg_2048:
; RV64I:       # %bb.0:
; RV64I-NEXT:    not a0, a0
; RV64I-NEXT:    srli a0, a0, 63
; RV64I-NEXT:    ret
  %1 = icmp sge i64 %a, 0
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_slt(i64 %a, i64 %b) nounwind {
; RV64I-LABEL: icmp_slt:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slt a0, a0, a1
; RV64I-NEXT:    ret
  %1 = icmp slt i64 %a, %b
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_slt_constant_zero(i64 %a) nounwind {
; RV64I-LABEL: icmp_slt_constant_zero:
; RV64I:       # %bb.0:
; RV64I-NEXT:    srli a0, a0, 63
; RV64I-NEXT:    ret
  %1 = icmp slt i64 %a, 0
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_slt_constant_2047(i64 %a) nounwind {
; RV64I-LABEL: icmp_slt_constant_2047:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slti a0, a0, 2047
; RV64I-NEXT:    ret
  %1 = icmp slt i64 %a, 2047
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_slt_constant_2048(i64 %a) nounwind {
; RV64I-LABEL: icmp_slt_constant_2048:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a1, 1
; RV64I-NEXT:    addiw a1, a1, -2048
; RV64I-NEXT:    slt a0, a0, a1
; RV64I-NEXT:    ret
  %1 = icmp slt i64 %a, 2048
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_slt_constant_neg_2048(i64 %a) nounwind {
; RV64I-LABEL: icmp_slt_constant_neg_2048:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slti a0, a0, -2048
; RV64I-NEXT:    ret
  %1 = icmp slt i64 %a, -2048
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_slt_constant_neg_2049(i64 %a) nounwind {
; RV64I-LABEL: icmp_slt_constant_neg_2049:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a1, 1048575
; RV64I-NEXT:    addiw a1, a1, 2047
; RV64I-NEXT:    slt a0, a0, a1
; RV64I-NEXT:    ret
  %1 = icmp slt i64 %a, -2049
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_sle(i64 %a, i64 %b) nounwind {
; RV64I-LABEL: icmp_sle:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slt a0, a1, a0
; RV64I-NEXT:    xori a0, a0, 1
; RV64I-NEXT:    ret
  %1 = icmp sle i64 %a, %b
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_sle_constant_zero(i64 %a) nounwind {
; RV64I-LABEL: icmp_sle_constant_zero:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slti a0, a0, 1
; RV64I-NEXT:    ret
  %1 = icmp sle i64 %a, 0
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_sle_constant_2046(i64 %a) nounwind {
; RV64I-LABEL: icmp_sle_constant_2046:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slti a0, a0, 2047
; RV64I-NEXT:    ret
  %1 = icmp sle i64 %a, 2046
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_sle_constant_2047(i64 %a) nounwind {
; RV64I-LABEL: icmp_sle_constant_2047:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a1, 1
; RV64I-NEXT:    addiw a1, a1, -2048
; RV64I-NEXT:    slt a0, a0, a1
; RV64I-NEXT:    ret
  %1 = icmp sle i64 %a, 2047
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_sle_constant_neg_2049(i64 %a) nounwind {
; RV64I-LABEL: icmp_sle_constant_neg_2049:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slti a0, a0, -2048
; RV64I-NEXT:    ret
  %1 = icmp sle i64 %a, -2049
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_sle_constant_neg_2050(i64 %a) nounwind {
; RV64I-LABEL: icmp_sle_constant_neg_2050:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a1, 1048575
; RV64I-NEXT:    addiw a1, a1, 2047
; RV64I-NEXT:    slt a0, a0, a1
; RV64I-NEXT:    ret
  %1 = icmp sle i64 %a, -2050
  %2 = zext i1 %1 to i64
  ret i64 %2
}

define i64 @icmp_eq_zext_inreg_small_constant(i64 %a) nounwind {
; RV64I-LABEL: icmp_eq_zext_inreg_small_constant:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sext.w a0, a0
; RV64I-NEXT:    addi a0, a0, -123
; RV64I-NEXT:    seqz a0, a0
; RV64I-NEXT:    ret
  %1 = and i64 %a, 4294967295
  %2 = icmp eq i64 %1, 123
  %3 = zext i1 %2 to i64
  ret i64 %3
}

define i64 @icmp_eq_zext_inreg_large_constant(i64 %a) nounwind {
; RV64I-LABEL: icmp_eq_zext_inreg_large_constant:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sext.w a0, a0
; RV64I-NEXT:    lui a1, 563901
; RV64I-NEXT:    addiw a1, a1, -529
; RV64I-NEXT:    xor a0, a0, a1
; RV64I-NEXT:    seqz a0, a0
; RV64I-NEXT:    ret
  %1 = and i64 %a, 4294967295
  %2 = icmp eq i64 %1, 2309737967
  %3 = zext i1 %2 to i64
  ret i64 %3
}

define i64 @icmp_ne_zext_inreg_small_constant(i64 %a) nounwind {
; RV64I-LABEL: icmp_ne_zext_inreg_small_constant:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sext.w a0, a0
; RV64I-NEXT:    snez a0, a0
; RV64I-NEXT:    ret
  %1 = and i64 %a, 4294967295
  %2 = icmp ne i64 %1, 0
  %3 = zext i1 %2 to i64
  ret i64 %3
}

define i64 @icmp_ne_zext_inreg_large_constant(i64 %a) nounwind {
; RV64I-LABEL: icmp_ne_zext_inreg_large_constant:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sext.w a0, a0
; RV64I-NEXT:    addi a0, a0, 2
; RV64I-NEXT:    snez a0, a0
; RV64I-NEXT:    ret
  %1 = and i64 %a, 4294967295
  %2 = icmp ne i64 %1, 4294967294
  %3 = zext i1 %2 to i64
  ret i64 %3
}

; This used to trigger an infinite loop where we toggled between 'and' and
; 'sext_inreg'.
define i64 @icmp_ne_zext_inreg_umin(i64 %a) nounwind {
; RV64I-LABEL: icmp_ne_zext_inreg_umin:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a1, 30141
; RV64I-NEXT:    addiw a1, a1, -747
; RV64I-NEXT:    bltu a0, a1, .LBB67_2
; RV64I-NEXT:  # %bb.1:
; RV64I-NEXT:    mv a0, a1
; RV64I-NEXT:  .LBB67_2:
; RV64I-NEXT:    addi a0, a0, -123
; RV64I-NEXT:    snez a0, a0
; RV64I-NEXT:    ret
  %1 = call i64 @llvm.umin.i64(i64 %a, i64 123456789)
  %2 = and i64 %1, 4294967295
  %3 = icmp ne i64 %2, 123
  %4 = zext i1 %3 to i64
  ret i64 %4
}
declare i64 @llvm.umin.i64(i64, i64)
