; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc --mtriple=loongarch32 --mattr=+f,-d < %s | FileCheck %s --check-prefix=LA32
; RUN: llc --mtriple=loongarch64 --mattr=+f,-d < %s | FileCheck %s --check-prefix=LA64

;; Test the 'fcmp' LLVM IR: https://llvm.org/docs/LangRef.html#fcmp-instruction
;; over float values.

define i1 @fcmp_false(float %a, float %b) {
; LA32-LABEL: fcmp_false:
; LA32:       # %bb.0:
; LA32-NEXT:    move $a0, $zero
; LA32-NEXT:    ret
;
; LA64-LABEL: fcmp_false:
; LA64:       # %bb.0:
; LA64-NEXT:    move $a0, $zero
; LA64-NEXT:    ret
  %cmp = fcmp false float %a, %b
  ret i1 %cmp
}

define i1 @fcmp_oeq(float %a, float %b) {
; LA32-LABEL: fcmp_oeq:
; LA32:       # %bb.0:
; LA32-NEXT:    fcmp.ceq.s $fcc0, $fa0, $fa1
; LA32-NEXT:    movcf2gr $a0, $fcc0
; LA32-NEXT:    ret
;
; LA64-LABEL: fcmp_oeq:
; LA64:       # %bb.0:
; LA64-NEXT:    fcmp.ceq.s $fcc0, $fa0, $fa1
; LA64-NEXT:    movcf2gr $a0, $fcc0
; LA64-NEXT:    ret
  %cmp = fcmp oeq float %a, %b
  ret i1 %cmp
}

define i1 @fcmp_ogt(float %a, float %b) {
; LA32-LABEL: fcmp_ogt:
; LA32:       # %bb.0:
; LA32-NEXT:    fcmp.clt.s $fcc0, $fa1, $fa0
; LA32-NEXT:    movcf2gr $a0, $fcc0
; LA32-NEXT:    ret
;
; LA64-LABEL: fcmp_ogt:
; LA64:       # %bb.0:
; LA64-NEXT:    fcmp.clt.s $fcc0, $fa1, $fa0
; LA64-NEXT:    movcf2gr $a0, $fcc0
; LA64-NEXT:    ret
  %cmp = fcmp ogt float %a, %b
  ret i1 %cmp
}

define i1 @fcmp_oge(float %a, float %b) {
; LA32-LABEL: fcmp_oge:
; LA32:       # %bb.0:
; LA32-NEXT:    fcmp.cle.s $fcc0, $fa1, $fa0
; LA32-NEXT:    movcf2gr $a0, $fcc0
; LA32-NEXT:    ret
;
; LA64-LABEL: fcmp_oge:
; LA64:       # %bb.0:
; LA64-NEXT:    fcmp.cle.s $fcc0, $fa1, $fa0
; LA64-NEXT:    movcf2gr $a0, $fcc0
; LA64-NEXT:    ret
  %cmp = fcmp oge float %a, %b
  ret i1 %cmp
}

define i1 @fcmp_olt(float %a, float %b) {
; LA32-LABEL: fcmp_olt:
; LA32:       # %bb.0:
; LA32-NEXT:    fcmp.clt.s $fcc0, $fa0, $fa1
; LA32-NEXT:    movcf2gr $a0, $fcc0
; LA32-NEXT:    ret
;
; LA64-LABEL: fcmp_olt:
; LA64:       # %bb.0:
; LA64-NEXT:    fcmp.clt.s $fcc0, $fa0, $fa1
; LA64-NEXT:    movcf2gr $a0, $fcc0
; LA64-NEXT:    ret
  %cmp = fcmp olt float %a, %b
  ret i1 %cmp
}

define i1 @fcmp_ole(float %a, float %b) {
; LA32-LABEL: fcmp_ole:
; LA32:       # %bb.0:
; LA32-NEXT:    fcmp.cle.s $fcc0, $fa0, $fa1
; LA32-NEXT:    movcf2gr $a0, $fcc0
; LA32-NEXT:    ret
;
; LA64-LABEL: fcmp_ole:
; LA64:       # %bb.0:
; LA64-NEXT:    fcmp.cle.s $fcc0, $fa0, $fa1
; LA64-NEXT:    movcf2gr $a0, $fcc0
; LA64-NEXT:    ret
  %cmp = fcmp ole float %a, %b
  ret i1 %cmp
}

define i1 @fcmp_one(float %a, float %b) {
; LA32-LABEL: fcmp_one:
; LA32:       # %bb.0:
; LA32-NEXT:    fcmp.cne.s $fcc0, $fa0, $fa1
; LA32-NEXT:    movcf2gr $a0, $fcc0
; LA32-NEXT:    ret
;
; LA64-LABEL: fcmp_one:
; LA64:       # %bb.0:
; LA64-NEXT:    fcmp.cne.s $fcc0, $fa0, $fa1
; LA64-NEXT:    movcf2gr $a0, $fcc0
; LA64-NEXT:    ret
  %cmp = fcmp one float %a, %b
  ret i1 %cmp
}

define i1 @fcmp_ord(float %a, float %b) {
; LA32-LABEL: fcmp_ord:
; LA32:       # %bb.0:
; LA32-NEXT:    fcmp.cor.s $fcc0, $fa0, $fa1
; LA32-NEXT:    movcf2gr $a0, $fcc0
; LA32-NEXT:    ret
;
; LA64-LABEL: fcmp_ord:
; LA64:       # %bb.0:
; LA64-NEXT:    fcmp.cor.s $fcc0, $fa0, $fa1
; LA64-NEXT:    movcf2gr $a0, $fcc0
; LA64-NEXT:    ret
  %cmp = fcmp ord float %a, %b
  ret i1 %cmp
}

define i1 @fcmp_ueq(float %a, float %b) {
; LA32-LABEL: fcmp_ueq:
; LA32:       # %bb.0:
; LA32-NEXT:    fcmp.cueq.s $fcc0, $fa0, $fa1
; LA32-NEXT:    movcf2gr $a0, $fcc0
; LA32-NEXT:    ret
;
; LA64-LABEL: fcmp_ueq:
; LA64:       # %bb.0:
; LA64-NEXT:    fcmp.cueq.s $fcc0, $fa0, $fa1
; LA64-NEXT:    movcf2gr $a0, $fcc0
; LA64-NEXT:    ret
  %cmp = fcmp ueq float %a, %b
  ret i1 %cmp
}

define i1 @fcmp_ugt(float %a, float %b) {
; LA32-LABEL: fcmp_ugt:
; LA32:       # %bb.0:
; LA32-NEXT:    fcmp.cult.s $fcc0, $fa1, $fa0
; LA32-NEXT:    movcf2gr $a0, $fcc0
; LA32-NEXT:    ret
;
; LA64-LABEL: fcmp_ugt:
; LA64:       # %bb.0:
; LA64-NEXT:    fcmp.cult.s $fcc0, $fa1, $fa0
; LA64-NEXT:    movcf2gr $a0, $fcc0
; LA64-NEXT:    ret
  %cmp = fcmp ugt float %a, %b
  ret i1 %cmp
}

define i1 @fcmp_uge(float %a, float %b) {
; LA32-LABEL: fcmp_uge:
; LA32:       # %bb.0:
; LA32-NEXT:    fcmp.cule.s $fcc0, $fa1, $fa0
; LA32-NEXT:    movcf2gr $a0, $fcc0
; LA32-NEXT:    ret
;
; LA64-LABEL: fcmp_uge:
; LA64:       # %bb.0:
; LA64-NEXT:    fcmp.cule.s $fcc0, $fa1, $fa0
; LA64-NEXT:    movcf2gr $a0, $fcc0
; LA64-NEXT:    ret
  %cmp = fcmp uge float %a, %b
  ret i1 %cmp
}

define i1 @fcmp_ult(float %a, float %b) {
; LA32-LABEL: fcmp_ult:
; LA32:       # %bb.0:
; LA32-NEXT:    fcmp.cult.s $fcc0, $fa0, $fa1
; LA32-NEXT:    movcf2gr $a0, $fcc0
; LA32-NEXT:    ret
;
; LA64-LABEL: fcmp_ult:
; LA64:       # %bb.0:
; LA64-NEXT:    fcmp.cult.s $fcc0, $fa0, $fa1
; LA64-NEXT:    movcf2gr $a0, $fcc0
; LA64-NEXT:    ret
  %cmp = fcmp ult float %a, %b
  ret i1 %cmp
}

define i1 @fcmp_ule(float %a, float %b) {
; LA32-LABEL: fcmp_ule:
; LA32:       # %bb.0:
; LA32-NEXT:    fcmp.cule.s $fcc0, $fa0, $fa1
; LA32-NEXT:    movcf2gr $a0, $fcc0
; LA32-NEXT:    ret
;
; LA64-LABEL: fcmp_ule:
; LA64:       # %bb.0:
; LA64-NEXT:    fcmp.cule.s $fcc0, $fa0, $fa1
; LA64-NEXT:    movcf2gr $a0, $fcc0
; LA64-NEXT:    ret
  %cmp = fcmp ule float %a, %b
  ret i1 %cmp
}

define i1 @fcmp_une(float %a, float %b) {
; LA32-LABEL: fcmp_une:
; LA32:       # %bb.0:
; LA32-NEXT:    fcmp.cune.s $fcc0, $fa0, $fa1
; LA32-NEXT:    movcf2gr $a0, $fcc0
; LA32-NEXT:    ret
;
; LA64-LABEL: fcmp_une:
; LA64:       # %bb.0:
; LA64-NEXT:    fcmp.cune.s $fcc0, $fa0, $fa1
; LA64-NEXT:    movcf2gr $a0, $fcc0
; LA64-NEXT:    ret
  %cmp = fcmp une float %a, %b
  ret i1 %cmp
}

define i1 @fcmp_uno(float %a, float %b) {
; LA32-LABEL: fcmp_uno:
; LA32:       # %bb.0:
; LA32-NEXT:    fcmp.cun.s $fcc0, $fa0, $fa1
; LA32-NEXT:    movcf2gr $a0, $fcc0
; LA32-NEXT:    ret
;
; LA64-LABEL: fcmp_uno:
; LA64:       # %bb.0:
; LA64-NEXT:    fcmp.cun.s $fcc0, $fa0, $fa1
; LA64-NEXT:    movcf2gr $a0, $fcc0
; LA64-NEXT:    ret
  %cmp = fcmp uno float %a, %b
  ret i1 %cmp
}

define i1 @fcmp_true(float %a, float %b) {
; LA32-LABEL: fcmp_true:
; LA32:       # %bb.0:
; LA32-NEXT:    ori $a0, $zero, 1
; LA32-NEXT:    ret
;
; LA64-LABEL: fcmp_true:
; LA64:       # %bb.0:
; LA64-NEXT:    ori $a0, $zero, 1
; LA64-NEXT:    ret
  %cmp = fcmp true float %a, %b
  ret i1 %cmp
}

define i1 @fcmp_fast_olt(float %a, float %b, i1 %c) nounwind {
; LA32-LABEL: fcmp_fast_olt:
; LA32:       # %bb.0:
; LA32-NEXT:    movgr2fr.w $fa1, $zero
; LA32-NEXT:    fcmp.cle.s $fcc0, $fa1, $fa0
; LA32-NEXT:    movcf2gr $a1, $fcc0
; LA32-NEXT:    bnez $a1, .LBB16_2
; LA32-NEXT:  # %bb.1: # %if.then
; LA32-NEXT:    ret
; LA32-NEXT:  .LBB16_2: # %if.else
; LA32-NEXT:    fcmp.clt.s $fcc0, $fa0, $fa1
; LA32-NEXT:    movcf2gr $a0, $fcc0
; LA32-NEXT:    ret
;
; LA64-LABEL: fcmp_fast_olt:
; LA64:       # %bb.0:
; LA64-NEXT:    movgr2fr.w $fa1, $zero
; LA64-NEXT:    fcmp.cle.s $fcc0, $fa1, $fa0
; LA64-NEXT:    movcf2gr $a1, $fcc0
; LA64-NEXT:    bnez $a1, .LBB16_2
; LA64-NEXT:  # %bb.1: # %if.then
; LA64-NEXT:    ret
; LA64-NEXT:  .LBB16_2: # %if.else
; LA64-NEXT:    fcmp.clt.s $fcc0, $fa0, $fa1
; LA64-NEXT:    movcf2gr $a0, $fcc0
; LA64-NEXT:    ret
  %cmp = fcmp fast olt float %a, 0.000000e+00
  br i1 %cmp, label %if.then, label %if.else

if.then:
  ret i1 %c

if.else:
  ret i1 %cmp
}

define i1 @fcmp_fast_oeq(float %a, float %b, i1 %c) nounwind {
; LA32-LABEL: fcmp_fast_oeq:
; LA32:       # %bb.0:
; LA32-NEXT:    movgr2fr.w $fa1, $zero
; LA32-NEXT:    fcmp.ceq.s $fcc0, $fa0, $fa1
; LA32-NEXT:    movcf2gr $a1, $fcc0
; LA32-NEXT:    xori $a1, $a1, 1
; LA32-NEXT:    bnez $a1, .LBB17_2
; LA32-NEXT:  # %bb.1: # %if.then
; LA32-NEXT:    ret
; LA32-NEXT:  .LBB17_2: # %if.else
; LA32-NEXT:    fcmp.ceq.s $fcc0, $fa0, $fa1
; LA32-NEXT:    movcf2gr $a0, $fcc0
; LA32-NEXT:    ret
;
; LA64-LABEL: fcmp_fast_oeq:
; LA64:       # %bb.0:
; LA64-NEXT:    movgr2fr.w $fa1, $zero
; LA64-NEXT:    fcmp.ceq.s $fcc0, $fa0, $fa1
; LA64-NEXT:    movcf2gr $a1, $fcc0
; LA64-NEXT:    xori $a1, $a1, 1
; LA64-NEXT:    bnez $a1, .LBB17_2
; LA64-NEXT:  # %bb.1: # %if.then
; LA64-NEXT:    ret
; LA64-NEXT:  .LBB17_2: # %if.else
; LA64-NEXT:    fcmp.ceq.s $fcc0, $fa0, $fa1
; LA64-NEXT:    movcf2gr $a0, $fcc0
; LA64-NEXT:    ret
  %cmp = fcmp fast oeq float %a, 0.000000e+00
  br i1 %cmp, label %if.then, label %if.else

if.then:
  ret i1 %c

if.else:
  ret i1 %cmp
}

define i1 @fcmp_fast_ole(float %a, float %b, i1 %c) nounwind {
; LA32-LABEL: fcmp_fast_ole:
; LA32:       # %bb.0:
; LA32-NEXT:    movgr2fr.w $fa1, $zero
; LA32-NEXT:    fcmp.clt.s $fcc0, $fa1, $fa0
; LA32-NEXT:    bcnez $fcc0, .LBB18_2
; LA32-NEXT:  # %bb.1: # %if.then
; LA32-NEXT:    ret
; LA32-NEXT:  .LBB18_2: # %if.else
; LA32-NEXT:    fcmp.cle.s $fcc0, $fa0, $fa1
; LA32-NEXT:    movcf2gr $a0, $fcc0
; LA32-NEXT:    ret
;
; LA64-LABEL: fcmp_fast_ole:
; LA64:       # %bb.0:
; LA64-NEXT:    movgr2fr.w $fa1, $zero
; LA64-NEXT:    fcmp.clt.s $fcc0, $fa1, $fa0
; LA64-NEXT:    bcnez $fcc0, .LBB18_2
; LA64-NEXT:  # %bb.1: # %if.then
; LA64-NEXT:    ret
; LA64-NEXT:  .LBB18_2: # %if.else
; LA64-NEXT:    fcmp.cle.s $fcc0, $fa0, $fa1
; LA64-NEXT:    movcf2gr $a0, $fcc0
; LA64-NEXT:    ret
  %cmp = fcmp fast ole float %a, 0.000000e+00
  br i1 %cmp, label %if.then, label %if.else

if.then:
  ret i1 %c

if.else:
  ret i1 %cmp
}
