; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -csky-no-aliases < %s -mtriple=csky -float-abi=hard -mattr=+hard-float -mattr=+2e3 -mattr=+fpuv2_sf | FileCheck %s --check-prefix=CHECK-SF
; RUN: llc -verify-machineinstrs -csky-no-aliases < %s -mtriple=csky -float-abi=hard -mattr=+hard-float -mattr=+2e3 -mattr=+fpuv3_sf | FileCheck %s --check-prefix=CHECK-SF2

;OEQ
define i32 @brRR_oeq(float %x, float %y) {
;
; CHECK-SF-LABEL: brRR_oeq:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    fcmpnes vr1, vr0
; CHECK-SF-NEXT:    bt32 .LBB0_2
; CHECK-SF-NEXT:  # %bb.1: # %label1
; CHECK-SF-NEXT:    movi16 a0, 1
; CHECK-SF-NEXT:    rts16
; CHECK-SF-NEXT:  .LBB0_2: # %label2
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: brRR_oeq:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    fcmpne.32 vr1, vr0
; CHECK-SF2-NEXT:    bt32 .LBB0_2
; CHECK-SF2-NEXT:  # %bb.1: # %label1
; CHECK-SF2-NEXT:    movi16 a0, 1
; CHECK-SF2-NEXT:    rts16
; CHECK-SF2-NEXT:  .LBB0_2: # %label2
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    rts16
entry:
  %fcmp = fcmp oeq float %y, %x
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brRI_oeq(float %x) {
;
; CHECK-SF-LABEL: brRI_oeq:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    movih32 a0, 16672
; CHECK-SF-NEXT:    fmtvrl vr1, a0
; CHECK-SF-NEXT:    fcmpnes vr0, vr1
; CHECK-SF-NEXT:    bt32 .LBB1_2
; CHECK-SF-NEXT:  # %bb.1: # %label1
; CHECK-SF-NEXT:    movi16 a0, 1
; CHECK-SF-NEXT:    rts16
; CHECK-SF-NEXT:  .LBB1_2: # %label2
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: brRI_oeq:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    movih32 a0, 16672
; CHECK-SF2-NEXT:    fmtvr.32.1 vr1, a0
; CHECK-SF2-NEXT:    fcmpne.32 vr0, vr1
; CHECK-SF2-NEXT:    bt32 .LBB1_2
; CHECK-SF2-NEXT:  # %bb.1: # %label1
; CHECK-SF2-NEXT:    movi16 a0, 1
; CHECK-SF2-NEXT:    rts16
; CHECK-SF2-NEXT:  .LBB1_2: # %label2
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    rts16
entry:
  %fcmp = fcmp oeq float %x, 10.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brR0_oeq(float %x) {
;
; CHECK-SF-LABEL: brR0_oeq:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    fcmpznes vr0
; CHECK-SF-NEXT:    bt32 .LBB2_2
; CHECK-SF-NEXT:  # %bb.1: # %label1
; CHECK-SF-NEXT:    movi16 a0, 1
; CHECK-SF-NEXT:    rts16
; CHECK-SF-NEXT:  .LBB2_2: # %label2
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: brR0_oeq:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    fcmpnez.32 vr0
; CHECK-SF2-NEXT:    bt32 .LBB2_2
; CHECK-SF2-NEXT:  # %bb.1: # %label1
; CHECK-SF2-NEXT:    movi16 a0, 1
; CHECK-SF2-NEXT:    rts16
; CHECK-SF2-NEXT:  .LBB2_2: # %label2
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    rts16
entry:
  %fcmp = fcmp oeq float %x, 0.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

;NE
define i32 @brRR_one(float %x, float %y) {
;
; CHECK-SF-LABEL: brRR_one:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    fcmpuos vr1, vr0
; CHECK-SF-NEXT:    mvc32 a0
; CHECK-SF-NEXT:    fcmpnes vr1, vr0
; CHECK-SF-NEXT:    mvcv16 a1
; CHECK-SF-NEXT:    or16 a0, a1
; CHECK-SF-NEXT:    btsti16 a0, 0
; CHECK-SF-NEXT:    bt32 .LBB3_2
; CHECK-SF-NEXT:  # %bb.1: # %label1
; CHECK-SF-NEXT:    movi16 a0, 1
; CHECK-SF-NEXT:    rts16
; CHECK-SF-NEXT:  .LBB3_2: # %label2
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: brRR_one:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    fcmpuo.32 vr1, vr0
; CHECK-SF2-NEXT:    mvc32 a0
; CHECK-SF2-NEXT:    fcmpne.32 vr1, vr0
; CHECK-SF2-NEXT:    mvcv16 a1
; CHECK-SF2-NEXT:    or16 a0, a1
; CHECK-SF2-NEXT:    btsti16 a0, 0
; CHECK-SF2-NEXT:    bt32 .LBB3_2
; CHECK-SF2-NEXT:  # %bb.1: # %label1
; CHECK-SF2-NEXT:    movi16 a0, 1
; CHECK-SF2-NEXT:    rts16
; CHECK-SF2-NEXT:  .LBB3_2: # %label2
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    rts16
entry:
  %fcmp = fcmp one float %y, %x
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brRI_one(float %x) {
;
; CHECK-SF-LABEL: brRI_one:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    movih32 a0, 16672
; CHECK-SF-NEXT:    fmtvrl vr1, a0
; CHECK-SF-NEXT:    fcmpnes vr0, vr1
; CHECK-SF-NEXT:    mvcv16 a0
; CHECK-SF-NEXT:    fcmpuos vr0, vr0
; CHECK-SF-NEXT:    mvc32 a1
; CHECK-SF-NEXT:    or16 a0, a1
; CHECK-SF-NEXT:    btsti16 a0, 0
; CHECK-SF-NEXT:    bt32 .LBB4_2
; CHECK-SF-NEXT:  # %bb.1: # %label1
; CHECK-SF-NEXT:    movi16 a0, 1
; CHECK-SF-NEXT:    rts16
; CHECK-SF-NEXT:  .LBB4_2: # %label2
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: brRI_one:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    movih32 a0, 16672
; CHECK-SF2-NEXT:    fmtvr.32.1 vr1, a0
; CHECK-SF2-NEXT:    fcmpne.32 vr0, vr1
; CHECK-SF2-NEXT:    mvcv16 a0
; CHECK-SF2-NEXT:    fcmpuo.32 vr0, vr0
; CHECK-SF2-NEXT:    mvc32 a1
; CHECK-SF2-NEXT:    or16 a0, a1
; CHECK-SF2-NEXT:    btsti16 a0, 0
; CHECK-SF2-NEXT:    bt32 .LBB4_2
; CHECK-SF2-NEXT:  # %bb.1: # %label1
; CHECK-SF2-NEXT:    movi16 a0, 1
; CHECK-SF2-NEXT:    rts16
; CHECK-SF2-NEXT:  .LBB4_2: # %label2
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    rts16
entry:
  %fcmp = fcmp one float %x, 10.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brR0_one(float %x) {
;
; CHECK-SF-LABEL: brR0_one:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    fcmpuos vr0, vr0
; CHECK-SF-NEXT:    mvc32 a0
; CHECK-SF-NEXT:    fcmpznes vr0
; CHECK-SF-NEXT:    mvcv16 a1
; CHECK-SF-NEXT:    or16 a0, a1
; CHECK-SF-NEXT:    btsti16 a0, 0
; CHECK-SF-NEXT:    bt32 .LBB5_2
; CHECK-SF-NEXT:  # %bb.1: # %label1
; CHECK-SF-NEXT:    movi16 a0, 1
; CHECK-SF-NEXT:    rts16
; CHECK-SF-NEXT:  .LBB5_2: # %label2
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: brR0_one:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    fcmpuo.32 vr0, vr0
; CHECK-SF2-NEXT:    mvc32 a0
; CHECK-SF2-NEXT:    fcmpnez.32 vr0
; CHECK-SF2-NEXT:    mvcv16 a1
; CHECK-SF2-NEXT:    or16 a0, a1
; CHECK-SF2-NEXT:    btsti16 a0, 0
; CHECK-SF2-NEXT:    bt32 .LBB5_2
; CHECK-SF2-NEXT:  # %bb.1: # %label1
; CHECK-SF2-NEXT:    movi16 a0, 1
; CHECK-SF2-NEXT:    rts16
; CHECK-SF2-NEXT:  .LBB5_2: # %label2
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    rts16
entry:
  %fcmp = fcmp one float %x, 0.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

;UGT
define i32 @brRR_ugt(float %x, float %y) {
;
; CHECK-SF-LABEL: brRR_ugt:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    fcmphss vr0, vr1
; CHECK-SF-NEXT:    bt32 .LBB6_2
; CHECK-SF-NEXT:  # %bb.1: # %label1
; CHECK-SF-NEXT:    movi16 a0, 1
; CHECK-SF-NEXT:    rts16
; CHECK-SF-NEXT:  .LBB6_2: # %label2
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: brRR_ugt:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    fcmphs.32 vr0, vr1
; CHECK-SF2-NEXT:    bt32 .LBB6_2
; CHECK-SF2-NEXT:  # %bb.1: # %label1
; CHECK-SF2-NEXT:    movi16 a0, 1
; CHECK-SF2-NEXT:    rts16
; CHECK-SF2-NEXT:  .LBB6_2: # %label2
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    rts16
entry:
  %fcmp = fcmp ugt float %y, %x
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brRI_ugt(float %x) {
;
; CHECK-SF-LABEL: brRI_ugt:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    movih32 a0, 16672
; CHECK-SF-NEXT:    fmtvrl vr1, a0
; CHECK-SF-NEXT:    fcmphss vr1, vr0
; CHECK-SF-NEXT:    bt32 .LBB7_2
; CHECK-SF-NEXT:  # %bb.1: # %label1
; CHECK-SF-NEXT:    movi16 a0, 1
; CHECK-SF-NEXT:    rts16
; CHECK-SF-NEXT:  .LBB7_2: # %label2
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: brRI_ugt:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    movih32 a0, 16672
; CHECK-SF2-NEXT:    fmtvr.32.1 vr1, a0
; CHECK-SF2-NEXT:    fcmphs.32 vr1, vr0
; CHECK-SF2-NEXT:    bt32 .LBB7_2
; CHECK-SF2-NEXT:  # %bb.1: # %label1
; CHECK-SF2-NEXT:    movi16 a0, 1
; CHECK-SF2-NEXT:    rts16
; CHECK-SF2-NEXT:  .LBB7_2: # %label2
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    rts16
entry:
  %fcmp = fcmp ugt float %x, 10.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brR0_ugt(float %x) {
;
; CHECK-SF-LABEL: brR0_ugt:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    fcmpzlss vr0
; CHECK-SF-NEXT:    bt32 .LBB8_2
; CHECK-SF-NEXT:  # %bb.1: # %label1
; CHECK-SF-NEXT:    movi16 a0, 1
; CHECK-SF-NEXT:    rts16
; CHECK-SF-NEXT:  .LBB8_2: # %label2
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: brR0_ugt:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    fcmplsz.32 vr0
; CHECK-SF2-NEXT:    bt32 .LBB8_2
; CHECK-SF2-NEXT:  # %bb.1: # %label1
; CHECK-SF2-NEXT:    movi16 a0, 1
; CHECK-SF2-NEXT:    rts16
; CHECK-SF2-NEXT:  .LBB8_2: # %label2
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    rts16
entry:
  %fcmp = fcmp ugt float %x, 0.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

;UGE
define i32 @brRR_uge(float %x, float %y) {
;
; CHECK-SF-LABEL: brRR_uge:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    fcmplts vr1, vr0
; CHECK-SF-NEXT:    bt32 .LBB9_2
; CHECK-SF-NEXT:  # %bb.1: # %label1
; CHECK-SF-NEXT:    movi16 a0, 1
; CHECK-SF-NEXT:    rts16
; CHECK-SF-NEXT:  .LBB9_2: # %label2
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: brRR_uge:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    fcmplt.32 vr1, vr0
; CHECK-SF2-NEXT:    bt32 .LBB9_2
; CHECK-SF2-NEXT:  # %bb.1: # %label1
; CHECK-SF2-NEXT:    movi16 a0, 1
; CHECK-SF2-NEXT:    rts16
; CHECK-SF2-NEXT:  .LBB9_2: # %label2
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    rts16
entry:
  %fcmp = fcmp uge float %y, %x
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brRI_uge(float %x) {
;
; CHECK-SF-LABEL: brRI_uge:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    movih32 a0, 16672
; CHECK-SF-NEXT:    fmtvrl vr1, a0
; CHECK-SF-NEXT:    fcmplts vr0, vr1
; CHECK-SF-NEXT:    bt32 .LBB10_2
; CHECK-SF-NEXT:  # %bb.1: # %label1
; CHECK-SF-NEXT:    movi16 a0, 1
; CHECK-SF-NEXT:    rts16
; CHECK-SF-NEXT:  .LBB10_2: # %label2
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: brRI_uge:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    movih32 a0, 16672
; CHECK-SF2-NEXT:    fmtvr.32.1 vr1, a0
; CHECK-SF2-NEXT:    fcmplt.32 vr0, vr1
; CHECK-SF2-NEXT:    bt32 .LBB10_2
; CHECK-SF2-NEXT:  # %bb.1: # %label1
; CHECK-SF2-NEXT:    movi16 a0, 1
; CHECK-SF2-NEXT:    rts16
; CHECK-SF2-NEXT:  .LBB10_2: # %label2
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    rts16
entry:
  %fcmp = fcmp uge float %x, 10.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brR0_uge(float %x) {
;
; CHECK-SF-LABEL: brR0_uge:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    fcmpzhss vr0
; CHECK-SF-NEXT:    bf32 .LBB11_2
; CHECK-SF-NEXT:  # %bb.1: # %label1
; CHECK-SF-NEXT:    movi16 a0, 1
; CHECK-SF-NEXT:    rts16
; CHECK-SF-NEXT:  .LBB11_2: # %label2
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: brR0_uge:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    fcmpltz.32 vr0
; CHECK-SF2-NEXT:    bt32 .LBB11_2
; CHECK-SF2-NEXT:  # %bb.1: # %label1
; CHECK-SF2-NEXT:    movi16 a0, 1
; CHECK-SF2-NEXT:    rts16
; CHECK-SF2-NEXT:  .LBB11_2: # %label2
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    rts16
entry:
  %fcmp = fcmp uge float %x, 0.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

;ULT
define i32 @brRR_ult(float %x, float %y) {
;
; CHECK-SF-LABEL: brRR_ult:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    fcmphss vr1, vr0
; CHECK-SF-NEXT:    bt32 .LBB12_2
; CHECK-SF-NEXT:  # %bb.1: # %label1
; CHECK-SF-NEXT:    movi16 a0, 1
; CHECK-SF-NEXT:    rts16
; CHECK-SF-NEXT:  .LBB12_2: # %label2
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: brRR_ult:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    fcmphs.32 vr1, vr0
; CHECK-SF2-NEXT:    bt32 .LBB12_2
; CHECK-SF2-NEXT:  # %bb.1: # %label1
; CHECK-SF2-NEXT:    movi16 a0, 1
; CHECK-SF2-NEXT:    rts16
; CHECK-SF2-NEXT:  .LBB12_2: # %label2
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    rts16
entry:
  %fcmp = fcmp ult float %y, %x
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brRI_ult(float %x) {
;
; CHECK-SF-LABEL: brRI_ult:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    movih32 a0, 16672
; CHECK-SF-NEXT:    fmtvrl vr1, a0
; CHECK-SF-NEXT:    fcmphss vr0, vr1
; CHECK-SF-NEXT:    bt32 .LBB13_2
; CHECK-SF-NEXT:  # %bb.1: # %label1
; CHECK-SF-NEXT:    movi16 a0, 1
; CHECK-SF-NEXT:    rts16
; CHECK-SF-NEXT:  .LBB13_2: # %label2
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: brRI_ult:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    movih32 a0, 16672
; CHECK-SF2-NEXT:    fmtvr.32.1 vr1, a0
; CHECK-SF2-NEXT:    fcmphs.32 vr0, vr1
; CHECK-SF2-NEXT:    bt32 .LBB13_2
; CHECK-SF2-NEXT:  # %bb.1: # %label1
; CHECK-SF2-NEXT:    movi16 a0, 1
; CHECK-SF2-NEXT:    rts16
; CHECK-SF2-NEXT:  .LBB13_2: # %label2
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    rts16
entry:
  %fcmp = fcmp ult float %x, 10.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brR0_ult(float %x) {
;
; CHECK-SF-LABEL: brR0_ult:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    fcmpzhss vr0
; CHECK-SF-NEXT:    bt32 .LBB14_2
; CHECK-SF-NEXT:  # %bb.1: # %label1
; CHECK-SF-NEXT:    movi16 a0, 1
; CHECK-SF-NEXT:    rts16
; CHECK-SF-NEXT:  .LBB14_2: # %label2
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: brR0_ult:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    fcmphsz.32 vr0
; CHECK-SF2-NEXT:    bt32 .LBB14_2
; CHECK-SF2-NEXT:  # %bb.1: # %label1
; CHECK-SF2-NEXT:    movi16 a0, 1
; CHECK-SF2-NEXT:    rts16
; CHECK-SF2-NEXT:  .LBB14_2: # %label2
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    rts16
entry:
  %fcmp = fcmp ult float %x, 0.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

;ULE
define i32 @brRR_ule(float %x, float %y) {
;
; CHECK-SF-LABEL: brRR_ule:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    fcmplts vr0, vr1
; CHECK-SF-NEXT:    bt32 .LBB15_2
; CHECK-SF-NEXT:  # %bb.1: # %label1
; CHECK-SF-NEXT:    movi16 a0, 1
; CHECK-SF-NEXT:    rts16
; CHECK-SF-NEXT:  .LBB15_2: # %label2
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: brRR_ule:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    fcmplt.32 vr0, vr1
; CHECK-SF2-NEXT:    bt32 .LBB15_2
; CHECK-SF2-NEXT:  # %bb.1: # %label1
; CHECK-SF2-NEXT:    movi16 a0, 1
; CHECK-SF2-NEXT:    rts16
; CHECK-SF2-NEXT:  .LBB15_2: # %label2
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    rts16
entry:
  %fcmp = fcmp ule float %y, %x
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brRI_ule(float %x) {
;
; CHECK-SF-LABEL: brRI_ule:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    movih32 a0, 16672
; CHECK-SF-NEXT:    fmtvrl vr1, a0
; CHECK-SF-NEXT:    fcmplts vr1, vr0
; CHECK-SF-NEXT:    bt32 .LBB16_2
; CHECK-SF-NEXT:  # %bb.1: # %label1
; CHECK-SF-NEXT:    movi16 a0, 1
; CHECK-SF-NEXT:    rts16
; CHECK-SF-NEXT:  .LBB16_2: # %label2
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: brRI_ule:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    movih32 a0, 16672
; CHECK-SF2-NEXT:    fmtvr.32.1 vr1, a0
; CHECK-SF2-NEXT:    fcmplt.32 vr1, vr0
; CHECK-SF2-NEXT:    bt32 .LBB16_2
; CHECK-SF2-NEXT:  # %bb.1: # %label1
; CHECK-SF2-NEXT:    movi16 a0, 1
; CHECK-SF2-NEXT:    rts16
; CHECK-SF2-NEXT:  .LBB16_2: # %label2
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    rts16
entry:
  %fcmp = fcmp ule float %x, 10.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brR0_ule(float %x) {
;
; CHECK-SF-LABEL: brR0_ule:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    fcmpzlss vr0
; CHECK-SF-NEXT:    bf32 .LBB17_2
; CHECK-SF-NEXT:  # %bb.1: # %label1
; CHECK-SF-NEXT:    movi16 a0, 1
; CHECK-SF-NEXT:    rts16
; CHECK-SF-NEXT:  .LBB17_2: # %label2
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: brR0_ule:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    fcmphz.32 vr0
; CHECK-SF2-NEXT:    bt32 .LBB17_2
; CHECK-SF2-NEXT:  # %bb.1: # %label1
; CHECK-SF2-NEXT:    movi16 a0, 1
; CHECK-SF2-NEXT:    rts16
; CHECK-SF2-NEXT:  .LBB17_2: # %label2
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    rts16
entry:
  %fcmp = fcmp ule float %x, 0.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

;SGT
define i32 @brRR_ogt(float %x, float %y) {
;
; CHECK-SF-LABEL: brRR_ogt:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    fcmplts vr0, vr1
; CHECK-SF-NEXT:    mvc32 a0
; CHECK-SF-NEXT:    xori32 a0, a0, 1
; CHECK-SF-NEXT:    btsti16 a0, 0
; CHECK-SF-NEXT:    bt32 .LBB18_2
; CHECK-SF-NEXT:  # %bb.1: # %label1
; CHECK-SF-NEXT:    movi16 a0, 1
; CHECK-SF-NEXT:    rts16
; CHECK-SF-NEXT:  .LBB18_2: # %label2
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: brRR_ogt:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    fcmplt.32 vr0, vr1
; CHECK-SF2-NEXT:    mvc32 a0
; CHECK-SF2-NEXT:    xori32 a0, a0, 1
; CHECK-SF2-NEXT:    btsti16 a0, 0
; CHECK-SF2-NEXT:    bt32 .LBB18_2
; CHECK-SF2-NEXT:  # %bb.1: # %label1
; CHECK-SF2-NEXT:    movi16 a0, 1
; CHECK-SF2-NEXT:    rts16
; CHECK-SF2-NEXT:  .LBB18_2: # %label2
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    rts16
entry:
  %fcmp = fcmp ogt float %y, %x
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brRI_ogt(float %x) {
;
; CHECK-SF-LABEL: brRI_ogt:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    movih32 a0, 16672
; CHECK-SF-NEXT:    fmtvrl vr1, a0
; CHECK-SF-NEXT:    fcmplts vr1, vr0
; CHECK-SF-NEXT:    mvc32 a0
; CHECK-SF-NEXT:    xori32 a0, a0, 1
; CHECK-SF-NEXT:    btsti16 a0, 0
; CHECK-SF-NEXT:    bt32 .LBB19_2
; CHECK-SF-NEXT:  # %bb.1: # %label1
; CHECK-SF-NEXT:    movi16 a0, 1
; CHECK-SF-NEXT:    rts16
; CHECK-SF-NEXT:  .LBB19_2: # %label2
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: brRI_ogt:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    movih32 a0, 16672
; CHECK-SF2-NEXT:    fmtvr.32.1 vr1, a0
; CHECK-SF2-NEXT:    fcmplt.32 vr1, vr0
; CHECK-SF2-NEXT:    mvc32 a0
; CHECK-SF2-NEXT:    xori32 a0, a0, 1
; CHECK-SF2-NEXT:    btsti16 a0, 0
; CHECK-SF2-NEXT:    bt32 .LBB19_2
; CHECK-SF2-NEXT:  # %bb.1: # %label1
; CHECK-SF2-NEXT:    movi16 a0, 1
; CHECK-SF2-NEXT:    rts16
; CHECK-SF2-NEXT:  .LBB19_2: # %label2
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    rts16
entry:
  %fcmp = fcmp ogt float %x, 10.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brR0_ogt(float %x) {
;
; CHECK-SF-LABEL: brR0_ogt:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    fcmpzlss vr0
; CHECK-SF-NEXT:    mvcv16 a0
; CHECK-SF-NEXT:    xori32 a0, a0, 1
; CHECK-SF-NEXT:    btsti16 a0, 0
; CHECK-SF-NEXT:    bt32 .LBB20_2
; CHECK-SF-NEXT:  # %bb.1: # %label1
; CHECK-SF-NEXT:    movi16 a0, 1
; CHECK-SF-NEXT:    rts16
; CHECK-SF-NEXT:  .LBB20_2: # %label2
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: brR0_ogt:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    fcmphz.32 vr0
; CHECK-SF2-NEXT:    mvc32 a0
; CHECK-SF2-NEXT:    xori32 a0, a0, 1
; CHECK-SF2-NEXT:    btsti16 a0, 0
; CHECK-SF2-NEXT:    bt32 .LBB20_2
; CHECK-SF2-NEXT:  # %bb.1: # %label1
; CHECK-SF2-NEXT:    movi16 a0, 1
; CHECK-SF2-NEXT:    rts16
; CHECK-SF2-NEXT:  .LBB20_2: # %label2
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    rts16
entry:
  %fcmp = fcmp ogt float %x, 0.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

;SGE
define i32 @brRR_oge(float %x, float %y) {
;
; CHECK-SF-LABEL: brRR_oge:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    fcmphss vr1, vr0
; CHECK-SF-NEXT:    mvc32 a0
; CHECK-SF-NEXT:    xori32 a0, a0, 1
; CHECK-SF-NEXT:    btsti16 a0, 0
; CHECK-SF-NEXT:    bt32 .LBB21_2
; CHECK-SF-NEXT:  # %bb.1: # %label1
; CHECK-SF-NEXT:    movi16 a0, 1
; CHECK-SF-NEXT:    rts16
; CHECK-SF-NEXT:  .LBB21_2: # %label2
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: brRR_oge:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    fcmphs.32 vr1, vr0
; CHECK-SF2-NEXT:    mvc32 a0
; CHECK-SF2-NEXT:    xori32 a0, a0, 1
; CHECK-SF2-NEXT:    btsti16 a0, 0
; CHECK-SF2-NEXT:    bt32 .LBB21_2
; CHECK-SF2-NEXT:  # %bb.1: # %label1
; CHECK-SF2-NEXT:    movi16 a0, 1
; CHECK-SF2-NEXT:    rts16
; CHECK-SF2-NEXT:  .LBB21_2: # %label2
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    rts16
entry:
  %fcmp = fcmp oge float %y, %x
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brRI_oge(float %x) {
;
; CHECK-SF-LABEL: brRI_oge:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    movih32 a0, 16672
; CHECK-SF-NEXT:    fmtvrl vr1, a0
; CHECK-SF-NEXT:    fcmphss vr0, vr1
; CHECK-SF-NEXT:    mvc32 a0
; CHECK-SF-NEXT:    xori32 a0, a0, 1
; CHECK-SF-NEXT:    btsti16 a0, 0
; CHECK-SF-NEXT:    bt32 .LBB22_2
; CHECK-SF-NEXT:  # %bb.1: # %label1
; CHECK-SF-NEXT:    movi16 a0, 1
; CHECK-SF-NEXT:    rts16
; CHECK-SF-NEXT:  .LBB22_2: # %label2
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: brRI_oge:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    movih32 a0, 16672
; CHECK-SF2-NEXT:    fmtvr.32.1 vr1, a0
; CHECK-SF2-NEXT:    fcmphs.32 vr0, vr1
; CHECK-SF2-NEXT:    mvc32 a0
; CHECK-SF2-NEXT:    xori32 a0, a0, 1
; CHECK-SF2-NEXT:    btsti16 a0, 0
; CHECK-SF2-NEXT:    bt32 .LBB22_2
; CHECK-SF2-NEXT:  # %bb.1: # %label1
; CHECK-SF2-NEXT:    movi16 a0, 1
; CHECK-SF2-NEXT:    rts16
; CHECK-SF2-NEXT:  .LBB22_2: # %label2
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    rts16
entry:
  %fcmp = fcmp oge float %x, 10.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brR0_oge(float %x) {
;
; CHECK-SF-LABEL: brR0_oge:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    fcmpzhss vr0
; CHECK-SF-NEXT:    mvc32 a0
; CHECK-SF-NEXT:    xori32 a0, a0, 1
; CHECK-SF-NEXT:    btsti16 a0, 0
; CHECK-SF-NEXT:    bt32 .LBB23_2
; CHECK-SF-NEXT:  # %bb.1: # %label1
; CHECK-SF-NEXT:    movi16 a0, 1
; CHECK-SF-NEXT:    rts16
; CHECK-SF-NEXT:  .LBB23_2: # %label2
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: brR0_oge:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    fcmphsz.32 vr0
; CHECK-SF2-NEXT:    mvc32 a0
; CHECK-SF2-NEXT:    xori32 a0, a0, 1
; CHECK-SF2-NEXT:    btsti16 a0, 0
; CHECK-SF2-NEXT:    bt32 .LBB23_2
; CHECK-SF2-NEXT:  # %bb.1: # %label1
; CHECK-SF2-NEXT:    movi16 a0, 1
; CHECK-SF2-NEXT:    rts16
; CHECK-SF2-NEXT:  .LBB23_2: # %label2
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    rts16
entry:
  %fcmp = fcmp oge float %x, 0.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

;SLT
define i32 @brRR_olt(float %x, float %y) {
;
; CHECK-SF-LABEL: brRR_olt:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    fcmplts vr1, vr0
; CHECK-SF-NEXT:    mvc32 a0
; CHECK-SF-NEXT:    xori32 a0, a0, 1
; CHECK-SF-NEXT:    btsti16 a0, 0
; CHECK-SF-NEXT:    bt32 .LBB24_2
; CHECK-SF-NEXT:  # %bb.1: # %label1
; CHECK-SF-NEXT:    movi16 a0, 1
; CHECK-SF-NEXT:    rts16
; CHECK-SF-NEXT:  .LBB24_2: # %label2
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: brRR_olt:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    fcmplt.32 vr1, vr0
; CHECK-SF2-NEXT:    mvc32 a0
; CHECK-SF2-NEXT:    xori32 a0, a0, 1
; CHECK-SF2-NEXT:    btsti16 a0, 0
; CHECK-SF2-NEXT:    bt32 .LBB24_2
; CHECK-SF2-NEXT:  # %bb.1: # %label1
; CHECK-SF2-NEXT:    movi16 a0, 1
; CHECK-SF2-NEXT:    rts16
; CHECK-SF2-NEXT:  .LBB24_2: # %label2
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    rts16
entry:
  %fcmp = fcmp olt float %y, %x
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brRI_olt(float %x) {
;
; CHECK-SF-LABEL: brRI_olt:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    movih32 a0, 16672
; CHECK-SF-NEXT:    fmtvrl vr1, a0
; CHECK-SF-NEXT:    fcmplts vr0, vr1
; CHECK-SF-NEXT:    mvc32 a0
; CHECK-SF-NEXT:    xori32 a0, a0, 1
; CHECK-SF-NEXT:    btsti16 a0, 0
; CHECK-SF-NEXT:    bt32 .LBB25_2
; CHECK-SF-NEXT:  # %bb.1: # %label1
; CHECK-SF-NEXT:    movi16 a0, 1
; CHECK-SF-NEXT:    rts16
; CHECK-SF-NEXT:  .LBB25_2: # %label2
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: brRI_olt:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    movih32 a0, 16672
; CHECK-SF2-NEXT:    fmtvr.32.1 vr1, a0
; CHECK-SF2-NEXT:    fcmplt.32 vr0, vr1
; CHECK-SF2-NEXT:    mvc32 a0
; CHECK-SF2-NEXT:    xori32 a0, a0, 1
; CHECK-SF2-NEXT:    btsti16 a0, 0
; CHECK-SF2-NEXT:    bt32 .LBB25_2
; CHECK-SF2-NEXT:  # %bb.1: # %label1
; CHECK-SF2-NEXT:    movi16 a0, 1
; CHECK-SF2-NEXT:    rts16
; CHECK-SF2-NEXT:  .LBB25_2: # %label2
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    rts16
entry:
  %fcmp = fcmp olt float %x, 10.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brR0_olt(float %x) {
;
; CHECK-SF-LABEL: brR0_olt:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    fcmpzhss vr0
; CHECK-SF-NEXT:    mvcv16 a0
; CHECK-SF-NEXT:    xori32 a0, a0, 1
; CHECK-SF-NEXT:    btsti16 a0, 0
; CHECK-SF-NEXT:    bt32 .LBB26_2
; CHECK-SF-NEXT:  # %bb.1: # %label1
; CHECK-SF-NEXT:    movi16 a0, 1
; CHECK-SF-NEXT:    rts16
; CHECK-SF-NEXT:  .LBB26_2: # %label2
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: brR0_olt:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    fcmpltz.32 vr0
; CHECK-SF2-NEXT:    mvc32 a0
; CHECK-SF2-NEXT:    xori32 a0, a0, 1
; CHECK-SF2-NEXT:    btsti16 a0, 0
; CHECK-SF2-NEXT:    bt32 .LBB26_2
; CHECK-SF2-NEXT:  # %bb.1: # %label1
; CHECK-SF2-NEXT:    movi16 a0, 1
; CHECK-SF2-NEXT:    rts16
; CHECK-SF2-NEXT:  .LBB26_2: # %label2
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    rts16
entry:
  %fcmp = fcmp olt float %x, 0.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

;SLE
define i32 @brRR_ole(float %x, float %y) {
;
; CHECK-SF-LABEL: brRR_ole:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    fcmphss vr0, vr1
; CHECK-SF-NEXT:    mvc32 a0
; CHECK-SF-NEXT:    xori32 a0, a0, 1
; CHECK-SF-NEXT:    btsti16 a0, 0
; CHECK-SF-NEXT:    bt32 .LBB27_2
; CHECK-SF-NEXT:  # %bb.1: # %label1
; CHECK-SF-NEXT:    movi16 a0, 1
; CHECK-SF-NEXT:    rts16
; CHECK-SF-NEXT:  .LBB27_2: # %label2
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: brRR_ole:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    fcmphs.32 vr0, vr1
; CHECK-SF2-NEXT:    mvc32 a0
; CHECK-SF2-NEXT:    xori32 a0, a0, 1
; CHECK-SF2-NEXT:    btsti16 a0, 0
; CHECK-SF2-NEXT:    bt32 .LBB27_2
; CHECK-SF2-NEXT:  # %bb.1: # %label1
; CHECK-SF2-NEXT:    movi16 a0, 1
; CHECK-SF2-NEXT:    rts16
; CHECK-SF2-NEXT:  .LBB27_2: # %label2
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    rts16
entry:
  %fcmp = fcmp ole float %y, %x
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brRI_ole(float %x) {
;
; CHECK-SF-LABEL: brRI_ole:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    movih32 a0, 16672
; CHECK-SF-NEXT:    fmtvrl vr1, a0
; CHECK-SF-NEXT:    fcmphss vr1, vr0
; CHECK-SF-NEXT:    mvc32 a0
; CHECK-SF-NEXT:    xori32 a0, a0, 1
; CHECK-SF-NEXT:    btsti16 a0, 0
; CHECK-SF-NEXT:    bt32 .LBB28_2
; CHECK-SF-NEXT:  # %bb.1: # %label1
; CHECK-SF-NEXT:    movi16 a0, 1
; CHECK-SF-NEXT:    rts16
; CHECK-SF-NEXT:  .LBB28_2: # %label2
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: brRI_ole:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    movih32 a0, 16672
; CHECK-SF2-NEXT:    fmtvr.32.1 vr1, a0
; CHECK-SF2-NEXT:    fcmphs.32 vr1, vr0
; CHECK-SF2-NEXT:    mvc32 a0
; CHECK-SF2-NEXT:    xori32 a0, a0, 1
; CHECK-SF2-NEXT:    btsti16 a0, 0
; CHECK-SF2-NEXT:    bt32 .LBB28_2
; CHECK-SF2-NEXT:  # %bb.1: # %label1
; CHECK-SF2-NEXT:    movi16 a0, 1
; CHECK-SF2-NEXT:    rts16
; CHECK-SF2-NEXT:  .LBB28_2: # %label2
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    rts16
entry:
  %fcmp = fcmp ole float %x, 10.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brR0_ole(float %x) {
;
; CHECK-SF-LABEL: brR0_ole:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    fcmpzlss vr0
; CHECK-SF-NEXT:    mvc32 a0
; CHECK-SF-NEXT:    xori32 a0, a0, 1
; CHECK-SF-NEXT:    btsti16 a0, 0
; CHECK-SF-NEXT:    bt32 .LBB29_2
; CHECK-SF-NEXT:  # %bb.1: # %label1
; CHECK-SF-NEXT:    movi16 a0, 1
; CHECK-SF-NEXT:    rts16
; CHECK-SF-NEXT:  .LBB29_2: # %label2
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: brR0_ole:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    fcmplsz.32 vr0
; CHECK-SF2-NEXT:    mvc32 a0
; CHECK-SF2-NEXT:    xori32 a0, a0, 1
; CHECK-SF2-NEXT:    btsti16 a0, 0
; CHECK-SF2-NEXT:    bt32 .LBB29_2
; CHECK-SF2-NEXT:  # %bb.1: # %label1
; CHECK-SF2-NEXT:    movi16 a0, 1
; CHECK-SF2-NEXT:    rts16
; CHECK-SF2-NEXT:  .LBB29_2: # %label2
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    rts16
entry:
  %fcmp = fcmp ole float %x, 0.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

;False
define i32 @brRR_false(float %x, float %y) {
;
; CHECK-SF-LABEL: brRR_false:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    movi16 a0, 1
; CHECK-SF-NEXT:    btsti16 a0, 0
; CHECK-SF-NEXT:    bt32 .LBB30_2
; CHECK-SF-NEXT:  # %bb.1: # %label1
; CHECK-SF-NEXT:    movi16 a0, 1
; CHECK-SF-NEXT:    rts16
; CHECK-SF-NEXT:  .LBB30_2: # %label2
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: brRR_false:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    movi16 a0, 1
; CHECK-SF2-NEXT:    btsti16 a0, 0
; CHECK-SF2-NEXT:    bt32 .LBB30_2
; CHECK-SF2-NEXT:  # %bb.1: # %label1
; CHECK-SF2-NEXT:    movi16 a0, 1
; CHECK-SF2-NEXT:    rts16
; CHECK-SF2-NEXT:  .LBB30_2: # %label2
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    rts16
entry:
  %fcmp = fcmp false float %y, %x
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brRI_false(float %x) {
;
; CHECK-SF-LABEL: brRI_false:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    movi16 a0, 1
; CHECK-SF-NEXT:    btsti16 a0, 0
; CHECK-SF-NEXT:    bt32 .LBB31_2
; CHECK-SF-NEXT:  # %bb.1: # %label1
; CHECK-SF-NEXT:    movi16 a0, 1
; CHECK-SF-NEXT:    rts16
; CHECK-SF-NEXT:  .LBB31_2: # %label2
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: brRI_false:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    movi16 a0, 1
; CHECK-SF2-NEXT:    btsti16 a0, 0
; CHECK-SF2-NEXT:    bt32 .LBB31_2
; CHECK-SF2-NEXT:  # %bb.1: # %label1
; CHECK-SF2-NEXT:    movi16 a0, 1
; CHECK-SF2-NEXT:    rts16
; CHECK-SF2-NEXT:  .LBB31_2: # %label2
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    rts16
entry:
  %fcmp = fcmp false float %x, 10.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brR0_false(float %x) {
;
; CHECK-SF-LABEL: brR0_false:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    movi16 a0, 1
; CHECK-SF-NEXT:    btsti16 a0, 0
; CHECK-SF-NEXT:    bt32 .LBB32_2
; CHECK-SF-NEXT:  # %bb.1: # %label1
; CHECK-SF-NEXT:    movi16 a0, 1
; CHECK-SF-NEXT:    rts16
; CHECK-SF-NEXT:  .LBB32_2: # %label2
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: brR0_false:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    movi16 a0, 1
; CHECK-SF2-NEXT:    btsti16 a0, 0
; CHECK-SF2-NEXT:    bt32 .LBB32_2
; CHECK-SF2-NEXT:  # %bb.1: # %label1
; CHECK-SF2-NEXT:    movi16 a0, 1
; CHECK-SF2-NEXT:    rts16
; CHECK-SF2-NEXT:  .LBB32_2: # %label2
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    rts16
entry:
  %fcmp = fcmp false float %x, 0.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}


;ORD
define i32 @brRR_ord(float %x, float %y) {
;
; CHECK-SF-LABEL: brRR_ord:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    fcmpuos vr1, vr0
; CHECK-SF-NEXT:    bt32 .LBB33_2
; CHECK-SF-NEXT:  # %bb.1: # %label1
; CHECK-SF-NEXT:    movi16 a0, 1
; CHECK-SF-NEXT:    rts16
; CHECK-SF-NEXT:  .LBB33_2: # %label2
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: brRR_ord:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    fcmpuo.32 vr1, vr0
; CHECK-SF2-NEXT:    bt32 .LBB33_2
; CHECK-SF2-NEXT:  # %bb.1: # %label1
; CHECK-SF2-NEXT:    movi16 a0, 1
; CHECK-SF2-NEXT:    rts16
; CHECK-SF2-NEXT:  .LBB33_2: # %label2
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    rts16
entry:
  %fcmp = fcmp ord float %y, %x
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brRI_ord(float %x) {
;
; CHECK-SF-LABEL: brRI_ord:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    fcmpuos vr0, vr0
; CHECK-SF-NEXT:    bt32 .LBB34_2
; CHECK-SF-NEXT:  # %bb.1: # %label1
; CHECK-SF-NEXT:    movi16 a0, 1
; CHECK-SF-NEXT:    rts16
; CHECK-SF-NEXT:  .LBB34_2: # %label2
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: brRI_ord:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    fcmpuo.32 vr0, vr0
; CHECK-SF2-NEXT:    bt32 .LBB34_2
; CHECK-SF2-NEXT:  # %bb.1: # %label1
; CHECK-SF2-NEXT:    movi16 a0, 1
; CHECK-SF2-NEXT:    rts16
; CHECK-SF2-NEXT:  .LBB34_2: # %label2
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    rts16
entry:
  %fcmp = fcmp ord float %x, 10.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brR0_ord(float %x) {
;
; CHECK-SF-LABEL: brR0_ord:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    fcmpuos vr0, vr0
; CHECK-SF-NEXT:    bt32 .LBB35_2
; CHECK-SF-NEXT:  # %bb.1: # %label1
; CHECK-SF-NEXT:    movi16 a0, 1
; CHECK-SF-NEXT:    rts16
; CHECK-SF-NEXT:  .LBB35_2: # %label2
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: brR0_ord:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    fcmpuo.32 vr0, vr0
; CHECK-SF2-NEXT:    bt32 .LBB35_2
; CHECK-SF2-NEXT:  # %bb.1: # %label1
; CHECK-SF2-NEXT:    movi16 a0, 1
; CHECK-SF2-NEXT:    rts16
; CHECK-SF2-NEXT:  .LBB35_2: # %label2
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    rts16
entry:
  %fcmp = fcmp ord float %x, 0.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}


;UEQ
define i32 @brRR_ueq(float %x, float %y) {
;
; CHECK-SF-LABEL: brRR_ueq:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    fcmpuos vr1, vr0
; CHECK-SF-NEXT:    mvcv16 a0
; CHECK-SF-NEXT:    fcmpnes vr1, vr0
; CHECK-SF-NEXT:    mvc32 a1
; CHECK-SF-NEXT:    and16 a0, a1
; CHECK-SF-NEXT:    btsti16 a0, 0
; CHECK-SF-NEXT:    bf32 .LBB36_2
; CHECK-SF-NEXT:  # %bb.1: # %label2
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    rts16
; CHECK-SF-NEXT:  .LBB36_2: # %label1
; CHECK-SF-NEXT:    movi16 a0, 1
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: brRR_ueq:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    fcmpuo.32 vr1, vr0
; CHECK-SF2-NEXT:    mvcv16 a0
; CHECK-SF2-NEXT:    fcmpne.32 vr1, vr0
; CHECK-SF2-NEXT:    mvc32 a1
; CHECK-SF2-NEXT:    and16 a0, a1
; CHECK-SF2-NEXT:    btsti16 a0, 0
; CHECK-SF2-NEXT:    bf32 .LBB36_2
; CHECK-SF2-NEXT:  # %bb.1: # %label2
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    rts16
; CHECK-SF2-NEXT:  .LBB36_2: # %label1
; CHECK-SF2-NEXT:    movi16 a0, 1
; CHECK-SF2-NEXT:    rts16
entry:
  %fcmp = fcmp ueq float %y, %x
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brRI_ueq(float %x) {
;
; CHECK-SF-LABEL: brRI_ueq:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    movih32 a0, 16672
; CHECK-SF-NEXT:    fmtvrl vr1, a0
; CHECK-SF-NEXT:    fcmpnes vr0, vr1
; CHECK-SF-NEXT:    mvc32 a0
; CHECK-SF-NEXT:    fcmpuos vr0, vr0
; CHECK-SF-NEXT:    mvcv16 a1
; CHECK-SF-NEXT:    and16 a0, a1
; CHECK-SF-NEXT:    btsti16 a0, 0
; CHECK-SF-NEXT:    bf32 .LBB37_2
; CHECK-SF-NEXT:  # %bb.1: # %label2
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    rts16
; CHECK-SF-NEXT:  .LBB37_2: # %label1
; CHECK-SF-NEXT:    movi16 a0, 1
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: brRI_ueq:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    movih32 a0, 16672
; CHECK-SF2-NEXT:    fmtvr.32.1 vr1, a0
; CHECK-SF2-NEXT:    fcmpne.32 vr0, vr1
; CHECK-SF2-NEXT:    mvc32 a0
; CHECK-SF2-NEXT:    fcmpuo.32 vr0, vr0
; CHECK-SF2-NEXT:    mvcv16 a1
; CHECK-SF2-NEXT:    and16 a0, a1
; CHECK-SF2-NEXT:    btsti16 a0, 0
; CHECK-SF2-NEXT:    bf32 .LBB37_2
; CHECK-SF2-NEXT:  # %bb.1: # %label2
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    rts16
; CHECK-SF2-NEXT:  .LBB37_2: # %label1
; CHECK-SF2-NEXT:    movi16 a0, 1
; CHECK-SF2-NEXT:    rts16
entry:
  %fcmp = fcmp ueq float %x, 10.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brR0_ueq(float %x) {
;
; CHECK-SF-LABEL: brR0_ueq:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    fcmpuos vr0, vr0
; CHECK-SF-NEXT:    mvcv16 a0
; CHECK-SF-NEXT:    fcmpznes vr0
; CHECK-SF-NEXT:    mvc32 a1
; CHECK-SF-NEXT:    and16 a0, a1
; CHECK-SF-NEXT:    btsti16 a0, 0
; CHECK-SF-NEXT:    bf32 .LBB38_2
; CHECK-SF-NEXT:  # %bb.1: # %label2
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    rts16
; CHECK-SF-NEXT:  .LBB38_2: # %label1
; CHECK-SF-NEXT:    movi16 a0, 1
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: brR0_ueq:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    fmtvr.32.1 vr1, a0
; CHECK-SF2-NEXT:    fcmpne.32 vr0, vr1
; CHECK-SF2-NEXT:    mvc32 a0
; CHECK-SF2-NEXT:    fcmpuo.32 vr0, vr0
; CHECK-SF2-NEXT:    mvcv16 a1
; CHECK-SF2-NEXT:    and16 a0, a1
; CHECK-SF2-NEXT:    btsti16 a0, 0
; CHECK-SF2-NEXT:    bf32 .LBB38_2
; CHECK-SF2-NEXT:  # %bb.1: # %label2
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    rts16
; CHECK-SF2-NEXT:  .LBB38_2: # %label1
; CHECK-SF2-NEXT:    movi16 a0, 1
; CHECK-SF2-NEXT:    rts16
entry:
  %fcmp = fcmp ueq float %x, 0.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

;UNE
define i32 @brRR_une(float %x, float %y) {
;
; CHECK-SF-LABEL: brRR_une:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    fcmpnes vr1, vr0
; CHECK-SF-NEXT:    bf32 .LBB39_2
; CHECK-SF-NEXT:  # %bb.1: # %label1
; CHECK-SF-NEXT:    movi16 a0, 1
; CHECK-SF-NEXT:    rts16
; CHECK-SF-NEXT:  .LBB39_2: # %label2
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: brRR_une:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    fcmpne.32 vr1, vr0
; CHECK-SF2-NEXT:    bf32 .LBB39_2
; CHECK-SF2-NEXT:  # %bb.1: # %label1
; CHECK-SF2-NEXT:    movi16 a0, 1
; CHECK-SF2-NEXT:    rts16
; CHECK-SF2-NEXT:  .LBB39_2: # %label2
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    rts16
entry:
  %fcmp = fcmp une float %y, %x
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brRI_une(float %x) {
;
; CHECK-SF-LABEL: brRI_une:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    movih32 a0, 16672
; CHECK-SF-NEXT:    fmtvrl vr1, a0
; CHECK-SF-NEXT:    fcmpnes vr0, vr1
; CHECK-SF-NEXT:    bf32 .LBB40_2
; CHECK-SF-NEXT:  # %bb.1: # %label1
; CHECK-SF-NEXT:    movi16 a0, 1
; CHECK-SF-NEXT:    rts16
; CHECK-SF-NEXT:  .LBB40_2: # %label2
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: brRI_une:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    movih32 a0, 16672
; CHECK-SF2-NEXT:    fmtvr.32.1 vr1, a0
; CHECK-SF2-NEXT:    fcmpne.32 vr0, vr1
; CHECK-SF2-NEXT:    bf32 .LBB40_2
; CHECK-SF2-NEXT:  # %bb.1: # %label1
; CHECK-SF2-NEXT:    movi16 a0, 1
; CHECK-SF2-NEXT:    rts16
; CHECK-SF2-NEXT:  .LBB40_2: # %label2
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    rts16
entry:
  %fcmp = fcmp une float %x, 10.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brR0_une(float %x) {
;
; CHECK-SF-LABEL: brR0_une:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    fcmpznes vr0
; CHECK-SF-NEXT:    bf32 .LBB41_2
; CHECK-SF-NEXT:  # %bb.1: # %label1
; CHECK-SF-NEXT:    movi16 a0, 1
; CHECK-SF-NEXT:    rts16
; CHECK-SF-NEXT:  .LBB41_2: # %label2
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: brR0_une:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    fcmpnez.32 vr0
; CHECK-SF2-NEXT:    bf32 .LBB41_2
; CHECK-SF2-NEXT:  # %bb.1: # %label1
; CHECK-SF2-NEXT:    movi16 a0, 1
; CHECK-SF2-NEXT:    rts16
; CHECK-SF2-NEXT:  .LBB41_2: # %label2
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    rts16
entry:
  %fcmp = fcmp une float %x, 0.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

;UNO
define i32 @brRR_uno(float %x, float %y) {
;
; CHECK-SF-LABEL: brRR_uno:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    fcmpuos vr1, vr0
; CHECK-SF-NEXT:    bt32 .LBB42_2
; CHECK-SF-NEXT:  # %bb.1: # %label2
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    rts16
; CHECK-SF-NEXT:  .LBB42_2: # %label1
; CHECK-SF-NEXT:    movi16 a0, 1
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: brRR_uno:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    fcmpuo.32 vr1, vr0
; CHECK-SF2-NEXT:    bt32 .LBB42_2
; CHECK-SF2-NEXT:  # %bb.1: # %label2
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    rts16
; CHECK-SF2-NEXT:  .LBB42_2: # %label1
; CHECK-SF2-NEXT:    movi16 a0, 1
; CHECK-SF2-NEXT:    rts16
entry:
  %fcmp = fcmp uno float %y, %x
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brRI_uno(float %x) {
;
; CHECK-SF-LABEL: brRI_uno:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    fcmpuos vr0, vr0
; CHECK-SF-NEXT:    bt32 .LBB43_2
; CHECK-SF-NEXT:  # %bb.1: # %label2
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    rts16
; CHECK-SF-NEXT:  .LBB43_2: # %label1
; CHECK-SF-NEXT:    movi16 a0, 1
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: brRI_uno:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    fcmpuo.32 vr0, vr0
; CHECK-SF2-NEXT:    bt32 .LBB43_2
; CHECK-SF2-NEXT:  # %bb.1: # %label2
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    rts16
; CHECK-SF2-NEXT:  .LBB43_2: # %label1
; CHECK-SF2-NEXT:    movi16 a0, 1
; CHECK-SF2-NEXT:    rts16
entry:
  %fcmp = fcmp uno float %x, 10.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brR0_uno(float %x) {
;
; CHECK-SF-LABEL: brR0_uno:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    fcmpuos vr0, vr0
; CHECK-SF-NEXT:    bt32 .LBB44_2
; CHECK-SF-NEXT:  # %bb.1: # %label2
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    rts16
; CHECK-SF-NEXT:  .LBB44_2: # %label1
; CHECK-SF-NEXT:    movi16 a0, 1
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: brR0_uno:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    fcmpuo.32 vr0, vr0
; CHECK-SF2-NEXT:    bt32 .LBB44_2
; CHECK-SF2-NEXT:  # %bb.1: # %label2
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    rts16
; CHECK-SF2-NEXT:  .LBB44_2: # %label1
; CHECK-SF2-NEXT:    movi16 a0, 1
; CHECK-SF2-NEXT:    rts16
entry:
  %fcmp = fcmp uno float %x, 0.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

;True
define i32 @brRR_true(float %x, float %y) {
;
; CHECK-SF-LABEL: brRR_true:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    btsti16 a0, 0
; CHECK-SF-NEXT:    bt32 .LBB45_2
; CHECK-SF-NEXT:  # %bb.1: # %label1
; CHECK-SF-NEXT:    movi16 a0, 1
; CHECK-SF-NEXT:    rts16
; CHECK-SF-NEXT:  .LBB45_2: # %label2
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: brRR_true:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    btsti16 a0, 0
; CHECK-SF2-NEXT:    bt32 .LBB45_2
; CHECK-SF2-NEXT:  # %bb.1: # %label1
; CHECK-SF2-NEXT:    movi16 a0, 1
; CHECK-SF2-NEXT:    rts16
; CHECK-SF2-NEXT:  .LBB45_2: # %label2
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    rts16
entry:
  %fcmp = fcmp true float %y, %x
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brRI_true(float %x) {
;
; CHECK-SF-LABEL: brRI_true:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    btsti16 a0, 0
; CHECK-SF-NEXT:    bt32 .LBB46_2
; CHECK-SF-NEXT:  # %bb.1: # %label1
; CHECK-SF-NEXT:    movi16 a0, 1
; CHECK-SF-NEXT:    rts16
; CHECK-SF-NEXT:  .LBB46_2: # %label2
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: brRI_true:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    btsti16 a0, 0
; CHECK-SF2-NEXT:    bt32 .LBB46_2
; CHECK-SF2-NEXT:  # %bb.1: # %label1
; CHECK-SF2-NEXT:    movi16 a0, 1
; CHECK-SF2-NEXT:    rts16
; CHECK-SF2-NEXT:  .LBB46_2: # %label2
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    rts16
entry:
  %fcmp = fcmp true float %x, 10.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}

define i32 @brR0_true(float %x) {
;
; CHECK-SF-LABEL: brR0_true:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    btsti16 a0, 0
; CHECK-SF-NEXT:    bt32 .LBB47_2
; CHECK-SF-NEXT:  # %bb.1: # %label1
; CHECK-SF-NEXT:    movi16 a0, 1
; CHECK-SF-NEXT:    rts16
; CHECK-SF-NEXT:  .LBB47_2: # %label2
; CHECK-SF-NEXT:    movi16 a0, 0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: brR0_true:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    btsti16 a0, 0
; CHECK-SF2-NEXT:    bt32 .LBB47_2
; CHECK-SF2-NEXT:  # %bb.1: # %label1
; CHECK-SF2-NEXT:    movi16 a0, 1
; CHECK-SF2-NEXT:    rts16
; CHECK-SF2-NEXT:  .LBB47_2: # %label2
; CHECK-SF2-NEXT:    movi16 a0, 0
; CHECK-SF2-NEXT:    rts16
entry:
  %fcmp = fcmp true float %x, 0.0
  br i1 %fcmp, label %label1, label %label2
label1:
  ret i32 1
label2:
  ret i32 0
}
