; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=aarch64-linux-gnuabi -O2 | FileCheck %s

; The following cases are for i16

%struct.s_signed_i16 = type { i16, i16, i16 }
%struct.s_unsigned_i16 = type { i16, i16, i16 }

@cost_s_i8_i16 = common global %struct.s_signed_i16 zeroinitializer, align 2
@cost_u_i16 = common global %struct.s_unsigned_i16 zeroinitializer, align 2

define void @test_i16_2cmp_signed_1() {
; CHECK-LABEL: test_i16_2cmp_signed_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    adrp x8, :got:cost_s_i8_i16
; CHECK-NEXT:    ldr x8, [x8, :got_lo12:cost_s_i8_i16]
; CHECK-NEXT:    ldrsh w9, [x8, #2]
; CHECK-NEXT:    ldrsh w10, [x8, #4]
; CHECK-NEXT:    cmp w9, w10
; CHECK-NEXT:    b.lt .LBB0_2
; CHECK-NEXT:  // %bb.1: // %if.end8.sink.split
; CHECK-NEXT:    strh w9, [x8]
; CHECK-NEXT:  .LBB0_2: // %if.end8
; CHECK-NEXT:    ret
entry:
  %0 = load i16, i16* getelementptr inbounds (%struct.s_signed_i16, %struct.s_signed_i16* @cost_s_i8_i16, i64 0, i32 1), align 2
  %1 = load i16, i16* getelementptr inbounds (%struct.s_signed_i16, %struct.s_signed_i16* @cost_s_i8_i16, i64 0, i32 2), align 2
  %cmp = icmp sgt i16 %0, %1
  br i1 %cmp, label %if.then, label %if.else

if.then:                                          ; preds = %entry
  store i16 %0, i16* getelementptr inbounds (%struct.s_signed_i16, %struct.s_signed_i16* @cost_s_i8_i16, i64 0, i32 0), align 2
  br label %if.end8

if.else:                                          ; preds = %entry
  %cmp5 = icmp eq i16 %0, %1
  br i1 %cmp5, label %if.then7, label %if.end8

if.then7:                                         ; preds = %if.else
  store i16 %0, i16* getelementptr inbounds (%struct.s_signed_i16, %struct.s_signed_i16* @cost_s_i8_i16, i64 0, i32 0), align 2
  br label %if.end8

if.end8:                                          ; preds = %if.else, %if.then7, %if.then
  ret void
}

define void @test_i16_2cmp_signed_2() {
; CHECK-LABEL: test_i16_2cmp_signed_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    adrp x8, :got:cost_s_i8_i16
; CHECK-NEXT:    ldr x8, [x8, :got_lo12:cost_s_i8_i16]
; CHECK-NEXT:    ldrsh w9, [x8, #2]
; CHECK-NEXT:    ldrsh w10, [x8, #4]
; CHECK-NEXT:    cmp w9, w10
; CHECK-NEXT:    b.gt .LBB1_2
; CHECK-NEXT:  // %bb.1: // %if.else
; CHECK-NEXT:    mov w9, w10
; CHECK-NEXT:    b.ge .LBB1_3
; CHECK-NEXT:  .LBB1_2: // %if.end8.sink.split
; CHECK-NEXT:    strh w9, [x8]
; CHECK-NEXT:  .LBB1_3: // %if.end8
; CHECK-NEXT:    ret
entry:
  %0 = load i16, i16* getelementptr inbounds (%struct.s_signed_i16, %struct.s_signed_i16* @cost_s_i8_i16, i64 0, i32 1), align 2
  %1 = load i16, i16* getelementptr inbounds (%struct.s_signed_i16, %struct.s_signed_i16* @cost_s_i8_i16, i64 0, i32 2), align 2
  %cmp = icmp sgt i16 %0, %1
  br i1 %cmp, label %if.then, label %if.else

if.then:                                          ; preds = %entry
  store i16 %0, i16* getelementptr inbounds (%struct.s_signed_i16, %struct.s_signed_i16* @cost_s_i8_i16, i64 0, i32 0), align 2
  br label %if.end8

if.else:                                          ; preds = %entry
  %cmp5 = icmp slt i16 %0, %1
  br i1 %cmp5, label %if.then7, label %if.end8

if.then7:                                         ; preds = %if.else
  store i16 %1, i16* getelementptr inbounds (%struct.s_signed_i16, %struct.s_signed_i16* @cost_s_i8_i16, i64 0, i32 0), align 2
  br label %if.end8

if.end8:                                          ; preds = %if.else, %if.then7, %if.then
  ret void
}

define void @test_i16_2cmp_unsigned_1() {
; CHECK-LABEL: test_i16_2cmp_unsigned_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    adrp x8, :got:cost_u_i16
; CHECK-NEXT:    ldr x8, [x8, :got_lo12:cost_u_i16]
; CHECK-NEXT:    ldrh w9, [x8, #2]
; CHECK-NEXT:    ldrh w10, [x8, #4]
; CHECK-NEXT:    cmp w9, w10
; CHECK-NEXT:    b.lo .LBB2_2
; CHECK-NEXT:  // %bb.1: // %if.end8.sink.split
; CHECK-NEXT:    strh w9, [x8]
; CHECK-NEXT:  .LBB2_2: // %if.end8
; CHECK-NEXT:    ret
entry:
  %0 = load i16, i16* getelementptr inbounds (%struct.s_unsigned_i16, %struct.s_unsigned_i16* @cost_u_i16, i64 0, i32 1), align 2
  %1 = load i16, i16* getelementptr inbounds (%struct.s_unsigned_i16, %struct.s_unsigned_i16* @cost_u_i16, i64 0, i32 2), align 2
  %cmp = icmp ugt i16 %0, %1
  br i1 %cmp, label %if.then, label %if.else

if.then:                                          ; preds = %entry
  store i16 %0, i16* getelementptr inbounds (%struct.s_unsigned_i16, %struct.s_unsigned_i16* @cost_u_i16, i64 0, i32 0), align 2
  br label %if.end8

if.else:                                          ; preds = %entry
  %cmp5 = icmp eq i16 %0, %1
  br i1 %cmp5, label %if.then7, label %if.end8

if.then7:                                         ; preds = %if.else
  store i16 %0, i16* getelementptr inbounds (%struct.s_unsigned_i16, %struct.s_unsigned_i16* @cost_u_i16, i64 0, i32 0), align 2
  br label %if.end8

if.end8:                                          ; preds = %if.else, %if.then7, %if.then
  ret void
}

define void @test_i16_2cmp_unsigned_2() {
; CHECK-LABEL: test_i16_2cmp_unsigned_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    adrp x8, :got:cost_u_i16
; CHECK-NEXT:    ldr x8, [x8, :got_lo12:cost_u_i16]
; CHECK-NEXT:    ldrh w9, [x8, #2]
; CHECK-NEXT:    ldrh w10, [x8, #4]
; CHECK-NEXT:    cmp w9, w10
; CHECK-NEXT:    b.hi .LBB3_2
; CHECK-NEXT:  // %bb.1: // %if.else
; CHECK-NEXT:    mov w9, w10
; CHECK-NEXT:    b.hs .LBB3_3
; CHECK-NEXT:  .LBB3_2: // %if.end8.sink.split
; CHECK-NEXT:    strh w9, [x8]
; CHECK-NEXT:  .LBB3_3: // %if.end8
; CHECK-NEXT:    ret
entry:
  %0 = load i16, i16* getelementptr inbounds (%struct.s_unsigned_i16, %struct.s_unsigned_i16* @cost_u_i16, i64 0, i32 1), align 2
  %1 = load i16, i16* getelementptr inbounds (%struct.s_unsigned_i16, %struct.s_unsigned_i16* @cost_u_i16, i64 0, i32 2), align 2
  %cmp = icmp ugt i16 %0, %1
  br i1 %cmp, label %if.then, label %if.else

if.then:                                          ; preds = %entry
  store i16 %0, i16* getelementptr inbounds (%struct.s_unsigned_i16, %struct.s_unsigned_i16* @cost_u_i16, i64 0, i32 0), align 2
  br label %if.end8

if.else:                                          ; preds = %entry
  %cmp5 = icmp ult i16 %0, %1
  br i1 %cmp5, label %if.then7, label %if.end8

if.then7:                                         ; preds = %if.else
  store i16 %1, i16* getelementptr inbounds (%struct.s_unsigned_i16, %struct.s_unsigned_i16* @cost_u_i16, i64 0, i32 0), align 2
  br label %if.end8

if.end8:                                          ; preds = %if.else, %if.then7, %if.then
  ret void
}

; The following cases are for i8

%struct.s_signed_i8 = type { i8, i8, i8 }
%struct.s_unsigned_i8 = type { i8, i8, i8 }

@cost_s = common global %struct.s_signed_i8 zeroinitializer, align 2
@cost_u_i8 = common global %struct.s_unsigned_i8 zeroinitializer, align 2


define void @test_i8_2cmp_signed_1() {
; CHECK-LABEL: test_i8_2cmp_signed_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    adrp x8, :got:cost_s
; CHECK-NEXT:    ldr x8, [x8, :got_lo12:cost_s]
; CHECK-NEXT:    ldrsb w9, [x8, #1]
; CHECK-NEXT:    ldrsb w10, [x8, #2]
; CHECK-NEXT:    cmp w9, w10
; CHECK-NEXT:    b.lt .LBB4_2
; CHECK-NEXT:  // %bb.1: // %if.end8.sink.split
; CHECK-NEXT:    strb w9, [x8]
; CHECK-NEXT:  .LBB4_2: // %if.end8
; CHECK-NEXT:    ret
entry:
  %0 = load i8, i8* getelementptr inbounds (%struct.s_signed_i8, %struct.s_signed_i8* @cost_s, i64 0, i32 1), align 2
  %1 = load i8, i8* getelementptr inbounds (%struct.s_signed_i8, %struct.s_signed_i8* @cost_s, i64 0, i32 2), align 2
  %cmp = icmp sgt i8 %0, %1
  br i1 %cmp, label %if.then, label %if.else

if.then:                                          ; preds = %entry
  store i8 %0, i8* getelementptr inbounds (%struct.s_signed_i8, %struct.s_signed_i8* @cost_s, i64 0, i32 0), align 2
  br label %if.end8

if.else:                                          ; preds = %entry
  %cmp5 = icmp eq i8 %0, %1
  br i1 %cmp5, label %if.then7, label %if.end8

if.then7:                                         ; preds = %if.else
  store i8 %0, i8* getelementptr inbounds (%struct.s_signed_i8, %struct.s_signed_i8* @cost_s, i64 0, i32 0), align 2
  br label %if.end8

if.end8:                                          ; preds = %if.else, %if.then7, %if.then
  ret void
}

define void @test_i8_2cmp_signed_2() {
; CHECK-LABEL: test_i8_2cmp_signed_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    adrp x8, :got:cost_s
; CHECK-NEXT:    ldr x8, [x8, :got_lo12:cost_s]
; CHECK-NEXT:    ldrsb w9, [x8, #1]
; CHECK-NEXT:    ldrsb w10, [x8, #2]
; CHECK-NEXT:    cmp w9, w10
; CHECK-NEXT:    b.gt .LBB5_2
; CHECK-NEXT:  // %bb.1: // %if.else
; CHECK-NEXT:    mov w9, w10
; CHECK-NEXT:    b.ge .LBB5_3
; CHECK-NEXT:  .LBB5_2: // %if.end8.sink.split
; CHECK-NEXT:    strb w9, [x8]
; CHECK-NEXT:  .LBB5_3: // %if.end8
; CHECK-NEXT:    ret
entry:
  %0 = load i8, i8* getelementptr inbounds (%struct.s_signed_i8, %struct.s_signed_i8* @cost_s, i64 0, i32 1), align 2
  %1 = load i8, i8* getelementptr inbounds (%struct.s_signed_i8, %struct.s_signed_i8* @cost_s, i64 0, i32 2), align 2
  %cmp = icmp sgt i8 %0, %1
  br i1 %cmp, label %if.then, label %if.else

if.then:                                          ; preds = %entry
  store i8 %0, i8* getelementptr inbounds (%struct.s_signed_i8, %struct.s_signed_i8* @cost_s, i64 0, i32 0), align 2
  br label %if.end8

if.else:                                          ; preds = %entry
  %cmp5 = icmp slt i8 %0, %1
  br i1 %cmp5, label %if.then7, label %if.end8

if.then7:                                         ; preds = %if.else
  store i8 %1, i8* getelementptr inbounds (%struct.s_signed_i8, %struct.s_signed_i8* @cost_s, i64 0, i32 0), align 2
  br label %if.end8

if.end8:                                          ; preds = %if.else, %if.then7, %if.then
  ret void
}

define void @test_i8_2cmp_unsigned_1() {
; CHECK-LABEL: test_i8_2cmp_unsigned_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    adrp x8, :got:cost_u_i8
; CHECK-NEXT:    ldr x8, [x8, :got_lo12:cost_u_i8]
; CHECK-NEXT:    ldrb w9, [x8, #1]
; CHECK-NEXT:    ldrb w10, [x8, #2]
; CHECK-NEXT:    cmp w9, w10
; CHECK-NEXT:    b.lo .LBB6_2
; CHECK-NEXT:  // %bb.1: // %if.end8.sink.split
; CHECK-NEXT:    strb w9, [x8]
; CHECK-NEXT:  .LBB6_2: // %if.end8
; CHECK-NEXT:    ret
entry:
  %0 = load i8, i8* getelementptr inbounds (%struct.s_unsigned_i8, %struct.s_unsigned_i8* @cost_u_i8, i64 0, i32 1), align 2
  %1 = load i8, i8* getelementptr inbounds (%struct.s_unsigned_i8, %struct.s_unsigned_i8* @cost_u_i8, i64 0, i32 2), align 2
  %cmp = icmp ugt i8 %0, %1
  br i1 %cmp, label %if.then, label %if.else

if.then:                                          ; preds = %entry
  store i8 %0, i8* getelementptr inbounds (%struct.s_unsigned_i8, %struct.s_unsigned_i8* @cost_u_i8, i64 0, i32 0), align 2
  br label %if.end8

if.else:                                          ; preds = %entry
  %cmp5 = icmp eq i8 %0, %1
  br i1 %cmp5, label %if.then7, label %if.end8

if.then7:                                         ; preds = %if.else
  store i8 %0, i8* getelementptr inbounds (%struct.s_unsigned_i8, %struct.s_unsigned_i8* @cost_u_i8, i64 0, i32 0), align 2
  br label %if.end8

if.end8:                                          ; preds = %if.else, %if.then7, %if.then
  ret void
}

define void @test_i8_2cmp_unsigned_2() {
; CHECK-LABEL: test_i8_2cmp_unsigned_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    adrp x8, :got:cost_u_i8
; CHECK-NEXT:    ldr x8, [x8, :got_lo12:cost_u_i8]
; CHECK-NEXT:    ldrb w9, [x8, #1]
; CHECK-NEXT:    ldrb w10, [x8, #2]
; CHECK-NEXT:    cmp w9, w10
; CHECK-NEXT:    b.hi .LBB7_2
; CHECK-NEXT:  // %bb.1: // %if.else
; CHECK-NEXT:    mov w9, w10
; CHECK-NEXT:    b.hs .LBB7_3
; CHECK-NEXT:  .LBB7_2: // %if.end8.sink.split
; CHECK-NEXT:    strb w9, [x8]
; CHECK-NEXT:  .LBB7_3: // %if.end8
; CHECK-NEXT:    ret
entry:
  %0 = load i8, i8* getelementptr inbounds (%struct.s_unsigned_i8, %struct.s_unsigned_i8* @cost_u_i8, i64 0, i32 1), align 2
  %1 = load i8, i8* getelementptr inbounds (%struct.s_unsigned_i8, %struct.s_unsigned_i8* @cost_u_i8, i64 0, i32 2), align 2
  %cmp = icmp ugt i8 %0, %1
  br i1 %cmp, label %if.then, label %if.else

if.then:                                          ; preds = %entry
  store i8 %0, i8* getelementptr inbounds (%struct.s_unsigned_i8, %struct.s_unsigned_i8* @cost_u_i8, i64 0, i32 0), align 2
  br label %if.end8

if.else:                                          ; preds = %entry
  %cmp5 = icmp ult i8 %0, %1
  br i1 %cmp5, label %if.then7, label %if.end8

if.then7:                                         ; preds = %if.else
  store i8 %1, i8* getelementptr inbounds (%struct.s_unsigned_i8, %struct.s_unsigned_i8* @cost_u_i8, i64 0, i32 0), align 2
  br label %if.end8

if.end8:                                          ; preds = %if.else, %if.then7, %if.then
  ret void
}

; Make sure the case below won't crash.

; The optimization of ZERO_EXTEND and SIGN_EXTEND in type legalization stage can't assert
; the operand of a set_cc is always a TRUNCATE.

define i1 @foo(float %inl, float %inr) {
; CHECK-LABEL: foo:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtzs w8, s0
; CHECK-NEXT:    fcvtzs w9, s1
; CHECK-NEXT:    cmp w8, w9
; CHECK-NEXT:    cset w0, eq
; CHECK-NEXT:    ret
  %lval = fptosi float %inl to i8
  %rval = fptosi float %inr to i8
  %sum = icmp eq i8 %lval, %rval
  ret i1 %sum
}
