; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple arm64e-apple-darwin -verify-machineinstrs | FileCheck %s

target datalayout = "e-m:o-i64:64-i128:128-n32:64-S128"

define i64 @test_load_auth_da(i64* %ptr) {
; CHECK-LABEL: test_load_auth_da:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    ldraa x0, [x0]
; CHECK-NEXT:    ret
  %tmp0 = ptrtoint i64* %ptr to i64
  %tmp1 = call i64 @llvm.ptrauth.auth(i64 %tmp0, i32 2, i64 0)
  %tmp2 = inttoptr i64 %tmp1 to i64*
  %tmp3 = load i64, i64* %tmp2
  ret i64 %tmp3
}

define i64 @test_load_auth_db(i64* %ptr) {
; CHECK-LABEL: test_load_auth_db:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    ldrab x0, [x0]
; CHECK-NEXT:    ret
  %tmp0 = ptrtoint i64* %ptr to i64
  %tmp1 = call i64 @llvm.ptrauth.auth(i64 %tmp0, i32 3, i64 0)
  %tmp2 = inttoptr i64 %tmp1 to i64*
  %tmp3 = load i64, i64* %tmp2
  ret i64 %tmp3
}

; Offset.

define i64 @test_load_auth_da_8(i64* %ptr) {
; CHECK-LABEL: test_load_auth_da_8:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    ldraa x0, [x0, #8]
; CHECK-NEXT:    ret
  %tmp0 = ptrtoint i64* %ptr to i64
  %tmp1 = call i64 @llvm.ptrauth.auth(i64 %tmp0, i32 2, i64 0)
  %tmp2 = add i64 %tmp1, 8
  %tmp3 = inttoptr i64 %tmp2 to i64*
  %tmp4 = load i64, i64* %tmp3
  ret i64 %tmp4
}

define i64 @test_load_auth_da_m8(i64* %ptr) {
; CHECK-LABEL: test_load_auth_da_m8:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    ldraa x0, [x0, #-8]
; CHECK-NEXT:    ret
  %tmp0 = ptrtoint i64* %ptr to i64
  %tmp1 = call i64 @llvm.ptrauth.auth(i64 %tmp0, i32 2, i64 0)
  %tmp2 = add i64 %tmp1, -8
  %tmp3 = inttoptr i64 %tmp2 to i64*
  %tmp4 = load i64, i64* %tmp3
  ret i64 %tmp4
}

define i64 @test_load_auth_db_4088(i64* %ptr) {
; CHECK-LABEL: test_load_auth_db_4088:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    ldrab x0, [x0, #4088]
; CHECK-NEXT:    ret
  %tmp0 = ptrtoint i64* %ptr to i64
  %tmp1 = call i64 @llvm.ptrauth.auth(i64 %tmp0, i32 3, i64 0)
  %tmp2 = add i64 %tmp1, 4088
  %tmp3 = inttoptr i64 %tmp2 to i64*
  %tmp4 = load i64, i64* %tmp3
  ret i64 %tmp4
}

; Offset invalid cases.

define i64 @test_load_auth_da_4(i64* %ptr) {
; CHECK-LABEL: test_load_auth_da_4:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    mov x16, x0
; CHECK-NEXT:    autdza x16
; CHECK-NEXT:    ldur x0, [x16, #4]
; CHECK-NEXT:    ret
  %tmp0 = ptrtoint i64* %ptr to i64
  %tmp1 = call i64 @llvm.ptrauth.auth(i64 %tmp0, i32 2, i64 0)
  %tmp2 = add i64 %tmp1, 4
  %tmp3 = inttoptr i64 %tmp2 to i64*
  %tmp4 = load i64, i64* %tmp3
  ret i64 %tmp4
}

define i64 @test_load_auth_da_4096(i64* %ptr) {
; CHECK-LABEL: test_load_auth_da_4096:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    mov x16, x0
; CHECK-NEXT:    autdza x16
; CHECK-NEXT:    ldr x0, [x16, #4096]
; CHECK-NEXT:    ret
  %tmp0 = ptrtoint i64* %ptr to i64
  %tmp1 = call i64 @llvm.ptrauth.auth(i64 %tmp0, i32 2, i64 0)
  %tmp2 = add i64 %tmp1, 4096
  %tmp3 = inttoptr i64 %tmp2 to i64*
  %tmp4 = load i64, i64* %tmp3
  ret i64 %tmp4
}

; Pre-indexed variant.

define i64* @test_load_auth_da_8_pre(i64* %ptr, i64* %dst) {
; CHECK-LABEL: test_load_auth_da_8_pre:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    ldraa x8, [x0, #8]!
; CHECK-NEXT:    str x8, [x1]
; CHECK-NEXT:    ret
  %tmp0 = ptrtoint i64* %ptr to i64
  %tmp1 = call i64 @llvm.ptrauth.auth(i64 %tmp0, i32 2, i64 0)
  %tmp2 = add i64 %tmp1, 8
  %tmp3 = inttoptr i64 %tmp2 to i64*
  %tmp4 = load i64, i64* %tmp3
  store i64 %tmp4, i64* %dst
  ret i64* %tmp3
}

define i64* @test_load_auth_db_248_pre(i64* %ptr, i64* %dst) {
; CHECK-LABEL: test_load_auth_db_248_pre:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    ldrab x8, [x0, #248]!
; CHECK-NEXT:    str x8, [x1]
; CHECK-NEXT:    ret
  %tmp0 = ptrtoint i64* %ptr to i64
  %tmp1 = call i64 @llvm.ptrauth.auth(i64 %tmp0, i32 3, i64 0)
  %tmp2 = add i64 %tmp1, 248
  %tmp3 = inttoptr i64 %tmp2 to i64*
  %tmp4 = load i64, i64* %tmp3
  store i64 %tmp4, i64* %dst
  ret i64* %tmp3
}

define i64* @test_load_auth_db_m256_pre(i64* %ptr, i64* %dst) {
; CHECK-LABEL: test_load_auth_db_m256_pre:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    ldrab x8, [x0, #-256]!
; CHECK-NEXT:    str x8, [x1]
; CHECK-NEXT:    ret
  %tmp0 = ptrtoint i64* %ptr to i64
  %tmp1 = call i64 @llvm.ptrauth.auth(i64 %tmp0, i32 3, i64 0)
  %tmp2 = add i64 %tmp1, -256
  %tmp3 = inttoptr i64 %tmp2 to i64*
  %tmp4 = load i64, i64* %tmp3
  store i64 %tmp4, i64* %dst
  ret i64* %tmp3
}

; "Pre-indexed" with index 0: writeback the auth result.

define i64* @test_load_auth_da_0_pre(i64* %ptr, i64* %dst) {
; CHECK-LABEL: test_load_auth_da_0_pre:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    ldraa x8, [x0, #0]!
; CHECK-NEXT:    str x8, [x1]
; CHECK-NEXT:    ret
  %tmp0 = ptrtoint i64* %ptr to i64
  %tmp1 = call i64 @llvm.ptrauth.auth(i64 %tmp0, i32 2, i64 0)
  %tmp2 = inttoptr i64 %tmp1 to i64*
  %tmp3 = load i64, i64* %tmp2
  store i64 %tmp3, i64* %dst
  ret i64* %tmp2
}

; "Pre-indexed" with index 0, with a potential cycle.

define void @test_load_auth_da_0_pre_cycle(i64* %ptr, i64* %dst, i64* %dst2, i64* %dst3) {
; CHECK-LABEL: test_load_auth_da_0_pre_cycle:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    mov x16, x0
; CHECK-NEXT:    autdza x16
; CHECK-NEXT:    str x16, [x2]
; CHECK-NEXT:    ldr x8, [x16]
; CHECK-NEXT:    str x8, [x1]
; CHECK-NEXT:    ret
  %tmp0 = ptrtoint i64* %ptr to i64
  %tmp1 = call i64 @llvm.ptrauth.auth(i64 %tmp0, i32 2, i64 0)
  %tmp2 = inttoptr i64 %tmp1 to i64*
  store i64 %tmp1, i64* %dst2
  %tmp3 = load i64, i64* %tmp2
  store i64 %tmp3, i64* %dst
  ret void
}

; Pre-indexed invalid offsets.

define i64* @test_load_auth_db_4_pre(i64* %ptr, i64* %dst) {
; CHECK-LABEL: test_load_auth_db_4_pre:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    mov x16, x0
; CHECK-NEXT:    autdzb x16
; CHECK-NEXT:    mov x0, x16
; CHECK-NEXT:    ldr x8, [x0, #4]!
; CHECK-NEXT:    str x8, [x1]
; CHECK-NEXT:    ret
  %tmp0 = ptrtoint i64* %ptr to i64
  %tmp1 = call i64 @llvm.ptrauth.auth(i64 %tmp0, i32 3, i64 0)
  %tmp2 = add i64 %tmp1, 4
  %tmp3 = inttoptr i64 %tmp2 to i64*
  %tmp4 = load i64, i64* %tmp3
  store i64 %tmp4, i64* %dst
  ret i64* %tmp3
}

define i64* @test_load_auth_db_4096_pre(i64* %ptr, i64* %dst) {
; CHECK-LABEL: test_load_auth_db_4096_pre:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    mov x16, x0
; CHECK-NEXT:    autdzb x16
; CHECK-NEXT:    add x0, x16, #1, lsl #12 ; =4096
; CHECK-NEXT:    ldr x8, [x16, #4096]
; CHECK-NEXT:    str x8, [x1]
; CHECK-NEXT:    ret
  %tmp0 = ptrtoint i64* %ptr to i64
  %tmp1 = call i64 @llvm.ptrauth.auth(i64 %tmp0, i32 3, i64 0)
  %tmp2 = add i64 %tmp1, 4096
  %tmp3 = inttoptr i64 %tmp2 to i64*
  %tmp4 = load i64, i64* %tmp3
  store i64 %tmp4, i64* %dst
  ret i64* %tmp3
}

define i64* @test_load_auth_db_256_pre(i64* %ptr, i64* %dst) {
; CHECK-LABEL: test_load_auth_db_256_pre:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    ldrab x8, [x0, #256]!
; CHECK-NEXT:    str x8, [x1]
; CHECK-NEXT:    ret
  %tmp0 = ptrtoint i64* %ptr to i64
  %tmp1 = call i64 @llvm.ptrauth.auth(i64 %tmp0, i32 3, i64 0)
  %tmp2 = add i64 %tmp1, 256
  %tmp3 = inttoptr i64 %tmp2 to i64*
  %tmp4 = load i64, i64* %tmp3
  store i64 %tmp4, i64* %dst
  ret i64* %tmp3
}

define i64* @test_load_auth_db_m264_pre(i64* %ptr, i64* %dst) {
; CHECK-LABEL: test_load_auth_db_m264_pre:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    ldrab x8, [x0, #-264]!
; CHECK-NEXT:    str x8, [x1]
; CHECK-NEXT:    ret
  %tmp0 = ptrtoint i64* %ptr to i64
  %tmp1 = call i64 @llvm.ptrauth.auth(i64 %tmp0, i32 3, i64 0)
  %tmp2 = add i64 %tmp1, -264
  %tmp3 = inttoptr i64 %tmp2 to i64*
  %tmp4 = load i64, i64* %tmp3
  store i64 %tmp4, i64* %dst
  ret i64* %tmp3
}

; Pre-indexed multiple-use of the auth.

define i64* @test_load_auth_da_8_pre_use(i64* %ptr, i64* %dst, i64* %dst2) {
; CHECK-LABEL: test_load_auth_da_8_pre_use:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    mov x16, x0
; CHECK-NEXT:    autdza x16
; CHECK-NEXT:    mov x0, x16
; CHECK-NEXT:    ldr x8, [x0, #8]!
; CHECK-NEXT:    str x8, [x1]
; CHECK-NEXT:    str x16, [x2]
; CHECK-NEXT:    ret
  %tmp0 = ptrtoint i64* %ptr to i64
  %tmp1 = call i64 @llvm.ptrauth.auth(i64 %tmp0, i32 2, i64 0)
  %tmp2 = add i64 %tmp1, 8
  %tmp3 = inttoptr i64 %tmp2 to i64*
  %tmp4 = load i64, i64* %tmp3
  store i64 %tmp4, i64* %dst
  store i64 %tmp1, i64* %dst2
  ret i64* %tmp3
}

; Pre-indexed multiple-use of the auth, invalid offset.

define i64* @test_load_auth_da_256_pre_use(i64* %ptr, i64* %dst, i64* %dst2) {
; CHECK-LABEL: test_load_auth_da_256_pre_use:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    mov x16, x0
; CHECK-NEXT:    autdza x16
; CHECK-NEXT:    ldr x8, [x16, #256]
; CHECK-NEXT:    add x0, x16, #256
; CHECK-NEXT:    str x8, [x1]
; CHECK-NEXT:    str x16, [x2]
; CHECK-NEXT:    ret
  %tmp0 = ptrtoint i64* %ptr to i64
  %tmp1 = call i64 @llvm.ptrauth.auth(i64 %tmp0, i32 2, i64 0)
  %tmp2 = add i64 %tmp1, 256
  %tmp3 = inttoptr i64 %tmp2 to i64*
  %tmp4 = load i64, i64* %tmp3
  store i64 %tmp4, i64* %dst
  store i64 %tmp1, i64* %dst2
  ret i64* %tmp3
}

declare i64 @llvm.ptrauth.auth(i64, i32, i64)
