; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple arm64e-apple-darwin -aarch64-ptrauth-auth-checks=none -verify-machineinstrs | FileCheck %s --check-prefixes=ALL,UNCHECKED
; RUN: llc < %s -mtriple arm64e-apple-darwin                                   -verify-machineinstrs | FileCheck %s --check-prefixes=ALL,CHECKED
; RUN: llc < %s -mtriple arm64e-apple-darwin -aarch64-ptrauth-auth-checks=trap -verify-machineinstrs | FileCheck %s --check-prefixes=ALL,TRAP

target datalayout = "e-m:o-i64:64-i128:128-n32:64-S128"

define i64 @test_auth_ia(i64 %arg, i64 %arg1) {
; UNCHECKED-LABEL: test_auth_ia:
; UNCHECKED:       ; %bb.0:
; UNCHECKED-NEXT:    mov x16, x0
; UNCHECKED-NEXT:    autia x16, x1
; UNCHECKED-NEXT:    mov x0, x16
; UNCHECKED-NEXT:    ret
;
; CHECKED-LABEL: test_auth_ia:
; CHECKED:       ; %bb.0:
; CHECKED-NEXT:    mov x16, x0
; CHECKED-NEXT:    autia x16, x1
; CHECKED-NEXT:    mov x0, x16
; CHECKED-NEXT:    ret
;
; TRAP-LABEL: test_auth_ia:
; TRAP:       ; %bb.0:
; TRAP-NEXT:    mov x16, x0
; TRAP-NEXT:    mov x17, x16
; TRAP-NEXT:    autia x16, x1
; TRAP-NEXT:    xpaci x17
; TRAP-NEXT:    cmp x16, x17
; TRAP-NEXT:    b.eq #8
; TRAP-NEXT:    brk #0xc470
; TRAP-NEXT:    mov x0, x16
; TRAP-NEXT:    ret
  %tmp = call i64 @llvm.ptrauth.auth(i64 %arg, i32 0, i64 %arg1)
  ret i64 %tmp
}

define i64 @test_auth_ia_zero(i64 %arg) {
; UNCHECKED-LABEL: test_auth_ia_zero:
; UNCHECKED:       ; %bb.0:
; UNCHECKED-NEXT:    mov x16, x0
; UNCHECKED-NEXT:    autiza x16
; UNCHECKED-NEXT:    mov x0, x16
; UNCHECKED-NEXT:    ret
;
; CHECKED-LABEL: test_auth_ia_zero:
; CHECKED:       ; %bb.0:
; CHECKED-NEXT:    mov x16, x0
; CHECKED-NEXT:    autiza x16
; CHECKED-NEXT:    mov x0, x16
; CHECKED-NEXT:    ret
;
; TRAP-LABEL: test_auth_ia_zero:
; TRAP:       ; %bb.0:
; TRAP-NEXT:    mov x16, x0
; TRAP-NEXT:    mov x17, x16
; TRAP-NEXT:    autiza x16
; TRAP-NEXT:    xpaci x17
; TRAP-NEXT:    cmp x16, x17
; TRAP-NEXT:    b.eq #8
; TRAP-NEXT:    brk #0xc470
; TRAP-NEXT:    mov x0, x16
; TRAP-NEXT:    ret
  %tmp = call i64 @llvm.ptrauth.auth(i64 %arg, i32 0, i64 0)
  ret i64 %tmp
}

define i64 @test_auth_ib(i64 %arg, i64 %arg1) {
; UNCHECKED-LABEL: test_auth_ib:
; UNCHECKED:       ; %bb.0:
; UNCHECKED-NEXT:    mov x16, x0
; UNCHECKED-NEXT:    autib x16, x1
; UNCHECKED-NEXT:    mov x0, x16
; UNCHECKED-NEXT:    ret
;
; CHECKED-LABEL: test_auth_ib:
; CHECKED:       ; %bb.0:
; CHECKED-NEXT:    mov x16, x0
; CHECKED-NEXT:    autib x16, x1
; CHECKED-NEXT:    mov x0, x16
; CHECKED-NEXT:    ret
;
; TRAP-LABEL: test_auth_ib:
; TRAP:       ; %bb.0:
; TRAP-NEXT:    mov x16, x0
; TRAP-NEXT:    mov x17, x16
; TRAP-NEXT:    autib x16, x1
; TRAP-NEXT:    xpaci x17
; TRAP-NEXT:    cmp x16, x17
; TRAP-NEXT:    b.eq #8
; TRAP-NEXT:    brk #0xc471
; TRAP-NEXT:    mov x0, x16
; TRAP-NEXT:    ret
  %tmp = call i64 @llvm.ptrauth.auth(i64 %arg, i32 1, i64 %arg1)
  ret i64 %tmp
}

define i64 @test_auth_ib_zero(i64 %arg) {
; UNCHECKED-LABEL: test_auth_ib_zero:
; UNCHECKED:       ; %bb.0:
; UNCHECKED-NEXT:    mov x16, x0
; UNCHECKED-NEXT:    autizb x16
; UNCHECKED-NEXT:    mov x0, x16
; UNCHECKED-NEXT:    ret
;
; CHECKED-LABEL: test_auth_ib_zero:
; CHECKED:       ; %bb.0:
; CHECKED-NEXT:    mov x16, x0
; CHECKED-NEXT:    autizb x16
; CHECKED-NEXT:    mov x0, x16
; CHECKED-NEXT:    ret
;
; TRAP-LABEL: test_auth_ib_zero:
; TRAP:       ; %bb.0:
; TRAP-NEXT:    mov x16, x0
; TRAP-NEXT:    mov x17, x16
; TRAP-NEXT:    autizb x16
; TRAP-NEXT:    xpaci x17
; TRAP-NEXT:    cmp x16, x17
; TRAP-NEXT:    b.eq #8
; TRAP-NEXT:    brk #0xc471
; TRAP-NEXT:    mov x0, x16
; TRAP-NEXT:    ret
  %tmp = call i64 @llvm.ptrauth.auth(i64 %arg, i32 1, i64 0)
  ret i64 %tmp
}

define i64 @test_auth_da(i64 %arg, i64 %arg1) {
; UNCHECKED-LABEL: test_auth_da:
; UNCHECKED:       ; %bb.0:
; UNCHECKED-NEXT:    mov x16, x0
; UNCHECKED-NEXT:    autda x16, x1
; UNCHECKED-NEXT:    mov x0, x16
; UNCHECKED-NEXT:    ret
;
; CHECKED-LABEL: test_auth_da:
; CHECKED:       ; %bb.0:
; CHECKED-NEXT:    mov x16, x0
; CHECKED-NEXT:    autda x16, x1
; CHECKED-NEXT:    mov x0, x16
; CHECKED-NEXT:    ret
;
; TRAP-LABEL: test_auth_da:
; TRAP:       ; %bb.0:
; TRAP-NEXT:    mov x16, x0
; TRAP-NEXT:    mov x17, x16
; TRAP-NEXT:    autda x16, x1
; TRAP-NEXT:    xpacd x17
; TRAP-NEXT:    cmp x16, x17
; TRAP-NEXT:    b.eq #8
; TRAP-NEXT:    brk #0xc472
; TRAP-NEXT:    mov x0, x16
; TRAP-NEXT:    ret
  %tmp = call i64 @llvm.ptrauth.auth(i64 %arg, i32 2, i64 %arg1)
  ret i64 %tmp
}

define i64 @test_auth_da_zero(i64 %arg) {
; UNCHECKED-LABEL: test_auth_da_zero:
; UNCHECKED:       ; %bb.0:
; UNCHECKED-NEXT:    mov x16, x0
; UNCHECKED-NEXT:    autdza x16
; UNCHECKED-NEXT:    mov x0, x16
; UNCHECKED-NEXT:    ret
;
; CHECKED-LABEL: test_auth_da_zero:
; CHECKED:       ; %bb.0:
; CHECKED-NEXT:    mov x16, x0
; CHECKED-NEXT:    autdza x16
; CHECKED-NEXT:    mov x0, x16
; CHECKED-NEXT:    ret
;
; TRAP-LABEL: test_auth_da_zero:
; TRAP:       ; %bb.0:
; TRAP-NEXT:    mov x16, x0
; TRAP-NEXT:    mov x17, x16
; TRAP-NEXT:    autdza x16
; TRAP-NEXT:    xpacd x17
; TRAP-NEXT:    cmp x16, x17
; TRAP-NEXT:    b.eq #8
; TRAP-NEXT:    brk #0xc472
; TRAP-NEXT:    mov x0, x16
; TRAP-NEXT:    ret
  %tmp = call i64 @llvm.ptrauth.auth(i64 %arg, i32 2, i64 0)
  ret i64 %tmp
}

define i64 @test_auth_db(i64 %arg, i64 %arg1) {
; UNCHECKED-LABEL: test_auth_db:
; UNCHECKED:       ; %bb.0:
; UNCHECKED-NEXT:    mov x16, x0
; UNCHECKED-NEXT:    autdb x16, x1
; UNCHECKED-NEXT:    mov x0, x16
; UNCHECKED-NEXT:    ret
;
; CHECKED-LABEL: test_auth_db:
; CHECKED:       ; %bb.0:
; CHECKED-NEXT:    mov x16, x0
; CHECKED-NEXT:    autdb x16, x1
; CHECKED-NEXT:    mov x0, x16
; CHECKED-NEXT:    ret
;
; TRAP-LABEL: test_auth_db:
; TRAP:       ; %bb.0:
; TRAP-NEXT:    mov x16, x0
; TRAP-NEXT:    mov x17, x16
; TRAP-NEXT:    autdb x16, x1
; TRAP-NEXT:    xpacd x17
; TRAP-NEXT:    cmp x16, x17
; TRAP-NEXT:    b.eq #8
; TRAP-NEXT:    brk #0xc473
; TRAP-NEXT:    mov x0, x16
; TRAP-NEXT:    ret
  %tmp = call i64 @llvm.ptrauth.auth(i64 %arg, i32 3, i64 %arg1)
  ret i64 %tmp
}

define i64 @test_auth_db_zero(i64 %arg) {
; UNCHECKED-LABEL: test_auth_db_zero:
; UNCHECKED:       ; %bb.0:
; UNCHECKED-NEXT:    mov x16, x0
; UNCHECKED-NEXT:    autdzb x16
; UNCHECKED-NEXT:    mov x0, x16
; UNCHECKED-NEXT:    ret
;
; CHECKED-LABEL: test_auth_db_zero:
; CHECKED:       ; %bb.0:
; CHECKED-NEXT:    mov x16, x0
; CHECKED-NEXT:    autdzb x16
; CHECKED-NEXT:    mov x0, x16
; CHECKED-NEXT:    ret
;
; TRAP-LABEL: test_auth_db_zero:
; TRAP:       ; %bb.0:
; TRAP-NEXT:    mov x16, x0
; TRAP-NEXT:    mov x17, x16
; TRAP-NEXT:    autdzb x16
; TRAP-NEXT:    xpacd x17
; TRAP-NEXT:    cmp x16, x17
; TRAP-NEXT:    b.eq #8
; TRAP-NEXT:    brk #0xc473
; TRAP-NEXT:    mov x0, x16
; TRAP-NEXT:    ret
  %tmp = call i64 @llvm.ptrauth.auth(i64 %arg, i32 3, i64 0)
  ret i64 %tmp
}

; Note that this might seem like a no-op but is actually a valid way to enforce
; the validity of a signature.
define i64 @test_resign_ia_ia(i64 %arg, i64 %arg1, i64 %arg2) {
; UNCHECKED-LABEL: test_resign_ia_ia:
; UNCHECKED:       ; %bb.0:
; UNCHECKED-NEXT:    mov x16, x0
; UNCHECKED-NEXT:    autia x16, x1
; UNCHECKED-NEXT:    pacia x16, x2
; UNCHECKED-NEXT:    mov x0, x16
; UNCHECKED-NEXT:    ret
;
; CHECKED-LABEL: test_resign_ia_ia:
; CHECKED:       ; %bb.0:
; CHECKED-NEXT:    mov x16, x0
; CHECKED-NEXT:    mov x17, x16
; CHECKED-NEXT:    autia x16, x1
; CHECKED-NEXT:    xpaci x17
; CHECKED-NEXT:    cmp x16, x17
; CHECKED-NEXT:    pacia x16, x2
; CHECKED-NEXT:    csel x16, x16, x17, eq
; CHECKED-NEXT:    mov x0, x16
; CHECKED-NEXT:    ret
;
; TRAP-LABEL: test_resign_ia_ia:
; TRAP:       ; %bb.0:
; TRAP-NEXT:    mov x16, x0
; TRAP-NEXT:    mov x17, x16
; TRAP-NEXT:    autia x16, x1
; TRAP-NEXT:    xpaci x17
; TRAP-NEXT:    cmp x16, x17
; TRAP-NEXT:    b.eq #8
; TRAP-NEXT:    brk #0xc470
; TRAP-NEXT:    pacia x16, x2
; TRAP-NEXT:    mov x0, x16
; TRAP-NEXT:    ret
  %tmp = call i64 @llvm.ptrauth.resign(i64 %arg, i32 0, i64 %arg1, i32 0, i64 %arg2)
  ret i64 %tmp
}

define i64 @test_resign_ib_ia(i64 %arg, i64 %arg1, i64 %arg2) {
; UNCHECKED-LABEL: test_resign_ib_ia:
; UNCHECKED:       ; %bb.0:
; UNCHECKED-NEXT:    mov x16, x0
; UNCHECKED-NEXT:    autib x16, x1
; UNCHECKED-NEXT:    pacia x16, x2
; UNCHECKED-NEXT:    mov x0, x16
; UNCHECKED-NEXT:    ret
;
; CHECKED-LABEL: test_resign_ib_ia:
; CHECKED:       ; %bb.0:
; CHECKED-NEXT:    mov x16, x0
; CHECKED-NEXT:    mov x17, x16
; CHECKED-NEXT:    autib x16, x1
; CHECKED-NEXT:    xpaci x17
; CHECKED-NEXT:    cmp x16, x17
; CHECKED-NEXT:    pacia x16, x2
; CHECKED-NEXT:    csel x16, x16, x17, eq
; CHECKED-NEXT:    mov x0, x16
; CHECKED-NEXT:    ret
;
; TRAP-LABEL: test_resign_ib_ia:
; TRAP:       ; %bb.0:
; TRAP-NEXT:    mov x16, x0
; TRAP-NEXT:    mov x17, x16
; TRAP-NEXT:    autib x16, x1
; TRAP-NEXT:    xpaci x17
; TRAP-NEXT:    cmp x16, x17
; TRAP-NEXT:    b.eq #8
; TRAP-NEXT:    brk #0xc471
; TRAP-NEXT:    pacia x16, x2
; TRAP-NEXT:    mov x0, x16
; TRAP-NEXT:    ret
  %tmp = call i64 @llvm.ptrauth.resign(i64 %arg, i32 1, i64 %arg1, i32 0, i64 %arg2)
  ret i64 %tmp
}

define i64 @test_resign_da_ia(i64 %arg, i64 %arg1, i64 %arg2) {
; UNCHECKED-LABEL: test_resign_da_ia:
; UNCHECKED:       ; %bb.0:
; UNCHECKED-NEXT:    mov x16, x0
; UNCHECKED-NEXT:    autda x16, x1
; UNCHECKED-NEXT:    pacia x16, x2
; UNCHECKED-NEXT:    mov x0, x16
; UNCHECKED-NEXT:    ret
;
; CHECKED-LABEL: test_resign_da_ia:
; CHECKED:       ; %bb.0:
; CHECKED-NEXT:    mov x16, x0
; CHECKED-NEXT:    mov x17, x16
; CHECKED-NEXT:    autda x16, x1
; CHECKED-NEXT:    xpacd x17
; CHECKED-NEXT:    cmp x16, x17
; CHECKED-NEXT:    pacia x16, x2
; CHECKED-NEXT:    csel x16, x16, x17, eq
; CHECKED-NEXT:    mov x0, x16
; CHECKED-NEXT:    ret
;
; TRAP-LABEL: test_resign_da_ia:
; TRAP:       ; %bb.0:
; TRAP-NEXT:    mov x16, x0
; TRAP-NEXT:    mov x17, x16
; TRAP-NEXT:    autda x16, x1
; TRAP-NEXT:    xpacd x17
; TRAP-NEXT:    cmp x16, x17
; TRAP-NEXT:    b.eq #8
; TRAP-NEXT:    brk #0xc472
; TRAP-NEXT:    pacia x16, x2
; TRAP-NEXT:    mov x0, x16
; TRAP-NEXT:    ret
  %tmp = call i64 @llvm.ptrauth.resign(i64 %arg, i32 2, i64 %arg1, i32 0, i64 %arg2)
  ret i64 %tmp
}

define i64 @test_resign_db_ia(i64 %arg, i64 %arg1, i64 %arg2) {
; UNCHECKED-LABEL: test_resign_db_ia:
; UNCHECKED:       ; %bb.0:
; UNCHECKED-NEXT:    mov x16, x0
; UNCHECKED-NEXT:    autdb x16, x1
; UNCHECKED-NEXT:    pacia x16, x2
; UNCHECKED-NEXT:    mov x0, x16
; UNCHECKED-NEXT:    ret
;
; CHECKED-LABEL: test_resign_db_ia:
; CHECKED:       ; %bb.0:
; CHECKED-NEXT:    mov x16, x0
; CHECKED-NEXT:    mov x17, x16
; CHECKED-NEXT:    autdb x16, x1
; CHECKED-NEXT:    xpacd x17
; CHECKED-NEXT:    cmp x16, x17
; CHECKED-NEXT:    pacia x16, x2
; CHECKED-NEXT:    csel x16, x16, x17, eq
; CHECKED-NEXT:    mov x0, x16
; CHECKED-NEXT:    ret
;
; TRAP-LABEL: test_resign_db_ia:
; TRAP:       ; %bb.0:
; TRAP-NEXT:    mov x16, x0
; TRAP-NEXT:    mov x17, x16
; TRAP-NEXT:    autdb x16, x1
; TRAP-NEXT:    xpacd x17
; TRAP-NEXT:    cmp x16, x17
; TRAP-NEXT:    b.eq #8
; TRAP-NEXT:    brk #0xc473
; TRAP-NEXT:    pacia x16, x2
; TRAP-NEXT:    mov x0, x16
; TRAP-NEXT:    ret
  %tmp = call i64 @llvm.ptrauth.resign(i64 %arg, i32 3, i64 %arg1, i32 0, i64 %arg2)
  ret i64 %tmp
}

define i64 @test_resign_db_ib(i64 %arg, i64 %arg1, i64 %arg2) {
; UNCHECKED-LABEL: test_resign_db_ib:
; UNCHECKED:       ; %bb.0:
; UNCHECKED-NEXT:    mov x16, x0
; UNCHECKED-NEXT:    autdb x16, x1
; UNCHECKED-NEXT:    pacib x16, x2
; UNCHECKED-NEXT:    mov x0, x16
; UNCHECKED-NEXT:    ret
;
; CHECKED-LABEL: test_resign_db_ib:
; CHECKED:       ; %bb.0:
; CHECKED-NEXT:    mov x16, x0
; CHECKED-NEXT:    mov x17, x16
; CHECKED-NEXT:    autdb x16, x1
; CHECKED-NEXT:    xpacd x17
; CHECKED-NEXT:    cmp x16, x17
; CHECKED-NEXT:    pacib x16, x2
; CHECKED-NEXT:    csel x16, x16, x17, eq
; CHECKED-NEXT:    mov x0, x16
; CHECKED-NEXT:    ret
;
; TRAP-LABEL: test_resign_db_ib:
; TRAP:       ; %bb.0:
; TRAP-NEXT:    mov x16, x0
; TRAP-NEXT:    mov x17, x16
; TRAP-NEXT:    autdb x16, x1
; TRAP-NEXT:    xpacd x17
; TRAP-NEXT:    cmp x16, x17
; TRAP-NEXT:    b.eq #8
; TRAP-NEXT:    brk #0xc473
; TRAP-NEXT:    pacib x16, x2
; TRAP-NEXT:    mov x0, x16
; TRAP-NEXT:    ret
  %tmp = call i64 @llvm.ptrauth.resign(i64 %arg, i32 3, i64 %arg1, i32 1, i64 %arg2)
  ret i64 %tmp
}

define i64 @test_resign_db_da(i64 %arg, i64 %arg1, i64 %arg2) {
; UNCHECKED-LABEL: test_resign_db_da:
; UNCHECKED:       ; %bb.0:
; UNCHECKED-NEXT:    mov x16, x0
; UNCHECKED-NEXT:    autdb x16, x1
; UNCHECKED-NEXT:    pacda x16, x2
; UNCHECKED-NEXT:    mov x0, x16
; UNCHECKED-NEXT:    ret
;
; CHECKED-LABEL: test_resign_db_da:
; CHECKED:       ; %bb.0:
; CHECKED-NEXT:    mov x16, x0
; CHECKED-NEXT:    mov x17, x16
; CHECKED-NEXT:    autdb x16, x1
; CHECKED-NEXT:    xpacd x17
; CHECKED-NEXT:    cmp x16, x17
; CHECKED-NEXT:    pacda x16, x2
; CHECKED-NEXT:    csel x16, x16, x17, eq
; CHECKED-NEXT:    mov x0, x16
; CHECKED-NEXT:    ret
;
; TRAP-LABEL: test_resign_db_da:
; TRAP:       ; %bb.0:
; TRAP-NEXT:    mov x16, x0
; TRAP-NEXT:    mov x17, x16
; TRAP-NEXT:    autdb x16, x1
; TRAP-NEXT:    xpacd x17
; TRAP-NEXT:    cmp x16, x17
; TRAP-NEXT:    b.eq #8
; TRAP-NEXT:    brk #0xc473
; TRAP-NEXT:    pacda x16, x2
; TRAP-NEXT:    mov x0, x16
; TRAP-NEXT:    ret
  %tmp = call i64 @llvm.ptrauth.resign(i64 %arg, i32 3, i64 %arg1, i32 2, i64 %arg2)
  ret i64 %tmp
}

define i64 @test_resign_db_db(i64 %arg, i64 %arg1, i64 %arg2) {
; UNCHECKED-LABEL: test_resign_db_db:
; UNCHECKED:       ; %bb.0:
; UNCHECKED-NEXT:    mov x16, x0
; UNCHECKED-NEXT:    autdb x16, x1
; UNCHECKED-NEXT:    pacdb x16, x2
; UNCHECKED-NEXT:    mov x0, x16
; UNCHECKED-NEXT:    ret
;
; CHECKED-LABEL: test_resign_db_db:
; CHECKED:       ; %bb.0:
; CHECKED-NEXT:    mov x16, x0
; CHECKED-NEXT:    mov x17, x16
; CHECKED-NEXT:    autdb x16, x1
; CHECKED-NEXT:    xpacd x17
; CHECKED-NEXT:    cmp x16, x17
; CHECKED-NEXT:    pacdb x16, x2
; CHECKED-NEXT:    csel x16, x16, x17, eq
; CHECKED-NEXT:    mov x0, x16
; CHECKED-NEXT:    ret
;
; TRAP-LABEL: test_resign_db_db:
; TRAP:       ; %bb.0:
; TRAP-NEXT:    mov x16, x0
; TRAP-NEXT:    mov x17, x16
; TRAP-NEXT:    autdb x16, x1
; TRAP-NEXT:    xpacd x17
; TRAP-NEXT:    cmp x16, x17
; TRAP-NEXT:    b.eq #8
; TRAP-NEXT:    brk #0xc473
; TRAP-NEXT:    pacdb x16, x2
; TRAP-NEXT:    mov x0, x16
; TRAP-NEXT:    ret
  %tmp = call i64 @llvm.ptrauth.resign(i64 %arg, i32 3, i64 %arg1, i32 3, i64 %arg2)
  ret i64 %tmp
}

define i64 @test_resign_iza_db(i64 %arg, i64 %arg1, i64 %arg2) {
; UNCHECKED-LABEL: test_resign_iza_db:
; UNCHECKED:       ; %bb.0:
; UNCHECKED-NEXT:    mov x16, x0
; UNCHECKED-NEXT:    autiza x16
; UNCHECKED-NEXT:    pacdb x16, x2
; UNCHECKED-NEXT:    mov x0, x16
; UNCHECKED-NEXT:    ret
;
; CHECKED-LABEL: test_resign_iza_db:
; CHECKED:       ; %bb.0:
; CHECKED-NEXT:    mov x16, x0
; CHECKED-NEXT:    mov x17, x16
; CHECKED-NEXT:    autiza x16
; CHECKED-NEXT:    xpaci x17
; CHECKED-NEXT:    cmp x16, x17
; CHECKED-NEXT:    pacdb x16, x2
; CHECKED-NEXT:    csel x16, x16, x17, eq
; CHECKED-NEXT:    mov x0, x16
; CHECKED-NEXT:    ret
;
; TRAP-LABEL: test_resign_iza_db:
; TRAP:       ; %bb.0:
; TRAP-NEXT:    mov x16, x0
; TRAP-NEXT:    mov x17, x16
; TRAP-NEXT:    autiza x16
; TRAP-NEXT:    xpaci x17
; TRAP-NEXT:    cmp x16, x17
; TRAP-NEXT:    b.eq #8
; TRAP-NEXT:    brk #0xc470
; TRAP-NEXT:    pacdb x16, x2
; TRAP-NEXT:    mov x0, x16
; TRAP-NEXT:    ret
  %tmp = call i64 @llvm.ptrauth.resign(i64 %arg, i32 0, i64 0, i32 3, i64 %arg2)
  ret i64 %tmp
}

define i64 @test_resign_da_dzb(i64 %arg, i64 %arg1, i64 %arg2) {
; UNCHECKED-LABEL: test_resign_da_dzb:
; UNCHECKED:       ; %bb.0:
; UNCHECKED-NEXT:    mov x16, x0
; UNCHECKED-NEXT:    autda x16, x1
; UNCHECKED-NEXT:    pacdzb x16
; UNCHECKED-NEXT:    mov x0, x16
; UNCHECKED-NEXT:    ret
;
; CHECKED-LABEL: test_resign_da_dzb:
; CHECKED:       ; %bb.0:
; CHECKED-NEXT:    mov x16, x0
; CHECKED-NEXT:    mov x17, x16
; CHECKED-NEXT:    autda x16, x1
; CHECKED-NEXT:    xpacd x17
; CHECKED-NEXT:    cmp x16, x17
; CHECKED-NEXT:    pacdzb x16
; CHECKED-NEXT:    csel x16, x16, x17, eq
; CHECKED-NEXT:    mov x0, x16
; CHECKED-NEXT:    ret
;
; TRAP-LABEL: test_resign_da_dzb:
; TRAP:       ; %bb.0:
; TRAP-NEXT:    mov x16, x0
; TRAP-NEXT:    mov x17, x16
; TRAP-NEXT:    autda x16, x1
; TRAP-NEXT:    xpacd x17
; TRAP-NEXT:    cmp x16, x17
; TRAP-NEXT:    b.eq #8
; TRAP-NEXT:    brk #0xc472
; TRAP-NEXT:    pacdzb x16
; TRAP-NEXT:    mov x0, x16
; TRAP-NEXT:    ret
  %tmp = call i64 @llvm.ptrauth.resign(i64 %arg, i32 2, i64 %arg1, i32 3, i64 0)
  ret i64 %tmp
}

define i64 @test_strip(i64 %arg) {
; ALL-LABEL: test_strip:
; ALL:       ; %bb.0:
; ALL-NEXT:    xpaci x0
; ALL-NEXT:    ret
  %tmp = call i64 @llvm.ptrauth.strip(i64 %arg, i32 0)
  ret i64 %tmp
}

define i64 @test_blend(i64 %arg, i64 %arg1) {
; ALL-LABEL: test_blend:
; ALL:       ; %bb.0:
; ALL-NEXT:    bfi x0, x1, #48, #16
; ALL-NEXT:    ret
  %tmp = call i64 @llvm.ptrauth.blend(i64 %arg, i64 %arg1)
  ret i64 %tmp
}

define i64 @test_blend_constant(i64 %arg) {
; ALL-LABEL: test_blend_constant:
; ALL:       ; %bb.0:
; ALL-NEXT:    movk x0, #12345, lsl #48
; ALL-NEXT:    ret
  %tmp = call i64 @llvm.ptrauth.blend(i64 %arg, i64 12345)
  ret i64 %tmp
}


define i64 @test_auth_cse(i64 %arg, i64 %arg1) {
; UNCHECKED-LABEL: test_auth_cse:
; UNCHECKED:       ; %bb.0:
; UNCHECKED-NEXT:    mov x16, x0
; UNCHECKED-NEXT:    autia x16, x1
; UNCHECKED-NEXT:    add x0, x16, x16
; UNCHECKED-NEXT:    ret
;
; CHECKED-LABEL: test_auth_cse:
; CHECKED:       ; %bb.0:
; CHECKED-NEXT:    mov x16, x0
; CHECKED-NEXT:    autia x16, x1
; CHECKED-NEXT:    add x0, x16, x16
; CHECKED-NEXT:    ret
;
; TRAP-LABEL: test_auth_cse:
; TRAP:       ; %bb.0:
; TRAP-NEXT:    mov x16, x0
; TRAP-NEXT:    mov x17, x16
; TRAP-NEXT:    autia x16, x1
; TRAP-NEXT:    xpaci x17
; TRAP-NEXT:    cmp x16, x17
; TRAP-NEXT:    b.eq #8
; TRAP-NEXT:    brk #0xc470
; TRAP-NEXT:    add x0, x16, x16
; TRAP-NEXT:    ret
  %tmp0 = call i64 @llvm.ptrauth.auth(i64 %arg, i32 0, i64 %arg1)
  %tmp1 = call i64 @llvm.ptrauth.auth(i64 %arg, i32 0, i64 %arg1)
  %tmp2 = add i64 %tmp0, %tmp1
  ret i64 %tmp2
}

define i64 @test_blend_cse(i64 %arg, i64 %arg1) {
; ALL-LABEL: test_blend_cse:
; ALL:       ; %bb.0:
; ALL-NEXT:    bfi x0, x1, #48, #16
; ALL-NEXT:    add x0, x0, x0
; ALL-NEXT:    ret
  %tmp0 = call i64 @llvm.ptrauth.blend(i64 %arg, i64 %arg1)
  %tmp1 = call i64 @llvm.ptrauth.blend(i64 %arg, i64 %arg1)
  %tmp2 = add i64 %tmp0, %tmp1
  ret i64 %tmp2
}

define i64 @test_auth_trap_attribute(i64 %arg, i64 %arg1) "ptrauth-auth-traps" {
; UNCHECKED-LABEL: test_auth_trap_attribute:
; UNCHECKED:       ; %bb.0:
; UNCHECKED-NEXT:    mov x16, x0
; UNCHECKED-NEXT:    autia x16, x1
; UNCHECKED-NEXT:    mov x0, x16
; UNCHECKED-NEXT:    ret
;
; CHECKED-LABEL: test_auth_trap_attribute:
; CHECKED:       ; %bb.0:
; CHECKED-NEXT:    mov x16, x0
; CHECKED-NEXT:    mov x17, x16
; CHECKED-NEXT:    autia x16, x1
; CHECKED-NEXT:    xpaci x17
; CHECKED-NEXT:    cmp x16, x17
; CHECKED-NEXT:    b.eq #8
; CHECKED-NEXT:    brk #0xc470
; CHECKED-NEXT:    mov x0, x16
; CHECKED-NEXT:    ret
;
; TRAP-LABEL: test_auth_trap_attribute:
; TRAP:       ; %bb.0:
; TRAP-NEXT:    mov x16, x0
; TRAP-NEXT:    mov x17, x16
; TRAP-NEXT:    autia x16, x1
; TRAP-NEXT:    xpaci x17
; TRAP-NEXT:    cmp x16, x17
; TRAP-NEXT:    b.eq #8
; TRAP-NEXT:    brk #0xc470
; TRAP-NEXT:    mov x0, x16
; TRAP-NEXT:    ret
  %tmp = call i64 @llvm.ptrauth.auth(i64 %arg, i32 0, i64 %arg1)
  ret i64 %tmp
}

declare i64 @llvm.ptrauth.auth(i64, i32, i64)
declare i64 @llvm.ptrauth.resign(i64, i32, i64, i32, i64)
declare i64 @llvm.ptrauth.strip(i64, i32)
declare i64 @llvm.ptrauth.blend(i64, i64)
