; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mtriple=arm64-unknown-unknown < %s -o -| FileCheck %s

; This test covers a case where extract_vector_elt is selected when DUP is
; generated. Where it tries to generate a ZextOrTrunc node with floating point
; type resulting in a crash.
; See https://reviews.llvm.org/D128144#4280024 for context
define void @dot_product(double %a) {
; CHECK-LABEL: dot_product:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fmov d1, #1.00000000
; CHECK-NEXT:    fadd d0, d0, d1
; CHECK-NEXT:    fadd d0, d0, d1
; CHECK-NEXT:    movi d1, #0000000000000000
; CHECK-NEXT:    fadd d0, d0, d1
; CHECK-NEXT:    fsqrt d0, d0
; CHECK-NEXT:    fcmp d0, #0.0
; CHECK-NEXT:    ret
entry:
  %fadd = call double @llvm.vector.reduce.fadd.v3f64(double %a, <3 x double> <double 1.000000e+00, double 1.000000e+00, double 0.000000e+00>)
  %sqrt = call double @llvm.sqrt.f64(double %fadd)
  %insert = insertelement <3 x double> zeroinitializer, double %sqrt, i64 0
  %shuffle = shufflevector <3 x double> %insert, <3 x double> zeroinitializer, <3 x i32> zeroinitializer
  %mul = fmul <3 x double> %shuffle, <double 1.000000e+00, double 1.000000e+00, double 0.000000e+00>
  %shuffle.1 = extractelement <3 x double> %mul, i64 0
  %shuffle.2 = extractelement <3 x double> %mul, i64 1
  %cmp = fcmp ogt double %shuffle.2, 0.000000e+00
  br i1 %cmp, label %exit, label %bb.1

bb.1:
  %mul.2 = fmul double %shuffle.1, 0.000000e+00
  br label %exit

exit:
  ret void
}

declare double @llvm.sqrt.f64(double)
declare double @llvm.vector.reduce.fadd.v3f64(double, <3 x double>)
