/*
 *  Copyright (C) 2008 Nicolas Vion <nico@picapo.net>
 *
 *   This file is part of swac-explore.
 *
 *   Swac-get is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   Swac-get is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with swac-explore; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef _SQLITE3PP_HH
#define _SQLITE3PP_HH

#include <sqlite3.h>
#include <vector>
#include <string>

typedef std::vector<std::string> SqlQueryResultRaw;
typedef std::vector<SqlQueryResultRaw> SqlQueryResult;
class SqlQuery;

class SqlDatabase { 
	friend class SqlQuery;
private:
	sqlite3 *handle;
public:
	void errorMsg();
	bool open(std::string const path);
	bool close();
	int lastInsertRowId();
	int changes();
	std::string str(std::string str);

	bool exec(std::string const sql, int (*callback)(void*,int,char**,char**), void *params);
	bool exec(std::string const sql, SqlQueryResult &result);
	bool exec(std::string const sql);
};

class SqlQuery {
private:
	sqlite3_stmt *handle;
	SqlDatabase *database;
public:
	SqlQuery(SqlDatabase *parent);
	~SqlQuery();

	int prepare(std::string const sql);
	int step();
	int reset();
	bool exec(SqlQueryResult &result);

	int bind(std::string const value, int const n);
	int bind(int const value, int const n);
	int bindParameterCount();
	int clearBindings();

	int columnCount();
	std::string columnName(int const iCol);
	std::string columnText(int const iCol);
	int columnInt(int const iCol);
	double columnDouble(int const iCol);
};

#endif
