/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_STDEXCEPTION_H
#define _SC_STDEXCEPTION_H

// sc
#include "util/Stackframe.h"
#include "util/Exception.h"
#include "util/ExceptionStack.h"

/**
 * an Exception class for Windows standard exceptions.
 */
class StdException : public sc::Exception, public sc::ExceptionStack
{
public:
  StdException( unsigned int error, const Stackframes& stack, const sc::String& dump );
  virtual ~StdException();

  // Exception
  const sc::Error* getError() const;

  // ExceptionStack
  const Stackframes& getStack() const;

private:
  const sc::Error* _error;
  Stackframes      _stack;
};


#endif // _SC_STDEXCEPTION_H
