/* ====================================================================
 * Copyright (c) 2009       Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "OStreamQt.h"

// qt
#include <QtCore/QString>
#include <QtCore/QVariant>
#include <QtCore/QModelIndex>

// sys
#include <ostream>


std::ostream& operator<< (std::ostream& os, const QString& s)
{
  os << "\"";
  os << (const char*)s.toAscii();
  os << "\"";
  return os;
}

std::ostream& operator<< (std::ostream& os, const QVariant& v)
{
  os << "\"";
  if(v.isValid()){
    os << (const char*)v.toString().toAscii();
  }
  else {
    os << "<invalid>";
  }
  os << "\"";
  return os;
}

std::ostream& operator<< (std::ostream& os, const QModelIndex& idx)
{
  os << "\"";
  if(idx.isValid()) {
    os << "r(" << idx.row() << ")/c(" << idx.column() << ")";
  }
  else {
    os << "<invalid>";
  }
  os << "\"";
  return os;
}
