/* ====================================================================
 * Copyright (c) 2007-2008   Martin Hauner
 *                           http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_RPVIEWTREEITEMMODEL_H
#define _SC_RPVIEWTREEITEMMODEL_H

// sc
#include "RpViewItem.h"
#include "util/String.h"
class RpViewTreeItemModelMember;
class RpViewTreeItemFolder;


// qt
#include <QtCore/QAbstractItemModel>


/**
 * Item model for RpViewTree.
 */
class RpViewTreeItemModel : public QAbstractItemModel
{
  typedef QAbstractItemModel super;
  Q_OBJECT

public:
  /** Custom Roles. */
  enum Roles {
    RpViewItemRole = Qt::UserRole,
    NameRole,
    DragRole,
    DirRole
  };

  RpViewTreeItemModel( const sc::String& root, const RpViewItemData* data );
  ~RpViewTreeItemModel();

  // QAbstractItemModel
  QModelIndex index( int row, int column, const QModelIndex& parent ) const;
  QModelIndex parent( const QModelIndex& index ) const;
  int columnCount( const QModelIndex& parent ) const;
  int rowCount( const QModelIndex& parent ) const;
  QVariant headerData( int section, Qt::Orientation orientation, int role ) const;
  QVariant data( const QModelIndex& index, int role ) const;
  bool canFetchMore( const QModelIndex& parent ) const;
  void fetchMore( const QModelIndex& parent );
  Qt::ItemFlags flags( const QModelIndex& index ) const;
  bool hasChildren( const QModelIndex& parent ) const;

  /** find row index of @a name. The index is invalid if the item was not found. */
  QModelIndex index( const sc::String& name ) const;
  
public slots:
  /** add the @a RpViewItems entries for @a path to the model. */
  void add( const sc::String& path, const RpViewItems& );
  /** remove the @a DirEntry entries from the model. */
  void remove( const sc::String& path );
  
signals:
  void fetch( const sc::String& path );

private:
  void remove( RpViewTreeItemFolder* folder );

  RpViewTreeItemModelMember* _m;
  const RpViewItemData*      _data;
};

#endif // _SC_RPVIEWTREEITEMMODEL_H
