use lang:bs:macro;
use sql;
use io;

// To run: mm Main -a -f sql.test.NAME_OF_FUNCTION


TABLE MY_TABLE2 {
    A INTEGER PRIMARY KEY,
    B TEXT NOT NULL UNIQUE
}


DATABASE TestDB {
    TABLE Dummy_eng (
        col_one INTEGER PRIMARY KEY AUTOINCREMENT,
        col_two TEXT NOT NULL UNIQUE
    );

    TABLE Dummy_swe (
        col_ett INTEGER PRIMARY KEY,
        col_tva TEXT NOT NULL UNIQUE
    );

    TABLE Dummy_esp (
        col_uno INTEGER PRIMARY KEY,
        col_dos TEXT NOT NULL UNIQUE
    );
}

// This will create a database called "dummydb.db", when running the test like this:
//     mm Main -a -f sql.tests.createDummyDatabaseForTesting;
// the database can be found in "storm/Main/dummydb.db"
void createDummyDatabaseForTesting()  {
    print("This is the beginning of the test");

    SQLite db(cwdUrl/"dummydb.db");
    print("db connected");

    CREATE TABLE IF NOT EXISTS Dummy_eng( col_one INTEGER PRIMARY KEY AUTOINCREMENT, col_two TEXT UNIQUE NOT NULL ) DB db;
    print("One table finished");

    CREATE TABLE IF NOT EXISTS Dummy_swe( col_ett INTEGER PRIMARY KEY, col_tva TEXT NOT NULL UNIQUE ) DB db;

    print("Both tables finished");

    print("Begin insertion");
    INSERT INTO Dummy_swe(col_ett, col_tva) VALUES (1,"Rad nummer ett") DB db;
    print("Inserted once into Dummy_swe");

    INSERT INTO Dummy_swe(col_ett, col_tva) VALUES (2,"Rad nummer tva") DB db;
    INSERT INTO Dummy_swe(col_ett, col_tva) VALUES (3,"Rad nummer tre") DB db;
    INSERT INTO Dummy_swe(col_ett, col_tva) VALUES (4,"Rad nummer fyra") DB db;
    print("This is the end of the test, DB should be done.");
    INSERT INTO Dummy_eng(col_two) VALUES ("Row number one") DB db;
    print("Inserted once into Dummy_eng");
    INSERT INTO Dummy_eng(col_two) VALUES ("Row number two") DB db;
    INSERT INTO Dummy_eng(col_two) VALUES ("Row number three") DB db;
    INSERT INTO Dummy_eng(col_two) VALUES ("Row number four") DB db;
    print("Dummy_eng done, beginning insertions for Dummy_swe");
}

void insertDataToDB(SQLite db) {

    INSERT INTO Dummy_swe(col_ett, col_tva) VALUES (1,"Rad nummer ett") DB db;
    INSERT INTO Dummy_swe(col_ett, col_tva) VALUES (2,"Rad nummer tva") DB db;
    INSERT INTO Dummy_swe(col_ett, col_tva) VALUES (3,"Rad nummer tre") DB db;
    INSERT INTO Dummy_swe(col_ett, col_tva) VALUES (4,"Rad nummer fyra") DB db;
    INSERT INTO Dummy_eng(col_two) VALUES ("Row number one") DB db;
    INSERT INTO Dummy_eng(col_two) VALUES ("Row number two") DB db;
    INSERT INTO Dummy_eng(col_two) VALUES ("Row number three") DB db;
    INSERT INTO Dummy_eng(col_two) VALUES ("Row number four") DB db;

}


void testTypeDBConnection() {
    SQLite db;
    TestDB connection;
    connection.connect(db);
    insertDataToDB(db);

    var result = SELECT col_ett, col_tva FROM Dummy_swe DB connection;
    print("Table [Dummy_swe]:");
    print("\tcol_ett\t\tcol_tva");
    for (row in result)
        print("\t"+ row.getInt(0).toS + "\t\t" + row.getStr(1));

    var result2 = SELECT col_one, col_two FROM Dummy_eng DB connection;
    print("\nTable [Dummy_eng]:");
    print("\tcol_one\t\tcol_two");
    for (row in result2)
        print("\t" + row.getInt(0).toS + "\t\t" + row.getStr(1));

    var result3 = SELECT col_uno, col_dos FROM Dummy_esp DB connection;
    print("\nTable [Dummy_esp]:");
    print("\tcol_uno\t\tcol_dos");
    for (row in result3)
        print("\t" + row.getInt(0).toS + "\t\t" + row.getStr(1));
}


// SQLite_Statement.bind no longer print which version they use to reduce
// number of prints during regular use. 
void testBind()
{
    print("Testing different binds.");

    SQLite db();
    TestDB connection;
    connection.connect(db);
    insertDataToDB(db);

    print("Trying to bind with the Int version of bind: "); 
    Int int_bind = 2;
    Statement stmt_int = db.prepare("SELECT * FROM Dummy_swe WHERE col_ett = ?");
    stmt_int.bind(1, int_bind);

    print("\nTrying to bind with the Str* version of bind: ");
    Str str_bind = "Rad nummer ett";
    Statement stmt_str = db.prepare("SELECT * FROM Dummy_swe WHERE col_tva = ?");
    stmt_str.bind(1, str_bind);
}

void testDisplayTables(){
    SQLite db();
    TestDB connection;
    connection.connect(db);

    for (table in db.tables)
        print(table);
}

void testSchema(){

    SQLite db();
    TestDB connection;
    connection.connect(db);
    var s = db.schema("Dummy_swe");

    print("Table name: " + s.getTable());
    for (Int i = 0; i < s.size(); ++i) {
        var cont = s.getRow(i);
        var a = cont.getAttr();
        Str s ="";
        for (var it = a.begin(); it != a.end(); it++) {
            s = s + " " + it.v;
        }
        print(cont.getName() + " " + cont.getDt() + s);

    }

}

void test1() {
    print("Opening connection to db:");
    SQLite db();
    TestDB connection;
    connection.connect(db);
    insertDataToDB(db);

    print("\nListing Dummy_eng:");
    Statement eng = db.prepare("SELECT * FROM Dummy_eng");
    if (eng.execute)
        for (row in eng)
            print("col_one: " + row.getInt(0).toS + ", col_two: " + row.getStr(1));
    else
        print("Error retrieving playlists entries: " + eng.errMsg);

    eng.finalize; // Ugly design, but is (unfortunately) necessary for the next DROP statement to work.

    print("\nListing Dummy_swe:");
    Statement swe = db.prepare("SELECT * FROM Dummy_swe");
    if (swe.execute)
       for (row in swe)
           print("col_ett: " + row.getInt(0).toS + ", col_tva: " + row.getStr(1));
    else
        print("Error retrieving employees entries: " + swe.errMsg);

    swe.finalize; // Apparently, you need to finalize both the SELECT statements for the DROP statement to work.

    // Turns out that having (one or more) SELECT statements above the DROP statement, will BLOCK it from executing and return false.
    // Even if the DROP statement if not altering the current TABLE(s) that the SELECT statement(s) is/are using.
    // Have not yet found a fix for this (except calling finalize on all the current alive SELECT statements).

    print("\nRemoving TABLE Dummy_swe:");
    Statement remove = db.prepare("DROP TABLE IF EXISTS Dummy_swe");
    if (remove.execute)
        print("Removed Dummy_swe TABLE successfully!");
    else
        print("Error removing Dummy_swe TABLE: " + remove.errMsg);

    // Creating TABLE(s), however, works just fine.

    print("\nCreating TABLE Dummy_swe:");
    Statement create = db.prepare("CREATE TABLE IF NOT EXISTS Dummy_swe ( PersonID int, LastName varchar(255), FirstName varchar(255), Address varchar(255), City varchar(255) )");
    if (create.execute)
        print("Created Dummy_swe TABLE successfully!");
    else
        print("Error creating Dummy_swe TABLE: " + create.errMsg);

    // The DROP statement above, will not block the SELECT statements below.
    // Which is confusing. SELECT statements therefore sucks... (or is it DROP that sucks?).

    print("\nList all %number% from Dummy_eng:");
    Statement engNumber = db.prepare("SELECT * FROM Dummy_eng WHERE col_two LIKE ?");
    engNumber.bind(1, "%number%");
    if (engNumber.execute)
        for (row in engNumber)
            print("col_one: " + row.getInt(0).toS + ", col_two: " + row.getStr(1));
    else
        print("Error retrieving matching Dummy_eng entries: " + engNumber.errMsg);

    print("\nListing 0 entries from Dummy_eng:");
    Statement nothing = db.prepare("SELECT * FROM Dummy_eng WHERE col_one = ?");
    nothing.bind(1, "0"); // Playlistid starts at 1, 0 will give no results.
    if (nothing.execute) {
        for (row in nothing)
            print("Should not be printed (iterator error)");
    } else
        print("Error retrieving matching Dummy_eng entries: " + nothing.errMsg);

    print("\nTesting no execute on Statement:");
    Statement noExec = db.prepare("SELECT * FROM Dummy_eng");
    for (row in noExec)
        print("Should not be printed!");

    // We done here.
    print("\nEnd of test");
}


void testLastRowID()
{
    SQLite db();
    TestDB connection;
    connection.connect(db);
    insertDataToDB(db);

    Statement lastRowStmt = db.prepare("INSERT INTO Dummy_eng (col_two) VALUES(\"German viking techno\")");
	print("\nTesting lastRowID:");
	if (lastRowStmt.execute) {
		print("Added entry \"German viking techno\" to table Dummy_eng.");
		Long dbRowID = db.lastRowId();

		if (dbRowID > 0)
			print("Last row ID in database: " + dbRowID.toS() + ".");
		else
			print("Nothing inserted.");

		Long stRowID = lastRowStmt.lastRowId();
		if (stRowID > 0)
			print("Last row ID in statement: " + stRowID.toS() + ".");
		else
			print("Nothing inserted.");

		Statement lastRowStmt2 = db.prepare("INSERT INTO Dummy_eng (col_two) VALUES(\"Ambient doom folk-jazz\")");
		if (lastRowStmt2.execute) {
			print("Added entry \"Ambient doom folk-jazz\" to table Dummy_eng.");
			Long stRowID2 = db.lastRowId();

			if (stRowID2 > 0) {
				print("Last row ID in first statement: " + stRowID.toS() + ".");
				print("Last row ID in second statement: " + stRowID2.toS() + ".");
			}
			else
				print("Nothing inserted.");
		}
	}
	else
		print("\nFailed to execute lastRowID.");

	lastRowStmt = db.prepare("DELETE FROM Dummy_eng WHERE col_two=\"German viking techno\"");
	if (lastRowStmt.execute())
		print("Deleted entry \"German viking techno\" from table Dummy_eng.");
	else
		print("Failed to delete \"German viking techno\" entry from table Dummy_eng.");

	lastRowStmt = db.prepare("DELETE FROM Dummy_eng WHERE col_two=\"Ambient doom folk-jazz\"");
	if (lastRowStmt.execute())
		print("Deleted entry \"Ambient doom folk-jazz\" from table Dummy_eng.");
	else
		print("Failed to delete \"Ambient doom folk-jazz\" entry from table Dummy_eng.");
}


