use ui;
use layout;
use progvis:net;
use core:geometry;
use core:io;

/**
 * Dialog for uploading new problems.
 */
dialog UploadDlg {
	layout Grid {
		expandCol: 1;
		Label nameLbl("Name:", VAlign:center) { row: 0; }
		Edit name("Name your problem") { row: 0; col: 1; colspan: 2; }
		Button upload("Upload") { row: 1; col: 2; }
	}

	Client client;
	Str source;
	Str ext;

	// If set, we're submitting a new problem based on this solution.
	Int? solutionId;

	// Upload a new problem.
	init(Client client, Str source, Str ext) {
		init("Submit a problem", Size(300, 10)) {
			client = client;
			source = source;
			ext = ext;
		}

		defaultChoice(upload);
		upload.onClick = &this.done();
	}

	// Upload a solution to another problem.
	init(Client client, Str source, Str ext, Str title, Int solutionId) {
		init("Submit your solution", Size(300, 10)) {
			client = client;
			source = source;
			ext = ext;
			solutionId = solutionId;
		}

		name.text = title;
		defaultChoice(upload);
		upload.onClick = &this.done();
	}

	void done() {
		try {
			var req = if (solutionId) {
				NewImprovementRequest(name.text, source, ext, solutionId);
			} else {
				NewProblemRequest(name.text, source, ext);
			};
			client.query(req);
			close(1);
		} catch (Exception e) {
			showMessage(this, "Error", "Failed to upload the problem: ${e.message}");
		}
	}
}
