/*
 * $Id: StAXStreamWriterTest.java,v 1.1 2004-07-15 02:15:55 cniles Exp $
 * 
 * Copyright (c) 2004, Christian Niles, Unit12
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *		*   Redistributions of source code must retain the above copyright
 *          notice, this list of conditions and the following disclaimer.
 * 
 *	    *	Redistributions in binary form must reproduce the above copyright
 *          notice, this list of conditions and the following disclaimer in the
 *          documentation and/or other materials provided with the distribution.
 * 
 *      *   Neither the name of Christian Niles, Unit12, nor the names of its
 *          contributors may be used to endorse or promote products derived from
 *          this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 */
package javanet.staxutils.io;

import java.io.StringWriter;
import java.io.Writer;

import javanet.staxutils.StAXTestCase;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

/**
 * Tests the {@link StAXStreamWriter} interface.
 * 
 * @author Christian Niles
 * @version $Revision: 1.1 $
 */
public class StAXStreamWriterTest extends StAXTestCase {

    public void testEmptyDocument() throws Exception {

        // create writers
        StringWriter writer = new StringWriter();
        XMLStreamWriter streamWriter = createStreamWriter(writer);

        streamWriter.writeStartDocument();
        streamWriter.writeEndDocument();
        streamWriter.close();

        String xml = writer.getBuffer().toString();
        assertEquals("XML output failed (" + xml + ")",
                "<?xml version=\"1.0\"?>", xml);

    }

    public void testEmptyRootElement() throws Exception {

        // create writers
        StringWriter writer = new StringWriter();
        XMLStreamWriter streamWriter = createStreamWriter(writer);

        streamWriter.writeStartDocument();
        streamWriter.writeEmptyElement("prefix", "name",
                "http://test.namespace.tld/");
        streamWriter.writeAttribute("attribute", "value");
        streamWriter.writeNamespace("prefix", "http://test.namespace.tld/");
        streamWriter.writeEndDocument();
        streamWriter.close();

        String xml = writer.getBuffer().toString();
        assertEquals(
                "XML output failed (" + xml + ")",
                "<?xml version=\"1.0\"?><prefix:name attribute=\"value\" xmlns:prefix=\"http://test.namespace.tld/\"/>",
                xml);

    }

    protected XMLStreamWriter createStreamWriter(Writer writer)
            throws XMLStreamException {

        return new StAXStreamWriter(writer);

    }

}