; LLVM IR generated by Intel SYCL Clang compiler (https://github.com/intel/llvm)

; SYCL source code for this test:
; #include "CL/__spirv/spirv_ops.hpp"
;
; constexpr int32_t Subnorm = 0;
; constexpr int32_t RndMode = 2;
; constexpr int32_t RndAcc = 1;
; constexpr bool FromSign = false;
; constexpr bool ToSign = true;
; constexpr bool SignOfB = false;
;
; template <int EA, int MA, int Eout, int Mout>
; void ap_float_cast() {
;   ap_int<1+EA+MA> A;
;   ap_int<1+Eout+Mout> float_cast_res =
;       __spirv_ArbitraryFloatCastINTEL<1+EA+MA, 1+Eout+Mout>(
;           A, MA, Mout, Subnorm, RndMode, RndAcc);
; }
;
; template <int WA, int Eout, int Mout>
; void ap_float_cast_from_int() {
;   ap_int<WA> A;
;   ap_int<1+Eout+Mout> cast_from_int_res =
;       __spirv_ArbitraryFloatCastFromIntINTEL<WA, 1+Eout+Mout>(
;           A, Mout, FromSign, Subnorm, RndMode, RndAcc);
; }
;
; template <int EA, int MA, int Wout>
; void ap_float_cast_to_int() {
;   ap_int<1+EA+MA> A;
;   ap_int<Wout> cast_to_int_res =
;       __spirv_ArbitraryFloatCastToIntINTEL<1+EA+MA, Wout>(
;           A, MA, ToSign, Subnorm, RndMode, RndAcc);
; }
;
; Test also that the same arbitrary precision floating point intrinsic with
; different signature is translated correctly.
;
; template <int EA, int MA, int EB, int MB, int Eout, int Mout>
; void ap_float_add() {
;   ap_int<1+EA+MA> A1, A2;
;   ap_int<1+EB+MB> B1, B2;
;   ap_int<1+Eout+Mout> add_res_1 =
;       __spirv_ArbitraryFloatAddINTEL<1+EA+MA, 1+EB+MB, 1+Eout+Mout>(
;           A1, MA, B1, MB, Mout, Subnorm, RndMode, RndAcc);
;   ap_int<1+Eout+Mout> add_res_2 =
;       __spirv_ArbitraryFloatAddINTEL<1+EA+MA, 1+EB+MB, 1+Eout+Mout>(
;           A2, MA, B2, MB, Mout, Subnorm, RndMode, RndAcc);
; }
;
; template <int EA, int MA, int EB, int MB, int Eout, int Mout>
; void ap_float_sub() {
;   ap_int<1+EA+MA> A;
;   ap_int<1+EB+MB> B;
;   ap_int<1+Eout+Mout> sub_res =
;       __spirv_ArbitraryFloatSubINTEL<1+EA+MA, 1+EB+MB, 1+Eout+Mout>(
;           A, MA, B, MB, Mout, Subnorm, RndMode, RndAcc);
; }
;
; template <int EA, int MA, int EB, int MB, int Eout, int Mout>
; void ap_float_mul() {
;   ap_int<1+EA+MA> A;
;   ap_int<1+EB+MB> B;
;   ap_int<1+Eout+Mout> mul_res =
;       __spirv_ArbitraryFloatMulINTEL<1+EA+MA, 1+EB+MB, 1+Eout+Mout>(
;           A, MA, B, MB, Mout, Subnorm, RndMode, RndAcc);
; }
;
; template <int EA, int MA, int EB, int MB, int Eout, int Mout>
; void ap_float_div() {
;   ap_int<1+EA+MA> A;
;   ap_int<1+EB+MB> B;
;   ap_int<1+Eout+Mout> div_res =
;       __spirv_ArbitraryFloatDivINTEL<1+EA+MA, 1+EB+MB, 1+Eout+Mout>(
;           A, MA, B, MB, Mout, Subnorm, RndMode, RndAcc);
; }
;
; template <int EA, int MA, int EB, int MB>
; void ap_float_gt() {
;   ap_int<1+EA+MA> A;
;   ap_int<1+EB+MB> B;
;   bool gt_res = __spirv_ArbitraryFloatGTINTEL<1+EA+MA, 1+EB+MB>(A, MA, B, MB);
; }
;
; template <int EA, int MA, int EB, int MB>
; void ap_float_ge() {
;   ap_int<1+EA+MA> A;
;   ap_int<1+EB+MB> B;
;   bool ge_res = __spirv_ArbitraryFloatGEINTEL<1+EA+MA, 1+EB+MB>(A, MA, B, MB);
; }
;
; template <int EA, int MA, int EB, int MB>
; void ap_float_lt() {
;   ap_int<1+EA+MA> A;
;   ap_int<1+EB+MB> B;
;   bool lt_res = __spirv_ArbitraryFloatLTINTEL<1+EA+MA, 1+EB+MB>(A, MA, B, MB);
; }
;
; template <int EA, int MA, int EB, int MB>
; void ap_float_le() {
;   ap_int<1+EA+MA> A;
;   ap_int<1+EB+MB> B;
;   bool le_res = __spirv_ArbitraryFloatLEINTEL<1+EA+MA, 1+EB+MB>(A, MA, B, MB);
; }
;
; template <int EA, int MA, int EB, int MB>
; void ap_float_eq() {
;   ap_int<1+EA+MA> A;
;   ap_int<1+EB+MB> B;
;   bool eq_res = __spirv_ArbitraryFloatEQINTEL<1+EA+MA, 1+EB+MB>(A, MA, B, MB);
; }
;
; template <int EA, int MA, int Eout, int Mout>
; void ap_float_recip() {
;   ap_int<1+EA+MA> A;
;   ap_int<1+Eout+Mout> recip_res =
;       __spirv_ArbitraryFloatRecipINTEL<1+EA+MA, 1+Eout+Mout>(
;           A, MA, Mout, Subnorm, RndMode, RndAcc);
; }
;
; template <int EA, int MA, int Eout, int Mout>
; void ap_float_rsqrt() {
;   ap_int<1+EA+MA> A;
;   ap_int<1+Eout+Mout> rsqrt_res =
;       __spirv_ArbitraryFloatRSqrtINTEL<1+EA+MA, 1+Eout+Mout>(
;           A, MA, Mout, Subnorm, RndMode, RndAcc);
; }
;
; template <int EA, int MA, int Eout, int Mout>
; void ap_float_cbrt() {
;   ap_int<1+EA+MA> A;
;   ap_int<1+Eout+Mout> cbrt_res =
;       __spirv_ArbitraryFloatCbrtINTEL<1+EA+MA, 1+Eout+Mout>(
;           A, MA, Mout, Subnorm, RndMode, RndAcc);
; }
;
; template <int EA, int MA, int EB, int MB, int Eout, int Mout>
; void ap_float_hypot() {
;   ap_int<1+EA+MA> A;
;   ap_int<1+EB+MB> B;
;   ap_int<1+Eout+Mout> hypot_res =
;       __spirv_ArbitraryFloatHypotINTEL<1+EA+MA, 1+EB+MB, 1+Eout+Mout>(
;           A, MA, B, MB, Mout, Subnorm, RndMode, RndAcc);
; }
;
; template <int EA, int MA, int Eout, int Mout>
; void ap_float_sqrt() {
;   ap_int<1+EA+MA> A;
;   ap_int<1+Eout+Mout> sqrt_res =
;       __spirv_ArbitraryFloatSqrtINTEL<1+EA+MA, 1+Eout+Mout>(
;           A, MA, Mout, Subnorm, RndMode, RndAcc);
; }
;
; template <int EA, int MA, int Eout, int Mout>
; void ap_float_log() {
;   ap_int<1+EA+MA> A;
;   ap_int<1+Eout+Mout> log_res =
;       __spirv_ArbitraryFloatLogINTEL<1+EA+MA, 1+Eout+Mout>(
;           A, MA, Mout, Subnorm, RndMode, RndAcc);
; }
;
; template <int EA, int MA, int Eout, int Mout>
; void ap_float_log2() {
;   ap_int<1+EA+MA> A;
;   ap_int<1+Eout+Mout> log2_res =
;       __spirv_ArbitraryFloatLog2INTEL<1+EA+MA, 1+Eout+Mout>(
;           A, MA, Mout, Subnorm, RndMode, RndAcc);
; }
;
; template <int EA, int MA, int Eout, int Mout>
; void ap_float_log10() {
;   ap_int<1+EA+MA> A;
;   ap_int<1+Eout+Mout> log10_res =
;       __spirv_ArbitraryFloatLog10INTEL<1+EA+MA, 1+Eout+Mout>(
;           A, MA, Mout, Subnorm, RndMode, RndAcc);
; }
;
; template <int EA, int MA, int Eout, int Mout>
; void ap_float_log1p() {
;   ap_int<1+EA+MA> A;
;   ap_int<1+Eout+Mout> log1p_res =
;       __spirv_ArbitraryFloatLog1pINTEL<1+EA+MA, 1+Eout+Mout>(
;           A, MA, Mout, Subnorm, RndMode, RndAcc);
; }
;
; template <int EA, int MA, int Eout, int Mout>
; void ap_float_exp() {
;   ap_int<1+EA+MA> A;
;   ap_int<1+Eout+Mout> exp_res =
;       __spirv_ArbitraryFloatExpINTEL<1+EA+MA, 1+Eout+Mout>(
;           A, MA, Mout, Subnorm, RndMode, RndAcc);
; }
;
; template <int EA, int MA, int Eout, int Mout>
; void ap_float_exp2() {
;   ap_int<1+EA+MA> A;
;   ap_int<1+Eout+Mout> exp2_res =
;       __spirv_ArbitraryFloatExp2INTEL<1+EA+MA, 1+Eout+Mout>(
;           A, MA, Mout, Subnorm, RndMode, RndAcc);
; }
;
; template <int EA, int MA, int Eout, int Mout>
; void ap_float_exp10() {
;   ap_int<1+EA+MA> A;
;   ap_int<1+Eout+Mout> exp10_res =
;       __spirv_ArbitraryFloatExp10INTEL<1+EA+MA, 1+Eout+Mout>(
;           A, MA, Mout, Subnorm, RndMode, RndAcc);
; }
;
; template <int EA, int MA, int Eout, int Mout>
; void ap_float_expm1() {
;   ap_int<1+EA+MA> A;
;   ap_int<1+Eout+Mout> expm1_res =
;       __spirv_ArbitraryFloatExpm1INTEL<1+EA+MA, 1+Eout+Mout>(
;           A, MA, Mout, Subnorm, RndMode, RndAcc);
; }
;
; template <int EA, int MA, int Eout, int Mout>
; void ap_float_sin() {
;   ap_int<1+EA+MA> A;
;   ap_int<1+Eout+Mout> sin_res =
;       __spirv_ArbitraryFloatSinINTEL<1+EA+MA, 1+Eout+Mout>(
;           A, MA, Mout, Subnorm, RndMode, RndAcc);
; }
;
; template <int EA, int MA, int Eout, int Mout>
; void ap_float_cos() {
;   ap_int<1+EA+MA> A;
;   ap_int<1+Eout+Mout> cos_res =
;       __spirv_ArbitraryFloatCosINTEL<1+EA+MA, 1+Eout+Mout>(
;           A, MA, Mout, Subnorm, RndMode, RndAcc);
; }
;
; template <int EA, int MA, int Eout, int Mout>
; void ap_float_sincos() {
;   ap_int<1+EA+MA> A;
;   ap_int<2*(1+Eout+Mout)> sincos_res =
;       __spirv_ArbitraryFloatSinCosINTEL<1+EA+MA, 1+Eout+Mout>(
;           A, MA, Mout, Subnorm, RndMode, RndAcc);
; }
;
; template <int EA, int MA, int Eout, int Mout>
; void ap_float_sinpi() {
;   ap_int<1+EA+MA> A;
;   ap_int<1+Eout+Mout> sinpi_res =
;       __spirv_ArbitraryFloatSinPiINTEL<1+EA+MA, 1+Eout+Mout>(
;           A, MA, Mout, Subnorm, RndMode, RndAcc);
; }
;
; template <int EA, int MA, int Eout, int Mout>
; void ap_float_cospi() {
;   ap_int<1+EA+MA> A;
;   ap_int<1+Eout+Mout> cospi_res =
;       __spirv_ArbitraryFloatCosPiINTEL<1+EA+MA, 1+Eout+Mout>(
;           A, MA, Mout, Subnorm, RndMode, RndAcc);
; }
;
; template <int EA, int MA, int Eout, int Mout>
; void ap_float_sincospi() {
;   ap_int<1+EA+MA> A;
;   ap_int<2*(1+Eout+Mout)> sincos_res =
;       __spirv_ArbitraryFloatSinCosPiINTEL<1+EA+MA, 1+Eout+Mout>(
;           A, MA, Mout, Subnorm, RndMode, RndAcc);
; }
;
; template <int EA, int MA, int Eout, int Mout>
; void ap_float_asin() {
;   ap_int<1+EA+MA> A;
;   ap_int<1+Eout+Mout> asin_res =
;       __spirv_ArbitraryFloatASinINTEL<1+EA+MA, 1+Eout+Mout>(
;           A, MA, Mout, Subnorm, RndMode, RndAcc);
; }
;
; template <int EA, int MA, int Eout, int Mout>
; void ap_float_asinpi() {
;   ap_int<1+EA+MA> A;
;   ap_int<1+Eout+Mout> asinpi_res =
;       __spirv_ArbitraryFloatASinPiINTEL<1+EA+MA, 1+Eout+Mout>(
;           A, MA, Mout, Subnorm, RndMode, RndAcc);
; }
;
; template <int EA, int MA, int Eout, int Mout>
; void ap_float_acos() {
;   ap_int<1+EA+MA> A;
;   ap_int<1+Eout+Mout> acos_res =
;       __spirv_ArbitraryFloatACosINTEL<1+EA+MA, 1+Eout+Mout>(
;           A, MA, Mout, Subnorm, RndMode, RndAcc);
; }
;
; template <int EA, int MA, int Eout, int Mout>
; void ap_float_acospi() {
;   ap_int<1+EA+MA> A;
;   ap_int<1+Eout+Mout> acospi_res =
;       __spirv_ArbitraryFloatACosPiINTEL<1+EA+MA, 1+Eout+Mout>(
;           A, MA, Mout, Subnorm, RndMode, RndAcc);
; }
;
; template <int EA, int MA, int Eout, int Mout>
; void ap_float_atan() {
;   ap_int<1+EA+MA> A;
;   ap_int<1+Eout+Mout> atan_res =
;       __spirv_ArbitraryFloatATanINTEL<1+EA+MA, 1+Eout+Mout>(
;           A, MA, Mout, Subnorm, RndMode, RndAcc);
; }
;
; template <int EA, int MA, int Eout, int Mout>
; void ap_float_atanpi() {
;   ap_int<1+EA+MA> A;
;   ap_int<1+Eout+Mout> atanpi_res =
;       __spirv_ArbitraryFloatATanPiINTEL<1+EA+MA, 1+Eout+Mout>(
;           A, MA, Mout, Subnorm, RndMode, RndAcc);
; }
;
; template <int EA, int MA, int EB, int MB, int Eout, int Mout>
; void ap_float_atan2() {
;   ap_int<1+EA+MA> A;
;   ap_int<1+EB+MB> B;
;   ap_int<1+Eout+Mout> atan2_res =
;       __spirv_ArbitraryFloatATan2INTEL<1+EA+MA, 1+EB+MB, 1+Eout+Mout>(
;           A, MA, B, MB, Mout, Subnorm, RndMode, RndAcc);
; }
;
; template <int EA, int MA, int EB, int MB, int Eout, int Mout>
; void ap_float_pow() {
;   ap_int<1+EA+MA> A;
;   ap_int<1+EB+MB> B;
;   ap_int<1+Eout+Mout> pow_res =
;       __spirv_ArbitraryFloatPowINTEL<1+EA+MA, 1+EB+MB, 1+Eout+Mout>(
;           A, MA, B, MB, Mout, Subnorm, RndMode, RndAcc);
; }
;
; template <int EA, int MA, int EB, int MB, int Eout, int Mout>
; void ap_float_powr() {
;   ap_int<1+EA+MA> A;
;   ap_int<1+EB+MB> B;
;   ap_int<1+Eout+Mout> powr_res =
;       __spirv_ArbitraryFloatPowRINTEL<1+EA+MA, 1+EB+MB, 1+Eout+Mout>(
;           A, MA, B, MB, Mout, Subnorm, RndMode, RndAcc);
; }
;
; template <int EA, int MA, int WB, int Eout, int Mout>
; void ap_float_pown() {
;   ap_int<1+EA+MA> A;
;   ap_int<WB> B;
;   ap_int<1+Eout+Mout> pown_res =
;       __spirv_ArbitraryFloatPowNINTEL<1+EA+MA, WB, 1+Eout+Mout>(
;           A, MA, B, SignOfB, Mout, Subnorm, RndMode, RndAcc);
; }
;
; template <typename name, typename Func>
; __attribute__((sycl_kernel)) void kernel_single_task(Func kernelFunc) {
;   kernelFunc();
; }
;
; int main() {
;   kernel_single_task<class kernel_function>([]() {
;     ap_float_cast<11, 28, 9, 30>();
;     ap_float_cast_from_int<43, 8, 16>();
;     ap_float_cast_to_int<7, 15, 30>();
;     ap_float_add<5, 7, 6, 8, 4, 9>();
;     ap_float_add<6, 8, 4, 9, 5, 7>();
;     ap_float_sub<4, 4, 5, 5, 6, 6>();
;     ap_float_mul<16, 34, 16, 34, 16, 34>();
;     ap_float_div<4, 11, 4, 11, 5, 12>();
;     ap_float_gt<20, 42, 21, 41>();
;     ap_float_ge<19, 27, 19, 27>();
;     ap_float_lt<2, 2, 3, 3>();
;     ap_float_le<27, 27, 26, 28>();
;     ap_float_eq<7, 12, 7, 7>();
;     ap_float_recip<9, 29, 9, 29>();
;     ap_float_rsqrt<12, 19, 13, 20>();
;     ap_float_cbrt<0, 1, 0, 1>();
;     ap_float_hypot<20, 20, 21, 21, 19, 22>();
;     ap_float_sqrt<7, 7, 8, 8>();
;     ap_float_log<30, 19, 19, 30>();
;     ap_float_log2<17, 20, 18, 19>();
;     ap_float_log10<4, 3, 4, 5>();
;     ap_float_log1p<17, 30, 18, 30>();
;     ap_float_exp<16, 25, 16, 25>();
;     ap_float_exp2<1, 1, 2, 2>();
;     ap_float_exp10<8, 16, 8, 16>();
;     ap_float_expm1<21, 42, 20, 41>();
;     ap_float_sin<14, 15, 16, 17>();
;     ap_float_cos<1, 2, 2, 1>();
;     ap_float_sincos<8, 18, 10, 20>();
;     ap_float_sinpi<3, 6, 6, 6>();
;     ap_float_cospi<18, 40, 18, 40>();
;     ap_float_sincospi<9, 20, 11, 20>();
;     ap_float_asin<2, 4, 2, 8>();
;     ap_float_asinpi<11, 23, 11, 23>();
;     ap_float_acos<4, 9, 3, 10>();
;     ap_float_acospi<2, 5, 3, 4>();
;     ap_float_atan<12, 31, 12, 31>();
;     ap_float_atanpi<1, 38, 1, 32>();
;     ap_float_atan2<7, 16, 7, 17, 8, 18>();
;     ap_float_pow<8, 8, 9, 9, 10, 10>();
;     ap_float_powr<18, 35, 19, 35, 20, 35>();
;     ap_float_pown<4, 7, 10, 5, 9>();
;     ap_float_pown<64, 7, 10, 5, 9>();
;   });
;   return 0;
; }

; LLVM IR compilation command:
; clang -I llvm/include/sycl -S -emit-llvm -fno-sycl-early-optimizations -fsycl-device-only capability-arbitrary-precision-floating-point.cpp

; RUN: llvm-as %s -o %t.bc
; RUN: llvm-spirv %t.bc --spirv-ext=+SPV_INTEL_arbitrary_precision_integers,+SPV_INTEL_arbitrary_precision_floating_point -o %t.spv
; RUN: llvm-spirv %t.spv -to-text -o - | FileCheck %s --check-prefix=CHECK-SPIRV

; RUN: not llvm-spirv %t.bc --spirv-ext=+SPV_INTEL_arbitrary_precision_integers -spirv-text -o - 2>&1 | FileCheck %s --check-prefix=CHECK-ERROR
; CHECK-ERROR: InvalidInstruction: Can't translate llvm instruction:
; CHECK-ERROR: Floating point instructions can't be translated correctly without enabled SPV_INTEL_arbitrary_precision_floating_point extension!

; RUN: llvm-spirv -r %t.spv -o %t.r.bc
; RUN: llvm-dis < %t.r.bc | FileCheck %s --check-prefix=CHECK-LLVM

; CHECK-SPIRV: 2 Capability Kernel
; CHECK-SPIRV: 2 Capability ArbitraryPrecisionIntegersINTEL
; CHECK-SPIRV: 2 Capability ArbitraryPrecisionFloatingPointINTEL
; CHECK-SPIRV: 13 Extension "SPV_INTEL_arbitrary_precision_floating_point"
; CHECK-SPIRV: 11 Extension "SPV_INTEL_arbitrary_precision_integers"

; CHECK-SPIRV: 4 TypeInt [[Ty_8:[0-9]+]] 8 0
; CHECK-SPIRV: 4 TypeInt [[Ty_40:[0-9]+]] 40 0
; CHECK-SPIRV: 4 TypeInt [[Ty_43:[0-9]+]] 43 0
; CHECK-SPIRV: 4 TypeInt [[Ty_25:[0-9]+]] 25 0
; CHECK-SPIRV: 4 TypeInt [[Ty_23:[0-9]+]] 23 0
; CHECK-SPIRV: 4 TypeInt [[Ty_30:[0-9]+]] 30 0
; CHECK-SPIRV: 4 TypeInt [[Ty_13:[0-9]+]] 13 0
; CHECK-SPIRV: 4 TypeInt [[Ty_15:[0-9]+]] 15 0
; CHECK-SPIRV: 4 TypeInt [[Ty_14:[0-9]+]] 14 0
; CHECK-SPIRV: 4 TypeInt [[Ty_9:[0-9]+]] 9 0
; CHECK-SPIRV: 4 TypeInt [[Ty_11:[0-9]+]] 11 0
; CHECK-SPIRV: 4 TypeInt [[Ty_51:[0-9]+]] 51 0
; CHECK-SPIRV: 4 TypeInt [[Ty_16:[0-9]+]] 16 0
; CHECK-SPIRV: 4 TypeInt [[Ty_18:[0-9]+]] 18 0
; CHECK-SPIRV: 4 TypeInt [[Ty_63:[0-9]+]] 63 0
; CHECK-SPIRV: 4 TypeInt [[Ty_47:[0-9]+]] 47 0
; CHECK-SPIRV: 4 TypeInt [[Ty_5:[0-9]+]] 5 0
; CHECK-SPIRV: 4 TypeInt [[Ty_7:[0-9]+]] 7 0
; CHECK-SPIRV: 4 TypeInt [[Ty_55:[0-9]+]] 55 0
; CHECK-SPIRV: 4 TypeInt [[Ty_20:[0-9]+]] 20 0
; CHECK-SPIRV: 4 TypeInt [[Ty_39:[0-9]+]] 39 0
; CHECK-SPIRV: 4 TypeInt [[Ty_32:[0-9]+]] 32 0
; CHECK-SPIRV: 4 TypeInt [[Ty_34:[0-9]+]] 34 0
; CHECK-SPIRV: 4 TypeInt [[Ty_2:[0-9]+]] 2 0
; CHECK-SPIRV: 4 TypeInt [[Ty_41:[0-9]+]] 41 0
; CHECK-SPIRV: 4 TypeInt [[Ty_42:[0-9]+]] 42 0
; CHECK-SPIRV: 4 TypeInt [[Ty_17:[0-9]+]] 17 0
; CHECK-SPIRV: 4 TypeInt [[Ty_50:[0-9]+]] 50 0
; CHECK-SPIRV: 4 TypeInt [[Ty_38:[0-9]+]] 38 0
; CHECK-SPIRV: 4 TypeInt [[Ty_10:[0-9]+]] 10 0
; CHECK-SPIRV: 4 TypeInt [[Ty_48:[0-9]+]] 48 0
; CHECK-SPIRV: 4 TypeInt [[Ty_49:[0-9]+]] 49 0
; CHECK-SPIRV: 4 TypeInt [[Ty_3:[0-9]+]] 3 0
; CHECK-SPIRV: 4 TypeInt [[Ty_64:[0-9]+]] 64 0
; CHECK-SPIRV: 4 TypeInt [[Ty_62:[0-9]+]] 62 0
; CHECK-SPIRV: 4 TypeInt [[Ty_4:[0-9]+]] 4 0
; CHECK-SPIRV: 4 TypeInt [[Ty_27:[0-9]+]] 27 0
; CHECK-SPIRV: 4 TypeInt [[Ty_59:[0-9]+]] 59 0
; CHECK-SPIRV: 4 TypeInt [[Ty_35:[0-9]+]] 35 0
; CHECK-SPIRV: 4 TypeInt [[Ty_44:[0-9]+]] 44 0
; CHECK-SPIRV: 4 TypeInt [[Ty_24:[0-9]+]] 24 0
; CHECK-SPIRV: 4 TypeInt [[Ty_19:[0-9]+]] 19 0
; CHECK-SPIRV: 4 TypeInt [[Ty_21:[0-9]+]] 21 0
; CHECK-SPIRV: 4 TypeInt [[Ty_54:[0-9]+]] 54 0
; CHECK-SPIRV: 4 TypeInt [[Ty_56:[0-9]+]] 56 0
; CHECK-SPIRV: 4 TypeInt [[Ty_12:[0-9]+]] 12 0
; CHECK-SPIRV: 4 TypeInt [[Ty_66:[0-9]+]] 66 0
; CHECK-SPIRV: 4 TypeInt [[Ty_72:[0-9]+]] 72 0
; CHECK-SPIRV: 2 TypeBool [[Ty_Bool:[0-9]+]]

target datalayout = "e-i64:64-v16:16-v24:32-v32:32-v48:64-v96:128-v192:256-v256:256-v512:512-v1024:1024-n8:16:32:64"
target triple = "spir64-unknown-linux"

%"class._ZTSZ4mainE3$_0.anon" = type { i8 }

; Function Attrs: norecurse
define dso_local spir_kernel void @_ZTSZ4mainE15kernel_function() #0 !kernel_arg_addr_space !4 !kernel_arg_access_qual !4 !kernel_arg_type !4 !kernel_arg_base_type !4 !kernel_arg_type_qual !4 {
  %1 = alloca %"class._ZTSZ4mainE3$_0.anon", align 1
  %2 = bitcast %"class._ZTSZ4mainE3$_0.anon"* %1 to i8*
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %2) #5
  %3 = addrspacecast %"class._ZTSZ4mainE3$_0.anon"* %1 to %"class._ZTSZ4mainE3$_0.anon" addrspace(4)*
  call spir_func void @"_ZZ4mainENK3$_0clEv"(%"class._ZTSZ4mainE3$_0.anon" addrspace(4)* %3)
  %4 = bitcast %"class._ZTSZ4mainE3$_0.anon"* %1 to i8*
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %4) #5
  ret void
}

; Function Attrs: argmemonly nounwind willreturn
declare void @llvm.lifetime.start.p0i8(i64 immarg, i8* nocapture) #1

; Function Attrs: inlinehint norecurse
define internal spir_func void @"_ZZ4mainENK3$_0clEv"(%"class._ZTSZ4mainE3$_0.anon" addrspace(4)* %0) #2 align 2 {
  %2 = alloca %"class._ZTSZ4mainE3$_0.anon" addrspace(4)*, align 8
  store %"class._ZTSZ4mainE3$_0.anon" addrspace(4)* %0, %"class._ZTSZ4mainE3$_0.anon" addrspace(4)** %2, align 8, !tbaa !5
  call spir_func void @_Z13ap_float_castILi11ELi28ELi9ELi30EEvv()
  call spir_func void @_Z22ap_float_cast_from_intILi43ELi8ELi16EEvv()
  call spir_func void @_Z20ap_float_cast_to_intILi7ELi15ELi30EEvv()
  call spir_func void @_Z12ap_float_addILi5ELi7ELi6ELi8ELi4ELi9EEvv()
  call spir_func void @_Z12ap_float_addILi6ELi8ELi4ELi9ELi5ELi7EEvv()
  call spir_func void @_Z12ap_float_subILi4ELi4ELi5ELi5ELi6ELi6EEvv()
  call spir_func void @_Z12ap_float_mulILi16ELi34ELi16ELi34ELi16ELi34EEvv()
  call spir_func void @_Z12ap_float_divILi4ELi11ELi4ELi11ELi5ELi12EEvv()
  call spir_func void @_Z11ap_float_gtILi20ELi42ELi21ELi41EEvv()
  call spir_func void @_Z11ap_float_geILi19ELi27ELi19ELi27EEvv()
  call spir_func void @_Z11ap_float_ltILi2ELi2ELi3ELi3EEvv()
  call spir_func void @_Z11ap_float_leILi27ELi27ELi26ELi28EEvv()
  call spir_func void @_Z11ap_float_eqILi7ELi12ELi7ELi7EEvv()
  call spir_func void @_Z14ap_float_recipILi9ELi29ELi9ELi29EEvv()
  call spir_func void @_Z14ap_float_rsqrtILi12ELi19ELi13ELi20EEvv()
  call spir_func void @_Z13ap_float_cbrtILi0ELi1ELi0ELi1EEvv()
  call spir_func void @_Z14ap_float_hypotILi20ELi20ELi21ELi21ELi19ELi22EEvv()
  call spir_func void @_Z13ap_float_sqrtILi7ELi7ELi8ELi8EEvv()
  call spir_func void @_Z12ap_float_logILi30ELi19ELi19ELi30EEvv()
  call spir_func void @_Z13ap_float_log2ILi17ELi20ELi18ELi19EEvv()
  call spir_func void @_Z14ap_float_log10ILi4ELi3ELi4ELi5EEvv()
  call spir_func void @_Z14ap_float_log1pILi17ELi30ELi18ELi30EEvv()
  call spir_func void @_Z12ap_float_expILi16ELi25ELi16ELi25EEvv()
  call spir_func void @_Z13ap_float_exp2ILi1ELi1ELi2ELi2EEvv()
  call spir_func void @_Z14ap_float_exp10ILi8ELi16ELi8ELi16EEvv()
  call spir_func void @_Z14ap_float_expm1ILi21ELi42ELi20ELi41EEvv()
  call spir_func void @_Z12ap_float_sinILi14ELi15ELi16ELi17EEvv()
  call spir_func void @_Z12ap_float_cosILi1ELi2ELi2ELi1EEvv()
  call spir_func void @_Z15ap_float_sincosILi8ELi18ELi10ELi20EEvv()
  call spir_func void @_Z14ap_float_sinpiILi3ELi6ELi6ELi6EEvv()
  call spir_func void @_Z14ap_float_cospiILi18ELi40ELi18ELi40EEvv()
  call spir_func void @_Z17ap_float_sincospiILi9ELi20ELi11ELi20EEvv()
  call spir_func void @_Z13ap_float_asinILi2ELi4ELi2ELi8EEvv()
  call spir_func void @_Z15ap_float_asinpiILi11ELi23ELi11ELi23EEvv()
  call spir_func void @_Z13ap_float_acosILi4ELi9ELi3ELi10EEvv()
  call spir_func void @_Z15ap_float_acospiILi2ELi5ELi3ELi4EEvv()
  call spir_func void @_Z13ap_float_atanILi12ELi31ELi12ELi31EEvv()
  call spir_func void @_Z15ap_float_atanpiILi1ELi38ELi1ELi32EEvv()
  call spir_func void @_Z14ap_float_atan2ILi7ELi16ELi7ELi17ELi8ELi18EEvv()
  call spir_func void @_Z12ap_float_powILi8ELi8ELi9ELi9ELi10ELi10EEvv()
  call spir_func void @_Z13ap_float_powrILi18ELi35ELi19ELi35ELi20ELi35EEvv()
  call spir_func void @_Z13ap_float_pownILi4ELi7ELi10ELi5ELi9EEvv()
  call spir_func void @_Z15ap_float_sincosILi8ELi18ELi10ELi20EEvv_()
  call spir_func void @_Z14ap_float_atan2ILi7ELi16ELi7ELi17ELi8ELi18EEvv_()
  call spir_func void @_Z13ap_float_pownILi64ELi7ELi10ELi5ELi9EEvv()
  ret void
}

; Function Attrs: argmemonly nounwind willreturn
declare void @llvm.lifetime.end.p0i8(i64 immarg, i8* nocapture) #1

; Function Attrs: norecurse nounwind
define linkonce_odr dso_local spir_func void @_Z13ap_float_castILi11ELi28ELi9ELi30EEvv() #3 {
  %1 = alloca i40, align 8
  %2 = alloca i40, align 8
  %3 = bitcast i40* %1 to i8*
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %3) #5
  %4 = bitcast i40* %2 to i8*
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %4) #5
  %5 = load i40, i40* %1, align 8, !tbaa !9
  %6 = call spir_func i40 @_Z31__spirv_ArbitraryFloatCastINTELILi40ELi40EEU7_ExtIntIXT0_EEiU7_ExtIntIXT_EEiiiiii(i40 %5, i32 28, i32 30, i32 0, i32 2, i32 1) #5
; CHECK-SPIRV: 6 Load [[Ty_40]] [[Cast_AId:[0-9]+]]
; CHECK-SPIRV-NEXT: 9 ArbitraryFloatCastINTEL [[Ty_40]] [[#]] [[Cast_AId]] 28 30 0 2 1
; CHECK-LLVM: call i40 @intel_arbitrary_float_cast.i40.i40(i40 %[[#]], i32 28, i32 30, i32 0, i32 2, i32 1)
  store i40 %6, i40* %2, align 8, !tbaa !9
  %7 = bitcast i40* %2 to i8*
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %7) #5
  %8 = bitcast i40* %1 to i8*
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %8) #5
  ret void
}

; Function Attrs: norecurse nounwind
define linkonce_odr dso_local spir_func void @_Z22ap_float_cast_from_intILi43ELi8ELi16EEvv() #3 {
  %1 = alloca i43, align 8
  %2 = alloca i25, align 4
  %3 = bitcast i43* %1 to i8*
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %3) #5
  %4 = bitcast i25* %2 to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %4) #5
  %5 = load i43, i43* %1, align 8, !tbaa !11
  %6 = call spir_func signext i25 @_Z38__spirv_ArbitraryFloatCastFromIntINTELILi43ELi25EEU7_ExtIntIXT0_EEiU7_ExtIntIXT_EEiibiii(i43 %5, i32 16, i1 zeroext false, i32 0, i32 2, i32 1) #5
; CHECK-SPIRV: 6 Load [[Ty_43]] [[CastFromInt_AId:[0-9]+]]
; CHECK-SPIRV-NEXT: 9 ArbitraryFloatCastFromIntINTEL [[Ty_25]] [[#]] [[CastFromInt_AId]] 16 0 0 2 1
; CHECK-LLVM: call i25 @intel_arbitrary_float_cast_from_int.i25.i43(i43 %[[#]], i32 16, i1 false, i32 0, i32 2, i32 1)
  store i25 %6, i25* %2, align 4, !tbaa !13
  %7 = bitcast i25* %2 to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %7) #5
  %8 = bitcast i43* %1 to i8*
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %8) #5
  ret void
}

; Function Attrs: norecurse nounwind
define linkonce_odr dso_local spir_func void @_Z20ap_float_cast_to_intILi7ELi15ELi30EEvv() #3 {
  %1 = alloca i23, align 4
  %2 = alloca i30, align 4
  %3 = bitcast i23* %1 to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %3) #5
  %4 = bitcast i30* %2 to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %4) #5
  %5 = load i23, i23* %1, align 4, !tbaa !15
  %6 = call spir_func signext i30 @_Z36__spirv_ArbitraryFloatCastToIntINTELILi23ELi30EEU7_ExtIntIXT0_EEiU7_ExtIntIXT_EEiibiii(i23 signext %5, i32 15, i1 zeroext true, i32 0, i32 2, i32 1) #5
; CHECK-SPIRV: 6 Load [[Ty_23]] [[CastToInt_AId:[0-9]+]]
; CHECK-SPIRV-NEXT: 9 ArbitraryFloatCastToIntINTEL [[Ty_30]] [[#]] [[CastToInt_AId]] 15 1 0 2 1
; CHECK-LLVM: call i30 @intel_arbitrary_float_cast_to_int.i30.i23(i23 %[[#]], i32 15, i1 true, i32 0, i32 2, i32 1)
  store i30 %6, i30* %2, align 4, !tbaa !17
  %7 = bitcast i30* %2 to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %7) #5
  %8 = bitcast i23* %1 to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %8) #5
  ret void
}

; Function Attrs: norecurse nounwind
define linkonce_odr dso_local spir_func void @_Z12ap_float_addILi5ELi7ELi6ELi8ELi4ELi9EEvv() #3 {
  %1 = alloca i13, align 2
  %2 = alloca i13, align 2
  %3 = alloca i15, align 2
  %4 = alloca i15, align 2
  %5 = alloca i14, align 2
  %6 = alloca i14, align 2
  %7 = bitcast i13* %1 to i8*
  call void @llvm.lifetime.start.p0i8(i64 2, i8* %7) #5
  %8 = bitcast i13* %2 to i8*
  call void @llvm.lifetime.start.p0i8(i64 2, i8* %8) #5
  %9 = bitcast i15* %3 to i8*
  call void @llvm.lifetime.start.p0i8(i64 2, i8* %9) #5
  %10 = bitcast i15* %4 to i8*
  call void @llvm.lifetime.start.p0i8(i64 2, i8* %10) #5
  %11 = bitcast i14* %5 to i8*
  call void @llvm.lifetime.start.p0i8(i64 2, i8* %11) #5
  %12 = load i13, i13* %1, align 2, !tbaa !19
  %13 = load i15, i15* %3, align 2, !tbaa !21
  %14 = call spir_func signext i14 @_Z30__spirv_ArbitraryFloatAddINTELILi13ELi15ELi14EEU7_ExtIntIXT1_EEiU7_ExtIntIXT_EEiiU7_ExtIntIXT0_EEiiiiii(i13 signext %12, i32 7, i15 signext %13, i32 8, i32 9, i32 0, i32 2, i32 1) #5
; CHECK-SPIRV: 6 Load [[Ty_13]] [[Add1_A1Id:[0-9]+]]
; CHECK-SPIRV-NEXT: 6 Load [[Ty_15]] [[Add1_B1Id:[0-9]+]]
; CHECK-SPIRV-NEXT: 11 ArbitraryFloatAddINTEL [[Ty_14]] [[#]] [[Add1_A1Id]] 7 [[Add1_B1Id]] 8 9 0 2 1
; CHECK-LLVM: call i14 @intel_arbitrary_float_add.i14.i13.i15(i13 %[[#]], i32 7, i15 %[[#]], i32 8, i32 9, i32 0, i32 2, i32 1)
  store i14 %14, i14* %5, align 2, !tbaa !23
  %15 = bitcast i14* %6 to i8*
  call void @llvm.lifetime.start.p0i8(i64 2, i8* %15) #5
  %16 = load i13, i13* %2, align 2, !tbaa !19
  %17 = load i15, i15* %4, align 2, !tbaa !21
  %18 = call spir_func signext i14 @_Z30__spirv_ArbitraryFloatAddINTELILi13ELi15ELi14EEU7_ExtIntIXT1_EEiU7_ExtIntIXT_EEiiU7_ExtIntIXT0_EEiiiiii(i13 signext %16, i32 7, i15 signext %17, i32 8, i32 9, i32 0, i32 2, i32 1) #5
; CHECK-SPIRV: 6 Load [[Ty_13]] [[Add1_A2Id:[0-9]+]]
; CHECK-SPIRV-NEXT: 6 Load [[Ty_15]] [[Add1_B2Id:[0-9]+]]
; CHECK-SPIRV-NEXT: 11 ArbitraryFloatAddINTEL [[Ty_14]] [[#]] [[Add1_A2Id]] 7 [[Add1_B2Id]] 8 9 0 2 1
; CHECK-LLVM: call i14 @intel_arbitrary_float_add.i14.i13.i15(i13 %[[#]], i32 7, i15 %[[#]], i32 8, i32 9, i32 0, i32 2, i32 1)
  store i14 %18, i14* %6, align 2, !tbaa !23
  %19 = bitcast i14* %6 to i8*
  call void @llvm.lifetime.end.p0i8(i64 2, i8* %19) #5
  %20 = bitcast i14* %5 to i8*
  call void @llvm.lifetime.end.p0i8(i64 2, i8* %20) #5
  %21 = bitcast i15* %4 to i8*
  call void @llvm.lifetime.end.p0i8(i64 2, i8* %21) #5
  %22 = bitcast i15* %3 to i8*
  call void @llvm.lifetime.end.p0i8(i64 2, i8* %22) #5
  %23 = bitcast i13* %2 to i8*
  call void @llvm.lifetime.end.p0i8(i64 2, i8* %23) #5
  %24 = bitcast i13* %1 to i8*
  call void @llvm.lifetime.end.p0i8(i64 2, i8* %24) #5
  ret void
}

; Function Attrs: norecurse nounwind
define linkonce_odr dso_local spir_func void @_Z12ap_float_addILi6ELi8ELi4ELi9ELi5ELi7EEvv() #3 {
  %1 = alloca i15, align 2
  %2 = alloca i15, align 2
  %3 = alloca i14, align 2
  %4 = alloca i14, align 2
  %5 = alloca i13, align 2
  %6 = alloca i13, align 2
  %7 = bitcast i15* %1 to i8*
  call void @llvm.lifetime.start.p0i8(i64 2, i8* %7) #5
  %8 = bitcast i15* %2 to i8*
  call void @llvm.lifetime.start.p0i8(i64 2, i8* %8) #5
  %9 = bitcast i14* %3 to i8*
  call void @llvm.lifetime.start.p0i8(i64 2, i8* %9) #5
  %10 = bitcast i14* %4 to i8*
  call void @llvm.lifetime.start.p0i8(i64 2, i8* %10) #5
  %11 = bitcast i13* %5 to i8*
  call void @llvm.lifetime.start.p0i8(i64 2, i8* %11) #5
  %12 = load i15, i15* %1, align 2, !tbaa !21
  %13 = load i14, i14* %3, align 2, !tbaa !23
  %14 = call spir_func signext i13 @_Z30__spirv_ArbitraryFloatAddINTELILi15ELi14ELi13EEU7_ExtIntIXT1_EEiU7_ExtIntIXT_EEiiU7_ExtIntIXT0_EEiiiiii(i15 signext %12, i32 8, i14 signext %13, i32 9, i32 7, i32 0, i32 2, i32 1) #5
; CHECK-SPIRV: 6 Load [[Ty_15]] [[Add2_A1Id:[0-9]+]]
; CHECK-SPIRV-NEXT: 6 Load [[Ty_14]] [[Add2_B1Id:[0-9]+]]
; CHECK-SPIRV-NEXT: 11 ArbitraryFloatAddINTEL [[Ty_13]] [[#]] [[Add2_A1Id]] 8 [[Add2_B1Id]] 9 7 0 2 1
; CHECK-LLVM: call i13 @intel_arbitrary_float_add.i13.i15.i14(i15 %[[#]], i32 8, i14 %[[#]], i32 9, i32 7, i32 0, i32 2, i32 1)
  store i13 %14, i13* %5, align 2, !tbaa !19
  %15 = bitcast i13* %6 to i8*
  call void @llvm.lifetime.start.p0i8(i64 2, i8* %15) #5
  %16 = load i15, i15* %2, align 2, !tbaa !21
  %17 = load i14, i14* %4, align 2, !tbaa !23
  %18 = call spir_func signext i13 @_Z30__spirv_ArbitraryFloatAddINTELILi15ELi14ELi13EEU7_ExtIntIXT1_EEiU7_ExtIntIXT_EEiiU7_ExtIntIXT0_EEiiiiii(i15 signext %16, i32 8, i14 signext %17, i32 9, i32 7, i32 0, i32 2, i32 1) #5
; CHECK-SPIRV: 6 Load [[Ty_15]] [[Add2_A2Id:[0-9]+]]
; CHECK-SPIRV-NEXT: 6 Load [[Ty_14]] [[Add2_B2Id:[0-9]+]]
; CHECK-SPIRV-NEXT: 11 ArbitraryFloatAddINTEL [[Ty_13]] [[#]] [[Add2_A2Id]] 8 [[Add2_B2Id]] 9 7 0 2 1
; CHECK-LLVM: call i13 @intel_arbitrary_float_add.i13.i15.i14(i15 %[[#]], i32 8, i14 %[[#]], i32 9, i32 7, i32 0, i32 2, i32 1)
  store i13 %18, i13* %6, align 2, !tbaa !19
  %19 = bitcast i13* %6 to i8*
  call void @llvm.lifetime.end.p0i8(i64 2, i8* %19) #5
  %20 = bitcast i13* %5 to i8*
  call void @llvm.lifetime.end.p0i8(i64 2, i8* %20) #5
  %21 = bitcast i14* %4 to i8*
  call void @llvm.lifetime.end.p0i8(i64 2, i8* %21) #5
  %22 = bitcast i14* %3 to i8*
  call void @llvm.lifetime.end.p0i8(i64 2, i8* %22) #5
  %23 = bitcast i15* %2 to i8*
  call void @llvm.lifetime.end.p0i8(i64 2, i8* %23) #5
  %24 = bitcast i15* %1 to i8*
  call void @llvm.lifetime.end.p0i8(i64 2, i8* %24) #5
  ret void
}

; Function Attrs: norecurse nounwind
define linkonce_odr dso_local spir_func void @_Z12ap_float_subILi4ELi4ELi5ELi5ELi6ELi6EEvv() #3 {
  %1 = alloca i9, align 2
  %2 = alloca i11, align 2
  %3 = alloca i13, align 2
  %4 = bitcast i9* %1 to i8*
  call void @llvm.lifetime.start.p0i8(i64 2, i8* %4) #5
  %5 = bitcast i11* %2 to i8*
  call void @llvm.lifetime.start.p0i8(i64 2, i8* %5) #5
  %6 = bitcast i13* %3 to i8*
  call void @llvm.lifetime.start.p0i8(i64 2, i8* %6) #5
  %7 = load i9, i9* %1, align 2, !tbaa !25
  %8 = load i11, i11* %2, align 2, !tbaa !27
  %9 = call spir_func signext i13 @_Z30__spirv_ArbitraryFloatSubINTELILi9ELi11ELi13EEU7_ExtIntIXT1_EEiU7_ExtIntIXT_EEiiU7_ExtIntIXT0_EEiiiiii(i9 signext %7, i32 4, i11 signext %8, i32 5, i32 6, i32 0, i32 2, i32 1) #5
; CHECK-SPIRV: 6 Load [[Ty_9]] [[Sub_AId:[0-9]+]]
; CHECK-SPIRV-NEXT: 6 Load [[Ty_11]] [[Sub_BId:[0-9]+]]
; CHECK-SPIRV-NEXT: 11 ArbitraryFloatSubINTEL [[Ty_13]] [[#]] [[Sub_AId]] 4 [[Sub_BId]] 5 6 0 2 1
; CHECK-LLVM: call i13 @intel_arbitrary_float_sub.i13.i9.i11(i9 %[[#]], i32 4, i11 %[[#]], i32 5, i32 6, i32 0, i32 2, i32 1)
  store i13 %9, i13* %3, align 2, !tbaa !19
  %10 = bitcast i13* %3 to i8*
  call void @llvm.lifetime.end.p0i8(i64 2, i8* %10) #5
  %11 = bitcast i11* %2 to i8*
  call void @llvm.lifetime.end.p0i8(i64 2, i8* %11) #5
  %12 = bitcast i9* %1 to i8*
  call void @llvm.lifetime.end.p0i8(i64 2, i8* %12) #5
  ret void
}

; Function Attrs: norecurse nounwind
define linkonce_odr dso_local spir_func void @_Z12ap_float_mulILi16ELi34ELi16ELi34ELi16ELi34EEvv() #3 {
  %1 = alloca i51, align 8
  %2 = alloca i51, align 8
  %3 = alloca i51, align 8
  %4 = bitcast i51* %1 to i8*
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %4) #5
  %5 = bitcast i51* %2 to i8*
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %5) #5
  %6 = bitcast i51* %3 to i8*
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %6) #5
  %7 = load i51, i51* %1, align 8, !tbaa !29
  %8 = load i51, i51* %2, align 8, !tbaa !29
  %9 = call spir_func i51 @_Z30__spirv_ArbitraryFloatMulINTELILi51ELi51ELi51EEU7_ExtIntIXT1_EEiU7_ExtIntIXT_EEiiU7_ExtIntIXT0_EEiiiiii(i51 %7, i32 34, i51 %8, i32 34, i32 34, i32 0, i32 2, i32 1) #5
; CHECK-SPIRV: 6 Load [[Ty_51]] [[Mul_AId:[0-9]+]]
; CHECK-SPIRV-NEXT: 6 Load [[Ty_51]] [[Mul_BId:[0-9]+]]
; CHECK-SPIRV-NEXT: 11 ArbitraryFloatMulINTEL [[Ty_51]] [[#]] [[Mul_AId]] 34 [[Mul_BId]] 34 34 0 2 1
; CHECK-LLVM: call i51 @intel_arbitrary_float_mul.i51.i51.i51(i51 %[[#]], i32 34, i51 %[[#]], i32 34, i32 34, i32 0, i32 2, i32 1)
  store i51 %9, i51* %3, align 8, !tbaa !29
  %10 = bitcast i51* %3 to i8*
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %10) #5
  %11 = bitcast i51* %2 to i8*
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %11) #5
  %12 = bitcast i51* %1 to i8*
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %12) #5
  ret void
}

; Function Attrs: norecurse nounwind
define linkonce_odr dso_local spir_func void @_Z12ap_float_divILi4ELi11ELi4ELi11ELi5ELi12EEvv() #3 {
  %1 = alloca i16, align 2
  %2 = alloca i16, align 2
  %3 = alloca i18, align 4
  %4 = bitcast i16* %1 to i8*
  call void @llvm.lifetime.start.p0i8(i64 2, i8* %4) #5
  %5 = bitcast i16* %2 to i8*
  call void @llvm.lifetime.start.p0i8(i64 2, i8* %5) #5
  %6 = bitcast i18* %3 to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %6) #5
  %7 = load i16, i16* %1, align 2, !tbaa !31
  %8 = load i16, i16* %2, align 2, !tbaa !31
  %9 = call spir_func signext i18 @_Z30__spirv_ArbitraryFloatDivINTELILi16ELi16ELi18EEU7_ExtIntIXT1_EEiU7_ExtIntIXT_EEiiU7_ExtIntIXT0_EEiiiiii(i16 signext %7, i32 11, i16 signext %8, i32 11, i32 12, i32 0, i32 2, i32 1) #5
; CHECK-SPIRV: 6 Load [[Ty_16]] [[Div_AId:[0-9]+]]
; CHECK-SPIRV-NEXT: 6 Load [[Ty_16]] [[Div_BId:[0-9]+]]
; CHECK-SPIRV-NEXT: 11 ArbitraryFloatDivINTEL [[Ty_18]] [[#]] [[Div_AId]] 11 [[Div_BId]] 11 12 0 2 1
; CHECK-LLVM: call i18 @intel_arbitrary_float_div.i18.i16.i16(i16 %[[#]], i32 11, i16 %[[#]], i32 11, i32 12, i32 0, i32 2, i32 1)
  store i18 %9, i18* %3, align 4, !tbaa !33
  %10 = bitcast i18* %3 to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %10) #5
  %11 = bitcast i16* %2 to i8*
  call void @llvm.lifetime.end.p0i8(i64 2, i8* %11) #5
  %12 = bitcast i16* %1 to i8*
  call void @llvm.lifetime.end.p0i8(i64 2, i8* %12) #5
  ret void
}

; Function Attrs: norecurse nounwind
define linkonce_odr dso_local spir_func void @_Z11ap_float_gtILi20ELi42ELi21ELi41EEvv() #3 {
  %1 = alloca i63, align 8
  %2 = alloca i63, align 8
  %3 = alloca i8, align 1
  %4 = bitcast i63* %1 to i8*
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %4) #5
  %5 = bitcast i63* %2 to i8*
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %5) #5
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %3) #5
  %6 = load i63, i63* %1, align 8, !tbaa !35
  %7 = load i63, i63* %2, align 8, !tbaa !35
  %8 = call spir_func zeroext i1 @_Z29__spirv_ArbitraryFloatGTINTELILi63ELi63EEbU7_ExtIntIXT_EEiiU7_ExtIntIXT0_EEii(i63 %6, i32 42, i63 %7, i32 41) #5
; CHECK-SPIRV: 6 Load [[Ty_63]] [[GT_AId:[0-9]+]]
; CHECK-SPIRV-NEXT: 6 Load [[Ty_63]] [[GT_BId:[0-9]+]]
; CHECK-SPIRV-NEXT: 7 ArbitraryFloatGTINTEL [[Ty_Bool]] [[#]] [[GT_AId]] 42 [[GT_BId]] 41
; CHECK-LLVM: call i1 @intel_arbitrary_float_gt.i1.i63.i63(i63 %[[#]], i32 42, i63 %[[#]], i32 41)
  %9 = zext i1 %8 to i8
  store i8 %9, i8* %3, align 1, !tbaa !37
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %3) #5
  %10 = bitcast i63* %2 to i8*
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %10) #5
  %11 = bitcast i63* %1 to i8*
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %11) #5
  ret void
}

; Function Attrs: norecurse nounwind
define linkonce_odr dso_local spir_func void @_Z11ap_float_geILi19ELi27ELi19ELi27EEvv() #3 {
  %1 = alloca i47, align 8
  %2 = alloca i47, align 8
  %3 = alloca i8, align 1
  %4 = bitcast i47* %1 to i8*
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %4) #5
  %5 = bitcast i47* %2 to i8*
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %5) #5
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %3) #5
  %6 = load i47, i47* %1, align 8, !tbaa !39
  %7 = load i47, i47* %2, align 8, !tbaa !39
  %8 = call spir_func zeroext i1 @_Z29__spirv_ArbitraryFloatGEINTELILi47ELi47EEbU7_ExtIntIXT_EEiiU7_ExtIntIXT0_EEii(i47 %6, i32 27, i47 %7, i32 27) #5
; CHECK-SPIRV: 6 Load [[Ty_47]] [[GE_AId:[0-9]+]]
; CHECK-SPIRV-NEXT: 6 Load [[Ty_47]] [[GE_BId:[0-9]+]]
; CHECK-SPIRV-NEXT: 7 ArbitraryFloatGEINTEL [[Ty_Bool]] [[#]] [[GE_AId]] 27 [[GE_BId]] 27
; CHECK-LLVM: call i1 @intel_arbitrary_float_ge.i1.i47.i47(i47 %[[#]], i32 27, i47 %[[#]], i32 27)
  %9 = zext i1 %8 to i8
  store i8 %9, i8* %3, align 1, !tbaa !37
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %3) #5
  %10 = bitcast i47* %2 to i8*
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %10) #5
  %11 = bitcast i47* %1 to i8*
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %11) #5
  ret void
}

; Function Attrs: norecurse nounwind
define linkonce_odr dso_local spir_func void @_Z11ap_float_ltILi2ELi2ELi3ELi3EEvv() #3 {
  %1 = alloca i5, align 1
  %2 = alloca i7, align 1
  %3 = alloca i8, align 1
  %4 = bitcast i5* %1 to i8*
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %4) #5
  %5 = bitcast i7* %2 to i8*
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %5) #5
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %3) #5
  %6 = load i5, i5* %1, align 1, !tbaa !41
  %7 = load i7, i7* %2, align 1, !tbaa !43
  %8 = call spir_func zeroext i1 @_Z29__spirv_ArbitraryFloatLTINTELILi5ELi7EEbU7_ExtIntIXT_EEiiU7_ExtIntIXT0_EEii(i5 signext %6, i32 2, i7 signext %7, i32 3) #5
; CHECK-SPIRV: 6 Load [[Ty_5]] [[LT_AId:[0-9]+]]
; CHECK-SPIRV-NEXT: 6 Load [[Ty_7]] [[LT_BId:[0-9]+]]
; CHECK-SPIRV-NEXT: 7 ArbitraryFloatLTINTEL [[Ty_Bool]] [[#]] [[LT_AId]] 2 [[LT_BId]] 3
; CHECK-LLVM: call i1 @intel_arbitrary_float_lt.i1.i5.i7(i5 %[[#]], i32 2, i7 %[[#]], i32 3)
  %9 = zext i1 %8 to i8
  store i8 %9, i8* %3, align 1, !tbaa !37
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %3) #5
  %10 = bitcast i7* %2 to i8*
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %10) #5
  %11 = bitcast i5* %1 to i8*
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %11) #5
  ret void
}

; Function Attrs: norecurse nounwind
define linkonce_odr dso_local spir_func void @_Z11ap_float_leILi27ELi27ELi26ELi28EEvv() #3 {
  %1 = alloca i55, align 8
  %2 = alloca i55, align 8
  %3 = alloca i8, align 1
  %4 = bitcast i55* %1 to i8*
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %4) #5
  %5 = bitcast i55* %2 to i8*
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %5) #5
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %3) #5
  %6 = load i55, i55* %1, align 8, !tbaa !45
  %7 = load i55, i55* %2, align 8, !tbaa !45
  %8 = call spir_func zeroext i1 @_Z29__spirv_ArbitraryFloatLEINTELILi55ELi55EEbU7_ExtIntIXT_EEiiU7_ExtIntIXT0_EEii(i55 %6, i32 27, i55 %7, i32 28) #5
; CHECK-SPIRV: 6 Load [[Ty_55]] [[LE_AId:[0-9]+]]
; CHECK-SPIRV-NEXT: 6 Load [[Ty_55]] [[LE_BId:[0-9]+]]
; CHECK-SPIRV-NEXT: 7 ArbitraryFloatLEINTEL [[Ty_Bool]] [[#]] [[LE_AId]] 27 [[LE_BId]] 28
; CHECK-LLVM: call i1 @intel_arbitrary_float_le.i1.i55.i55(i55 %[[#]], i32 27, i55 %[[#]], i32 28)
  %9 = zext i1 %8 to i8
  store i8 %9, i8* %3, align 1, !tbaa !37
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %3) #5
  %10 = bitcast i55* %2 to i8*
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %10) #5
  %11 = bitcast i55* %1 to i8*
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %11) #5
  ret void
}

; Function Attrs: norecurse nounwind
define linkonce_odr dso_local spir_func void @_Z11ap_float_eqILi7ELi12ELi7ELi7EEvv() #3 {
  %1 = alloca i20, align 4
  %2 = alloca i15, align 2
  %3 = alloca i8, align 1
  %4 = bitcast i20* %1 to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %4) #5
  %5 = bitcast i15* %2 to i8*
  call void @llvm.lifetime.start.p0i8(i64 2, i8* %5) #5
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %3) #5
  %6 = load i20, i20* %1, align 4, !tbaa !47
  %7 = load i15, i15* %2, align 2, !tbaa !21
  %8 = call spir_func zeroext i1 @_Z29__spirv_ArbitraryFloatEQINTELILi20ELi15EEbU7_ExtIntIXT_EEiiU7_ExtIntIXT0_EEii(i20 signext %6, i32 12, i15 signext %7, i32 7) #5
; CHECK-SPIRV: 6 Load [[Ty_20]] [[EQ_AId:[0-9]+]]
; CHECK-SPIRV-NEXT: 6 Load [[Ty_15]] [[EQ_BId:[0-9]+]]
; CHECK-SPIRV-NEXT: 7 ArbitraryFloatEQINTEL [[Ty_Bool]] [[#]] [[EQ_AId]] 12 [[EQ_BId]] 7
; CHECK-LLVM: call i1 @intel_arbitrary_float_eq.i1.i20.i15(i20 %[[#]], i32 12, i15 %[[#]], i32 7)
  %9 = zext i1 %8 to i8
  store i8 %9, i8* %3, align 1, !tbaa !37
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %3) #5
  %10 = bitcast i15* %2 to i8*
  call void @llvm.lifetime.end.p0i8(i64 2, i8* %10) #5
  %11 = bitcast i20* %1 to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %11) #5
  ret void
}

; Function Attrs: norecurse nounwind
define linkonce_odr dso_local spir_func void @_Z14ap_float_recipILi9ELi29ELi9ELi29EEvv() #3 {
  %1 = alloca i39, align 8
  %2 = alloca i39, align 8
  %3 = bitcast i39* %1 to i8*
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %3) #5
  %4 = bitcast i39* %2 to i8*
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %4) #5
  %5 = load i39, i39* %1, align 8, !tbaa !49
  %6 = call spir_func i39 @_Z32__spirv_ArbitraryFloatRecipINTELILi39ELi39EEU7_ExtIntIXT0_EEiU7_ExtIntIXT_EEiiiiii(i39 %5, i32 29, i32 29, i32 0, i32 2, i32 1) #5
; CHECK-SPIRV: 6 Load [[Ty_39]] [[Recip_AId:[0-9]+]]
; CHECK-SPIRV-NEXT: 9 ArbitraryFloatRecipINTEL [[Ty_39]] [[#]] [[Recip_AId]] 29 29 0 2 1
; CHECK-LLVM: call i39 @intel_arbitrary_float_recip.i39.i39(i39 %[[#]], i32 29, i32 29, i32 0, i32 2, i32 1)
  store i39 %6, i39* %2, align 8, !tbaa !49
  %7 = bitcast i39* %2 to i8*
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %7) #5
  %8 = bitcast i39* %1 to i8*
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %8) #5
  ret void
}

; Function Attrs: norecurse nounwind
define linkonce_odr dso_local spir_func void @_Z14ap_float_rsqrtILi12ELi19ELi13ELi20EEvv() #3 {
  %1 = alloca i32, align 4
  %2 = alloca i34, align 8
  %3 = bitcast i32* %1 to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %3) #5
  %4 = bitcast i34* %2 to i8*
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %4) #5
  %5 = load i32, i32* %1, align 4, !tbaa !51
  %6 = call spir_func i34 @_Z32__spirv_ArbitraryFloatRSqrtINTELILi32ELi34EEU7_ExtIntIXT0_EEiU7_ExtIntIXT_EEiiiiii(i32 %5, i32 19, i32 20, i32 0, i32 2, i32 1) #5
; CHECK-SPIRV: 6 Load [[Ty_32]] [[Rsqrt_AId:[0-9]+]]
; CHECK-SPIRV-NEXT: 9 ArbitraryFloatRSqrtINTEL [[Ty_34]] [[#]] [[Rsqrt_AId]] 19 20 0 2 1
; CHECK-LLVM: call i34 @intel_arbitrary_float_rsqrt.i34.i32(i32 %[[#]], i32 19, i32 20, i32 0, i32 2, i32 1)
  store i34 %6, i34* %2, align 8, !tbaa !53
  %7 = bitcast i34* %2 to i8*
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %7) #5
  %8 = bitcast i32* %1 to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %8) #5
  ret void
}

; Function Attrs: norecurse nounwind
define linkonce_odr dso_local spir_func void @_Z13ap_float_cbrtILi0ELi1ELi0ELi1EEvv() #3 {
  %1 = alloca i2, align 1
  %2 = alloca i2, align 1
  %3 = bitcast i2* %1 to i8*
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %3) #5
  %4 = bitcast i2* %2 to i8*
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %4) #5
  %5 = load i2, i2* %1, align 1, !tbaa !55
  %6 = call spir_func signext i2 @_Z31__spirv_ArbitraryFloatCbrtINTELILi2ELi2EEU7_ExtIntIXT0_EEiU7_ExtIntIXT_EEiiiiii(i2 signext %5, i32 1, i32 1, i32 0, i32 2, i32 1) #5
; CHECK-SPIRV: 6 Load [[Ty_2]] [[Cbrt_AId:[0-9]+]]
; CHECK-SPIRV-NEXT: 9 ArbitraryFloatCbrtINTEL [[Ty_2]] [[#]] [[Cbrt_AId]] 1 1 0 2 1
; CHECK-LLVM: call i2 @intel_arbitrary_float_cbrt.i2.i2(i2 %[[#]], i32 1, i32 1, i32 0, i32 2, i32 1)
  store i2 %6, i2* %2, align 1, !tbaa !55
  %7 = bitcast i2* %2 to i8*
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %7) #5
  %8 = bitcast i2* %1 to i8*
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %8) #5
  ret void
}

; Function Attrs: norecurse nounwind
define linkonce_odr dso_local spir_func void @_Z14ap_float_hypotILi20ELi20ELi21ELi21ELi19ELi22EEvv() #3 {
  %1 = alloca i41, align 8
  %2 = alloca i43, align 8
  %3 = alloca i42, align 8
  %4 = bitcast i41* %1 to i8*
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %4) #5
  %5 = bitcast i43* %2 to i8*
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %5) #5
  %6 = bitcast i42* %3 to i8*
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %6) #5
  %7 = load i41, i41* %1, align 8, !tbaa !57
  %8 = load i43, i43* %2, align 8, !tbaa !11
  %9 = call spir_func i42 @_Z32__spirv_ArbitraryFloatHypotINTELILi41ELi43ELi42EEU7_ExtIntIXT1_EEiU7_ExtIntIXT_EEiiU7_ExtIntIXT0_EEiiiiii(i41 %7, i32 20, i43 %8, i32 21, i32 22, i32 0, i32 2, i32 1) #5
; CHECK-SPIRV: 6 Load [[Ty_41]] [[Hypot_AId:[0-9]+]]
; CHECK-SPIRV-NEXT: 6 Load [[Ty_43]] [[Hypot_BId:[0-9]+]]
; CHECK-SPIRV-NEXT: 11 ArbitraryFloatHypotINTEL [[Ty_42]] [[#]] [[Hypot_AId]] 20 [[Hypot_BId]] 21 22 0 2 1
; CHECK-LLVM: call i42 @intel_arbitrary_float_hypot.i42.i41.i43(i41 %[[#]], i32 20, i43 %[[#]], i32 21, i32 22, i32 0, i32 2, i32 1)
  store i42 %9, i42* %3, align 8, !tbaa !59
  %10 = bitcast i42* %3 to i8*
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %10) #5
  %11 = bitcast i43* %2 to i8*
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %11) #5
  %12 = bitcast i41* %1 to i8*
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %12) #5
  ret void
}

; Function Attrs: norecurse nounwind
define linkonce_odr dso_local spir_func void @_Z13ap_float_sqrtILi7ELi7ELi8ELi8EEvv() #3 {
  %1 = alloca i15, align 2
  %2 = alloca i17, align 4
  %3 = bitcast i15* %1 to i8*
  call void @llvm.lifetime.start.p0i8(i64 2, i8* %3) #5
  %4 = bitcast i17* %2 to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %4) #5
  %5 = load i15, i15* %1, align 2, !tbaa !21
  %6 = call spir_func signext i17 @_Z31__spirv_ArbitraryFloatSqrtINTELILi15ELi17EEU7_ExtIntIXT0_EEiU7_ExtIntIXT_EEiiiiii(i15 signext %5, i32 7, i32 8, i32 0, i32 2, i32 1) #5
; CHECK-SPIRV: 6 Load [[Ty_15]] [[Sqrt_AId:[0-9]+]]
; CHECK-SPIRV-NEXT: 9 ArbitraryFloatSqrtINTEL [[Ty_17]] [[#]] [[Sqrt_AId]] 7 8 0 2 1
; CHECK-LLVM: call i17 @intel_arbitrary_float_sqrt.i17.i15(i15 %[[#]], i32 7, i32 8, i32 0, i32 2, i32 1)
  store i17 %6, i17* %2, align 4, !tbaa !61
  %7 = bitcast i17* %2 to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %7) #5
  %8 = bitcast i15* %1 to i8*
  call void @llvm.lifetime.end.p0i8(i64 2, i8* %8) #5
  ret void
}

; Function Attrs: norecurse nounwind
define linkonce_odr dso_local spir_func void @_Z12ap_float_logILi30ELi19ELi19ELi30EEvv() #3 {
  %1 = alloca i50, align 8
  %2 = alloca i50, align 8
  %3 = bitcast i50* %1 to i8*
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %3) #5
  %4 = bitcast i50* %2 to i8*
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %4) #5
  %5 = load i50, i50* %1, align 8, !tbaa !63
  %6 = call spir_func i50 @_Z30__spirv_ArbitraryFloatLogINTELILi50ELi50EEU7_ExtIntIXT0_EEiU7_ExtIntIXT_EEiiiiii(i50 %5, i32 19, i32 30, i32 0, i32 2, i32 1) #5
; CHECK-SPIRV: 6 Load [[Ty_50]] [[Log_AId:[0-9]+]]
; CHECK-SPIRV-NEXT: 9 ArbitraryFloatLogINTEL [[Ty_50]] [[#]] [[Log_AId]] 19 30 0 2 1
; CHECK-LLVM: call i50 @intel_arbitrary_float_log.i50.i50(i50 %[[#]], i32 19, i32 30, i32 0, i32 2, i32 1)
  store i50 %6, i50* %2, align 8, !tbaa !63
  %7 = bitcast i50* %2 to i8*
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %7) #5
  %8 = bitcast i50* %1 to i8*
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %8) #5
  ret void
}

; Function Attrs: norecurse nounwind
define linkonce_odr dso_local spir_func void @_Z13ap_float_log2ILi17ELi20ELi18ELi19EEvv() #3 {
  %1 = alloca i38, align 8
  %2 = alloca i38, align 8
  %3 = bitcast i38* %1 to i8*
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %3) #5
  %4 = bitcast i38* %2 to i8*
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %4) #5
  %5 = load i38, i38* %1, align 8, !tbaa !65
  %6 = call spir_func i38 @_Z31__spirv_ArbitraryFloatLog2INTELILi38ELi38EEU7_ExtIntIXT0_EEiU7_ExtIntIXT_EEiiiiii(i38 %5, i32 20, i32 19, i32 0, i32 2, i32 1) #5
; CHECK-SPIRV: 6 Load [[Ty_38]] [[Log2_AId:[0-9]+]]
; CHECK-SPIRV-NEXT: 9 ArbitraryFloatLog2INTEL [[Ty_38]] [[#]] [[Log2_AId]] 20 19 0 2 1
; CHECK-LLVM: call i38 @intel_arbitrary_float_log2.i38.i38(i38 %[[#]], i32 20, i32 19, i32 0, i32 2, i32 1)
  store i38 %6, i38* %2, align 8, !tbaa !65
  %7 = bitcast i38* %2 to i8*
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %7) #5
  %8 = bitcast i38* %1 to i8*
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %8) #5
  ret void
}

; Function Attrs: norecurse nounwind
define linkonce_odr dso_local spir_func void @_Z14ap_float_log10ILi4ELi3ELi4ELi5EEvv() #3 {
  %1 = alloca i8, align 1
  %2 = alloca i10, align 2
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %1) #5
  %3 = bitcast i10* %2 to i8*
  call void @llvm.lifetime.start.p0i8(i64 2, i8* %3) #5
  %4 = load i8, i8* %1, align 1, !tbaa !67
  %5 = call spir_func signext i10 @_Z32__spirv_ArbitraryFloatLog10INTELILi8ELi10EEU7_ExtIntIXT0_EEiU7_ExtIntIXT_EEiiiiii(i8 signext %4, i32 3, i32 5, i32 0, i32 2, i32 1) #5
; CHECK-SPIRV: 6 Load [[Ty_8]] [[Log10_AId:[0-9]+]]
; CHECK-SPIRV-NEXT: 9 ArbitraryFloatLog10INTEL [[Ty_10]] [[#]] [[Log10_AId]] 3 5 0 2 1
; CHECK-LLVM: call i10 @intel_arbitrary_float_log10.i10.i8(i8 %[[#]], i32 3, i32 5, i32 0, i32 2, i32 1)
  store i10 %5, i10* %2, align 2, !tbaa !69
  %6 = bitcast i10* %2 to i8*
  call void @llvm.lifetime.end.p0i8(i64 2, i8* %6) #5
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %1) #5
  ret void
}

; Function Attrs: norecurse nounwind
define linkonce_odr dso_local spir_func void @_Z14ap_float_log1pILi17ELi30ELi18ELi30EEvv() #3 {
  %1 = alloca i48, align 8
  %2 = alloca i49, align 8
  %3 = bitcast i48* %1 to i8*
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %3) #5
  %4 = bitcast i49* %2 to i8*
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %4) #5
  %5 = load i48, i48* %1, align 8, !tbaa !71
  %6 = call spir_func i49 @_Z32__spirv_ArbitraryFloatLog1pINTELILi48ELi49EEU7_ExtIntIXT0_EEiU7_ExtIntIXT_EEiiiiii(i48 %5, i32 30, i32 30, i32 0, i32 2, i32 1) #5
; CHECK-SPIRV: 6 Load [[Ty_48]] [[Log1p_AId:[0-9]+]]
; CHECK-SPIRV-NEXT: 9 ArbitraryFloatLog1pINTEL [[Ty_49]] [[#]] [[Log1p_AId]] 30 30 0 2 1
; CHECK-LLVM: call i49 @intel_arbitrary_float_log1p.i49.i48(i48 %[[#]], i32 30, i32 30, i32 0, i32 2, i32 1)
  store i49 %6, i49* %2, align 8, !tbaa !73
  %7 = bitcast i49* %2 to i8*
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %7) #5
  %8 = bitcast i48* %1 to i8*
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %8) #5
  ret void
}

; Function Attrs: norecurse nounwind
define linkonce_odr dso_local spir_func void @_Z12ap_float_expILi16ELi25ELi16ELi25EEvv() #3 {
  %1 = alloca i42, align 8
  %2 = alloca i42, align 8
  %3 = bitcast i42* %1 to i8*
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %3) #5
  %4 = bitcast i42* %2 to i8*
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %4) #5
  %5 = load i42, i42* %1, align 8, !tbaa !59
  %6 = call spir_func i42 @_Z30__spirv_ArbitraryFloatExpINTELILi42ELi42EEU7_ExtIntIXT0_EEiU7_ExtIntIXT_EEiiiiii(i42 %5, i32 25, i32 25, i32 0, i32 2, i32 1) #5
; CHECK-SPIRV: 6 Load [[Ty_42]] [[Exp_AId:[0-9]+]]
; CHECK-SPIRV-NEXT: 9 ArbitraryFloatExpINTEL [[Ty_42]] [[#]] [[Exp_AId]] 25 25 0 2 1
; CHECK-LLVM: call i42 @intel_arbitrary_float_exp.i42.i42(i42 %[[#]], i32 25, i32 25, i32 0, i32 2, i32 1)
  store i42 %6, i42* %2, align 8, !tbaa !59
  %7 = bitcast i42* %2 to i8*
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %7) #5
  %8 = bitcast i42* %1 to i8*
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %8) #5
  ret void
}

; Function Attrs: norecurse nounwind
define linkonce_odr dso_local spir_func void @_Z13ap_float_exp2ILi1ELi1ELi2ELi2EEvv() #3 {
  %1 = alloca i3, align 1
  %2 = alloca i5, align 1
  %3 = bitcast i3* %1 to i8*
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %3) #5
  %4 = bitcast i5* %2 to i8*
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %4) #5
  %5 = load i3, i3* %1, align 1, !tbaa !75
  %6 = call spir_func signext i5 @_Z31__spirv_ArbitraryFloatExp2INTELILi3ELi5EEU7_ExtIntIXT0_EEiU7_ExtIntIXT_EEiiiiii(i3 signext %5, i32 1, i32 2, i32 0, i32 2, i32 1) #5
; CHECK-SPIRV: 6 Load [[Ty_3]] [[Exp2_AId:[0-9]+]]
; CHECK-SPIRV-NEXT: 9 ArbitraryFloatExp2INTEL [[Ty_5]] [[#]] [[Exp2_AId]] 1 2 0 2 1
; CHECK-LLVM: call i5 @intel_arbitrary_float_exp2.i5.i3(i3 %[[#]], i32 1, i32 2, i32 0, i32 2, i32 1)
  store i5 %6, i5* %2, align 1, !tbaa !41
  %7 = bitcast i5* %2 to i8*
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %7) #5
  %8 = bitcast i3* %1 to i8*
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %8) #5
  ret void
}

; Function Attrs: norecurse nounwind
define linkonce_odr dso_local spir_func void @_Z14ap_float_exp10ILi8ELi16ELi8ELi16EEvv() #3 {
  %1 = alloca i25, align 4
  %2 = alloca i25, align 4
  %3 = bitcast i25* %1 to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %3) #5
  %4 = bitcast i25* %2 to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %4) #5
  %5 = load i25, i25* %1, align 4, !tbaa !13
  %6 = call spir_func signext i25 @_Z32__spirv_ArbitraryFloatExp10INTELILi25ELi25EEU7_ExtIntIXT0_EEiU7_ExtIntIXT_EEiiiiii(i25 signext %5, i32 16, i32 16, i32 0, i32 2, i32 1) #5
; CHECK-SPIRV: 6 Load [[Ty_25]] [[Exp10_AId:[0-9]+]]
; CHECK-SPIRV-NEXT: 9 ArbitraryFloatExp10INTEL [[Ty_25]] [[#]] [[Exp10_AId]] 16 16 0 2 1
; CHECK-LLVM: call i25 @intel_arbitrary_float_exp10.i25.i25(i25 %[[#]], i32 16, i32 16, i32 0, i32 2, i32 1)
  store i25 %6, i25* %2, align 4, !tbaa !13
  %7 = bitcast i25* %2 to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %7) #5
  %8 = bitcast i25* %1 to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %8) #5
  ret void
}

; Function Attrs: norecurse nounwind
define linkonce_odr dso_local spir_func void @_Z14ap_float_expm1ILi21ELi42ELi20ELi41EEvv() #3 {
  %1 = alloca i64, align 8
  %2 = alloca i62, align 8
  %3 = bitcast i64* %1 to i8*
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %3) #5
  %4 = bitcast i62* %2 to i8*
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %4) #5
  %5 = load i64, i64* %1, align 8, !tbaa !77
  %6 = call spir_func i62 @_Z32__spirv_ArbitraryFloatExpm1INTELILi64ELi62EEU7_ExtIntIXT0_EEiU7_ExtIntIXT_EEiiiiii(i64 %5, i32 42, i32 41, i32 0, i32 2, i32 1) #5
; CHECK-SPIRV: 6 Load [[Ty_64]] [[Expm1_AId:[0-9]+]]
; CHECK-SPIRV-NEXT: 9 ArbitraryFloatExpm1INTEL [[Ty_62]] [[#]] [[Expm1_AId]] 42 41 0 2 1
; CHECK-LLVM: call i62 @intel_arbitrary_float_expm1.i62.i64(i64 %[[#]], i32 42, i32 41, i32 0, i32 2, i32 1)
  store i62 %6, i62* %2, align 8, !tbaa !79
  %7 = bitcast i62* %2 to i8*
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %7) #5
  %8 = bitcast i64* %1 to i8*
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %8) #5
  ret void
}

; Function Attrs: norecurse nounwind
define linkonce_odr dso_local spir_func void @_Z12ap_float_sinILi14ELi15ELi16ELi17EEvv() #3 {
  %1 = alloca i30, align 4
  %2 = alloca i34, align 8
  %3 = bitcast i30* %1 to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %3) #5
  %4 = bitcast i34* %2 to i8*
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %4) #5
  %5 = load i30, i30* %1, align 4, !tbaa !17
  %6 = call spir_func i34 @_Z30__spirv_ArbitraryFloatSinINTELILi30ELi34EEU7_ExtIntIXT0_EEiU7_ExtIntIXT_EEiiiiii(i30 signext %5, i32 15, i32 17, i32 0, i32 2, i32 1) #5
; CHECK-SPIRV: 6 Load [[Ty_30]] [[Sin_AId:[0-9]+]]
; CHECK-SPIRV-NEXT: 9 ArbitraryFloatSinINTEL [[Ty_34]] [[#]] [[Sin_AId]] 15 17 0 2 1
; CHECK-LLVM: call i34 @intel_arbitrary_float_sin.i34.i30(i30 %[[#]], i32 15, i32 17, i32 0, i32 2, i32 1)
  store i34 %6, i34* %2, align 8, !tbaa !53
  %7 = bitcast i34* %2 to i8*
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %7) #5
  %8 = bitcast i30* %1 to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %8) #5
  ret void
}

; Function Attrs: norecurse nounwind
define linkonce_odr dso_local spir_func void @_Z12ap_float_cosILi1ELi2ELi2ELi1EEvv() #3 {
  %1 = alloca i4, align 1
  %2 = alloca i4, align 1
  %3 = bitcast i4* %1 to i8*
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %3) #5
  %4 = bitcast i4* %2 to i8*
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %4) #5
  %5 = load i4, i4* %1, align 1, !tbaa !81
  %6 = call spir_func signext i4 @_Z30__spirv_ArbitraryFloatCosINTELILi4ELi4EEU7_ExtIntIXT0_EEiU7_ExtIntIXT_EEiiiiii(i4 signext %5, i32 2, i32 1, i32 0, i32 2, i32 1) #5
; CHECK-SPIRV: 6 Load [[Ty_4]] [[Cos_AId:[0-9]+]]
; CHECK-SPIRV-NEXT: 9 ArbitraryFloatCosINTEL [[Ty_4]] [[#]] [[Cos_AId]] 2 1 0 2 1
; CHECK-LLVM: call i4 @intel_arbitrary_float_cos.i4.i4(i4 %[[#]], i32 2, i32 1, i32 0, i32 2, i32 1)
  store i4 %6, i4* %2, align 1, !tbaa !81
  %7 = bitcast i4* %2 to i8*
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %7) #5
  %8 = bitcast i4* %1 to i8*
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %8) #5
  ret void
}

; Function Attrs: norecurse nounwind
define linkonce_odr dso_local spir_func void @_Z15ap_float_sincosILi8ELi18ELi10ELi20EEvv() #3 {
  %1 = alloca i27, align 4
  %2 = alloca i62, align 8
  %3 = bitcast i27* %1 to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %3) #5
  %4 = bitcast i62* %2 to i8*
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %4) #5
  %5 = load i27, i27* %1, align 4, !tbaa !83
  %6 = call spir_func i62 @_Z33__spirv_ArbitraryFloatSinCosINTELILi27ELi31EEU7_ExtIntIXmlLi2ET0_EEiU7_ExtIntIXT_EEiiiiii(i27 signext %5, i32 18, i32 20, i32 0, i32 2, i32 1) #5
; CHECK-SPIRV: 6 Load [[Ty_27]] [[SinCos_AId:[0-9]+]]
; CHECK-SPIRV-NEXT: 9 ArbitraryFloatSinCosINTEL [[Ty_62]] [[#]] [[SinCos_AId]] 18 20 0 2 1
; CHECK-LLVM: call i62 @intel_arbitrary_float_sincos.i62.i27(i27 %[[#]], i32 18, i32 20, i32 0, i32 2, i32 1)
  store i62 %6, i62* %2, align 8, !tbaa !79
  %7 = bitcast i62* %2 to i8*
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %7) #5
  %8 = bitcast i27* %1 to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %8) #5
  ret void
}

; Function Attrs: norecurse nounwind
define linkonce_odr dso_local spir_func void @_Z14ap_float_sinpiILi3ELi6ELi6ELi6EEvv() #3 {
  %1 = alloca i10, align 2
  %2 = alloca i13, align 2
  %3 = bitcast i10* %1 to i8*
  call void @llvm.lifetime.start.p0i8(i64 2, i8* %3) #5
  %4 = bitcast i13* %2 to i8*
  call void @llvm.lifetime.start.p0i8(i64 2, i8* %4) #5
  %5 = load i10, i10* %1, align 2, !tbaa !69
  %6 = call spir_func signext i13 @_Z32__spirv_ArbitraryFloatSinPiINTELILi10ELi13EEU7_ExtIntIXT0_EEiU7_ExtIntIXT_EEiiiiii(i10 signext %5, i32 6, i32 6, i32 0, i32 2, i32 1) #5
; CHECK-SPIRV: 6 Load [[Ty_10]] [[SinPi_AId:[0-9]+]]
; CHECK-SPIRV-NEXT: 9 ArbitraryFloatSinPiINTEL [[Ty_13]] [[#]] [[SinPi_AId]] 6 6 0 2 1
; CHECK-LLVM: call i13 @intel_arbitrary_float_sinpi.i13.i10(i10 %[[#]], i32 6, i32 6, i32 0, i32 2, i32 1)
  store i13 %6, i13* %2, align 2, !tbaa !19
  %7 = bitcast i13* %2 to i8*
  call void @llvm.lifetime.end.p0i8(i64 2, i8* %7) #5
  %8 = bitcast i10* %1 to i8*
  call void @llvm.lifetime.end.p0i8(i64 2, i8* %8) #5
  ret void
}

; Function Attrs: norecurse nounwind
define linkonce_odr dso_local spir_func void @_Z14ap_float_cospiILi18ELi40ELi18ELi40EEvv() #3 {
  %1 = alloca i59, align 8
  %2 = alloca i59, align 8
  %3 = bitcast i59* %1 to i8*
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %3) #5
  %4 = bitcast i59* %2 to i8*
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %4) #5
  %5 = load i59, i59* %1, align 8, !tbaa !85
  %6 = call spir_func i59 @_Z32__spirv_ArbitraryFloatCosPiINTELILi59ELi59EEU7_ExtIntIXT0_EEiU7_ExtIntIXT_EEiiiiii(i59 %5, i32 40, i32 40, i32 0, i32 2, i32 1) #5
; CHECK-SPIRV: 6 Load [[Ty_59]] [[CosPi_AId:[0-9]+]]
; CHECK-SPIRV-NEXT: 9 ArbitraryFloatCosPiINTEL [[Ty_59]] [[#]] [[CosPi_AId]] 40 40 0 2 1
; CHECK-LLVM: call i59 @intel_arbitrary_float_cospi.i59.i59(i59 %[[#]], i32 40, i32 40, i32 0, i32 2, i32 1)
  store i59 %6, i59* %2, align 8, !tbaa !85
  %7 = bitcast i59* %2 to i8*
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %7) #5
  %8 = bitcast i59* %1 to i8*
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %8) #5
  ret void
}

; Function Attrs: norecurse nounwind
define linkonce_odr dso_local spir_func void @_Z17ap_float_sincospiILi9ELi20ELi11ELi20EEvv() #3 {
  %1 = alloca i30, align 4
  %2 = alloca i64, align 8
  %3 = bitcast i30* %1 to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %3) #5
  %4 = bitcast i64* %2 to i8*
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %4) #5
  %5 = load i30, i30* %1, align 4, !tbaa !17
  %6 = call spir_func i64 @_Z35__spirv_ArbitraryFloatSinCosPiINTELILi30ELi32EEU7_ExtIntIXmlLi2ET0_EEiU7_ExtIntIXT_EEiiiiii(i30 signext %5, i32 20, i32 20, i32 0, i32 2, i32 1) #5
; CHECK-SPIRV: 6 Load [[Ty_30]] [[SinCosPi_AId:[0-9]+]]
; CHECK-SPIRV-NEXT: 9 ArbitraryFloatSinCosPiINTEL [[Ty_64]] [[#]] [[SinCosPi_AId]] 20 20 0 2 1
; CHECK-LLVM: call i64 @intel_arbitrary_float_sincospi.i64.i30(i30 %[[#]], i32 20, i32 20, i32 0, i32 2, i32 1)
  store i64 %6, i64* %2, align 8, !tbaa !77
  %7 = bitcast i64* %2 to i8*
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %7) #5
  %8 = bitcast i30* %1 to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %8) #5
  ret void
}

; Function Attrs: norecurse nounwind
define linkonce_odr dso_local spir_func void @_Z13ap_float_asinILi2ELi4ELi2ELi8EEvv() #3 {
  %1 = alloca i7, align 1
  %2 = alloca i11, align 2
  %3 = bitcast i7* %1 to i8*
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %3) #5
  %4 = bitcast i11* %2 to i8*
  call void @llvm.lifetime.start.p0i8(i64 2, i8* %4) #5
  %5 = load i7, i7* %1, align 1, !tbaa !43
  %6 = call spir_func signext i11 @_Z31__spirv_ArbitraryFloatASinINTELILi7ELi11EEU7_ExtIntIXT0_EEiU7_ExtIntIXT_EEiiiiii(i7 signext %5, i32 4, i32 8, i32 0, i32 2, i32 1) #5
; CHECK-SPIRV: 6 Load [[Ty_7]] [[ASin_AId:[0-9]+]]
; CHECK-SPIRV-NEXT: 9 ArbitraryFloatASinINTEL [[Ty_11]] [[#]] [[ASin_AId]] 4 8 0 2 1
; CHECK-LLVM: call i11 @intel_arbitrary_float_asin.i11.i7(i7 %[[#]], i32 4, i32 8, i32 0, i32 2, i32 1)
  store i11 %6, i11* %2, align 2, !tbaa !27
  %7 = bitcast i11* %2 to i8*
  call void @llvm.lifetime.end.p0i8(i64 2, i8* %7) #5
  %8 = bitcast i7* %1 to i8*
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %8) #5
  ret void
}

; Function Attrs: norecurse nounwind
define linkonce_odr dso_local spir_func void @_Z15ap_float_asinpiILi11ELi23ELi11ELi23EEvv() #3 {
  %1 = alloca i35, align 8
  %2 = alloca i35, align 8
  %3 = bitcast i35* %1 to i8*
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %3) #5
  %4 = bitcast i35* %2 to i8*
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %4) #5
  %5 = load i35, i35* %1, align 8, !tbaa !87
  %6 = call spir_func i35 @_Z33__spirv_ArbitraryFloatASinPiINTELILi35ELi35EEU7_ExtIntIXT0_EEiU7_ExtIntIXT_EEiiiiii(i35 %5, i32 23, i32 23, i32 0, i32 2, i32 1) #5
; CHECK-SPIRV: 6 Load [[Ty_35]] [[ASinPi_AId:[0-9]+]]
; CHECK-SPIRV-NEXT: 9 ArbitraryFloatASinPiINTEL [[Ty_35]] [[#]] [[ASinPi_AId]] 23 23 0 2 1
; CHECK-LLVM: call i35 @intel_arbitrary_float_asinpi.i35.i35(i35 %[[#]], i32 23, i32 23, i32 0, i32 2, i32 1)
  store i35 %6, i35* %2, align 8, !tbaa !87
  %7 = bitcast i35* %2 to i8*
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %7) #5
  %8 = bitcast i35* %1 to i8*
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %8) #5
  ret void
}

; Function Attrs: norecurse nounwind
define linkonce_odr dso_local spir_func void @_Z13ap_float_acosILi4ELi9ELi3ELi10EEvv() #3 {
  %1 = alloca i14, align 2
  %2 = alloca i14, align 2
  %3 = bitcast i14* %1 to i8*
  call void @llvm.lifetime.start.p0i8(i64 2, i8* %3) #5
  %4 = bitcast i14* %2 to i8*
  call void @llvm.lifetime.start.p0i8(i64 2, i8* %4) #5
  %5 = load i14, i14* %1, align 2, !tbaa !23
  %6 = call spir_func signext i14 @_Z31__spirv_ArbitraryFloatACosINTELILi14ELi14EEU7_ExtIntIXT0_EEiU7_ExtIntIXT_EEiiiiii(i14 signext %5, i32 9, i32 10, i32 0, i32 2, i32 1) #5
; CHECK-SPIRV: 6 Load [[Ty_14]] [[ACos_AId:[0-9]+]]
; CHECK-SPIRV-NEXT: 9 ArbitraryFloatACosINTEL [[Ty_14]] [[#]] [[ACos_AId]] 9 10 0 2 1
; CHECK-LLVM: call i14 @intel_arbitrary_float_acos.i14.i14(i14 %[[#]], i32 9, i32 10, i32 0, i32 2, i32 1)
  store i14 %6, i14* %2, align 2, !tbaa !23
  %7 = bitcast i14* %2 to i8*
  call void @llvm.lifetime.end.p0i8(i64 2, i8* %7) #5
  %8 = bitcast i14* %1 to i8*
  call void @llvm.lifetime.end.p0i8(i64 2, i8* %8) #5
  ret void
}

; Function Attrs: norecurse nounwind
define linkonce_odr dso_local spir_func void @_Z15ap_float_acospiILi2ELi5ELi3ELi4EEvv() #3 {
  %1 = alloca i8, align 1
  %2 = alloca i8, align 1
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %1) #5
  call void @llvm.lifetime.start.p0i8(i64 1, i8* %2) #5
  %3 = load i8, i8* %1, align 1, !tbaa !67
  %4 = call spir_func signext i8 @_Z33__spirv_ArbitraryFloatACosPiINTELILi8ELi8EEU7_ExtIntIXT0_EEiU7_ExtIntIXT_EEiiiiii(i8 signext %3, i32 5, i32 4, i32 0, i32 2, i32 1) #5
; CHECK-SPIRV: 6 Load [[Ty_8]] [[ACosPi_AId:[0-9]+]]
; CHECK-SPIRV-NEXT: 9 ArbitraryFloatACosPiINTEL [[Ty_8]] [[#]] [[ACosPi_AId]] 5 4 0 2 1
; CHECK-LLVM: call i8 @intel_arbitrary_float_acospi.i8.i8(i8 %[[#]], i32 5, i32 4, i32 0, i32 2, i32 1)
  store i8 %4, i8* %2, align 1, !tbaa !67
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %2) #5
  call void @llvm.lifetime.end.p0i8(i64 1, i8* %1) #5
  ret void
}

; Function Attrs: norecurse nounwind
define linkonce_odr dso_local spir_func void @_Z13ap_float_atanILi12ELi31ELi12ELi31EEvv() #3 {
  %1 = alloca i44, align 8
  %2 = alloca i44, align 8
  %3 = bitcast i44* %1 to i8*
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %3) #5
  %4 = bitcast i44* %2 to i8*
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %4) #5
  %5 = load i44, i44* %1, align 8, !tbaa !89
  %6 = call spir_func i44 @_Z31__spirv_ArbitraryFloatATanINTELILi44ELi44EEU7_ExtIntIXT0_EEiU7_ExtIntIXT_EEiiiiii(i44 %5, i32 31, i32 31, i32 0, i32 2, i32 1) #5
; CHECK-SPIRV: 6 Load [[Ty_44]] [[ATan_AId:[0-9]+]]
; CHECK-SPIRV-NEXT: 9 ArbitraryFloatATanINTEL [[Ty_44]] [[#]] [[ATan_AId]] 31 31 0 2 1
; CHECK-LLVM: call i44 @intel_arbitrary_float_atan.i44.i44(i44 %[[#]], i32 31, i32 31, i32 0, i32 2, i32 1)
  store i44 %6, i44* %2, align 8, !tbaa !89
  %7 = bitcast i44* %2 to i8*
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %7) #5
  %8 = bitcast i44* %1 to i8*
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %8) #5
  ret void
}

; Function Attrs: norecurse nounwind
define linkonce_odr dso_local spir_func void @_Z15ap_float_atanpiILi1ELi38ELi1ELi32EEvv() #3 {
  %1 = alloca i40, align 8
  %2 = alloca i34, align 8
  %3 = bitcast i40* %1 to i8*
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %3) #5
  %4 = bitcast i34* %2 to i8*
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %4) #5
  %5 = load i40, i40* %1, align 8, !tbaa !9
  %6 = call spir_func i34 @_Z33__spirv_ArbitraryFloatATanPiINTELILi40ELi34EEU7_ExtIntIXT0_EEiU7_ExtIntIXT_EEiiiiii(i40 %5, i32 38, i32 32, i32 0, i32 2, i32 1) #5
; CHECK-SPIRV: 6 Load [[Ty_40]] [[ATanPi_AId:[0-9]+]]
; CHECK-SPIRV-NEXT: 9 ArbitraryFloatATanPiINTEL [[Ty_34]] [[#]] [[ATanPi_AId]] 38 32 0 2 1
; CHECK-LLVM: call i34 @intel_arbitrary_float_atanpi.i34.i40(i40 %[[#]], i32 38, i32 32, i32 0, i32 2, i32 1)
  store i34 %6, i34* %2, align 8, !tbaa !53
  %7 = bitcast i34* %2 to i8*
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %7) #5
  %8 = bitcast i40* %1 to i8*
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %8) #5
  ret void
}

; Function Attrs: norecurse nounwind
define linkonce_odr dso_local spir_func void @_Z14ap_float_atan2ILi7ELi16ELi7ELi17ELi8ELi18EEvv() #3 {
  %1 = alloca i24, align 4
  %2 = alloca i25, align 4
  %3 = alloca i27, align 4
  %4 = bitcast i24* %1 to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %4) #5
  %5 = bitcast i25* %2 to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %5) #5
  %6 = bitcast i27* %3 to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %6) #5
  %7 = load i24, i24* %1, align 4, !tbaa !91
  %8 = load i25, i25* %2, align 4, !tbaa !13
  %9 = call spir_func signext i27 @_Z32__spirv_ArbitraryFloatATan2INTELILi24ELi25ELi27EEU7_ExtIntIXT1_EEiU7_ExtIntIXT_EEiiU7_ExtIntIXT0_EEiiiiii(i24 signext %7, i32 16, i25 signext %8, i32 17, i32 18, i32 0, i32 2, i32 1) #5
; CHECK-SPIRV: 6 Load [[Ty_24]] [[ATan2_AId:[0-9]+]]
; CHECK-SPIRV-NEXT: 6 Load [[Ty_25]] [[ATan2_BId:[0-9]+]]
; CHECK-SPIRV-NEXT: 11 ArbitraryFloatATan2INTEL [[Ty_27]] [[#]] [[ATan2_AId]] 16 [[ATan2_BId]] 17 18 0 2 1
; CHECK-LLVM: call i27 @intel_arbitrary_float_atan2.i27.i24.i25(i24 %[[#]], i32 16, i25 %[[#]], i32 17, i32 18, i32 0, i32 2, i32 1)
  store i27 %9, i27* %3, align 4, !tbaa !83
  %10 = bitcast i27* %3 to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %10) #5
  %11 = bitcast i25* %2 to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %11) #5
  %12 = bitcast i24* %1 to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %12) #5
  ret void
}

; Function Attrs: norecurse nounwind
define linkonce_odr dso_local spir_func void @_Z12ap_float_powILi8ELi8ELi9ELi9ELi10ELi10EEvv() #3 {
  %1 = alloca i17, align 4
  %2 = alloca i19, align 4
  %3 = alloca i21, align 4
  %4 = bitcast i17* %1 to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %4) #5
  %5 = bitcast i19* %2 to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %5) #5
  %6 = bitcast i21* %3 to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %6) #5
  %7 = load i17, i17* %1, align 4, !tbaa !61
  %8 = load i19, i19* %2, align 4, !tbaa !93
  %9 = call spir_func signext i21 @_Z30__spirv_ArbitraryFloatPowINTELILi17ELi19ELi21EEU7_ExtIntIXT1_EEiU7_ExtIntIXT_EEiiU7_ExtIntIXT0_EEiiiiii(i17 signext %7, i32 8, i19 signext %8, i32 9, i32 10, i32 0, i32 2, i32 1) #5
; CHECK-SPIRV: 6 Load [[Ty_17]] [[Pow_AId:[0-9]+]]
; CHECK-SPIRV-NEXT: 6 Load [[Ty_19]] [[Pow_BId:[0-9]+]]
; CHECK-SPIRV-NEXT: 11 ArbitraryFloatPowINTEL [[Ty_21]] [[#]] [[Pow_AId]] 8 [[Pow_BId]] 9 10 0 2 1
; CHECK-LLVM: call i21 @intel_arbitrary_float_pow.i21.i17.i19(i17 %[[#]], i32 8, i19 %[[#]], i32 9, i32 10, i32 0, i32 2, i32 1)
  store i21 %9, i21* %3, align 4, !tbaa !95
  %10 = bitcast i21* %3 to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %10) #5
  %11 = bitcast i19* %2 to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %11) #5
  %12 = bitcast i17* %1 to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %12) #5
  ret void
}

; Function Attrs: norecurse nounwind
define linkonce_odr dso_local spir_func void @_Z13ap_float_powrILi18ELi35ELi19ELi35ELi20ELi35EEvv() #3 {
  %1 = alloca i54, align 8
  %2 = alloca i55, align 8
  %3 = alloca i56, align 8
  %4 = bitcast i54* %1 to i8*
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %4) #5
  %5 = bitcast i55* %2 to i8*
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %5) #5
  %6 = bitcast i56* %3 to i8*
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %6) #5
  %7 = load i54, i54* %1, align 8, !tbaa !97
  %8 = load i55, i55* %2, align 8, !tbaa !45
  %9 = call spir_func i56 @_Z31__spirv_ArbitraryFloatPowRINTELILi54ELi55ELi56EEU7_ExtIntIXT1_EEiU7_ExtIntIXT_EEiiU7_ExtIntIXT0_EEiiiiii(i54 %7, i32 35, i55 %8, i32 35, i32 35, i32 0, i32 2, i32 1) #5
; CHECK-SPIRV: 6 Load [[Ty_54]] [[PowR_AId:[0-9]+]]
; CHECK-SPIRV-NEXT: 6 Load [[Ty_55]] [[PowR_BId:[0-9]+]]
; CHECK-SPIRV-NEXT: 11 ArbitraryFloatPowRINTEL [[Ty_56]] [[#]] [[PowR_AId]] 35 [[PowR_BId]] 35 35 0 2 1
; CHECK-LLVM: call i56 @intel_arbitrary_float_powr.i56.i54.i55(i54 %[[#]], i32 35, i55 %[[#]], i32 35, i32 35, i32 0, i32 2, i32 1)
  store i56 %9, i56* %3, align 8, !tbaa !99
  %10 = bitcast i56* %3 to i8*
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %10) #5
  %11 = bitcast i55* %2 to i8*
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %11) #5
  %12 = bitcast i54* %1 to i8*
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %12) #5
  ret void
}

; Function Attrs: norecurse nounwind
define linkonce_odr dso_local spir_func void @_Z13ap_float_pownILi4ELi7ELi10ELi5ELi9EEvv() #3 {
  %1 = alloca i12, align 2
  %2 = alloca i10, align 2
  %3 = alloca i15, align 2
  %4 = bitcast i12* %1 to i8*
  call void @llvm.lifetime.start.p0i8(i64 2, i8* %4) #5
  %5 = bitcast i10* %2 to i8*
  call void @llvm.lifetime.start.p0i8(i64 2, i8* %5) #5
  %6 = bitcast i15* %3 to i8*
  call void @llvm.lifetime.start.p0i8(i64 2, i8* %6) #5
  %7 = load i12, i12* %1, align 2, !tbaa !101
  %8 = load i10, i10* %2, align 2, !tbaa !69
  %9 = call spir_func signext i15 @_Z31__spirv_ArbitraryFloatPowNINTELILi12ELi10ELi15EEU7_ExtIntIXT1_EEiU7_ExtIntIXT_EEiiU7_ExtIntIXT0_EEiiiii(i12 signext %7, i32 7, i10 signext %8, i1 zeroext false, i32 9, i32 0, i32 2, i32 1) #5
; CHECK-SPIRV: 6 Load [[Ty_12]] [[PowN_AId:[0-9]+]]
; CHECK-SPIRV-NEXT: 6 Load [[Ty_10]] [[PowN_BId:[0-9]+]]
; CHECK-SPIRV-NEXT: 11 ArbitraryFloatPowNINTEL [[Ty_15]] [[#]] [[PowN_AId]] 7 [[PowN_BId]] 0 9 0 2 1
; CHECK-LLVM: call i15 @intel_arbitrary_float_pown.i15.i12.i10(i12 %[[#]], i32 7, i10 %[[#]], i1 false, i32 9, i32 0, i32 2, i32 1)
  store i15 %9, i15* %3, align 2, !tbaa !21
  %10 = bitcast i15* %3 to i8*
  call void @llvm.lifetime.end.p0i8(i64 2, i8* %10) #5
  %11 = bitcast i10* %2 to i8*
  call void @llvm.lifetime.end.p0i8(i64 2, i8* %11) #5
  %12 = bitcast i12* %1 to i8*
  call void @llvm.lifetime.end.p0i8(i64 2, i8* %12) #5
  ret void
}

; Function Attrs: norecurse nounwind
define linkonce_odr dso_local spir_func void @_Z15ap_float_sincosILi8ELi18ELi10ELi20EEvv_() #3 {
  %1 = alloca i34, align 8
  %2 = addrspacecast i34* %1 to i34 addrspace(4)*
  %3 = alloca i66, align 8
  %4 = addrspacecast i66* %3 to i66 addrspace(4)*
  %5 = bitcast i34* %1 to i8*
  call void @llvm.lifetime.start.p0i8(i64 8, i8* %5)
  %6 = bitcast i66* %3 to i8*
  call void @llvm.lifetime.start.p0i8(i64 16, i8* %6)
  %7 = load i34, i34 addrspace(4)* %2, align 8
  call spir_func void @_Z33__spirv_ArbitraryFloatSinCosINTELILi34ELi66EEU7_ExtIntIXmlLi2ET0_EEiU7_ExtIntIXT_EEiiiiii(i66 addrspace(4)* sret(i66) align 8 %4, i34 %7, i32 18, i32 20, i32 0, i32 2, i32 1) #5
; CHECK-SPIRV: 6 Load [[Ty_34]] [[SinCos_AId:[0-9]+]]
; CHECK-SPIRV-NEXT: 9 ArbitraryFloatSinCosINTEL [[Ty_66]] [[SinCos_ResultId:[0-9]+]] [[SinCos_AId]] 18 20 0 2 1
; CHECK-SPIRV: 3 Store [[#]] [[SinCos_ResultId]]
; CHECK-LLVM: call void @intel_arbitrary_float_sincos.i66.i34(i66 addrspace(4)* sret(i66) %[[#]], i34 %[[#]], i32 18, i32 20, i32 0, i32 2, i32 1)
  %8 = load i66, i66 addrspace(4)* %4, align 8
  store i66 %8, i66 addrspace(4)* %4, align 8
  %9 = bitcast i34* %1 to i8*
  call void @llvm.lifetime.end.p0i8(i64 8, i8* %9)
  %10 = bitcast i66* %3 to i8*
  call void @llvm.lifetime.end.p0i8(i64 16, i8* %10)
  ret void
}

; Function Attrs: norecurse nounwind
define linkonce_odr dso_local spir_func void @_Z14ap_float_atan2ILi7ELi16ELi7ELi17ELi8ELi18EEvv_() #3 {
  %1 = alloca i24, align 4
  %2 = alloca i25, align 4
  %3 = alloca i66, align 8
  %4 = addrspacecast i66* %3 to i66 addrspace(4)*
  %5 = bitcast i24* %1 to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %5) #5
  %6 = bitcast i25* %2 to i8*
  call void @llvm.lifetime.start.p0i8(i64 4, i8* %6) #5
  %7 = bitcast i66* %3 to i8*
  call void @llvm.lifetime.start.p0i8(i64 16, i8* %7) #5
  %8 = load i24, i24* %1, align 4, !tbaa !91
  %9 = load i25, i25* %2, align 4, !tbaa !13
  call spir_func void @_Z32__spirv_ArbitraryFloatATan2INTELILi24ELi25ELi66EEU7_ExtIntIXT1_EEiU7_ExtIntIXT_EEiiU7_ExtIntIXT0_EEiiiiii(i66 addrspace(4)* sret(i66) align 8 %4, i24 signext %8, i32 16, i25 signext %9, i32 17, i32 18, i32 0, i32 2, i32 1) #5
; CHECK-SPIRV: 6 Load [[Ty_24]] [[ATan2_AId:[0-9]+]]
; CHECK-SPIRV-NEXT: 6 Load [[Ty_25]] [[ATan2_BId:[0-9]+]]
; CHECK-SPIRV-NEXT: 11 ArbitraryFloatATan2INTEL [[Ty_66]] [[ATan2_ResultId:[0-9]+]] [[ATan2_AId]] 16 [[ATan2_BId]] 17 18 0 2 1
; CHECK-SPIRV: 3 Store [[#]] [[ATan2_ResultId]]
; CHECK-LLVM: call void @intel_arbitrary_float_atan2.i66.i24.i25(i66 addrspace(4)* sret(i66) %[[#]], i24 %[[#]], i32 16, i25 %[[#]], i32 17, i32 18, i32 0, i32 2, i32 1)
  %10 = load i66, i66 addrspace(4)* %4, align 8
  store i66 %10, i66 addrspace(4)* %4, align 8
  %11 = bitcast i66* %3 to i8*
  call void @llvm.lifetime.end.p0i8(i64 16, i8* %11) #5
  %12 = bitcast i25* %2 to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %12) #5
  %13 = bitcast i24* %1 to i8*
  call void @llvm.lifetime.end.p0i8(i64 4, i8* %13) #5
  ret void
}

; Function Attrs: norecurse nounwind
define linkonce_odr dso_local spir_func void @_Z13ap_float_pownILi64ELi7ELi10ELi5ELi9EEvv() #3 {
entry:
  %A = alloca i72, align 8
  %A.ascast = addrspacecast i72* %A to i72 addrspace(4)*
  %B = alloca i10, align 2
  %B.ascast = addrspacecast i10* %B to i10 addrspace(4)*
  %pown_res = alloca i15, align 2
  %pown_res.ascast = addrspacecast i15* %pown_res to i15 addrspace(4)*
  %indirect-arg-temp = alloca i72, align 8
  %0 = bitcast i72* %A to i8*
  call void @llvm.lifetime.start.p0i8(i64 16, i8* %0) #5
  %1 = bitcast i10* %B to i8*
  call void @llvm.lifetime.start.p0i8(i64 2, i8* %1) #5
  %2 = bitcast i15* %pown_res to i8*
  call void @llvm.lifetime.start.p0i8(i64 2, i8* %2) #5
  %3 = load i72, i72 addrspace(4)* %A.ascast, align 8
  %4 = load i10, i10 addrspace(4)* %B.ascast, align 2
  store i72 %3, i72* %indirect-arg-temp, align 8
; CHECK-SPIRV: 6 Load [[Ty_72]] [[ResAId:[0-9]+]]
; CHECK-SPIRV-NEXT: 6 Load [[Ty_10]] [[PowN_BId:[0-9]+]]
; CHECK-SPIRV-NEXT: 5 Store [[PtrId:[0-9]+]] [[ResAId]]
; CHECK-SPIRV-NEXT: 4 Load [[Ty_72]] [[PowN_AId:[0-9]+]]
; CHECK-SPIRV-NEXT: 11 ArbitraryFloatPowNINTEL [[Ty_15]] [[#]] [[PowN_AId]] 7 [[PowN_BId]] 1 9 0 2 1
; CHECK-LLVM: call i15 @intel_arbitrary_float_pown.i15.i72.i10(i72 %[[#]], i32 7, i10 %[[#]], i1 true, i32 9, i32 0, i32 2, i32 1)
  %call = call spir_func signext i15 @_Z31__spirv_ArbitraryFloatPowNINTELILi72ELi10ELi15EEU7_ExtIntIXT1_EEiU7_ExtIntIXT_EEiiU7_ExtIntIXT0_EEiiiii(i72* byval(i72) align 8 %indirect-arg-temp, i32 7, i10 signext %4, i1 zeroext true, i32 9, i32 0, i32 2, i32 1) #4
  store i15 %call, i15 addrspace(4)* %pown_res.ascast, align 2
  %5 = bitcast i15* %pown_res to i8*
  call void @llvm.lifetime.end.p0i8(i64 2, i8* %5) #5
  %6 = bitcast i10* %B to i8*
  call void @llvm.lifetime.end.p0i8(i64 2, i8* %6) #5
  %7 = bitcast i72* %A to i8*
  call void @llvm.lifetime.end.p0i8(i64 16, i8* %7) #5
  ret void
}

; Function Attrs: nounwind
declare dso_local spir_func i40 @_Z31__spirv_ArbitraryFloatCastINTELILi40ELi40EEU7_ExtIntIXT0_EEiU7_ExtIntIXT_EEiiiiii(i40, i32, i32, i32, i32, i32) #4

; Function Attrs: nounwind
declare dso_local spir_func signext i25 @_Z38__spirv_ArbitraryFloatCastFromIntINTELILi43ELi25EEU7_ExtIntIXT0_EEiU7_ExtIntIXT_EEiibiii(i43, i32, i1 zeroext, i32, i32, i32) #4

; Function Attrs: nounwind
declare dso_local spir_func signext i30 @_Z36__spirv_ArbitraryFloatCastToIntINTELILi23ELi30EEU7_ExtIntIXT0_EEiU7_ExtIntIXT_EEiibiii(i23 signext, i32, i1 zeroext, i32, i32, i32) #4

; Function Attrs: nounwind
declare dso_local spir_func signext i14 @_Z30__spirv_ArbitraryFloatAddINTELILi13ELi15ELi14EEU7_ExtIntIXT1_EEiU7_ExtIntIXT_EEiiU7_ExtIntIXT0_EEiiiiii(i13 signext, i32, i15 signext, i32, i32, i32, i32, i32) #4

; Function Attrs: nounwind
declare dso_local spir_func signext i13 @_Z30__spirv_ArbitraryFloatAddINTELILi15ELi14ELi13EEU7_ExtIntIXT1_EEiU7_ExtIntIXT_EEiiU7_ExtIntIXT0_EEiiiiii(i15 signext, i32, i14 signext, i32, i32, i32, i32, i32) #4

; Function Attrs: nounwind
declare dso_local spir_func signext i13 @_Z30__spirv_ArbitraryFloatSubINTELILi9ELi11ELi13EEU7_ExtIntIXT1_EEiU7_ExtIntIXT_EEiiU7_ExtIntIXT0_EEiiiiii(i9 signext, i32, i11 signext, i32, i32, i32, i32, i32) #4

; Function Attrs: nounwind
declare dso_local spir_func i51 @_Z30__spirv_ArbitraryFloatMulINTELILi51ELi51ELi51EEU7_ExtIntIXT1_EEiU7_ExtIntIXT_EEiiU7_ExtIntIXT0_EEiiiiii(i51, i32, i51, i32, i32, i32, i32, i32) #4

; Function Attrs: nounwind
declare dso_local spir_func signext i18 @_Z30__spirv_ArbitraryFloatDivINTELILi16ELi16ELi18EEU7_ExtIntIXT1_EEiU7_ExtIntIXT_EEiiU7_ExtIntIXT0_EEiiiiii(i16 signext, i32, i16 signext, i32, i32, i32, i32, i32) #4

; Function Attrs: nounwind
declare dso_local spir_func zeroext i1 @_Z29__spirv_ArbitraryFloatGTINTELILi63ELi63EEbU7_ExtIntIXT_EEiiU7_ExtIntIXT0_EEii(i63, i32, i63, i32) #4

; Function Attrs: nounwind
declare dso_local spir_func zeroext i1 @_Z29__spirv_ArbitraryFloatGEINTELILi47ELi47EEbU7_ExtIntIXT_EEiiU7_ExtIntIXT0_EEii(i47, i32, i47, i32) #4

; Function Attrs: nounwind
declare dso_local spir_func zeroext i1 @_Z29__spirv_ArbitraryFloatLTINTELILi5ELi7EEbU7_ExtIntIXT_EEiiU7_ExtIntIXT0_EEii(i5 signext, i32, i7 signext, i32) #4

; Function Attrs: nounwind
declare dso_local spir_func zeroext i1 @_Z29__spirv_ArbitraryFloatLEINTELILi55ELi55EEbU7_ExtIntIXT_EEiiU7_ExtIntIXT0_EEii(i55, i32, i55, i32) #4

; Function Attrs: nounwind
declare dso_local spir_func zeroext i1 @_Z29__spirv_ArbitraryFloatEQINTELILi20ELi15EEbU7_ExtIntIXT_EEiiU7_ExtIntIXT0_EEii(i20 signext, i32, i15 signext, i32) #4

; Function Attrs: nounwind
declare dso_local spir_func i39 @_Z32__spirv_ArbitraryFloatRecipINTELILi39ELi39EEU7_ExtIntIXT0_EEiU7_ExtIntIXT_EEiiiiii(i39, i32, i32, i32, i32, i32) #4

; Function Attrs: nounwind
declare dso_local spir_func i34 @_Z32__spirv_ArbitraryFloatRSqrtINTELILi32ELi34EEU7_ExtIntIXT0_EEiU7_ExtIntIXT_EEiiiiii(i32, i32, i32, i32, i32, i32) #4

; Function Attrs: nounwind
declare dso_local spir_func signext i2 @_Z31__spirv_ArbitraryFloatCbrtINTELILi2ELi2EEU7_ExtIntIXT0_EEiU7_ExtIntIXT_EEiiiiii(i2 signext, i32, i32, i32, i32, i32) #4

; Function Attrs: nounwind
declare dso_local spir_func i42 @_Z32__spirv_ArbitraryFloatHypotINTELILi41ELi43ELi42EEU7_ExtIntIXT1_EEiU7_ExtIntIXT_EEiiU7_ExtIntIXT0_EEiiiiii(i41, i32, i43, i32, i32, i32, i32, i32) #4

; Function Attrs: nounwind
declare dso_local spir_func signext i17 @_Z31__spirv_ArbitraryFloatSqrtINTELILi15ELi17EEU7_ExtIntIXT0_EEiU7_ExtIntIXT_EEiiiiii(i15 signext, i32, i32, i32, i32, i32) #4

; Function Attrs: nounwind
declare dso_local spir_func i50 @_Z30__spirv_ArbitraryFloatLogINTELILi50ELi50EEU7_ExtIntIXT0_EEiU7_ExtIntIXT_EEiiiiii(i50, i32, i32, i32, i32, i32) #4

; Function Attrs: nounwind
declare dso_local spir_func i38 @_Z31__spirv_ArbitraryFloatLog2INTELILi38ELi38EEU7_ExtIntIXT0_EEiU7_ExtIntIXT_EEiiiiii(i38, i32, i32, i32, i32, i32) #4

; Function Attrs: nounwind
declare dso_local spir_func signext i10 @_Z32__spirv_ArbitraryFloatLog10INTELILi8ELi10EEU7_ExtIntIXT0_EEiU7_ExtIntIXT_EEiiiiii(i8 signext, i32, i32, i32, i32, i32) #4

; Function Attrs: nounwind
declare dso_local spir_func i49 @_Z32__spirv_ArbitraryFloatLog1pINTELILi48ELi49EEU7_ExtIntIXT0_EEiU7_ExtIntIXT_EEiiiiii(i48, i32, i32, i32, i32, i32) #4

; Function Attrs: nounwind
declare dso_local spir_func i42 @_Z30__spirv_ArbitraryFloatExpINTELILi42ELi42EEU7_ExtIntIXT0_EEiU7_ExtIntIXT_EEiiiiii(i42, i32, i32, i32, i32, i32) #4

; Function Attrs: nounwind
declare dso_local spir_func signext i5 @_Z31__spirv_ArbitraryFloatExp2INTELILi3ELi5EEU7_ExtIntIXT0_EEiU7_ExtIntIXT_EEiiiiii(i3 signext, i32, i32, i32, i32, i32) #4

; Function Attrs: nounwind
declare dso_local spir_func signext i25 @_Z32__spirv_ArbitraryFloatExp10INTELILi25ELi25EEU7_ExtIntIXT0_EEiU7_ExtIntIXT_EEiiiiii(i25 signext, i32, i32, i32, i32, i32) #4

; Function Attrs: nounwind
declare dso_local spir_func i62 @_Z32__spirv_ArbitraryFloatExpm1INTELILi64ELi62EEU7_ExtIntIXT0_EEiU7_ExtIntIXT_EEiiiiii(i64, i32, i32, i32, i32, i32) #4

; Function Attrs: nounwind
declare dso_local spir_func i34 @_Z30__spirv_ArbitraryFloatSinINTELILi30ELi34EEU7_ExtIntIXT0_EEiU7_ExtIntIXT_EEiiiiii(i30 signext, i32, i32, i32, i32, i32) #4

; Function Attrs: nounwind
declare dso_local spir_func signext i4 @_Z30__spirv_ArbitraryFloatCosINTELILi4ELi4EEU7_ExtIntIXT0_EEiU7_ExtIntIXT_EEiiiiii(i4 signext, i32, i32, i32, i32, i32) #4

; Function Attrs: nounwind
declare dso_local spir_func i62 @_Z33__spirv_ArbitraryFloatSinCosINTELILi27ELi31EEU7_ExtIntIXmlLi2ET0_EEiU7_ExtIntIXT_EEiiiiii(i27 signext, i32, i32, i32, i32, i32) #4

; Function Attrs: nounwind
declare dso_local spir_func signext i13 @_Z32__spirv_ArbitraryFloatSinPiINTELILi10ELi13EEU7_ExtIntIXT0_EEiU7_ExtIntIXT_EEiiiiii(i10 signext, i32, i32, i32, i32, i32) #4

; Function Attrs: nounwind
declare dso_local spir_func i59 @_Z32__spirv_ArbitraryFloatCosPiINTELILi59ELi59EEU7_ExtIntIXT0_EEiU7_ExtIntIXT_EEiiiiii(i59, i32, i32, i32, i32, i32) #4

; Function Attrs: nounwind
declare dso_local spir_func i64 @_Z35__spirv_ArbitraryFloatSinCosPiINTELILi30ELi32EEU7_ExtIntIXmlLi2ET0_EEiU7_ExtIntIXT_EEiiiiii(i30 signext, i32, i32, i32, i32, i32) #4

; Function Attrs: nounwind
declare dso_local spir_func signext i11 @_Z31__spirv_ArbitraryFloatASinINTELILi7ELi11EEU7_ExtIntIXT0_EEiU7_ExtIntIXT_EEiiiiii(i7 signext, i32, i32, i32, i32, i32) #4

; Function Attrs: nounwind
declare dso_local spir_func i35 @_Z33__spirv_ArbitraryFloatASinPiINTELILi35ELi35EEU7_ExtIntIXT0_EEiU7_ExtIntIXT_EEiiiiii(i35, i32, i32, i32, i32, i32) #4

; Function Attrs: nounwind
declare dso_local spir_func signext i14 @_Z31__spirv_ArbitraryFloatACosINTELILi14ELi14EEU7_ExtIntIXT0_EEiU7_ExtIntIXT_EEiiiiii(i14 signext, i32, i32, i32, i32, i32) #4

; Function Attrs: nounwind
declare dso_local spir_func signext i8 @_Z33__spirv_ArbitraryFloatACosPiINTELILi8ELi8EEU7_ExtIntIXT0_EEiU7_ExtIntIXT_EEiiiiii(i8 signext, i32, i32, i32, i32, i32) #4

; Function Attrs: nounwind
declare dso_local spir_func i44 @_Z31__spirv_ArbitraryFloatATanINTELILi44ELi44EEU7_ExtIntIXT0_EEiU7_ExtIntIXT_EEiiiiii(i44, i32, i32, i32, i32, i32) #4

; Function Attrs: nounwind
declare dso_local spir_func i34 @_Z33__spirv_ArbitraryFloatATanPiINTELILi40ELi34EEU7_ExtIntIXT0_EEiU7_ExtIntIXT_EEiiiiii(i40, i32, i32, i32, i32, i32) #4

; Function Attrs: nounwind
declare dso_local spir_func signext i27 @_Z32__spirv_ArbitraryFloatATan2INTELILi24ELi25ELi27EEU7_ExtIntIXT1_EEiU7_ExtIntIXT_EEiiU7_ExtIntIXT0_EEiiiiii(i24 signext, i32, i25 signext, i32, i32, i32, i32, i32) #4

; Function Attrs: nounwind
declare dso_local spir_func signext i21 @_Z30__spirv_ArbitraryFloatPowINTELILi17ELi19ELi21EEU7_ExtIntIXT1_EEiU7_ExtIntIXT_EEiiU7_ExtIntIXT0_EEiiiiii(i17 signext, i32, i19 signext, i32, i32, i32, i32, i32) #4

; Function Attrs: nounwind
declare dso_local spir_func i56 @_Z31__spirv_ArbitraryFloatPowRINTELILi54ELi55ELi56EEU7_ExtIntIXT1_EEiU7_ExtIntIXT_EEiiU7_ExtIntIXT0_EEiiiiii(i54, i32, i55, i32, i32, i32, i32, i32) #4

; Function Attrs: nounwind
declare dso_local spir_func signext i15 @_Z31__spirv_ArbitraryFloatPowNINTELILi12ELi10ELi15EEU7_ExtIntIXT1_EEiU7_ExtIntIXT_EEiiU7_ExtIntIXT0_EEiiiii(i12 signext, i32, i10 signext, i1 zeroext, i32, i32, i32, i32) #4

; Function Attrs: nounwind
declare dso_local spir_func void @_Z33__spirv_ArbitraryFloatSinCosINTELILi34ELi66EEU7_ExtIntIXmlLi2ET0_EEiU7_ExtIntIXT_EEiiiiii(i66 addrspace(4)* sret(i66) align 8, i34, i32, i32, i32, i32, i32) #4

; Function Attrs: nounwind
declare dso_local spir_func void @_Z32__spirv_ArbitraryFloatATan2INTELILi24ELi25ELi66EEU7_ExtIntIXT1_EEiU7_ExtIntIXT_EEiiU7_ExtIntIXT0_EEiiiiii(i66 addrspace(4)* sret(i66) align 8, i24 signext, i32, i25 signext, i32, i32, i32, i32, i32) #4

; Function Attrs: nounwind
declare dso_local spir_func signext i15 @_Z31__spirv_ArbitraryFloatPowNINTELILi72ELi10ELi15EEU7_ExtIntIXT1_EEiU7_ExtIntIXT_EEiiU7_ExtIntIXT0_EEiiiii(i72* byval(i72) align 8, i32, i10 signext, i1 zeroext, i32, i32, i32, i32) #4

attributes #0 = { norecurse "correctly-rounded-divide-sqrt-fp-math"="false" "disable-tail-calls"="false" "frame-pointer"="all" "less-precise-fpmad"="false" "min-legal-vector-width"="0" "no-infs-fp-math"="false" "no-jump-tables"="false" "no-nans-fp-math"="false" "no-signed-zeros-fp-math"="false" "no-trapping-math"="true" "stack-protector-buffer-size"="8" "uniform-work-group-size"="true" "unsafe-fp-math"="false" "use-soft-float"="false" }
attributes #1 = { argmemonly nounwind willreturn }
attributes #2 = { inlinehint norecurse "correctly-rounded-divide-sqrt-fp-math"="false" "disable-tail-calls"="false" "frame-pointer"="all" "less-precise-fpmad"="false" "min-legal-vector-width"="0" "no-infs-fp-math"="false" "no-jump-tables"="false" "no-nans-fp-math"="false" "no-signed-zeros-fp-math"="false" "no-trapping-math"="true" "stack-protector-buffer-size"="8" "unsafe-fp-math"="false" "use-soft-float"="false" }
attributes #3 = { norecurse nounwind "correctly-rounded-divide-sqrt-fp-math"="false" "disable-tail-calls"="false" "frame-pointer"="all" "less-precise-fpmad"="false" "min-legal-vector-width"="0" "no-infs-fp-math"="false" "no-jump-tables"="false" "no-nans-fp-math"="false" "no-signed-zeros-fp-math"="false" "no-trapping-math"="true" "stack-protector-buffer-size"="8" "unsafe-fp-math"="false" "use-soft-float"="false" }
attributes #4 = { nounwind "correctly-rounded-divide-sqrt-fp-math"="false" "disable-tail-calls"="false" "frame-pointer"="all" "less-precise-fpmad"="false" "no-infs-fp-math"="false" "no-nans-fp-math"="false" "no-signed-zeros-fp-math"="false" "no-trapping-math"="true" "stack-protector-buffer-size"="8" "unsafe-fp-math"="false" "use-soft-float"="false" }
attributes #5 = { nounwind }

!llvm.module.flags = !{!0}
!opencl.spir.version = !{!1}
!spirv.Source = !{!2}
!llvm.ident = !{!3}

!0 = !{i32 1, !"wchar_size", i32 4}
!1 = !{i32 1, i32 2}
!2 = !{i32 4, i32 100000}
!3 = !{!"clang version 11.0.0"}
!4 = !{}
!5 = !{!6, !6, i64 0}
!6 = !{!"any pointer", !7, i64 0}
!7 = !{!"omnipotent char", !8, i64 0}
!8 = !{!"Simple C++ TBAA"}
!9 = !{!10, !10, i64 0}
!10 = !{!"_ExtInt(40)", !7, i64 0}
!11 = !{!12, !12, i64 0}
!12 = !{!"_ExtInt(43)", !7, i64 0}
!13 = !{!14, !14, i64 0}
!14 = !{!"_ExtInt(25)", !7, i64 0}
!15 = !{!16, !16, i64 0}
!16 = !{!"_ExtInt(23)", !7, i64 0}
!17 = !{!18, !18, i64 0}
!18 = !{!"_ExtInt(30)", !7, i64 0}
!19 = !{!20, !20, i64 0}
!20 = !{!"_ExtInt(13)", !7, i64 0}
!21 = !{!22, !22, i64 0}
!22 = !{!"_ExtInt(15)", !7, i64 0}
!23 = !{!24, !24, i64 0}
!24 = !{!"_ExtInt(14)", !7, i64 0}
!25 = !{!26, !26, i64 0}
!26 = !{!"_ExtInt(9)", !7, i64 0}
!27 = !{!28, !28, i64 0}
!28 = !{!"_ExtInt(11)", !7, i64 0}
!29 = !{!30, !30, i64 0}
!30 = !{!"_ExtInt(51)", !7, i64 0}
!31 = !{!32, !32, i64 0}
!32 = !{!"_ExtInt(16)", !7, i64 0}
!33 = !{!34, !34, i64 0}
!34 = !{!"_ExtInt(18)", !7, i64 0}
!35 = !{!36, !36, i64 0}
!36 = !{!"_ExtInt(63)", !7, i64 0}
!37 = !{!38, !38, i64 0}
!38 = !{!"bool", !7, i64 0}
!39 = !{!40, !40, i64 0}
!40 = !{!"_ExtInt(47)", !7, i64 0}
!41 = !{!42, !42, i64 0}
!42 = !{!"_ExtInt(5)", !7, i64 0}
!43 = !{!44, !44, i64 0}
!44 = !{!"_ExtInt(7)", !7, i64 0}
!45 = !{!46, !46, i64 0}
!46 = !{!"_ExtInt(55)", !7, i64 0}
!47 = !{!48, !48, i64 0}
!48 = !{!"_ExtInt(20)", !7, i64 0}
!49 = !{!50, !50, i64 0}
!50 = !{!"_ExtInt(39)", !7, i64 0}
!51 = !{!52, !52, i64 0}
!52 = !{!"_ExtInt(32)", !7, i64 0}
!53 = !{!54, !54, i64 0}
!54 = !{!"_ExtInt(34)", !7, i64 0}
!55 = !{!56, !56, i64 0}
!56 = !{!"_ExtInt(2)", !7, i64 0}
!57 = !{!58, !58, i64 0}
!58 = !{!"_ExtInt(41)", !7, i64 0}
!59 = !{!60, !60, i64 0}
!60 = !{!"_ExtInt(42)", !7, i64 0}
!61 = !{!62, !62, i64 0}
!62 = !{!"_ExtInt(17)", !7, i64 0}
!63 = !{!64, !64, i64 0}
!64 = !{!"_ExtInt(50)", !7, i64 0}
!65 = !{!66, !66, i64 0}
!66 = !{!"_ExtInt(38)", !7, i64 0}
!67 = !{!68, !68, i64 0}
!68 = !{!"_ExtInt(8)", !7, i64 0}
!69 = !{!70, !70, i64 0}
!70 = !{!"_ExtInt(10)", !7, i64 0}
!71 = !{!72, !72, i64 0}
!72 = !{!"_ExtInt(48)", !7, i64 0}
!73 = !{!74, !74, i64 0}
!74 = !{!"_ExtInt(49)", !7, i64 0}
!75 = !{!76, !76, i64 0}
!76 = !{!"_ExtInt(3)", !7, i64 0}
!77 = !{!78, !78, i64 0}
!78 = !{!"_ExtInt(64)", !7, i64 0}
!79 = !{!80, !80, i64 0}
!80 = !{!"_ExtInt(62)", !7, i64 0}
!81 = !{!82, !82, i64 0}
!82 = !{!"_ExtInt(4)", !7, i64 0}
!83 = !{!84, !84, i64 0}
!84 = !{!"_ExtInt(27)", !7, i64 0}
!85 = !{!86, !86, i64 0}
!86 = !{!"_ExtInt(59)", !7, i64 0}
!87 = !{!88, !88, i64 0}
!88 = !{!"_ExtInt(35)", !7, i64 0}
!89 = !{!90, !90, i64 0}
!90 = !{!"_ExtInt(44)", !7, i64 0}
!91 = !{!92, !92, i64 0}
!92 = !{!"_ExtInt(24)", !7, i64 0}
!93 = !{!94, !94, i64 0}
!94 = !{!"_ExtInt(19)", !7, i64 0}
!95 = !{!96, !96, i64 0}
!96 = !{!"_ExtInt(21)", !7, i64 0}
!97 = !{!98, !98, i64 0}
!98 = !{!"_ExtInt(54)", !7, i64 0}
!99 = !{!100, !100, i64 0}
!100 = !{!"_ExtInt(56)", !7, i64 0}
!101 = !{!102, !102, i64 0}
!102 = !{!"_ExtInt(12)", !7, i64 0}
