-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

--Provides routines to support analysis of "files of files"
--------------------------------------------------------------------------------

with E_Strings;
with SPARK_IO;

use type SPARK_IO.File_Status;

--# inherit Ada.Characters.Latin_1,
--#         CommandLineData,
--#         CommandLineHandler,
--#         ErrorHandler,
--#         E_Strings,
--#         FileSystem,
--#         ScreenEcho,
--#         SPARK_IO,
--#         SystemErrors,
--#         XMLReport;

package MetaFile is

   type Meta_Files is private;

   --Meta File Operations

   procedure Create (File_Name     : in     E_Strings.T;
                     The_Meta_File :    out Meta_Files);
   --# global in     CommandLineData.Content;
   --#        in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                CommandLineData.Content,
   --#                                File_Name &
   --#         The_Meta_File     from File_Name,
   --#                                SPARK_IO.File_Sys;

   procedure Next_Name
     (The_Meta_File    : in out Meta_Files;
      The_Filename     :    out E_Strings.T;
      Do_Listing       :    out Boolean;
      The_Listing_Name :    out E_Strings.T;
      Do_VCG           :    out Boolean;
      File_Found       :    out Boolean);
   --# global in     CommandLineData.Content;
   --#        in out ErrorHandler.Error_Context;
   --#        in out SPARK_IO.File_Sys;
   --# derives Do_Listing,
   --#         Do_VCG,
   --#         File_Found,
   --#         SPARK_IO.File_Sys,
   --#         The_Filename,
   --#         The_Listing_Name,
   --#         The_Meta_File              from CommandLineData.Content,
   --#                                         SPARK_IO.File_Sys,
   --#                                         The_Meta_File &
   --#         ErrorHandler.Error_Context from *,
   --#                                         CommandLineData.Content,
   --#                                         SPARK_IO.File_Sys,
   --#                                         The_Meta_File;

   procedure Report_File_Content (To_File        : in     SPARK_IO.File_Type;
                                  Filename       : in     E_Strings.T;
                                  Meta_File_Used : in out Boolean);
   --# global in     CommandLineData.Content;
   --#        in out SPARK_IO.File_Sys;
   --#        in out XMLReport.State;
   --# derives Meta_File_Used    from *,
   --#                                Filename,
   --#                                SPARK_IO.File_Sys &
   --#         SPARK_IO.File_Sys,
   --#         XMLReport.State   from CommandLineData.Content,
   --#                                Filename,
   --#                                Meta_File_Used,
   --#                                SPARK_IO.File_Sys,
   --#                                To_File,
   --#                                XMLReport.State;

private
   Stack_Size : constant := 100;
   type Ptrs is range 0 .. Stack_Size;
   subtype Indexes is Ptrs range 1 .. Stack_Size;

   type Meta_File_Element is record
      File_Handle : SPARK_IO.File_Type;
      Path_Name   : E_Strings.T;
   end record;

   type Vectors is array (Indexes) of Meta_File_Element;

   type Meta_Files is record
      Vector : Vectors;
      Ptr    : Ptrs;
   end record;

end MetaFile;
