/* ResidualVM - A 3D game interpreter
 *
 * ResidualVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the AUTHORS
 * file distributed with this source distribution.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#include "common/scummsys.h"
#include "common/sinewindows.h"

namespace Common {

static const float sineWindow32[32] = {
	0.024541, 0.073565, 0.122411, 0.170962, 0.219101, 0.266713, 0.313682, 0.359895,
	0.405241, 0.449611, 0.492898, 0.534998, 0.575808, 0.615232, 0.653173, 0.689541,
	0.724247, 0.757209, 0.788346, 0.817585, 0.844854, 0.870087, 0.893224, 0.914210,
	0.932993, 0.949528, 0.963776, 0.975702, 0.985278, 0.992480, 0.997290, 0.999699
};

static const float sineWindow64[64] = {
	0.012272, 0.036807, 0.061321, 0.085797, 0.110222, 0.134581, 0.158858, 0.183040,
	0.207111, 0.231058, 0.254866, 0.278520, 0.302006, 0.325310, 0.348419, 0.371317,
	0.393992, 0.416430, 0.438616, 0.460539, 0.482184, 0.503538, 0.524590, 0.545325,
	0.565732, 0.585798, 0.605511, 0.624860, 0.643832, 0.662416, 0.680601, 0.698376,
	0.715731, 0.732654, 0.749136, 0.765167, 0.780737, 0.795837, 0.810457, 0.824589,
	0.838225, 0.851355, 0.863973, 0.876070, 0.887640, 0.898674, 0.909168, 0.919114,
	0.928506, 0.937339, 0.945607, 0.953306, 0.960431, 0.966976, 0.972940, 0.978317,
	0.983105, 0.987301, 0.990903, 0.993907, 0.996313, 0.998118, 0.999322, 0.999925
};

static const float sineWindow128[128] = {
	0.006136, 0.018407, 0.030675, 0.042938, 0.055195, 0.067444, 0.079682, 0.091909,
	0.104122, 0.116319, 0.128498, 0.140658, 0.152797, 0.164913, 0.177004, 0.189069,
	0.201105, 0.213110, 0.225084, 0.237024, 0.248928, 0.260794, 0.272621, 0.284408,
	0.296151, 0.307850, 0.319502, 0.331106, 0.342661, 0.354164, 0.365613, 0.377007,
	0.388345, 0.399624, 0.410843, 0.422000, 0.433094, 0.444122, 0.455084, 0.465977,
	0.476799, 0.487550, 0.498228, 0.508830, 0.519356, 0.529804, 0.540172, 0.550458,
	0.560662, 0.570781, 0.580814, 0.590760, 0.600616, 0.610383, 0.620057, 0.629638,
	0.639124, 0.648514, 0.657807, 0.667000, 0.676093, 0.685084, 0.693971, 0.702755,
	0.711432, 0.720002, 0.728464, 0.736817, 0.745058, 0.753187, 0.761202, 0.769103,
	0.776888, 0.784557, 0.792107, 0.799537, 0.806848, 0.814036, 0.821102, 0.828045,
	0.834863, 0.841555, 0.848120, 0.854558, 0.860867, 0.867046, 0.873095, 0.879012,
	0.884797, 0.890449, 0.895966, 0.901349, 0.906596, 0.911706, 0.916679, 0.921514,
	0.926210, 0.930767, 0.935183, 0.939459, 0.943593, 0.947586, 0.951435, 0.955141,
	0.958703, 0.962121, 0.965394, 0.968522, 0.971504, 0.974339, 0.977028, 0.979570,
	0.981964, 0.984210, 0.986308, 0.988258, 0.990058, 0.991710, 0.993212, 0.994565,
	0.995767, 0.996820, 0.997723, 0.998476, 0.999078, 0.999529, 0.999831, 0.999981
};

static const float sineWindow256[256] = {
	0.003068, 0.009204, 0.015339, 0.021474, 0.027608, 0.033741, 0.039873, 0.046003,
	0.052132, 0.058258, 0.064383, 0.070505, 0.076624, 0.082740, 0.088854, 0.094963,
	0.101070, 0.107172, 0.113271, 0.119365, 0.125455, 0.131540, 0.137620, 0.143695,
	0.149765, 0.155828, 0.161886, 0.167938, 0.173984, 0.180023, 0.186055, 0.192080,
	0.198098, 0.204109, 0.210112, 0.216107, 0.222094, 0.228072, 0.234042, 0.240003,
	0.245955, 0.251898, 0.257831, 0.263755, 0.269668, 0.275572, 0.281465, 0.287347,
	0.293219, 0.299080, 0.304929, 0.310767, 0.316593, 0.322408, 0.328210, 0.334000,
	0.339777, 0.345541, 0.351293, 0.357031, 0.362756, 0.368467, 0.374164, 0.379847,
	0.385516, 0.391170, 0.396810, 0.402435, 0.408044, 0.413638, 0.419217, 0.424780,
	0.430326, 0.435857, 0.441371, 0.446869, 0.452350, 0.457813, 0.463260, 0.468689,
	0.474100, 0.479494, 0.484869, 0.490227, 0.495565, 0.500885, 0.506187, 0.511469,
	0.516732, 0.521975, 0.527199, 0.532403, 0.537587, 0.542751, 0.547894, 0.553017,
	0.558119, 0.563199, 0.568259, 0.573297, 0.578314, 0.583309, 0.588282, 0.593232,
	0.598161, 0.603067, 0.607950, 0.612810, 0.617647, 0.622461, 0.627252, 0.632019,
	0.636762, 0.641481, 0.646176, 0.650847, 0.655493, 0.660114, 0.664711, 0.669283,
	0.673829, 0.678350, 0.682846, 0.687315, 0.691759, 0.696177, 0.700569, 0.704934,
	0.709273, 0.713585, 0.717870, 0.722128, 0.726359, 0.730563, 0.734739, 0.738887,
	0.743008, 0.747101, 0.751165, 0.755201, 0.759209, 0.763188, 0.767139, 0.771061,
	0.774953, 0.778817, 0.782651, 0.786455, 0.790230, 0.793975, 0.797691, 0.801376,
	0.805031, 0.808656, 0.812251, 0.815814, 0.819348, 0.822850, 0.826321, 0.829761,
	0.833170, 0.836548, 0.839894, 0.843208, 0.846491, 0.849742, 0.852961, 0.856147,
	0.859302, 0.862424, 0.865514, 0.868571, 0.871595, 0.874587, 0.877545, 0.880471,
	0.883363, 0.886223, 0.889048, 0.891841, 0.894599, 0.897325, 0.900016, 0.902673,
	0.905297, 0.907886, 0.910441, 0.912962, 0.915449, 0.917901, 0.920318, 0.922701,
	0.925049, 0.927363, 0.929641, 0.931884, 0.934093, 0.936266, 0.938404, 0.940506,
	0.942573, 0.944605, 0.946601, 0.948561, 0.950486, 0.952375, 0.954228, 0.956045,
	0.957826, 0.959571, 0.961280, 0.962953, 0.964590, 0.966190, 0.967754, 0.969281,
	0.970772, 0.972227, 0.973644, 0.975025, 0.976370, 0.977677, 0.978948, 0.980182,
	0.981379, 0.982539, 0.983662, 0.984748, 0.985798, 0.986809, 0.987784, 0.988722,
	0.989622, 0.990485, 0.991311, 0.992099, 0.992850, 0.993564, 0.994240, 0.994879,
	0.995481, 0.996045, 0.996571, 0.997060, 0.997511, 0.997925, 0.998302, 0.998640,
	0.998941, 0.999205, 0.999431, 0.999619, 0.999769, 0.999882, 0.999958, 0.999995
};

static const float sineWindow512[512] = {
	0.001534, 0.004602, 0.007670, 0.010738, 0.013805, 0.016873, 0.019940, 0.023008,
	0.026075, 0.029142, 0.032208, 0.035274, 0.038340, 0.041406, 0.044471, 0.047535,
	0.050600, 0.053664, 0.056727, 0.059790, 0.062852, 0.065913, 0.068974, 0.072035,
	0.075094, 0.078153, 0.081211, 0.084269, 0.087326, 0.090381, 0.093436, 0.096490,
	0.099544, 0.102596, 0.105647, 0.108697, 0.111747, 0.114795, 0.117842, 0.120888,
	0.123933, 0.126977, 0.130019, 0.133061, 0.136101, 0.139139, 0.142177, 0.145213,
	0.148248, 0.151281, 0.154313, 0.157343, 0.160372, 0.163400, 0.166426, 0.169450,
	0.172473, 0.175494, 0.178514, 0.181532, 0.184548, 0.187562, 0.190575, 0.193586,
	0.196595, 0.199602, 0.202607, 0.205610, 0.208612, 0.211611, 0.214609, 0.217604,
	0.220598, 0.223589, 0.226578, 0.229565, 0.232550, 0.235533, 0.238514, 0.241492,
	0.244468, 0.247442, 0.250413, 0.253382, 0.256349, 0.259313, 0.262275, 0.265234,
	0.268191, 0.271145, 0.274097, 0.277046, 0.279993, 0.282937, 0.285878, 0.288816,
	0.291752, 0.294685, 0.297616, 0.300543, 0.303468, 0.306390, 0.309309, 0.312225,
	0.315138, 0.318048, 0.320955, 0.323859, 0.326760, 0.329658, 0.332553, 0.335445,
	0.338334, 0.341219, 0.344101, 0.346980, 0.349856, 0.352729, 0.355598, 0.358463,
	0.361326, 0.364185, 0.367040, 0.369892, 0.372741, 0.375586, 0.378428, 0.381266,
	0.384100, 0.386931, 0.389758, 0.392582, 0.395401, 0.398218, 0.401030, 0.403838,
	0.406643, 0.409444, 0.412241, 0.415034, 0.417824, 0.420609, 0.423390, 0.426168,
	0.428941, 0.431711, 0.434476, 0.437237, 0.439994, 0.442747, 0.445496, 0.448241,
	0.450981, 0.453717, 0.456449, 0.459177, 0.461900, 0.464619, 0.467333, 0.470043,
	0.472749, 0.475450, 0.478147, 0.480839, 0.483527, 0.486210, 0.488889, 0.491563,
	0.494232, 0.496897, 0.499557, 0.502212, 0.504863, 0.507509, 0.510150, 0.512786,
	0.515418, 0.518044, 0.520666, 0.523283, 0.525895, 0.528502, 0.531104, 0.533701,
	0.536293, 0.538880, 0.541462, 0.544039, 0.546610, 0.549177, 0.551738, 0.554294,
	0.556845, 0.559391, 0.561931, 0.564466, 0.566996, 0.569521, 0.572040, 0.574553,
	0.577062, 0.579565, 0.582062, 0.584554, 0.587040, 0.589521, 0.591997, 0.594467,
	0.596931, 0.599389, 0.601842, 0.604290, 0.606731, 0.609167, 0.611597, 0.614022,
	0.616440, 0.618853, 0.621260, 0.623661, 0.626056, 0.628446, 0.630829, 0.633207,
	0.635578, 0.637944, 0.640303, 0.642657, 0.645005, 0.647346, 0.649681, 0.652011,
	0.654334, 0.656651, 0.658961, 0.661266, 0.663564, 0.665856, 0.668142, 0.670422,
	0.672695, 0.674962, 0.677222, 0.679476, 0.681724, 0.683965, 0.686200, 0.688429,
	0.690651, 0.692866, 0.695075, 0.697277, 0.699473, 0.701663, 0.703845, 0.706021,
	0.708191, 0.710353, 0.712509, 0.714659, 0.716801, 0.718937, 0.721066, 0.723189,
	0.725304, 0.727413, 0.729514, 0.731609, 0.733697, 0.735779, 0.737853, 0.739920,
	0.741980, 0.744034, 0.746080, 0.748119, 0.750152, 0.752177, 0.754195, 0.756206,
	0.758210, 0.760207, 0.762196, 0.764179, 0.766154, 0.768122, 0.770083, 0.772036,
	0.773983, 0.775922, 0.777853, 0.779778, 0.781695, 0.783605, 0.785507, 0.787402,
	0.789289, 0.791169, 0.793042, 0.794907, 0.796765, 0.798615, 0.800458, 0.802293,
	0.804120, 0.805940, 0.807753, 0.809558, 0.811355, 0.813144, 0.814926, 0.816701,
	0.818467, 0.820226, 0.821977, 0.823721, 0.825456, 0.827184, 0.828904, 0.830616,
	0.832321, 0.834018, 0.835706, 0.837387, 0.839060, 0.840725, 0.842383, 0.844032,
	0.845673, 0.847307, 0.848932, 0.850550, 0.852159, 0.853760, 0.855354, 0.856939,
	0.858516, 0.860085, 0.861646, 0.863199, 0.864744, 0.866281, 0.867809, 0.869330,
	0.870842, 0.872346, 0.873842, 0.875329, 0.876809, 0.878280, 0.879743, 0.881197,
	0.882643, 0.884081, 0.885511, 0.886932, 0.888345, 0.889750, 0.891146, 0.892534,
	0.893913, 0.895284, 0.896646, 0.898001, 0.899346, 0.900683, 0.902012, 0.903332,
	0.904644, 0.905947, 0.907242, 0.908528, 0.909806, 0.911075, 0.912335, 0.913587,
	0.914830, 0.916065, 0.917291, 0.918508, 0.919717, 0.920917, 0.922109, 0.923291,
	0.924465, 0.925631, 0.926787, 0.927935, 0.929075, 0.930205, 0.931327, 0.932440,
	0.933544, 0.934639, 0.935726, 0.936803, 0.937872, 0.938932, 0.939984, 0.941026,
	0.942060, 0.943084, 0.944100, 0.945107, 0.946105, 0.947094, 0.948075, 0.949046,
	0.950008, 0.950962, 0.951906, 0.952842, 0.953768, 0.954686, 0.955594, 0.956494,
	0.957385, 0.958266, 0.959139, 0.960002, 0.960857, 0.961702, 0.962538, 0.963366,
	0.964184, 0.964993, 0.965793, 0.966584, 0.967366, 0.968139, 0.968903, 0.969657,
	0.970403, 0.971139, 0.971866, 0.972584, 0.973293, 0.973993, 0.974684, 0.975365,
	0.976037, 0.976700, 0.977354, 0.977998, 0.978634, 0.979260, 0.979877, 0.980485,
	0.981083, 0.981673, 0.982253, 0.982824, 0.983385, 0.983937, 0.984480, 0.985014,
	0.985539, 0.986054, 0.986560, 0.987057, 0.987544, 0.988022, 0.988491, 0.988950,
	0.989400, 0.989841, 0.990273, 0.990695, 0.991108, 0.991511, 0.991906, 0.992291,
	0.992666, 0.993032, 0.993389, 0.993737, 0.994075, 0.994404, 0.994723, 0.995033,
	0.995334, 0.995625, 0.995907, 0.996180, 0.996443, 0.996697, 0.996941, 0.997176,
	0.997402, 0.997618, 0.997825, 0.998023, 0.998211, 0.998390, 0.998559, 0.998719,
	0.998870, 0.999011, 0.999142, 0.999265, 0.999378, 0.999481, 0.999575, 0.999660,
	0.999735, 0.999801, 0.999858, 0.999905, 0.999942, 0.999971, 0.999989, 0.999999
};

static const float sineWindow1024[1024] = {
	0.000767, 0.002301, 0.003835, 0.005369, 0.006903, 0.008437, 0.009971, 0.011505,
	0.013038, 0.014572, 0.016106, 0.017640, 0.019174, 0.020707, 0.022241, 0.023774,
	0.025308, 0.026841, 0.028375, 0.029908, 0.031441, 0.032975, 0.034508, 0.036041,
	0.037574, 0.039107, 0.040639, 0.042172, 0.043705, 0.045237, 0.046769, 0.048302,
	0.049834, 0.051366, 0.052898, 0.054429, 0.055961, 0.057493, 0.059024, 0.060555,
	0.062086, 0.063617, 0.065148, 0.066679, 0.068209, 0.069739, 0.071270, 0.072800,
	0.074329, 0.075859, 0.077389, 0.078918, 0.080447, 0.081976, 0.083505, 0.085033,
	0.086561, 0.088090, 0.089617, 0.091145, 0.092673, 0.094200, 0.095727, 0.097254,
	0.098780, 0.100307, 0.101833, 0.103359, 0.104884, 0.106410, 0.107935, 0.109460,
	0.110984, 0.112509, 0.114033, 0.115557, 0.117080, 0.118604, 0.120127, 0.121649,
	0.123172, 0.124694, 0.126216, 0.127737, 0.129259, 0.130780, 0.132300, 0.133821,
	0.135341, 0.136860, 0.138380, 0.139899, 0.141418, 0.142936, 0.144454, 0.145972,
	0.147489, 0.149006, 0.150523, 0.152039, 0.153555, 0.155071, 0.156586, 0.158101,
	0.159615, 0.161129, 0.162643, 0.164157, 0.165670, 0.167182, 0.168694, 0.170206,
	0.171718, 0.173229, 0.174739, 0.176249, 0.177759, 0.179268, 0.180777, 0.182286,
	0.183794, 0.185302, 0.186809, 0.188315, 0.189822, 0.191328, 0.192833, 0.194338,
	0.195843, 0.197347, 0.198850, 0.200353, 0.201856, 0.203358, 0.204860, 0.206361,
	0.207862, 0.209362, 0.210862, 0.212361, 0.213860, 0.215358, 0.216856, 0.218353,
	0.219850, 0.221346, 0.222841, 0.224337, 0.225831, 0.227325, 0.228819, 0.230312,
	0.231804, 0.233296, 0.234788, 0.236278, 0.237769, 0.239258, 0.240748, 0.242236,
	0.243724, 0.245212, 0.246698, 0.248185, 0.249670, 0.251155, 0.252640, 0.254124,
	0.255607, 0.257090, 0.258572, 0.260054, 0.261534, 0.263015, 0.264494, 0.265973,
	0.267452, 0.268930, 0.270407, 0.271883, 0.273359, 0.274834, 0.276309, 0.277783,
	0.279256, 0.280729, 0.282201, 0.283672, 0.285143, 0.286613, 0.288082, 0.289551,
	0.291019, 0.292486, 0.293952, 0.295418, 0.296883, 0.298348, 0.299812, 0.301275,
	0.302737, 0.304199, 0.305660, 0.307120, 0.308579, 0.310038, 0.311496, 0.312953,
	0.314410, 0.315866, 0.317321, 0.318775, 0.320229, 0.321682, 0.323134, 0.324585,
	0.326035, 0.327485, 0.328934, 0.330382, 0.331830, 0.333277, 0.334723, 0.336168,
	0.337612, 0.339055, 0.340498, 0.341940, 0.343381, 0.344821, 0.346261, 0.347700,
	0.349138, 0.350575, 0.352011, 0.353446, 0.354881, 0.356314, 0.357747, 0.359179,
	0.360611, 0.362041, 0.363470, 0.364899, 0.366327, 0.367754, 0.369180, 0.370605,
	0.372029, 0.373453, 0.374875, 0.376297, 0.377718, 0.379138, 0.380557, 0.381975,
	0.383392, 0.384808, 0.386224, 0.387638, 0.389052, 0.390464, 0.391876, 0.393287,
	0.394697, 0.396106, 0.397514, 0.398921, 0.400327, 0.401732, 0.403137, 0.404540,
	0.405942, 0.407344, 0.408744, 0.410144, 0.411542, 0.412940, 0.414336, 0.415732,
	0.417127, 0.418520, 0.419913, 0.421305, 0.422695, 0.424085, 0.425474, 0.426862,
	0.428248, 0.429634, 0.431019, 0.432402, 0.433785, 0.435167, 0.436547, 0.437927,
	0.439305, 0.440683, 0.442059, 0.443435, 0.444809, 0.446183, 0.447555, 0.448926,
	0.450296, 0.451665, 0.453033, 0.454400, 0.455766, 0.457131, 0.458495, 0.459858,
	0.461219, 0.462580, 0.463939, 0.465298, 0.466655, 0.468011, 0.469366, 0.470720,
	0.472073, 0.473425, 0.474775, 0.476125, 0.477473, 0.478821, 0.480167, 0.481512,
	0.482856, 0.484198, 0.485540, 0.486880, 0.488220, 0.489558, 0.490895, 0.492231,
	0.493565, 0.494899, 0.496231, 0.497562, 0.498893, 0.500221, 0.501549, 0.502876,
	0.504201, 0.505525, 0.506848, 0.508170, 0.509490, 0.510810, 0.512128, 0.513445,
	0.514760, 0.516075, 0.517388, 0.518700, 0.520011, 0.521321, 0.522629, 0.523937,
	0.525243, 0.526547, 0.527851, 0.529153, 0.530454, 0.531754, 0.533052, 0.534349,
	0.535645, 0.536940, 0.538234, 0.539526, 0.540817, 0.542106, 0.543395, 0.544682,
	0.545968, 0.547252, 0.548536, 0.549817, 0.551098, 0.552378, 0.553656, 0.554932,
	0.556208, 0.557482, 0.558755, 0.560026, 0.561297, 0.562565, 0.563833, 0.565099,
	0.566364, 0.567628, 0.568890, 0.570151, 0.571410, 0.572669, 0.573925, 0.575181,
	0.576435, 0.577688, 0.578939, 0.580189, 0.581438, 0.582685, 0.583931, 0.585176,
	0.586419, 0.587661, 0.588902, 0.590141, 0.591378, 0.592615, 0.593850, 0.595083,
	0.596315, 0.597546, 0.598775, 0.600003, 0.601230, 0.602455, 0.603678, 0.604900,
	0.606121, 0.607341, 0.608559, 0.609775, 0.610990, 0.612204, 0.613416, 0.614627,
	0.615836, 0.617044, 0.618250, 0.619455, 0.620659, 0.621861, 0.623061, 0.624260,
	0.625458, 0.626654, 0.627849, 0.629042, 0.630234, 0.631424, 0.632613, 0.633800,
	0.634986, 0.636170, 0.637353, 0.638534, 0.639714, 0.640892, 0.642069, 0.643245,
	0.644418, 0.645590, 0.646761, 0.647930, 0.649098, 0.650264, 0.651429, 0.652592,
	0.653753, 0.654913, 0.656072, 0.657229, 0.658384, 0.659538, 0.660690, 0.661841,
	0.662990, 0.664138, 0.665284, 0.666428, 0.667571, 0.668712, 0.669852, 0.670990,
	0.672127, 0.673262, 0.674396, 0.675527, 0.676658, 0.677786, 0.678913, 0.680039,
	0.681163, 0.682285, 0.683406, 0.684525, 0.685642, 0.686758, 0.687872, 0.688985,
	0.690096, 0.691205, 0.692313, 0.693419, 0.694523, 0.695626, 0.696728, 0.697827,
	0.698925, 0.700021, 0.701116, 0.702209, 0.703300, 0.704390, 0.705478, 0.706564,
	0.707649, 0.708732, 0.709813, 0.710893, 0.711971, 0.713047, 0.714122, 0.715195,
	0.716266, 0.717336, 0.718404, 0.719470, 0.720535, 0.721597, 0.722659, 0.723718,
	0.724776, 0.725832, 0.726886, 0.727939, 0.728990, 0.730039, 0.731086, 0.732132,
	0.733176, 0.734218, 0.735259, 0.736298, 0.737335, 0.738370, 0.739404, 0.740436,
	0.741466, 0.742494, 0.743521, 0.744546, 0.745569, 0.746591, 0.747610, 0.748628,
	0.749644, 0.750659, 0.751671, 0.752682, 0.753691, 0.754698, 0.755704, 0.756708,
	0.757710, 0.758710, 0.759708, 0.760705, 0.761700, 0.762693, 0.763684, 0.764673,
	0.765661, 0.766647, 0.767631, 0.768613, 0.769593, 0.770572, 0.771549, 0.772524,
	0.773497, 0.774468, 0.775438, 0.776405, 0.777371, 0.778335, 0.779297, 0.780258,
	0.781216, 0.782173, 0.783128, 0.784081, 0.785032, 0.785981, 0.786929, 0.787874,
	0.788818, 0.789760, 0.790700, 0.791638, 0.792575, 0.793509, 0.794442, 0.795372,
	0.796301, 0.797228, 0.798153, 0.799076, 0.799998, 0.800917, 0.801835, 0.802750,
	0.803664, 0.804576, 0.805486, 0.806394, 0.807300, 0.808205, 0.809107, 0.810008,
	0.810906, 0.811803, 0.812698, 0.813591, 0.814482, 0.815371, 0.816258, 0.817143,
	0.818026, 0.818908, 0.819787, 0.820664, 0.821540, 0.822414, 0.823285, 0.824155,
	0.825023, 0.825889, 0.826753, 0.827615, 0.828475, 0.829333, 0.830189, 0.831043,
	0.831895, 0.832746, 0.833594, 0.834440, 0.835285, 0.836127, 0.836968, 0.837806,
	0.838643, 0.839477, 0.840310, 0.841140, 0.841969, 0.842796, 0.843620, 0.844443,
	0.845264, 0.846082, 0.846899, 0.847714, 0.848526, 0.849337, 0.850146, 0.850953,
	0.851757, 0.852560, 0.853361, 0.854159, 0.854956, 0.855751, 0.856543, 0.857334,
	0.858123, 0.858909, 0.859694, 0.860476, 0.861257, 0.862035, 0.862812, 0.863586,
	0.864359, 0.865129, 0.865898, 0.866664, 0.867428, 0.868190, 0.868951, 0.869709,
	0.870465, 0.871219, 0.871971, 0.872721, 0.873469, 0.874215, 0.874958, 0.875700,
	0.876440, 0.877177, 0.877913, 0.878646, 0.879378, 0.880107, 0.880834, 0.881559,
	0.882283, 0.883004, 0.883723, 0.884439, 0.885154, 0.885867, 0.886578, 0.887286,
	0.887993, 0.888697, 0.889399, 0.890099, 0.890798, 0.891494, 0.892187, 0.892879,
	0.893569, 0.894257, 0.894942, 0.895625, 0.896307, 0.896986, 0.897663, 0.898338,
	0.899011, 0.899681, 0.900350, 0.901016, 0.901681, 0.902343, 0.903003, 0.903661,
	0.904317, 0.904971, 0.905622, 0.906272, 0.906919, 0.907564, 0.908207, 0.908848,
	0.909487, 0.910124, 0.910758, 0.911391, 0.912021, 0.912649, 0.913275, 0.913899,
	0.914520, 0.915140, 0.915757, 0.916372, 0.916985, 0.917596, 0.918205, 0.918811,
	0.919416, 0.920018, 0.920618, 0.921216, 0.921812, 0.922405, 0.922997, 0.923586,
	0.924173, 0.924758, 0.925340, 0.925921, 0.926499, 0.927075, 0.927649, 0.928221,
	0.928791, 0.929358, 0.929923, 0.930486, 0.931047, 0.931606, 0.932162, 0.932716,
	0.933269, 0.933818, 0.934366, 0.934912, 0.935455, 0.935996, 0.936535, 0.937072,
	0.937606, 0.938138, 0.938668, 0.939196, 0.939722, 0.940245, 0.940766, 0.941285,
	0.941802, 0.942317, 0.942829, 0.943339, 0.943847, 0.944353, 0.944856, 0.945358,
	0.945857, 0.946353, 0.946848, 0.947340, 0.947830, 0.948318, 0.948804, 0.949287,
	0.949768, 0.950247, 0.950724, 0.951199, 0.951671, 0.952141, 0.952609, 0.953074,
	0.953537, 0.953998, 0.954457, 0.954914, 0.955368, 0.955820, 0.956270, 0.956717,
	0.957163, 0.957606, 0.958047, 0.958485, 0.958921, 0.959355, 0.959787, 0.960217,
	0.960644, 0.961069, 0.961492, 0.961912, 0.962330, 0.962746, 0.963160, 0.963571,
	0.963980, 0.964387, 0.964792, 0.965194, 0.965594, 0.965992, 0.966387, 0.966781,
	0.967172, 0.967560, 0.967947, 0.968331, 0.968713, 0.969092, 0.969470, 0.969845,
	0.970217, 0.970588, 0.970956, 0.971322, 0.971685, 0.972047, 0.972406, 0.972762,
	0.973117, 0.973469, 0.973819, 0.974166, 0.974512, 0.974855, 0.975195, 0.975534,
	0.975870, 0.976204, 0.976535, 0.976864, 0.977191, 0.977516, 0.977838, 0.978158,
	0.978476, 0.978791, 0.979104, 0.979415, 0.979724, 0.980030, 0.980334, 0.980635,
	0.980935, 0.981232, 0.981526, 0.981819, 0.982109, 0.982396, 0.982682, 0.982965,
	0.983246, 0.983524, 0.983800, 0.984074, 0.984346, 0.984615, 0.984882, 0.985146,
	0.985408, 0.985668, 0.985926, 0.986181, 0.986434, 0.986685, 0.986933, 0.987179,
	0.987423, 0.987664, 0.987903, 0.988140, 0.988374, 0.988607, 0.988836, 0.989064,
	0.989289, 0.989511, 0.989732, 0.989950, 0.990166, 0.990379, 0.990590, 0.990799,
	0.991006, 0.991210, 0.991411, 0.991611, 0.991808, 0.992003, 0.992195, 0.992385,
	0.992573, 0.992759, 0.992942, 0.993122, 0.993301, 0.993477, 0.993651, 0.993822,
	0.993991, 0.994158, 0.994322, 0.994484, 0.994644, 0.994802, 0.994957, 0.995109,
	0.995260, 0.995408, 0.995553, 0.995697, 0.995838, 0.995976, 0.996113, 0.996247,
	0.996378, 0.996507, 0.996634, 0.996759, 0.996881, 0.997001, 0.997119, 0.997234,
	0.997347, 0.997457, 0.997565, 0.997671, 0.997774, 0.997876, 0.997974, 0.998071,
	0.998165, 0.998257, 0.998346, 0.998433, 0.998518, 0.998600, 0.998680, 0.998758,
	0.998833, 0.998906, 0.998976, 0.999044, 0.999110, 0.999174, 0.999235, 0.999294,
	0.999350, 0.999404, 0.999456, 0.999506, 0.999553, 0.999597, 0.999640, 0.999680,
	0.999717, 0.999753, 0.999786, 0.999816, 0.999844, 0.999870, 0.999894, 0.999915,
	0.999934, 0.999950, 0.999964, 0.999976, 0.999986, 0.999993, 0.999997, 1.000000
};

static const float sineWindow2048[2048] = {
	0.000383, 0.001150, 0.001917, 0.002684, 0.003451, 0.004218, 0.004985, 0.005752,
	0.006519, 0.007286, 0.008053, 0.008820, 0.009587, 0.010354, 0.011121, 0.011888,
	0.012655, 0.013422, 0.014189, 0.014956, 0.015723, 0.016490, 0.017256, 0.018023,
	0.018790, 0.019557, 0.020324, 0.021091, 0.021857, 0.022624, 0.023391, 0.024158,
	0.024925, 0.025691, 0.026458, 0.027225, 0.027991, 0.028758, 0.029525, 0.030291,
	0.031058, 0.031825, 0.032591, 0.033358, 0.034124, 0.034891, 0.035657, 0.036424,
	0.037190, 0.037957, 0.038723, 0.039490, 0.040256, 0.041022, 0.041789, 0.042555,
	0.043321, 0.044088, 0.044854, 0.045620, 0.046386, 0.047152, 0.047919, 0.048685,
	0.049451, 0.050217, 0.050983, 0.051749, 0.052515, 0.053281, 0.054046, 0.054812,
	0.055578, 0.056344, 0.057110, 0.057875, 0.058641, 0.059407, 0.060172, 0.060938,
	0.061704, 0.062469, 0.063234, 0.064000, 0.064765, 0.065531, 0.066296, 0.067061,
	0.067827, 0.068592, 0.069357, 0.070122, 0.070887, 0.071652, 0.072417, 0.073182,
	0.073947, 0.074712, 0.075477, 0.076241, 0.077006, 0.077771, 0.078536, 0.079300,
	0.080065, 0.080829, 0.081594, 0.082358, 0.083122, 0.083887, 0.084651, 0.085415,
	0.086179, 0.086943, 0.087708, 0.088472, 0.089236, 0.089999, 0.090763, 0.091527,
	0.092291, 0.093055, 0.093818, 0.094582, 0.095345, 0.096109, 0.096872, 0.097635,
	0.098399, 0.099162, 0.099925, 0.100688, 0.101451, 0.102214, 0.102977, 0.103740,
	0.104503, 0.105266, 0.106028, 0.106791, 0.107554, 0.108316, 0.109079, 0.109841,
	0.110603, 0.111366, 0.112128, 0.112890, 0.113652, 0.114414, 0.115176, 0.115938,
	0.116700, 0.117461, 0.118223, 0.118984, 0.119746, 0.120507, 0.121269, 0.122030,
	0.122791, 0.123552, 0.124314, 0.125075, 0.125835, 0.126596, 0.127357, 0.128118,
	0.128878, 0.129639, 0.130399, 0.131160, 0.131920, 0.132680, 0.133441, 0.134201,
	0.134961, 0.135721, 0.136480, 0.137240, 0.138000, 0.138760, 0.139519, 0.140279,
	0.141038, 0.141797, 0.142556, 0.143316, 0.144075, 0.144833, 0.145592, 0.146351,
	0.147110, 0.147868, 0.148627, 0.149385, 0.150144, 0.150902, 0.151660, 0.152418,
	0.153176, 0.153934, 0.154692, 0.155450, 0.156207, 0.156965, 0.157722, 0.158480,
	0.159237, 0.159994, 0.160751, 0.161508, 0.162265, 0.163022, 0.163778, 0.164535,
	0.165291, 0.166048, 0.166804, 0.167560, 0.168316, 0.169072, 0.169828, 0.170584,
	0.171340, 0.172095, 0.172851, 0.173606, 0.174362, 0.175117, 0.175872, 0.176627,
	0.177382, 0.178136, 0.178891, 0.179646, 0.180400, 0.181154, 0.181909, 0.182663,
	0.183417, 0.184171, 0.184925, 0.185678, 0.186432, 0.187185, 0.187939, 0.188692,
	0.189445, 0.190198, 0.190951, 0.191704, 0.192457, 0.193209, 0.193962, 0.194714,
	0.195466, 0.196219, 0.196971, 0.197722, 0.198474, 0.199226, 0.199978, 0.200729,
	0.201480, 0.202231, 0.202983, 0.203734, 0.204484, 0.205235, 0.205986, 0.206736,
	0.207487, 0.208237, 0.208987, 0.209737, 0.210487, 0.211236, 0.211986, 0.212736,
	0.213485, 0.214234, 0.214983, 0.215732, 0.216481, 0.217230, 0.217979, 0.218727,
	0.219475, 0.220224, 0.220972, 0.221720, 0.222468, 0.223215, 0.223963, 0.224710,
	0.225458, 0.226205, 0.226952, 0.227699, 0.228445, 0.229192, 0.229939, 0.230685,
	0.231431, 0.232177, 0.232923, 0.233669, 0.234415, 0.235160, 0.235906, 0.236651,
	0.237396, 0.238141, 0.238886, 0.239631, 0.240375, 0.241120, 0.241864, 0.242608,
	0.243352, 0.244096, 0.244840, 0.245583, 0.246327, 0.247070, 0.247813, 0.248556,
	0.249299, 0.250042, 0.250784, 0.251527, 0.252269, 0.253011, 0.253753, 0.254495,
	0.255236, 0.255978, 0.256719, 0.257461, 0.258202, 0.258943, 0.259683, 0.260424,
	0.261164, 0.261905, 0.262645, 0.263385, 0.264125, 0.264864, 0.265604, 0.266343,
	0.267082, 0.267821, 0.268560, 0.269299, 0.270038, 0.270776, 0.271514, 0.272252,
	0.272990, 0.273728, 0.274466, 0.275203, 0.275940, 0.276678, 0.277415, 0.278151,
	0.278888, 0.279624, 0.280361, 0.281097, 0.281833, 0.282569, 0.283304, 0.284040,
	0.284775, 0.285510, 0.286245, 0.286980, 0.287715, 0.288449, 0.289184, 0.289918,
	0.290652, 0.291385, 0.292119, 0.292853, 0.293586, 0.294319, 0.295052, 0.295785,
	0.296517, 0.297250, 0.297982, 0.298714, 0.299446, 0.300177, 0.300909, 0.301640,
	0.302372, 0.303103, 0.303833, 0.304564, 0.305294, 0.306025, 0.306755, 0.307485,
	0.308214, 0.308944, 0.309673, 0.310403, 0.311132, 0.311860, 0.312589, 0.313318,
	0.314046, 0.314774, 0.315502, 0.316230, 0.316957, 0.317684, 0.318412, 0.319139,
	0.319865, 0.320592, 0.321318, 0.322045, 0.322771, 0.323497, 0.324222, 0.324948,
	0.325673, 0.326398, 0.327123, 0.327848, 0.328572, 0.329296, 0.330020, 0.330744,
	0.331468, 0.332192, 0.332915, 0.333638, 0.334361, 0.335084, 0.335806, 0.336529,
	0.337251, 0.337973, 0.338695, 0.339416, 0.340138, 0.340859, 0.341580, 0.342300,
	0.343021, 0.343741, 0.344462, 0.345181, 0.345901, 0.346621, 0.347340, 0.348059,
	0.348778, 0.349497, 0.350215, 0.350934, 0.351652, 0.352370, 0.353087, 0.353805,
	0.354522, 0.355239, 0.355956, 0.356673, 0.357389, 0.358105, 0.358821, 0.359537,
	0.360253, 0.360968, 0.361683, 0.362398, 0.363113, 0.363828, 0.364542, 0.365256,
	0.365970, 0.366684, 0.367397, 0.368110, 0.368823, 0.369536, 0.370249, 0.370961,
	0.371673, 0.372385, 0.373097, 0.373808, 0.374520, 0.375231, 0.375942, 0.376652,
	0.377363, 0.378073, 0.378783, 0.379492, 0.380202, 0.380911, 0.381620, 0.382329,
	0.383038, 0.383746, 0.384454, 0.385162, 0.385870, 0.386577, 0.387285, 0.387992,
	0.388698, 0.389405, 0.390111, 0.390817, 0.391523, 0.392229, 0.392934, 0.393640,
	0.394344, 0.395049, 0.395754, 0.396458, 0.397162, 0.397866, 0.398569, 0.399273,
	0.399976, 0.400679, 0.401381, 0.402084, 0.402786, 0.403488, 0.404189, 0.404891,
	0.405592, 0.406293, 0.406994, 0.407694, 0.408394, 0.409094, 0.409794, 0.410494,
	0.411193, 0.411892, 0.412591, 0.413289, 0.413987, 0.414685, 0.415383, 0.416081,
	0.416778, 0.417475, 0.418172, 0.418869, 0.419565, 0.420261, 0.420957, 0.421653,
	0.422348, 0.423043, 0.423738, 0.424432, 0.425127, 0.425821, 0.426515, 0.427208,
	0.427902, 0.428595, 0.429288, 0.429980, 0.430673, 0.431365, 0.432057, 0.432748,
	0.433439, 0.434131, 0.434821, 0.435512, 0.436202, 0.436892, 0.437582, 0.438272,
	0.438961, 0.439650, 0.440339, 0.441027, 0.441715, 0.442403, 0.443091, 0.443779,
	0.444466, 0.445153, 0.445839, 0.446526, 0.447212, 0.447898, 0.448583, 0.449269,
	0.449954, 0.450639, 0.451323, 0.452008, 0.452692, 0.453375, 0.454059, 0.454742,
	0.455425, 0.456108, 0.456790, 0.457472, 0.458154, 0.458836, 0.459517, 0.460198,
	0.460879, 0.461560, 0.462240, 0.462920, 0.463600, 0.464279, 0.464958, 0.465637,
	0.466316, 0.466994, 0.467672, 0.468350, 0.469028, 0.469705, 0.470382, 0.471058,
	0.471735, 0.472411, 0.473087, 0.473763, 0.474438, 0.475113, 0.475788, 0.476462,
	0.477136, 0.477810, 0.478484, 0.479157, 0.479830, 0.480503, 0.481176, 0.481848,
	0.482520, 0.483191, 0.483863, 0.484534, 0.485205, 0.485875, 0.486545, 0.487215,
	0.487885, 0.488554, 0.489223, 0.489892, 0.490561, 0.491229, 0.491897, 0.492564,
	0.493232, 0.493899, 0.494566, 0.495232, 0.495898, 0.496564, 0.497230, 0.497895,
	0.498560, 0.499225, 0.499889, 0.500553, 0.501217, 0.501881, 0.502544, 0.503207,
	0.503870, 0.504532, 0.505194, 0.505856, 0.506517, 0.507179, 0.507839, 0.508500,
	0.509160, 0.509820, 0.510480, 0.511139, 0.511798, 0.512457, 0.513116, 0.513774,
	0.514432, 0.515089, 0.515746, 0.516403, 0.517060, 0.517716, 0.518372, 0.519028,
	0.519684, 0.520339, 0.520994, 0.521648, 0.522302, 0.522956, 0.523610, 0.524263,
	0.524916, 0.525569, 0.526221, 0.526873, 0.527525, 0.528176, 0.528827, 0.529478,
	0.530129, 0.530779, 0.531429, 0.532078, 0.532728, 0.533377, 0.534025, 0.534674,
	0.535322, 0.535969, 0.536617, 0.537264, 0.537910, 0.538557, 0.539203, 0.539849,
	0.540494, 0.541139, 0.541784, 0.542429, 0.543073, 0.543717, 0.544360, 0.545004,
	0.545646, 0.546289, 0.546931, 0.547573, 0.548215, 0.548856, 0.549497, 0.550138,
	0.550778, 0.551418, 0.552058, 0.552697, 0.553336, 0.553975, 0.554613, 0.555251,
	0.555889, 0.556526, 0.557164, 0.557800, 0.558437, 0.559073, 0.559709, 0.560344,
	0.560979, 0.561614, 0.562248, 0.562882, 0.563516, 0.564150, 0.564783, 0.565416,
	0.566048, 0.566680, 0.567312, 0.567943, 0.568574, 0.569205, 0.569836, 0.570466,
	0.571096, 0.571725, 0.572354, 0.572983, 0.573611, 0.574239, 0.574867, 0.575495,
	0.576122, 0.576748, 0.577375, 0.578001, 0.578627, 0.579252, 0.579877, 0.580502,
	0.581126, 0.581750, 0.582374, 0.582997, 0.583620, 0.584243, 0.584865, 0.585487,
	0.586109, 0.586730, 0.587351, 0.587971, 0.588592, 0.589212, 0.589831, 0.590450,
	0.591069, 0.591688, 0.592306, 0.592924, 0.593541, 0.594158, 0.594775, 0.595391,
	0.596007, 0.596623, 0.597238, 0.597853, 0.598468, 0.599082, 0.599696, 0.600310,
	0.600923, 0.601536, 0.602148, 0.602761, 0.603372, 0.603984, 0.604595, 0.605206,
	0.605816, 0.606426, 0.607036, 0.607645, 0.608254, 0.608863, 0.609471, 0.610079,
	0.610687, 0.611294, 0.611901, 0.612507, 0.613113, 0.613719, 0.614324, 0.614929,
	0.615534, 0.616138, 0.616742, 0.617346, 0.617949, 0.618552, 0.619154, 0.619756,
	0.620358, 0.620959, 0.621560, 0.622161, 0.622761, 0.623361, 0.623961, 0.624560,
	0.625159, 0.625757, 0.626355, 0.626953, 0.627550, 0.628147, 0.628744, 0.629340,
	0.629936, 0.630532, 0.631127, 0.631721, 0.632316, 0.632910, 0.633503, 0.634097,
	0.634690, 0.635282, 0.635874, 0.636466, 0.637057, 0.637649, 0.638239, 0.638829,
	0.639419, 0.640009, 0.640598, 0.641187, 0.641775, 0.642363, 0.642951, 0.643538,
	0.644125, 0.644711, 0.645298, 0.645883, 0.646469, 0.647054, 0.647638, 0.648222,
	0.648806, 0.649390, 0.649973, 0.650555, 0.651138, 0.651720, 0.652301, 0.652882,
	0.653463, 0.654044, 0.654624, 0.655203, 0.655782, 0.656361, 0.656940, 0.657518,
	0.658095, 0.658673, 0.659250, 0.659826, 0.660402, 0.660978, 0.661554, 0.662128,
	0.662703, 0.663277, 0.663851, 0.664424, 0.664997, 0.665570, 0.666142, 0.666714,
	0.667286, 0.667857, 0.668427, 0.668998, 0.669567, 0.670137, 0.670706, 0.671275,
	0.671843, 0.672411, 0.672978, 0.673546, 0.674112, 0.674679, 0.675245, 0.675810,
	0.676375, 0.676940, 0.677504, 0.678068, 0.678632, 0.679195, 0.679758, 0.680320,
	0.680882, 0.681443, 0.682005, 0.682565, 0.683126, 0.683686, 0.684245, 0.684804,
	0.685363, 0.685921, 0.686479, 0.687037, 0.687594, 0.688151, 0.688707, 0.689263,
	0.689818, 0.690373, 0.690928, 0.691482, 0.692036, 0.692590, 0.693143, 0.693695,
	0.694247, 0.694799, 0.695351, 0.695902, 0.696452, 0.697003, 0.697552, 0.698102,
	0.698651, 0.699199, 0.699747, 0.700295, 0.700842, 0.701389, 0.701936, 0.702482,
	0.703028, 0.703573, 0.704118, 0.704662, 0.705206, 0.705750, 0.706293, 0.706836,
	0.707378, 0.707920, 0.708461, 0.709002, 0.709543, 0.710083, 0.710623, 0.711163,
	0.711702, 0.712240, 0.712778, 0.713316, 0.713853, 0.714390, 0.714927, 0.715463,
	0.715999, 0.716534, 0.717069, 0.717603, 0.718137, 0.718671, 0.719204, 0.719736,
	0.720269, 0.720800, 0.721332, 0.721863, 0.722393, 0.722924, 0.723453, 0.723983,
	0.724512, 0.725040, 0.725568, 0.726095, 0.726623, 0.727149, 0.727676, 0.728202,
	0.728727, 0.729252, 0.729777, 0.730301, 0.730825, 0.731348, 0.731871, 0.732393,
	0.732915, 0.733437, 0.733958, 0.734479, 0.734999, 0.735519, 0.736038, 0.736557,
	0.737076, 0.737594, 0.738112, 0.738629, 0.739146, 0.739662, 0.740178, 0.740694,
	0.741209, 0.741723, 0.742237, 0.742751, 0.743265, 0.743777, 0.744290, 0.744802,
	0.745314, 0.745825, 0.746335, 0.746846, 0.747355, 0.747865, 0.748374, 0.748882,
	0.749390, 0.749898, 0.750405, 0.750912, 0.751418, 0.751924, 0.752429, 0.752934,
	0.753439, 0.753943, 0.754447, 0.754950, 0.755453, 0.755955, 0.756457, 0.756958,
	0.757459, 0.757960, 0.758460, 0.758960, 0.759459, 0.759957, 0.760456, 0.760954,
	0.761451, 0.761948, 0.762444, 0.762941, 0.763436, 0.763931, 0.764426, 0.764920,
	0.765414, 0.765907, 0.766400, 0.766893, 0.767385, 0.767876, 0.768368, 0.768858,
	0.769348, 0.769838, 0.770327, 0.770816, 0.771305, 0.771793, 0.772280, 0.772767,
	0.773254, 0.773740, 0.774225, 0.774711, 0.775195, 0.775680, 0.776164, 0.776647,
	0.777130, 0.777612, 0.778094, 0.778576, 0.779057, 0.779538, 0.780018, 0.780498,
	0.780977, 0.781456, 0.781934, 0.782412, 0.782889, 0.783366, 0.783843, 0.784319,
	0.784794, 0.785269, 0.785744, 0.786218, 0.786692, 0.787165, 0.787638, 0.788110,
	0.788582, 0.789054, 0.789525, 0.789995, 0.790465, 0.790935, 0.791404, 0.791873,
	0.792341, 0.792808, 0.793275, 0.793742, 0.794209, 0.794674, 0.795140, 0.795605,
	0.796069, 0.796533, 0.796996, 0.797459, 0.797922, 0.798384, 0.798846, 0.799307,
	0.799768, 0.800228, 0.800687, 0.801147, 0.801605, 0.802064, 0.802522, 0.802979,
	0.803436, 0.803892, 0.804348, 0.804804, 0.805259, 0.805713, 0.806167, 0.806621,
	0.807074, 0.807527, 0.807979, 0.808430, 0.808882, 0.809332, 0.809783, 0.810233,
	0.810682, 0.811131, 0.811579, 0.812027, 0.812474, 0.812921, 0.813368, 0.813814,
	0.814259, 0.814704, 0.815149, 0.815593, 0.816036, 0.816479, 0.816922, 0.817364,
	0.817806, 0.818247, 0.818687, 0.819128, 0.819567, 0.820007, 0.820445, 0.820884,
	0.821321, 0.821759, 0.822195, 0.822632, 0.823068, 0.823503, 0.823938, 0.824372,
	0.824806, 0.825240, 0.825673, 0.826105, 0.826537, 0.826968, 0.827399, 0.827830,
	0.828260, 0.828690, 0.829119, 0.829547, 0.829975, 0.830403, 0.830830, 0.831256,
	0.831683, 0.832108, 0.832533, 0.832958, 0.833382, 0.833806, 0.834229, 0.834652,
	0.835074, 0.835496, 0.835917, 0.836338, 0.836758, 0.837178, 0.837597, 0.838015,
	0.838434, 0.838852, 0.839269, 0.839686, 0.840102, 0.840518, 0.840933, 0.841348,
	0.841762, 0.842176, 0.842589, 0.843002, 0.843414, 0.843826, 0.844237, 0.844648,
	0.845059, 0.845469, 0.845878, 0.846287, 0.846695, 0.847103, 0.847510, 0.847917,
	0.848323, 0.848729, 0.849135, 0.849540, 0.849944, 0.850348, 0.850751, 0.851154,
	0.851556, 0.851958, 0.852360, 0.852760, 0.853161, 0.853561, 0.853960, 0.854359,
	0.854757, 0.855155, 0.855552, 0.855949, 0.856345, 0.856741, 0.857137, 0.857531,
	0.857926, 0.858320, 0.858713, 0.859106, 0.859498, 0.859890, 0.860281, 0.860672,
	0.861062, 0.861452, 0.861841, 0.862230, 0.862618, 0.863006, 0.863393, 0.863780,
	0.864166, 0.864552, 0.864937, 0.865321, 0.865706, 0.866089, 0.866472, 0.866855,
	0.867237, 0.867619, 0.868000, 0.868381, 0.868761, 0.869140, 0.869519, 0.869898,
	0.870276, 0.870654, 0.871031, 0.871407, 0.871783, 0.872159, 0.872534, 0.872908,
	0.873282, 0.873655, 0.874028, 0.874401, 0.874773, 0.875144, 0.875515, 0.875885,
	0.876255, 0.876624, 0.876993, 0.877361, 0.877729, 0.878096, 0.878463, 0.878829,
	0.879195, 0.879560, 0.879925, 0.880289, 0.880653, 0.881016, 0.881378, 0.881740,
	0.882102, 0.882463, 0.882824, 0.883184, 0.883543, 0.883902, 0.884260, 0.884618,
	0.884976, 0.885333, 0.885689, 0.886045, 0.886400, 0.886755, 0.887109, 0.887463,
	0.887816, 0.888169, 0.888521, 0.888873, 0.889224, 0.889574, 0.889925, 0.890274,
	0.890623, 0.890972, 0.891320, 0.891667, 0.892014, 0.892361, 0.892706, 0.893052,
	0.893397, 0.893741, 0.894085, 0.894428, 0.894771, 0.895113, 0.895455, 0.895796,
	0.896137, 0.896477, 0.896816, 0.897155, 0.897494, 0.897832, 0.898169, 0.898506,
	0.898843, 0.899179, 0.899514, 0.899849, 0.900183, 0.900517, 0.900850, 0.901183,
	0.901515, 0.901847, 0.902178, 0.902508, 0.902838, 0.903168, 0.903497, 0.903825,
	0.904153, 0.904481, 0.904807, 0.905134, 0.905460, 0.905785, 0.906110, 0.906434,
	0.906757, 0.907081, 0.907403, 0.907725, 0.908047, 0.908368, 0.908688, 0.909008,
	0.909328, 0.909647, 0.909965, 0.910283, 0.910600, 0.910917, 0.911233, 0.911548,
	0.911864, 0.912178, 0.912492, 0.912806, 0.913119, 0.913431, 0.913743, 0.914054,
	0.914365, 0.914675, 0.914985, 0.915294, 0.915603, 0.915911, 0.916219, 0.916526,
	0.916832, 0.917138, 0.917444, 0.917749, 0.918053, 0.918357, 0.918660, 0.918963,
	0.919265, 0.919567, 0.919868, 0.920168, 0.920468, 0.920768, 0.921067, 0.921365,
	0.921663, 0.921960, 0.922257, 0.922553, 0.922849, 0.923144, 0.923439, 0.923733,
	0.924026, 0.924319, 0.924612, 0.924904, 0.925195, 0.925486, 0.925776, 0.926066,
	0.926355, 0.926643, 0.926931, 0.927219, 0.927506, 0.927792, 0.928078, 0.928364,
	0.928648, 0.928933, 0.929216, 0.929500, 0.929782, 0.930064, 0.930346, 0.930627,
	0.930907, 0.931187, 0.931466, 0.931745, 0.932023, 0.932301, 0.932578, 0.932855,
	0.933131, 0.933406, 0.933681, 0.933956, 0.934229, 0.934503, 0.934775, 0.935048,
	0.935319, 0.935590, 0.935861, 0.936131, 0.936400, 0.936669, 0.936938, 0.937205,
	0.937473, 0.937739, 0.938005, 0.938271, 0.938536, 0.938800, 0.939064, 0.939328,
	0.939591, 0.939853, 0.940115, 0.940376, 0.940636, 0.940896, 0.941156, 0.941415,
	0.941673, 0.941931, 0.942188, 0.942445, 0.942701, 0.942957, 0.943212, 0.943466,
	0.943720, 0.943974, 0.944227, 0.944479, 0.944731, 0.944982, 0.945232, 0.945483,
	0.945732, 0.945981, 0.946229, 0.946477, 0.946724, 0.946971, 0.947217, 0.947463,
	0.947708, 0.947953, 0.948196, 0.948440, 0.948683, 0.948925, 0.949167, 0.949408,
	0.949648, 0.949888, 0.950128, 0.950367, 0.950605, 0.950843, 0.951080, 0.951317,
	0.951553, 0.951789, 0.952024, 0.952258, 0.952492, 0.952725, 0.952958, 0.953190,
	0.953422, 0.953653, 0.953883, 0.954113, 0.954343, 0.954572, 0.954800, 0.955028,
	0.955255, 0.955481, 0.955707, 0.955933, 0.956158, 0.956382, 0.956606, 0.956829,
	0.957052, 0.957274, 0.957495, 0.957716, 0.957937, 0.958156, 0.958376, 0.958594,
	0.958812, 0.959030, 0.959247, 0.959463, 0.959679, 0.959895, 0.960109, 0.960324,
	0.960537, 0.960750, 0.960963, 0.961175, 0.961386, 0.961597, 0.961807, 0.962017,
	0.962226, 0.962434, 0.962642, 0.962850, 0.963057, 0.963263, 0.963469, 0.963674,
	0.963878, 0.964082, 0.964286, 0.964489, 0.964691, 0.964893, 0.965094, 0.965294,
	0.965494, 0.965694, 0.965893, 0.966091, 0.966289, 0.966486, 0.966683, 0.966879,
	0.967074, 0.967269, 0.967463, 0.967657, 0.967850, 0.968043, 0.968235, 0.968427,
	0.968617, 0.968808, 0.968998, 0.969187, 0.969375, 0.969564, 0.969751, 0.969938,
	0.970124, 0.970310, 0.970495, 0.970680, 0.970864, 0.971048, 0.971231, 0.971413,
	0.971595, 0.971776, 0.971957, 0.972137, 0.972316, 0.972495, 0.972673, 0.972851,
	0.973028, 0.973205, 0.973381, 0.973557, 0.973732, 0.973906, 0.974080, 0.974253,
	0.974426, 0.974598, 0.974769, 0.974940, 0.975110, 0.975280, 0.975449, 0.975618,
	0.975786, 0.975954, 0.976120, 0.976287, 0.976453, 0.976618, 0.976782, 0.976946,
	0.977110, 0.977273, 0.977435, 0.977597, 0.977758, 0.977918, 0.978078, 0.978238,
	0.978397, 0.978555, 0.978713, 0.978870, 0.979026, 0.979182, 0.979338, 0.979493,
	0.979647, 0.979800, 0.979954, 0.980106, 0.980258, 0.980409, 0.980560, 0.980710,
	0.980860, 0.981009, 0.981158, 0.981305, 0.981453, 0.981600, 0.981746, 0.981891,
	0.982036, 0.982181, 0.982325, 0.982468, 0.982611, 0.982753, 0.982894, 0.983035,
	0.983176, 0.983315, 0.983455, 0.983593, 0.983731, 0.983869, 0.984006, 0.984142,
	0.984278, 0.984413, 0.984548, 0.984682, 0.984815, 0.984948, 0.985080, 0.985212,
	0.985343, 0.985474, 0.985604, 0.985733, 0.985862, 0.985990, 0.986118, 0.986245,
	0.986371, 0.986497, 0.986623, 0.986747, 0.986871, 0.986995, 0.987118, 0.987240,
	0.987362, 0.987484, 0.987604, 0.987724, 0.987844, 0.987963, 0.988081, 0.988199,
	0.988316, 0.988433, 0.988549, 0.988664, 0.988779, 0.988893, 0.989007, 0.989120,
	0.989233, 0.989345, 0.989456, 0.989567, 0.989677, 0.989787, 0.989896, 0.990004,
	0.990112, 0.990219, 0.990326, 0.990432, 0.990538, 0.990643, 0.990747, 0.990851,
	0.990954, 0.991057, 0.991159, 0.991260, 0.991361, 0.991462, 0.991561, 0.991660,
	0.991759, 0.991857, 0.991954, 0.992051, 0.992147, 0.992243, 0.992338, 0.992433,
	0.992526, 0.992620, 0.992712, 0.992805, 0.992896, 0.992987, 0.993077, 0.993167,
	0.993256, 0.993345, 0.993433, 0.993521, 0.993608, 0.993694, 0.993779, 0.993865,
	0.993949, 0.994033, 0.994116, 0.994199, 0.994281, 0.994363, 0.994444, 0.994525,
	0.994604, 0.994684, 0.994762, 0.994841, 0.994918, 0.994995, 0.995071, 0.995147,
	0.995222, 0.995297, 0.995371, 0.995444, 0.995517, 0.995589, 0.995661, 0.995732,
	0.995803, 0.995872, 0.995942, 0.996011, 0.996079, 0.996146, 0.996213, 0.996280,
	0.996345, 0.996411, 0.996475, 0.996539, 0.996603, 0.996666, 0.996728, 0.996790,
	0.996851, 0.996911, 0.996971, 0.997031, 0.997089, 0.997148, 0.997205, 0.997262,
	0.997319, 0.997374, 0.997430, 0.997484, 0.997538, 0.997592, 0.997645, 0.997697,
	0.997749, 0.997800, 0.997851, 0.997901, 0.997950, 0.997999, 0.998047, 0.998094,
	0.998142, 0.998188, 0.998234, 0.998279, 0.998324, 0.998368, 0.998411, 0.998454,
	0.998497, 0.998538, 0.998580, 0.998620, 0.998660, 0.998700, 0.998738, 0.998777,
	0.998814, 0.998851, 0.998888, 0.998924, 0.998959, 0.998994, 0.999028, 0.999061,
	0.999094, 0.999126, 0.999158, 0.999189, 0.999220, 0.999250, 0.999279, 0.999308,
	0.999336, 0.999364, 0.999391, 0.999418, 0.999443, 0.999469, 0.999493, 0.999518,
	0.999541, 0.999564, 0.999586, 0.999608, 0.999629, 0.999650, 0.999670, 0.999689,
	0.999708, 0.999726, 0.999744, 0.999761, 0.999778, 0.999793, 0.999809, 0.999823,
	0.999838, 0.999851, 0.999864, 0.999876, 0.999888, 0.999899, 0.999910, 0.999920,
	0.999929, 0.999938, 0.999946, 0.999954, 0.999961, 0.999968, 0.999973, 0.999979,
	0.999983, 0.999988, 0.999991, 0.999994, 0.999996, 0.999998, 0.999999, 1.000000
};

static const float sineWindow4096[4096] = {
	0.000192, 0.000575, 0.000959, 0.001342, 0.001726, 0.002109, 0.002493, 0.002876,
	0.003260, 0.003643, 0.004027, 0.004410, 0.004794, 0.005177, 0.005561, 0.005944,
	0.006328, 0.006711, 0.007095, 0.007478, 0.007862, 0.008245, 0.008629, 0.009012,
	0.009395, 0.009779, 0.010162, 0.010546, 0.010929, 0.011313, 0.011696, 0.012080,
	0.012463, 0.012847, 0.013230, 0.013614, 0.013997, 0.014381, 0.014764, 0.015147,
	0.015531, 0.015914, 0.016298, 0.016681, 0.017065, 0.017448, 0.017832, 0.018215,
	0.018598, 0.018982, 0.019365, 0.019749, 0.020132, 0.020516, 0.020899, 0.021282,
	0.021666, 0.022049, 0.022433, 0.022816, 0.023199, 0.023583, 0.023966, 0.024350,
	0.024733, 0.025116, 0.025500, 0.025883, 0.026266, 0.026650, 0.027033, 0.027416,
	0.027800, 0.028183, 0.028567, 0.028950, 0.029333, 0.029717, 0.030100, 0.030483,
	0.030866, 0.031250, 0.031633, 0.032016, 0.032400, 0.032783, 0.033166, 0.033550,
	0.033933, 0.034316, 0.034699, 0.035083, 0.035466, 0.035849, 0.036232, 0.036616,
	0.036999, 0.037382, 0.037765, 0.038149, 0.038532, 0.038915, 0.039298, 0.039681,
	0.040065, 0.040448, 0.040831, 0.041214, 0.041597, 0.041980, 0.042364, 0.042747,
	0.043130, 0.043513, 0.043896, 0.044279, 0.044662, 0.045045, 0.045429, 0.045812,
	0.046195, 0.046578, 0.046961, 0.047344, 0.047727, 0.048110, 0.048493, 0.048876,
	0.049259, 0.049642, 0.050025, 0.050408, 0.050791, 0.051174, 0.051557, 0.051940,
	0.052323, 0.052706, 0.053089, 0.053472, 0.053855, 0.054238, 0.054621, 0.055004,
	0.055387, 0.055770, 0.056152, 0.056535, 0.056918, 0.057301, 0.057684, 0.058067,
	0.058450, 0.058833, 0.059215, 0.059598, 0.059981, 0.060364, 0.060747, 0.061129,
	0.061512, 0.061895, 0.062278, 0.062660, 0.063043, 0.063426, 0.063809, 0.064191,
	0.064574, 0.064957, 0.065339, 0.065722, 0.066105, 0.066487, 0.066870, 0.067253,
	0.067635, 0.068018, 0.068400, 0.068783, 0.069166, 0.069548, 0.069931, 0.070313,
	0.070696, 0.071078, 0.071461, 0.071843, 0.072226, 0.072608, 0.072991, 0.073373,
	0.073756, 0.074138, 0.074521, 0.074903, 0.075286, 0.075668, 0.076050, 0.076433,
	0.076815, 0.077197, 0.077580, 0.077962, 0.078344, 0.078727, 0.079109, 0.079491,
	0.079874, 0.080256, 0.080638, 0.081020, 0.081403, 0.081785, 0.082167, 0.082549,
	0.082931, 0.083314, 0.083696, 0.084078, 0.084460, 0.084842, 0.085224, 0.085606,
	0.085988, 0.086370, 0.086752, 0.087135, 0.087517, 0.087899, 0.088281, 0.088663,
	0.089045, 0.089427, 0.089808, 0.090190, 0.090572, 0.090954, 0.091336, 0.091718,
	0.092100, 0.092482, 0.092864, 0.093245, 0.093627, 0.094009, 0.094391, 0.094773,
	0.095154, 0.095536, 0.095918, 0.096300, 0.096681, 0.097063, 0.097445, 0.097826,
	0.098208, 0.098590, 0.098971, 0.099353, 0.099734, 0.100116, 0.100498, 0.100879,
	0.101261, 0.101642, 0.102024, 0.102405, 0.102787, 0.103168, 0.103550, 0.103931,
	0.104312, 0.104694, 0.105075, 0.105456, 0.105838, 0.106219, 0.106600, 0.106982,
	0.107363, 0.107744, 0.108126, 0.108507, 0.108888, 0.109269, 0.109650, 0.110032,
	0.110413, 0.110794, 0.111175, 0.111556, 0.111937, 0.112318, 0.112699, 0.113080,
	0.113461, 0.113842, 0.114223, 0.114604, 0.114985, 0.115366, 0.115747, 0.116128,
	0.116509, 0.116890, 0.117271, 0.117652, 0.118032, 0.118413, 0.118794, 0.119175,
	0.119556, 0.119936, 0.120317, 0.120698, 0.121078, 0.121459, 0.121840, 0.122220,
	0.122601, 0.122982, 0.123362, 0.123743, 0.124123, 0.124504, 0.124884, 0.125265,
	0.125645, 0.126026, 0.126406, 0.126787, 0.127167, 0.127547, 0.127928, 0.128308,
	0.128688, 0.129069, 0.129449, 0.129829, 0.130209, 0.130590, 0.130970, 0.131350,
	0.131730, 0.132110, 0.132490, 0.132870, 0.133251, 0.133631, 0.134011, 0.134391,
	0.134771, 0.135151, 0.135531, 0.135911, 0.136291, 0.136670, 0.137050, 0.137430,
	0.137810, 0.138190, 0.138570, 0.138949, 0.139329, 0.139709, 0.140089, 0.140468,
	0.140848, 0.141228, 0.141607, 0.141987, 0.142367, 0.142746, 0.143126, 0.143505,
	0.143885, 0.144264, 0.144644, 0.145023, 0.145403, 0.145782, 0.146161, 0.146541,
	0.146920, 0.147299, 0.147679, 0.148058, 0.148437, 0.148817, 0.149196, 0.149575,
	0.149954, 0.150333, 0.150712, 0.151091, 0.151471, 0.151850, 0.152229, 0.152608,
	0.152987, 0.153366, 0.153745, 0.154124, 0.154502, 0.154881, 0.155260, 0.155639,
	0.156018, 0.156397, 0.156775, 0.157154, 0.157533, 0.157912, 0.158290, 0.158669,
	0.159047, 0.159426, 0.159805, 0.160183, 0.160562, 0.160940, 0.161319, 0.161697,
	0.162076, 0.162454, 0.162832, 0.163211, 0.163589, 0.163967, 0.164346, 0.164724,
	0.165102, 0.165480, 0.165859, 0.166237, 0.166615, 0.166993, 0.167371, 0.167749,
	0.168127, 0.168505, 0.168883, 0.169261, 0.169639, 0.170017, 0.170395, 0.170773,
	0.171151, 0.171529, 0.171906, 0.172284, 0.172662, 0.173040, 0.173417, 0.173795,
	0.174173, 0.174550, 0.174928, 0.175305, 0.175683, 0.176061, 0.176438, 0.176815,
	0.177193, 0.177570, 0.177948, 0.178325, 0.178702, 0.179080, 0.179457, 0.179834,
	0.180212, 0.180589, 0.180966, 0.181343, 0.181720, 0.182097, 0.182474, 0.182851,
	0.183228, 0.183605, 0.183982, 0.184359, 0.184736, 0.185113, 0.185490, 0.185867,
	0.186244, 0.186620, 0.186997, 0.187374, 0.187750, 0.188127, 0.188504, 0.188880,
	0.189257, 0.189634, 0.190010, 0.190387, 0.190763, 0.191139, 0.191516, 0.191892,
	0.192269, 0.192645, 0.193021, 0.193397, 0.193774, 0.194150, 0.194526, 0.194902,
	0.195278, 0.195654, 0.196031, 0.196407, 0.196783, 0.197159, 0.197535, 0.197910,
	0.198286, 0.198662, 0.199038, 0.199414, 0.199790, 0.200165, 0.200541, 0.200917,
	0.201292, 0.201668, 0.202044, 0.202419, 0.202795, 0.203170, 0.203546, 0.203921,
	0.204297, 0.204672, 0.205047, 0.205423, 0.205798, 0.206173, 0.206549, 0.206924,
	0.207299, 0.207674, 0.208049, 0.208424, 0.208799, 0.209174, 0.209549, 0.209924,
	0.210299, 0.210674, 0.211049, 0.211424, 0.211799, 0.212174, 0.212548, 0.212923,
	0.213298, 0.213672, 0.214047, 0.214422, 0.214796, 0.215171, 0.215545, 0.215920,
	0.216294, 0.216668, 0.217043, 0.217417, 0.217791, 0.218166, 0.218540, 0.218914,
	0.219288, 0.219662, 0.220037, 0.220411, 0.220785, 0.221159, 0.221533, 0.221907,
	0.222281, 0.222654, 0.223028, 0.223402, 0.223776, 0.224150, 0.224523, 0.224897,
	0.225271, 0.225644, 0.226018, 0.226392, 0.226765, 0.227139, 0.227512, 0.227885,
	0.228259, 0.228632, 0.229005, 0.229379, 0.229752, 0.230125, 0.230498, 0.230872,
	0.231245, 0.231618, 0.231991, 0.232364, 0.232737, 0.233110, 0.233483, 0.233856,
	0.234228, 0.234601, 0.234974, 0.235347, 0.235719, 0.236092, 0.236465, 0.236837,
	0.237210, 0.237582, 0.237955, 0.238327, 0.238700, 0.239072, 0.239445, 0.239817,
	0.240189, 0.240561, 0.240934, 0.241306, 0.241678, 0.242050, 0.242422, 0.242794,
	0.243166, 0.243538, 0.243910, 0.244282, 0.244654, 0.245026, 0.245397, 0.245769,
	0.246141, 0.246513, 0.246884, 0.247256, 0.247627, 0.247999, 0.248370, 0.248742,
	0.249113, 0.249485, 0.249856, 0.250227, 0.250599, 0.250970, 0.251341, 0.251712,
	0.252083, 0.252454, 0.252826, 0.253197, 0.253568, 0.253938, 0.254309, 0.254680,
	0.255051, 0.255422, 0.255793, 0.256163, 0.256534, 0.256905, 0.257275, 0.257646,
	0.258016, 0.258387, 0.258757, 0.259128, 0.259498, 0.259868, 0.260239, 0.260609,
	0.260979, 0.261349, 0.261720, 0.262090, 0.262460, 0.262830, 0.263200, 0.263570,
	0.263940, 0.264310, 0.264679, 0.265049, 0.265419, 0.265789, 0.266158, 0.266528,
	0.266898, 0.267267, 0.267637, 0.268006, 0.268376, 0.268745, 0.269114, 0.269484,
	0.269853, 0.270222, 0.270591, 0.270961, 0.271330, 0.271699, 0.272068, 0.272437,
	0.272806, 0.273175, 0.273544, 0.273913, 0.274281, 0.274650, 0.275019, 0.275387,
	0.275756, 0.276125, 0.276493, 0.276862, 0.277230, 0.277599, 0.277967, 0.278336,
	0.278704, 0.279072, 0.279440, 0.279809, 0.280177, 0.280545, 0.280913, 0.281281,
	0.281649, 0.282017, 0.282385, 0.282753, 0.283120, 0.283488, 0.283856, 0.284224,
	0.284591, 0.284959, 0.285327, 0.285694, 0.286062, 0.286429, 0.286796, 0.287164,
	0.287531, 0.287898, 0.288266, 0.288633, 0.289000, 0.289367, 0.289734, 0.290101,
	0.290468, 0.290835, 0.291202, 0.291569, 0.291936, 0.292302, 0.292669, 0.293036,
	0.293402, 0.293769, 0.294136, 0.294502, 0.294869, 0.295235, 0.295601, 0.295968,
	0.296334, 0.296700, 0.297066, 0.297433, 0.297799, 0.298165, 0.298531, 0.298897,
	0.299263, 0.299629, 0.299995, 0.300360, 0.300726, 0.301092, 0.301458, 0.301823,
	0.302189, 0.302554, 0.302920, 0.303285, 0.303651, 0.304016, 0.304381, 0.304747,
	0.305112, 0.305477, 0.305842, 0.306207, 0.306572, 0.306937, 0.307302, 0.307667,
	0.308032, 0.308397, 0.308762, 0.309126, 0.309491, 0.309856, 0.310220, 0.310585,
	0.310949, 0.311314, 0.311678, 0.312043, 0.312407, 0.312771, 0.313135, 0.313500,
	0.313864, 0.314228, 0.314592, 0.314956, 0.315320, 0.315684, 0.316048, 0.316411,
	0.316775, 0.317139, 0.317503, 0.317866, 0.318230, 0.318593, 0.318957, 0.319320,
	0.319684, 0.320047, 0.320410, 0.320774, 0.321137, 0.321500, 0.321863, 0.322226,
	0.322589, 0.322952, 0.323315, 0.323678, 0.324041, 0.324404, 0.324766, 0.325129,
	0.325492, 0.325854, 0.326217, 0.326579, 0.326942, 0.327304, 0.327666, 0.328029,
	0.328391, 0.328753, 0.329115, 0.329477, 0.329839, 0.330202, 0.330563, 0.330925,
	0.331287, 0.331649, 0.332011, 0.332373, 0.332734, 0.333096, 0.333457, 0.333819,
	0.334180, 0.334542, 0.334903, 0.335265, 0.335626, 0.335987, 0.336348, 0.336709,
	0.337070, 0.337431, 0.337792, 0.338153, 0.338514, 0.338875, 0.339236, 0.339597,
	0.339957, 0.340318, 0.340678, 0.341039, 0.341399, 0.341760, 0.342120, 0.342481,
	0.342841, 0.343201, 0.343561, 0.343921, 0.344281, 0.344642, 0.345001, 0.345361,
	0.345721, 0.346081, 0.346441, 0.346801, 0.347160, 0.347520, 0.347879, 0.348239,
	0.348598, 0.348958, 0.349317, 0.349676, 0.350036, 0.350395, 0.350754, 0.351113,
	0.351472, 0.351831, 0.352190, 0.352549, 0.352908, 0.353267, 0.353626, 0.353984,
	0.354343, 0.354701, 0.355060, 0.355418, 0.355777, 0.356135, 0.356494, 0.356852,
	0.357210, 0.357568, 0.357926, 0.358284, 0.358642, 0.359000, 0.359358, 0.359716,
	0.360074, 0.360432, 0.360789, 0.361147, 0.361505, 0.361862, 0.362220, 0.362577,
	0.362934, 0.363292, 0.363649, 0.364006, 0.364363, 0.364720, 0.365077, 0.365434,
	0.365791, 0.366148, 0.366505, 0.366862, 0.367219, 0.367575, 0.367932, 0.368289,
	0.368645, 0.369002, 0.369358, 0.369714, 0.370071, 0.370427, 0.370783, 0.371139,
	0.371495, 0.371851, 0.372207, 0.372563, 0.372919, 0.373275, 0.373631, 0.373986,
	0.374342, 0.374697, 0.375053, 0.375408, 0.375764, 0.376119, 0.376475, 0.376830,
	0.377185, 0.377540, 0.377895, 0.378250, 0.378605, 0.378960, 0.379315, 0.379670,
	0.380025, 0.380379, 0.380734, 0.381088, 0.381443, 0.381797, 0.382152, 0.382506,
	0.382861, 0.383215, 0.383569, 0.383923, 0.384277, 0.384631, 0.384985, 0.385339,
	0.385693, 0.386047, 0.386400, 0.386754, 0.387108, 0.387461, 0.387815, 0.388168,
	0.388522, 0.388875, 0.389228, 0.389582, 0.389935, 0.390288, 0.390641, 0.390994,
	0.391347, 0.391700, 0.392053, 0.392405, 0.392758, 0.393111, 0.393463, 0.393816,
	0.394168, 0.394521, 0.394873, 0.395225, 0.395578, 0.395930, 0.396282, 0.396634,
	0.396986, 0.397338, 0.397690, 0.398042, 0.398393, 0.398745, 0.399097, 0.399448,
	0.399800, 0.400151, 0.400503, 0.400854, 0.401206, 0.401557, 0.401908, 0.402259,
	0.402610, 0.402961, 0.403312, 0.403663, 0.404014, 0.404365, 0.404715, 0.405066,
	0.405417, 0.405767, 0.406118, 0.406468, 0.406818, 0.407169, 0.407519, 0.407869,
	0.408219, 0.408569, 0.408919, 0.409269, 0.409619, 0.409969, 0.410319, 0.410668,
	0.411018, 0.411368, 0.411717, 0.412067, 0.412416, 0.412765, 0.413115, 0.413464,
	0.413813, 0.414162, 0.414511, 0.414860, 0.415209, 0.415558, 0.415906, 0.416255,
	0.416604, 0.416952, 0.417301, 0.417650, 0.417998, 0.418346, 0.418695, 0.419043,
	0.419391, 0.419739, 0.420087, 0.420435, 0.420783, 0.421131, 0.421479, 0.421826,
	0.422174, 0.422522, 0.422869, 0.423217, 0.423564, 0.423912, 0.424259, 0.424606,
	0.424953, 0.425300, 0.425647, 0.425994, 0.426341, 0.426688, 0.427035, 0.427382,
	0.427728, 0.428075, 0.428422, 0.428768, 0.429114, 0.429461, 0.429807, 0.430153,
	0.430500, 0.430846, 0.431192, 0.431538, 0.431884, 0.432229, 0.432575, 0.432921,
	0.433267, 0.433612, 0.433958, 0.434303, 0.434649, 0.434994, 0.435339, 0.435685,
	0.436030, 0.436375, 0.436720, 0.437065, 0.437410, 0.437754, 0.438099, 0.438444,
	0.438789, 0.439133, 0.439478, 0.439822, 0.440166, 0.440511, 0.440855, 0.441199,
	0.441543, 0.441887, 0.442231, 0.442575, 0.442919, 0.443263, 0.443607, 0.443950,
	0.444294, 0.444637, 0.444981, 0.445324, 0.445668, 0.446011, 0.446354, 0.446697,
	0.447040, 0.447383, 0.447726, 0.448069, 0.448412, 0.448755, 0.449097, 0.449440,
	0.449783, 0.450125, 0.450467, 0.450810, 0.451152, 0.451494, 0.451836, 0.452179,
	0.452521, 0.452863, 0.453204, 0.453546, 0.453888, 0.454230, 0.454571, 0.454913,
	0.455254, 0.455596, 0.455937, 0.456278, 0.456620, 0.456961, 0.457302, 0.457643,
	0.457984, 0.458325, 0.458665, 0.459006, 0.459347, 0.459688, 0.460028, 0.460368,
	0.460709, 0.461049, 0.461390, 0.461730, 0.462070, 0.462410, 0.462750, 0.463090,
	0.463430, 0.463769, 0.464109, 0.464449, 0.464788, 0.465128, 0.465467, 0.465807,
	0.466146, 0.466485, 0.466825, 0.467164, 0.467503, 0.467842, 0.468181, 0.468519,
	0.468858, 0.469197, 0.469535, 0.469874, 0.470213, 0.470551, 0.470889, 0.471228,
	0.471566, 0.471904, 0.472242, 0.472580, 0.472918, 0.473256, 0.473594, 0.473931,
	0.474269, 0.474607, 0.474944, 0.475282, 0.475619, 0.475956, 0.476294, 0.476631,
	0.476968, 0.477305, 0.477642, 0.477979, 0.478315, 0.478652, 0.478989, 0.479325,
	0.479662, 0.479998, 0.480335, 0.480671, 0.481007, 0.481344, 0.481680, 0.482016,
	0.482352, 0.482688, 0.483023, 0.483359, 0.483695, 0.484031, 0.484366, 0.484702,
	0.485037, 0.485372, 0.485708, 0.486043, 0.486378, 0.486713, 0.487048, 0.487383,
	0.487718, 0.488052, 0.488387, 0.488722, 0.489056, 0.489391, 0.489725, 0.490059,
	0.490394, 0.490728, 0.491062, 0.491396, 0.491730, 0.492064, 0.492398, 0.492731,
	0.493065, 0.493399, 0.493732, 0.494066, 0.494399, 0.494732, 0.495066, 0.495399,
	0.495732, 0.496065, 0.496398, 0.496731, 0.497063, 0.497396, 0.497729, 0.498061,
	0.498394, 0.498726, 0.499059, 0.499391, 0.499723, 0.500055, 0.500387, 0.500719,
	0.501051, 0.501383, 0.501715, 0.502047, 0.502378, 0.502710, 0.503041, 0.503373,
	0.503704, 0.504035, 0.504366, 0.504698, 0.505029, 0.505360, 0.505690, 0.506021,
	0.506352, 0.506683, 0.507013, 0.507344, 0.507674, 0.508005, 0.508335, 0.508665,
	0.508995, 0.509325, 0.509655, 0.509985, 0.510315, 0.510645, 0.510974, 0.511304,
	0.511634, 0.511963, 0.512292, 0.512622, 0.512951, 0.513280, 0.513609, 0.513938,
	0.514267, 0.514596, 0.514925, 0.515254, 0.515582, 0.515911, 0.516239, 0.516568,
	0.516896, 0.517224, 0.517552, 0.517880, 0.518209, 0.518536, 0.518864, 0.519192,
	0.519520, 0.519848, 0.520175, 0.520503, 0.520830, 0.521157, 0.521485, 0.521812,
	0.522139, 0.522466, 0.522793, 0.523120, 0.523447, 0.523773, 0.524100, 0.524426,
	0.524753, 0.525079, 0.525406, 0.525732, 0.526058, 0.526384, 0.526710, 0.527036,
	0.527362, 0.527688, 0.528014, 0.528339, 0.528665, 0.528990, 0.529316, 0.529641,
	0.529966, 0.530291, 0.530616, 0.530941, 0.531266, 0.531591, 0.531916, 0.532241,
	0.532565, 0.532890, 0.533214, 0.533539, 0.533863, 0.534187, 0.534512, 0.534836,
	0.535160, 0.535484, 0.535807, 0.536131, 0.536455, 0.536778, 0.537102, 0.537425,
	0.537749, 0.538072, 0.538395, 0.538718, 0.539041, 0.539364, 0.539687, 0.540010,
	0.540333, 0.540655, 0.540978, 0.541301, 0.541623, 0.541945, 0.542268, 0.542590,
	0.542912, 0.543234, 0.543556, 0.543878, 0.544199, 0.544521, 0.544843, 0.545164,
	0.545486, 0.545807, 0.546128, 0.546450, 0.546771, 0.547092, 0.547413, 0.547734,
	0.548054, 0.548375, 0.548696, 0.549016, 0.549337, 0.549657, 0.549978, 0.550298,
	0.550618, 0.550938, 0.551258, 0.551578, 0.551898, 0.552218, 0.552537, 0.552857,
	0.553176, 0.553496, 0.553815, 0.554134, 0.554454, 0.554773, 0.555092, 0.555411,
	0.555730, 0.556048, 0.556367, 0.556686, 0.557004, 0.557323, 0.557641, 0.557959,
	0.558278, 0.558596, 0.558914, 0.559232, 0.559550, 0.559867, 0.560185, 0.560503,
	0.560820, 0.561138, 0.561455, 0.561773, 0.562090, 0.562407, 0.562724, 0.563041,
	0.563358, 0.563675, 0.563991, 0.564308, 0.564624, 0.564941, 0.565257, 0.565574,
	0.565890, 0.566206, 0.566522, 0.566838, 0.567154, 0.567470, 0.567786, 0.568101,
	0.568417, 0.568732, 0.569048, 0.569363, 0.569678, 0.569993, 0.570308, 0.570623,
	0.570938, 0.571253, 0.571568, 0.571882, 0.572197, 0.572511, 0.572826, 0.573140,
	0.573454, 0.573768, 0.574082, 0.574396, 0.574710, 0.575024, 0.575338, 0.575651,
	0.575965, 0.576278, 0.576592, 0.576905, 0.577218, 0.577531, 0.577844, 0.578157,
	0.578470, 0.578783, 0.579096, 0.579408, 0.579721, 0.580033, 0.580346, 0.580658,
	0.580970, 0.581282, 0.581594, 0.581906, 0.582218, 0.582530, 0.582841, 0.583153,
	0.583464, 0.583776, 0.584087, 0.584398, 0.584710, 0.585021, 0.585332, 0.585642,
	0.585953, 0.586264, 0.586575, 0.586885, 0.587196, 0.587506, 0.587816, 0.588126,
	0.588437, 0.588747, 0.589057, 0.589366, 0.589676, 0.589986, 0.590295, 0.590605,
	0.590914, 0.591224, 0.591533, 0.591842, 0.592151, 0.592460, 0.592769, 0.593078,
	0.593387, 0.593695, 0.594004, 0.594312, 0.594621, 0.594929, 0.595237, 0.595545,
	0.595853, 0.596161, 0.596469, 0.596777, 0.597085, 0.597392, 0.597700, 0.598007,
	0.598314, 0.598622, 0.598929, 0.599236, 0.599543, 0.599850, 0.600156, 0.600463,
	0.600770, 0.601076, 0.601383, 0.601689, 0.601995, 0.602302, 0.602608, 0.602914,
	0.603220, 0.603525, 0.603831, 0.604137, 0.604442, 0.604748, 0.605053, 0.605358,
	0.605664, 0.605969, 0.606274, 0.606579, 0.606884, 0.607188, 0.607493, 0.607798,
	0.608102, 0.608406, 0.608711, 0.609015, 0.609319, 0.609623, 0.609927, 0.610231,
	0.610535, 0.610838, 0.611142, 0.611445, 0.611749, 0.612052, 0.612355, 0.612659,
	0.612962, 0.613265, 0.613567, 0.613870, 0.614173, 0.614475, 0.614778, 0.615080,
	0.615383, 0.615685, 0.615987, 0.616289, 0.616591, 0.616893, 0.617195, 0.617496,
	0.617798, 0.618100, 0.618401, 0.618702, 0.619004, 0.619305, 0.619606, 0.619907,
	0.620208, 0.620508, 0.620809, 0.621110, 0.621410, 0.621711, 0.622011, 0.622311,
	0.622611, 0.622911, 0.623211, 0.623511, 0.623811, 0.624111, 0.624410, 0.624710,
	0.625009, 0.625309, 0.625608, 0.625907, 0.626206, 0.626505, 0.626804, 0.627102,
	0.627401, 0.627700, 0.627998, 0.628297, 0.628595, 0.628893, 0.629191, 0.629489,
	0.629787, 0.630085, 0.630383, 0.630680, 0.630978, 0.631275, 0.631573, 0.631870,
	0.632167, 0.632464, 0.632761, 0.633058, 0.633355, 0.633652, 0.633949, 0.634245,
	0.634541, 0.634838, 0.635134, 0.635430, 0.635726, 0.636022, 0.636318, 0.636614,
	0.636910, 0.637205, 0.637501, 0.637796, 0.638092, 0.638387, 0.638682, 0.638977,
	0.639272, 0.639567, 0.639862, 0.640156, 0.640451, 0.640745, 0.641040, 0.641334,
	0.641628, 0.641922, 0.642216, 0.642510, 0.642804, 0.643098, 0.643391, 0.643685,
	0.643978, 0.644272, 0.644565, 0.644858, 0.645151, 0.645444, 0.645737, 0.646030,
	0.646322, 0.646615, 0.646907, 0.647200, 0.647492, 0.647784, 0.648076, 0.648368,
	0.648660, 0.648952, 0.649244, 0.649536, 0.649827, 0.650118, 0.650410, 0.650701,
	0.650992, 0.651283, 0.651574, 0.651865, 0.652156, 0.652447, 0.652737, 0.653028,
	0.653318, 0.653608, 0.653898, 0.654189, 0.654479, 0.654769, 0.655058, 0.655348,
	0.655638, 0.655927, 0.656217, 0.656506, 0.656795, 0.657084, 0.657373, 0.657662,
	0.657951, 0.658240, 0.658529, 0.658817, 0.659106, 0.659394, 0.659682, 0.659970,
	0.660258, 0.660546, 0.660834, 0.661122, 0.661410, 0.661697, 0.661985, 0.662272,
	0.662559, 0.662847, 0.663134, 0.663421, 0.663708, 0.663994, 0.664281, 0.664568,
	0.664854, 0.665141, 0.665427, 0.665713, 0.665999, 0.666285, 0.666571, 0.666857,
	0.667143, 0.667428, 0.667714, 0.667999, 0.668285, 0.668570, 0.668855, 0.669140,
	0.669425, 0.669710, 0.669995, 0.670279, 0.670564, 0.670848, 0.671133, 0.671417,
	0.671701, 0.671985, 0.672269, 0.672553, 0.672837, 0.673120, 0.673404, 0.673687,
	0.673971, 0.674254, 0.674537, 0.674820, 0.675103, 0.675386, 0.675669, 0.675951,
	0.676234, 0.676516, 0.676799, 0.677081, 0.677363, 0.677645, 0.677927, 0.678209,
	0.678491, 0.678773, 0.679054, 0.679336, 0.679617, 0.679898, 0.680179, 0.680460,
	0.680741, 0.681022, 0.681303, 0.681584, 0.681864, 0.682145, 0.682425, 0.682705,
	0.682986, 0.683266, 0.683546, 0.683825, 0.684105, 0.684385, 0.684664, 0.684944,
	0.685223, 0.685503, 0.685782, 0.686061, 0.686340, 0.686619, 0.686897, 0.687176,
	0.687455, 0.687733, 0.688011, 0.688290, 0.688568, 0.688846, 0.689124, 0.689402,
	0.689679, 0.689957, 0.690235, 0.690512, 0.690789, 0.691067, 0.691344, 0.691621,
	0.691898, 0.692175, 0.692451, 0.692728, 0.693004, 0.693281, 0.693557, 0.693833,
	0.694109, 0.694386, 0.694661, 0.694937, 0.695213, 0.695489, 0.695764, 0.696039,
	0.696315, 0.696590, 0.696865, 0.697140, 0.697415, 0.697690, 0.697964, 0.698239,
	0.698513, 0.698788, 0.699062, 0.699336, 0.699610, 0.699884, 0.700158, 0.700432,
	0.700706, 0.700979, 0.701253, 0.701526, 0.701799, 0.702072, 0.702345, 0.702618,
	0.702891, 0.703164, 0.703436, 0.703709, 0.703981, 0.704254, 0.704526, 0.704798,
	0.705070, 0.705342, 0.705614, 0.705885, 0.706157, 0.706429, 0.706700, 0.706971,
	0.707242, 0.707513, 0.707784, 0.708055, 0.708326, 0.708597, 0.708867, 0.709138,
	0.709408, 0.709678, 0.709948, 0.710218, 0.710488, 0.710758, 0.711028, 0.711297,
	0.711567, 0.711836, 0.712106, 0.712375, 0.712644, 0.712913, 0.713182, 0.713450,
	0.713719, 0.713988, 0.714256, 0.714525, 0.714793, 0.715061, 0.715329, 0.715597,
	0.715865, 0.716132, 0.716400, 0.716668, 0.716935, 0.717202, 0.717469, 0.717737,
	0.718004, 0.718270, 0.718537, 0.718804, 0.719070, 0.719337, 0.719603, 0.719869,
	0.720136, 0.720402, 0.720667, 0.720933, 0.721199, 0.721465, 0.721730, 0.721996,
	0.722261, 0.722526, 0.722791, 0.723056, 0.723321, 0.723586, 0.723850, 0.724115,
	0.724379, 0.724644, 0.724908, 0.725172, 0.725436, 0.725700, 0.725964, 0.726227,
	0.726491, 0.726754, 0.727018, 0.727281, 0.727544, 0.727807, 0.728070, 0.728333,
	0.728596, 0.728858, 0.729121, 0.729383, 0.729646, 0.729908, 0.730170, 0.730432,
	0.730694, 0.730955, 0.731217, 0.731479, 0.731740, 0.732001, 0.732263, 0.732524,
	0.732785, 0.733046, 0.733306, 0.733567, 0.733828, 0.734088, 0.734349, 0.734609,
	0.734869, 0.735129, 0.735389, 0.735649, 0.735908, 0.736168, 0.736428, 0.736687,
	0.736946, 0.737205, 0.737464, 0.737723, 0.737982, 0.738241, 0.738500, 0.738758,
	0.739016, 0.739275, 0.739533, 0.739791, 0.740049, 0.740307, 0.740565, 0.740822,
	0.741080, 0.741337, 0.741595, 0.741852, 0.742109, 0.742366, 0.742623, 0.742880,
	0.743136, 0.743393, 0.743649, 0.743906, 0.744162, 0.744418, 0.744674, 0.744930,
	0.745186, 0.745441, 0.745697, 0.745952, 0.746208, 0.746463, 0.746718, 0.746973,
	0.747228, 0.747483, 0.747738, 0.747992, 0.748247, 0.748501, 0.748755, 0.749009,
	0.749263, 0.749517, 0.749771, 0.750025, 0.750278, 0.750532, 0.750785, 0.751039,
	0.751292, 0.751545, 0.751798, 0.752050, 0.752303, 0.752556, 0.752808, 0.753061,
	0.753313, 0.753565, 0.753817, 0.754069, 0.754321, 0.754573, 0.754824, 0.755076,
	0.755327, 0.755578, 0.755830, 0.756081, 0.756331, 0.756582, 0.756833, 0.757084,
	0.757334, 0.757584, 0.757835, 0.758085, 0.758335, 0.758585, 0.758835, 0.759084,
	0.759334, 0.759583, 0.759833, 0.760082, 0.760331, 0.760580, 0.760829, 0.761078,
	0.761327, 0.761575, 0.761824, 0.762072, 0.762320, 0.762569, 0.762817, 0.763065,
	0.763312, 0.763560, 0.763808, 0.764055, 0.764302, 0.764550, 0.764797, 0.765044,
	0.765291, 0.765538, 0.765784, 0.766031, 0.766277, 0.766524, 0.766770, 0.767016,
	0.767262, 0.767508, 0.767754, 0.767999, 0.768245, 0.768490, 0.768736, 0.768981,
	0.769226, 0.769471, 0.769716, 0.769960, 0.770205, 0.770450, 0.770694, 0.770938,
	0.771183, 0.771427, 0.771671, 0.771915, 0.772158, 0.772402, 0.772645, 0.772889,
	0.773132, 0.773375, 0.773618, 0.773861, 0.774104, 0.774347, 0.774589, 0.774832,
	0.775074, 0.775317, 0.775559, 0.775801, 0.776043, 0.776284, 0.776526, 0.776768,
	0.777009, 0.777251, 0.777492, 0.777733, 0.777974, 0.778215, 0.778456, 0.778696,
	0.778937, 0.779177, 0.779418, 0.779658, 0.779898, 0.780138, 0.780378, 0.780617,
	0.780857, 0.781097, 0.781336, 0.781575, 0.781814, 0.782053, 0.782292, 0.782531,
	0.782770, 0.783009, 0.783247, 0.783485, 0.783724, 0.783962, 0.784200, 0.784438,
	0.784675, 0.784913, 0.785151, 0.785388, 0.785625, 0.785863, 0.786100, 0.786337,
	0.786574, 0.786810, 0.787047, 0.787284, 0.787520, 0.787756, 0.787992, 0.788228,
	0.788464, 0.788700, 0.788936, 0.789172, 0.789407, 0.789642, 0.789878, 0.790113,
	0.790348, 0.790583, 0.790817, 0.791052, 0.791287, 0.791521, 0.791755, 0.791990,
	0.792224, 0.792458, 0.792691, 0.792925, 0.793159, 0.793392, 0.793626, 0.793859,
	0.794092, 0.794325, 0.794558, 0.794791, 0.795023, 0.795256, 0.795488, 0.795721,
	0.795953, 0.796185, 0.796417, 0.796649, 0.796881, 0.797112, 0.797344, 0.797575,
	0.797806, 0.798038, 0.798269, 0.798500, 0.798730, 0.798961, 0.799192, 0.799422,
	0.799652, 0.799883, 0.800113, 0.800343, 0.800573, 0.800802, 0.801032, 0.801261,
	0.801491, 0.801720, 0.801949, 0.802178, 0.802407, 0.802636, 0.802865, 0.803093,
	0.803322, 0.803550, 0.803778, 0.804006, 0.804234, 0.804462, 0.804690, 0.804918,
	0.805145, 0.805372, 0.805600, 0.805827, 0.806054, 0.806281, 0.806508, 0.806734,
	0.806961, 0.807187, 0.807414, 0.807640, 0.807866, 0.808092, 0.808318, 0.808543,
	0.808769, 0.808994, 0.809220, 0.809445, 0.809670, 0.809895, 0.810120, 0.810345,
	0.810570, 0.810794, 0.811018, 0.811243, 0.811467, 0.811691, 0.811915, 0.812139,
	0.812362, 0.812586, 0.812809, 0.813033, 0.813256, 0.813479, 0.813702, 0.813925,
	0.814148, 0.814370, 0.814593, 0.814815, 0.815037, 0.815260, 0.815482, 0.815704,
	0.815925, 0.816147, 0.816369, 0.816590, 0.816811, 0.817032, 0.817253, 0.817474,
	0.817695, 0.817916, 0.818136, 0.818357, 0.818577, 0.818797, 0.819018, 0.819238,
	0.819457, 0.819677, 0.819897, 0.820116, 0.820336, 0.820555, 0.820774, 0.820993,
	0.821212, 0.821431, 0.821649, 0.821868, 0.822086, 0.822305, 0.822523, 0.822741,
	0.822959, 0.823177, 0.823394, 0.823612, 0.823829, 0.824047, 0.824264, 0.824481,
	0.824698, 0.824915, 0.825131, 0.825348, 0.825564, 0.825781, 0.825997, 0.826213,
	0.826429, 0.826645, 0.826861, 0.827076, 0.827292, 0.827507, 0.827722, 0.827938,
	0.828153, 0.828367, 0.828582, 0.828797, 0.829011, 0.829226, 0.829440, 0.829654,
	0.829868, 0.830082, 0.830296, 0.830510, 0.830723, 0.830937, 0.831150, 0.831363,
	0.831576, 0.831789, 0.832002, 0.832215, 0.832427, 0.832640, 0.832852, 0.833064,
	0.833276, 0.833488, 0.833700, 0.833912, 0.834123, 0.834335, 0.834546, 0.834757,
	0.834968, 0.835179, 0.835390, 0.835601, 0.835812, 0.836022, 0.836232, 0.836443,
	0.836653, 0.836863, 0.837073, 0.837282, 0.837492, 0.837701, 0.837911, 0.838120,
	0.838329, 0.838538, 0.838747, 0.838956, 0.839165, 0.839373, 0.839581, 0.839790,
	0.839998, 0.840206, 0.840414, 0.840621, 0.840829, 0.841037, 0.841244, 0.841451,
	0.841659, 0.841866, 0.842072, 0.842279, 0.842486, 0.842692, 0.842899, 0.843105,
	0.843311, 0.843517, 0.843723, 0.843929, 0.844135, 0.844340, 0.844546, 0.844751,
	0.844956, 0.845161, 0.845366, 0.845571, 0.845776, 0.845980, 0.846185, 0.846389,
	0.846593, 0.846797, 0.847001, 0.847205, 0.847408, 0.847612, 0.847815, 0.848019,
	0.848222, 0.848425, 0.848628, 0.848831, 0.849033, 0.849236, 0.849438, 0.849641,
	0.849843, 0.850045, 0.850247, 0.850449, 0.850650, 0.850852, 0.851053, 0.851255,
	0.851456, 0.851657, 0.851858, 0.852059, 0.852259, 0.852460, 0.852660, 0.852860,
	0.853061, 0.853261, 0.853461, 0.853660, 0.853860, 0.854060, 0.854259, 0.854458,
	0.854658, 0.854857, 0.855056, 0.855254, 0.855453, 0.855651, 0.855850, 0.856048,
	0.856246, 0.856444, 0.856642, 0.856840, 0.857038, 0.857235, 0.857433, 0.857630,
	0.857827, 0.858024, 0.858221, 0.858418, 0.858615, 0.858811, 0.859007, 0.859204,
	0.859400, 0.859596, 0.859792, 0.859988, 0.860183, 0.860379, 0.860574, 0.860769,
	0.860965, 0.861160, 0.861354, 0.861549, 0.861744, 0.861938, 0.862133, 0.862327,
	0.862521, 0.862715, 0.862909, 0.863103, 0.863296, 0.863490, 0.863683, 0.863876,
	0.864069, 0.864262, 0.864455, 0.864648, 0.864841, 0.865033, 0.865225, 0.865418,
	0.865610, 0.865802, 0.865993, 0.866185, 0.866377, 0.866568, 0.866760, 0.866951,
	0.867142, 0.867333, 0.867524, 0.867714, 0.867905, 0.868095, 0.868285, 0.868476,
	0.868666, 0.868856, 0.869045, 0.869235, 0.869425, 0.869614, 0.869803, 0.869992,
	0.870181, 0.870370, 0.870559, 0.870748, 0.870936, 0.871125, 0.871313, 0.871501,
	0.871689, 0.871877, 0.872065, 0.872252, 0.872440, 0.872627, 0.872814, 0.873001,
	0.873188, 0.873375, 0.873562, 0.873749, 0.873935, 0.874121, 0.874308, 0.874494,
	0.874680, 0.874865, 0.875051, 0.875237, 0.875422, 0.875607, 0.875793, 0.875978,
	0.876163, 0.876347, 0.876532, 0.876716, 0.876901, 0.877085, 0.877269, 0.877453,
	0.877637, 0.877821, 0.878005, 0.878188, 0.878371, 0.878555, 0.878738, 0.878921,
	0.879104, 0.879286, 0.879469, 0.879651, 0.879834, 0.880016, 0.880198, 0.880380,
	0.880562, 0.880744, 0.880925, 0.881106, 0.881288, 0.881469, 0.881650, 0.881831,
	0.882012, 0.882192, 0.882373, 0.882553, 0.882733, 0.882914, 0.883094, 0.883273,
	0.883453, 0.883633, 0.883812, 0.883992, 0.884171, 0.884350, 0.884529, 0.884708,
	0.884886, 0.885065, 0.885243, 0.885422, 0.885600, 0.885778, 0.885956, 0.886134,
	0.886311, 0.886489, 0.886666, 0.886844, 0.887021, 0.887198, 0.887375, 0.887551,
	0.887728, 0.887904, 0.888081, 0.888257, 0.888433, 0.888609, 0.888785, 0.888961,
	0.889136, 0.889312, 0.889487, 0.889662, 0.889837, 0.890012, 0.890187, 0.890361,
	0.890536, 0.890710, 0.890885, 0.891059, 0.891233, 0.891407, 0.891580, 0.891754,
	0.891927, 0.892101, 0.892274, 0.892447, 0.892620, 0.892793, 0.892966, 0.893138,
	0.893310, 0.893483, 0.893655, 0.893827, 0.893999, 0.894171, 0.894342, 0.894514,
	0.894685, 0.894856, 0.895028, 0.895198, 0.895369, 0.895540, 0.895711, 0.895881,
	0.896051, 0.896222, 0.896392, 0.896562, 0.896731, 0.896901, 0.897071, 0.897240,
	0.897409, 0.897578, 0.897747, 0.897916, 0.898085, 0.898254, 0.898422, 0.898590,
	0.898759, 0.898927, 0.899095, 0.899262, 0.899430, 0.899598, 0.899765, 0.899932,
	0.900099, 0.900266, 0.900433, 0.900600, 0.900767, 0.900933, 0.901100, 0.901266,
	0.901432, 0.901598, 0.901764, 0.901929, 0.902095, 0.902260, 0.902426, 0.902591,
	0.902756, 0.902921, 0.903086, 0.903250, 0.903415, 0.903579, 0.903743, 0.903907,
	0.904071, 0.904235, 0.904399, 0.904562, 0.904726, 0.904889, 0.905052, 0.905215,
	0.905378, 0.905541, 0.905704, 0.905866, 0.906029, 0.906191, 0.906353, 0.906515,
	0.906677, 0.906838, 0.907000, 0.907161, 0.907323, 0.907484, 0.907645, 0.907806,
	0.907966, 0.908127, 0.908288, 0.908448, 0.908608, 0.908768, 0.908928, 0.909088,
	0.909248, 0.909407, 0.909567, 0.909726, 0.909885, 0.910044, 0.910203, 0.910362,
	0.910521, 0.910679, 0.910837, 0.910996, 0.911154, 0.911312, 0.911470, 0.911627,
	0.911785, 0.911942, 0.912099, 0.912257, 0.912414, 0.912571, 0.912727, 0.912884,
	0.913040, 0.913197, 0.913353, 0.913509, 0.913665, 0.913821, 0.913976, 0.914132,
	0.914287, 0.914443, 0.914598, 0.914753, 0.914908, 0.915062, 0.915217, 0.915372,
	0.915526, 0.915680, 0.915834, 0.915988, 0.916142, 0.916296, 0.916449, 0.916602,
	0.916756, 0.916909, 0.917062, 0.917215, 0.917367, 0.917520, 0.917672, 0.917825,
	0.917977, 0.918129, 0.918281, 0.918433, 0.918584, 0.918736, 0.918887, 0.919038,
	0.919189, 0.919340, 0.919491, 0.919642, 0.919792, 0.919943, 0.920093, 0.920243,
	0.920393, 0.920543, 0.920693, 0.920843, 0.920992, 0.921141, 0.921291, 0.921440,
	0.921588, 0.921737, 0.921886, 0.922035, 0.922183, 0.922331, 0.922479, 0.922627,
	0.922775, 0.922923, 0.923070, 0.923218, 0.923365, 0.923512, 0.923659, 0.923806,
	0.923953, 0.924100, 0.924246, 0.924392, 0.924539, 0.924685, 0.924831, 0.924976,
	0.925122, 0.925268, 0.925413, 0.925558, 0.925703, 0.925848, 0.925993, 0.926138,
	0.926283, 0.926427, 0.926571, 0.926715, 0.926859, 0.927003, 0.927147, 0.927291,
	0.927434, 0.927578, 0.927721, 0.927864, 0.928007, 0.928150, 0.928292, 0.928435,
	0.928577, 0.928720, 0.928862, 0.929004, 0.929146, 0.929287, 0.929429, 0.929570,
	0.929712, 0.929853, 0.929994, 0.930135, 0.930275, 0.930416, 0.930557, 0.930697,
	0.930837, 0.930977, 0.931117, 0.931257, 0.931397, 0.931536, 0.931675, 0.931815,
	0.931954, 0.932093, 0.932232, 0.932370, 0.932509, 0.932647, 0.932786, 0.932924,
	0.933062, 0.933200, 0.933337, 0.933475, 0.933613, 0.933750, 0.933887, 0.934024,
	0.934161, 0.934298, 0.934434, 0.934571, 0.934707, 0.934844, 0.934980, 0.935116,
	0.935251, 0.935387, 0.935523, 0.935658, 0.935793, 0.935928, 0.936063, 0.936198,
	0.936333, 0.936468, 0.936602, 0.936736, 0.936871, 0.937005, 0.937138, 0.937272,
	0.937406, 0.937539, 0.937673, 0.937806, 0.937939, 0.938072, 0.938205, 0.938337,
	0.938470, 0.938602, 0.938734, 0.938866, 0.938998, 0.939130, 0.939262, 0.939394,
	0.939525, 0.939656, 0.939787, 0.939918, 0.940049, 0.940180, 0.940310, 0.940441,
	0.940571, 0.940701, 0.940831, 0.940961, 0.941091, 0.941221, 0.941350, 0.941479,
	0.941609, 0.941738, 0.941867, 0.941995, 0.942124, 0.942253, 0.942381, 0.942509,
	0.942637, 0.942765, 0.942893, 0.943021, 0.943148, 0.943276, 0.943403, 0.943530,
	0.943657, 0.943784, 0.943910, 0.944037, 0.944163, 0.944290, 0.944416, 0.944542,
	0.944668, 0.944794, 0.944919, 0.945045, 0.945170, 0.945295, 0.945420, 0.945545,
	0.945670, 0.945794, 0.945919, 0.946043, 0.946167, 0.946291, 0.946415, 0.946539,
	0.946663, 0.946786, 0.946910, 0.947033, 0.947156, 0.947279, 0.947402, 0.947524,
	0.947647, 0.947769, 0.947891, 0.948014, 0.948136, 0.948257, 0.948379, 0.948501,
	0.948622, 0.948743, 0.948864, 0.948985, 0.949106, 0.949227, 0.949348, 0.949468,
	0.949588, 0.949709, 0.949829, 0.949948, 0.950068, 0.950188, 0.950307, 0.950427,
	0.950546, 0.950665, 0.950784, 0.950902, 0.951021, 0.951139, 0.951258, 0.951376,
	0.951494, 0.951612, 0.951730, 0.951847, 0.951965, 0.952082, 0.952199, 0.952317,
	0.952433, 0.952550, 0.952667, 0.952783, 0.952900, 0.953016, 0.953132, 0.953248,
	0.953364, 0.953480, 0.953595, 0.953710, 0.953826, 0.953941, 0.954056, 0.954171,
	0.954285, 0.954400, 0.954514, 0.954629, 0.954743, 0.954857, 0.954971, 0.955084,
	0.955198, 0.955311, 0.955425, 0.955538, 0.955651, 0.955764, 0.955876, 0.955989,
	0.956101, 0.956214, 0.956326, 0.956438, 0.956550, 0.956662, 0.956773, 0.956885,
	0.956996, 0.957107, 0.957218, 0.957329, 0.957440, 0.957550, 0.957661, 0.957771,
	0.957882, 0.957992, 0.958101, 0.958211, 0.958321, 0.958430, 0.958540, 0.958649,
	0.958758, 0.958867, 0.958976, 0.959084, 0.959193, 0.959301, 0.959409, 0.959518,
	0.959625, 0.959733, 0.959841, 0.959948, 0.960056, 0.960163, 0.960270, 0.960377,
	0.960484, 0.960591, 0.960697, 0.960804, 0.960910, 0.961016, 0.961122, 0.961228,
	0.961333, 0.961439, 0.961544, 0.961650, 0.961755, 0.961860, 0.961964, 0.962069,
	0.962174, 0.962278, 0.962382, 0.962486, 0.962590, 0.962694, 0.962798, 0.962902,
	0.963005, 0.963108, 0.963211, 0.963314, 0.963417, 0.963520, 0.963623, 0.963725,
	0.963827, 0.963929, 0.964031, 0.964133, 0.964235, 0.964337, 0.964438, 0.964539,
	0.964640, 0.964741, 0.964842, 0.964943, 0.965043, 0.965144, 0.965244, 0.965344,
	0.965444, 0.965544, 0.965644, 0.965744, 0.965843, 0.965942, 0.966042, 0.966141,
	0.966239, 0.966338, 0.966437, 0.966535, 0.966633, 0.966732, 0.966830, 0.966928,
	0.967025, 0.967123, 0.967220, 0.967318, 0.967415, 0.967512, 0.967609, 0.967705,
	0.967802, 0.967899, 0.967995, 0.968091, 0.968187, 0.968283, 0.968379, 0.968474,
	0.968570, 0.968665, 0.968760, 0.968855, 0.968950, 0.969045, 0.969140, 0.969234,
	0.969328, 0.969423, 0.969517, 0.969611, 0.969704, 0.969798, 0.969891, 0.969985,
	0.970078, 0.970171, 0.970264, 0.970357, 0.970449, 0.970542, 0.970634, 0.970726,
	0.970818, 0.970910, 0.971002, 0.971093, 0.971185, 0.971276, 0.971367, 0.971458,
	0.971549, 0.971640, 0.971731, 0.971821, 0.971911, 0.972002, 0.972092, 0.972182,
	0.972271, 0.972361, 0.972450, 0.972540, 0.972629, 0.972718, 0.972807, 0.972896,
	0.972984, 0.973073, 0.973161, 0.973249, 0.973337, 0.973425, 0.973513, 0.973601,
	0.973688, 0.973775, 0.973862, 0.973949, 0.974036, 0.974123, 0.974210, 0.974296,
	0.974383, 0.974469, 0.974555, 0.974641, 0.974726, 0.974812, 0.974897, 0.974983,
	0.975068, 0.975153, 0.975238, 0.975323, 0.975407, 0.975492, 0.975576, 0.975660,
	0.975744, 0.975828, 0.975912, 0.975995, 0.976079, 0.976162, 0.976245, 0.976328,
	0.976411, 0.976494, 0.976576, 0.976659, 0.976741, 0.976823, 0.976905, 0.976987,
	0.977069, 0.977151, 0.977232, 0.977313, 0.977394, 0.977475, 0.977556, 0.977637,
	0.977718, 0.977798, 0.977878, 0.977959, 0.978038, 0.978118, 0.978198, 0.978278,
	0.978357, 0.978436, 0.978516, 0.978594, 0.978673, 0.978752, 0.978831, 0.978909,
	0.978987, 0.979065, 0.979143, 0.979221, 0.979299, 0.979376, 0.979454, 0.979531,
	0.979608, 0.979685, 0.979762, 0.979839, 0.979915, 0.979992, 0.980068, 0.980144,
	0.980220, 0.980296, 0.980372, 0.980447, 0.980523, 0.980598, 0.980673, 0.980748,
	0.980823, 0.980897, 0.980972, 0.981046, 0.981121, 0.981195, 0.981269, 0.981342,
	0.981416, 0.981490, 0.981563, 0.981636, 0.981709, 0.981782, 0.981855, 0.981928,
	0.982000, 0.982072, 0.982145, 0.982217, 0.982289, 0.982360, 0.982432, 0.982504,
	0.982575, 0.982646, 0.982717, 0.982788, 0.982859, 0.982930, 0.983000, 0.983070,
	0.983141, 0.983211, 0.983281, 0.983350, 0.983420, 0.983489, 0.983559, 0.983628,
	0.983697, 0.983766, 0.983835, 0.983903, 0.983972, 0.984040, 0.984108, 0.984176,
	0.984244, 0.984312, 0.984379, 0.984447, 0.984514, 0.984581, 0.984648, 0.984715,
	0.984782, 0.984848, 0.984915, 0.984981, 0.985047, 0.985113, 0.985179, 0.985245,
	0.985310, 0.985376, 0.985441, 0.985506, 0.985571, 0.985636, 0.985701, 0.985765,
	0.985830, 0.985894, 0.985958, 0.986022, 0.986086, 0.986150, 0.986213, 0.986276,
	0.986340, 0.986403, 0.986466, 0.986529, 0.986591, 0.986654, 0.986716, 0.986778,
	0.986840, 0.986902, 0.986964, 0.987026, 0.987087, 0.987149, 0.987210, 0.987271,
	0.987332, 0.987393, 0.987453, 0.987514, 0.987574, 0.987634, 0.987694, 0.987754,
	0.987814, 0.987874, 0.987933, 0.987992, 0.988052, 0.988111, 0.988169, 0.988228,
	0.988287, 0.988345, 0.988404, 0.988462, 0.988520, 0.988578, 0.988635, 0.988693,
	0.988750, 0.988808, 0.988865, 0.988922, 0.988979, 0.989035, 0.989092, 0.989148,
	0.989205, 0.989261, 0.989317, 0.989373, 0.989428, 0.989484, 0.989539, 0.989594,
	0.989650, 0.989705, 0.989759, 0.989814, 0.989869, 0.989923, 0.989977, 0.990031,
	0.990085, 0.990139, 0.990193, 0.990246, 0.990299, 0.990353, 0.990406, 0.990459,
	0.990511, 0.990564, 0.990617, 0.990669, 0.990721, 0.990773, 0.990825, 0.990877,
	0.990928, 0.990980, 0.991031, 0.991082, 0.991133, 0.991184, 0.991235, 0.991286,
	0.991336, 0.991386, 0.991437, 0.991487, 0.991536, 0.991586, 0.991636, 0.991685,
	0.991734, 0.991783, 0.991832, 0.991881, 0.991930, 0.991979, 0.992027, 0.992075,
	0.992123, 0.992171, 0.992219, 0.992267, 0.992314, 0.992362, 0.992409, 0.992456,
	0.992503, 0.992550, 0.992596, 0.992643, 0.992689, 0.992736, 0.992782, 0.992828,
	0.992873, 0.992919, 0.992964, 0.993010, 0.993055, 0.993100, 0.993145, 0.993190,
	0.993234, 0.993279, 0.993323, 0.993367, 0.993411, 0.993455, 0.993499, 0.993542,
	0.993586, 0.993629, 0.993672, 0.993715, 0.993758, 0.993801, 0.993843, 0.993886,
	0.993928, 0.993970, 0.994012, 0.994054, 0.994096, 0.994137, 0.994179, 0.994220,
	0.994261, 0.994302, 0.994343, 0.994383, 0.994424, 0.994464, 0.994505, 0.994545,
	0.994585, 0.994624, 0.994664, 0.994703, 0.994743, 0.994782, 0.994821, 0.994860,
	0.994899, 0.994937, 0.994976, 0.995014, 0.995052, 0.995090, 0.995128, 0.995166,
	0.995203, 0.995241, 0.995278, 0.995315, 0.995352, 0.995389, 0.995426, 0.995463,
	0.995499, 0.995535, 0.995571, 0.995607, 0.995643, 0.995679, 0.995714, 0.995750,
	0.995785, 0.995820, 0.995855, 0.995890, 0.995925, 0.995959, 0.995993, 0.996028,
	0.996062, 0.996096, 0.996129, 0.996163, 0.996197, 0.996230, 0.996263, 0.996296,
	0.996329, 0.996362, 0.996394, 0.996427, 0.996459, 0.996491, 0.996523, 0.996555,
	0.996587, 0.996619, 0.996650, 0.996681, 0.996712, 0.996743, 0.996774, 0.996805,
	0.996836, 0.996866, 0.996896, 0.996926, 0.996956, 0.996986, 0.997016, 0.997045,
	0.997075, 0.997104, 0.997133, 0.997162, 0.997191, 0.997219, 0.997248, 0.997276,
	0.997305, 0.997333, 0.997361, 0.997388, 0.997416, 0.997443, 0.997471, 0.997498,
	0.997525, 0.997552, 0.997579, 0.997605, 0.997632, 0.997658, 0.997684, 0.997710,
	0.997736, 0.997762, 0.997787, 0.997813, 0.997838, 0.997863, 0.997888, 0.997913,
	0.997938, 0.997962, 0.997987, 0.998011, 0.998035, 0.998059, 0.998083, 0.998106,
	0.998130, 0.998153, 0.998176, 0.998200, 0.998222, 0.998245, 0.998268, 0.998290,
	0.998313, 0.998335, 0.998357, 0.998379, 0.998401, 0.998422, 0.998444, 0.998465,
	0.998486, 0.998507, 0.998528, 0.998549, 0.998569, 0.998590, 0.998610, 0.998630,
	0.998650, 0.998670, 0.998690, 0.998709, 0.998729, 0.998748, 0.998767, 0.998786,
	0.998805, 0.998824, 0.998842, 0.998860, 0.998879, 0.998897, 0.998915, 0.998932,
	0.998950, 0.998968, 0.998985, 0.999002, 0.999019, 0.999036, 0.999053, 0.999069,
	0.999086, 0.999102, 0.999118, 0.999134, 0.999150, 0.999166, 0.999182, 0.999197,
	0.999212, 0.999228, 0.999243, 0.999257, 0.999272, 0.999287, 0.999301, 0.999315,
	0.999329, 0.999343, 0.999357, 0.999371, 0.999384, 0.999398, 0.999411, 0.999424,
	0.999437, 0.999450, 0.999462, 0.999475, 0.999487, 0.999500, 0.999512, 0.999524,
	0.999535, 0.999547, 0.999558, 0.999570, 0.999581, 0.999592, 0.999603, 0.999614,
	0.999624, 0.999635, 0.999645, 0.999655, 0.999665, 0.999675, 0.999685, 0.999694,
	0.999704, 0.999713, 0.999722, 0.999731, 0.999740, 0.999748, 0.999757, 0.999765,
	0.999774, 0.999782, 0.999790, 0.999797, 0.999805, 0.999812, 0.999820, 0.999827,
	0.999834, 0.999841, 0.999848, 0.999854, 0.999861, 0.999867, 0.999873, 0.999879,
	0.999885, 0.999891, 0.999897, 0.999902, 0.999907, 0.999913, 0.999917, 0.999922,
	0.999927, 0.999932, 0.999936, 0.999940, 0.999944, 0.999948, 0.999952, 0.999956,
	0.999959, 0.999963, 0.999966, 0.999969, 0.999972, 0.999975, 0.999977, 0.999980,
	0.999982, 0.999985, 0.999987, 0.999988, 0.999990, 0.999992, 0.999993, 0.999995,
	0.999996, 0.999997, 0.999998, 0.999999, 0.999999, 1.000000, 1.000000, 1.000000
};

static const float *sineWindows[13] = {
	0             , 0             , 0             , 0            , 0            ,
	sineWindow32  , sineWindow64  , sineWindow128 , sineWindow256, sineWindow512,
	sineWindow1024, sineWindow2048, sineWindow4096
};

const float *getSineWindow(int bits) {
	assert((bits >= 5) && (bits <= 12));

	return sineWindows[bits];
}

} // End of namespace Common
