#
# SchoolTool - common information systems platform for school administration
# Copyright (c) 2005 Shuttleworth Foundation
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
"""
Unit tests for schooltool.intervention

"""

import unittest
import doctest

from zope.annotation.interfaces import IAnnotatable
from zope.app.testing import setup
from zope.component import provideAdapter, Interface

from schooltool.app.app import getSchoolToolApplication
from schooltool.basicperson.interfaces import IBasicPerson
from schooltool.contact.basicperson import getBoundContact
from schooltool.contact.basicperson import getPersonOfBoundContact
from schooltool.contact.contact import Contactable
from schooltool.relationship.interfaces import IRelationshipLinks
from schooltool.relationship.annotatable import getRelationshipLinks
from schooltool.schoolyear.schoolyear import getSchoolYearContainer
from schooltool.term.interfaces import ITermContainer
from schooltool.term.term import getTermContainer
from schooltool.term.term import getSchoolYearForTerm

from schooltool.intervention import interfaces, adapters

optionflags = (doctest.ELLIPSIS|doctest.REPORT_ONLY_FIRST_FAILURE|
               doctest.NORMALIZE_WHITESPACE)

def setUp(test):
    setup.placefulSetUp()
    provideAdapter(getSchoolToolApplication)
    provideAdapter(getTermContainer, [Interface], ITermContainer)
    provideAdapter(getSchoolYearForTerm)
    provideAdapter(getSchoolYearContainer)
    provideAdapter(getRelationshipLinks, (IAnnotatable,), IRelationshipLinks)
    provideAdapter(factory=Contactable, adapts=[IBasicPerson])
    provideAdapter(factory=getBoundContact, adapts=[None])
    provideAdapter(getPersonOfBoundContact)

    provideAdapter(adapters.getInterventionRoot)
    provideAdapter(adapters.getSchoolYearInterventionSchoolYear)
    provideAdapter(adapters.getSchoolToolApplicationInterventionSchoolYear)
    provideAdapter(adapters.getInterventionSchoolYearSchoolYear)
    provideAdapter(adapters.getMarkerInterventionStudent)
    provideAdapter(adapters.getStudentYearInterventionStudent)
    provideAdapter(adapters.getStudentInterventionStudent)
    provideAdapter(adapters.getInterventionStudentStudent)
    provideAdapter(adapters.getInterventionMessagesStudent)
    provideAdapter(adapters.getInterventionMessageStudent)
    provideAdapter(adapters.getInterventionGoalsStudent)
    provideAdapter(adapters.getInterventionGoalStudent)

def tearDown(test):
    setup.placefulTearDown()

def test_suite():
    return unittest.TestSuite([
         doctest.DocFileSuite('../README.txt', 
         setUp=setUp, tearDown=tearDown, 
         optionflags=optionflags),
         ])

if __name__ == '__main__':
    unittest.main(defaultTest='test_suite')

