#
#
#!/usr/bin/ruby

#
# Cu diagram.rb ۂɎgpgp
#
# ====================================================================
# ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
# ====================================================================
# 
#    Project              : SagCAD
#    Description          : Script
#    Source               : sample_diagram.rb
# 
#    ----------------------------------
# 
#    License              : GNU General Public License (GPL)
#    Copyright            : (C) 1998-2003 by Yutaka Sagiya
#    email                : kappa@a6s.highway.ne.jp
#                         : yutaka@sagiya.com
#    Begin                : 2003/05/21
#    Last                 : 2003/05/25
# ====================================================================
include Math							# ZpCuǂݍ
require "diagram.rb"



# -------------------------------------------------------------------
# px̒PʂAx (DEG) 烉WA (RAD) ɕϊeXg
# x  RAD
#
def degrad_test

	print "----- < degrad Test Staret > -----\n"
	print "x (DEG) 烉WA (RAD) ɕϊ\n"
	print "px (Deg) ͂ĂB\n"
	gets
	value = $_.to_f

	print value," (deg) = ",degrad(value)," (Rad)\n"
	print "----- < degrad Test End > -----\n"
	return 1
end



# -------------------------------------------------------------------
# px̒PʂAWA (RAD) x (DEG) x (DEG) ɕϊeXg
# RAD  x
#
def raddeg_test

	print "----- < raddeg Test Staret > -----\n"
	print "WA (RAD) x (DEG) x (DEG) ɕϊ\n"
	print "px (Rad) ͂ĂB\n"
	gets
	value = $_.to_f

	print value," (rad) = ",raddeg(value)," (deg)\n"
	print "----- < raddeg Test End > -----\n"
	return 1
end



# -------------------------------------------------------------------
# n_ƏI_Ԑ sx[2] : ex[2] ɓ_߂̃eXg
#
def ppp_test
	diagram = Diagram.new

	print "----- < ppp Test Start > -----\n"
	print "n_ƏI_Ԑ n : m ɓ_߂܂\n"
	print "n_X ͂ĂB>\n"
	gets
	sx = $_.to_f
	print "n_Y ͂ĂB>\n"
	gets
	sy = $_.to_f
	print "I_X ͂ĂB>\n"
	gets
	ex = $_.to_f
	print "I_Y ͂ĂB>\n"
	gets
	ey = $_.to_f
	print "n_̔䗦͂ĂB>\n"
	gets
	left = $_.to_f
	print "I_̔䗦͂ĂB>\n"
	gets
	right = $_.to_f


	diagram.sx[1] = sx
	diagram.sy[1] = sy
	diagram.ex[1] = ex
	diagram.ey[1] = ey

	diagram.sx[2] = left
	diagram.ex[2] = right
	
	diagram.ppp

	print " Ans = (",diagram.sx[3],",",diagram.sy[3],")\n"
	print "----- < ppp Test End > -----\n"
	return 1
end



# -------------------------------------------------------------------
# ̊px̃eXg
#
def la_test
	diagram = Diagram.new

	print "----- < la Test Start > -----\n"
	print "̊px߂܂\n"
	print "n_X ͂ĂB>\n"
	gets
	sx = $_.to_f
	print "n_Y ͂ĂB>\n"
	gets
	sy = $_.to_f
	print "I_X ͂ĂB>\n"
	gets
	ex = $_.to_f
	print "I_Y ͂ĂB>\n"
	gets
	ey = $_.to_f


	diagram.sx[1] = sx
	diagram.sy[1] = sy
	diagram.ex[1] = ex
	diagram.ey[1] = ey

	diagram.la

	print " Ans = ",diagram.Angle,"x\n"
	print "----- < la Test End > -----\n"
end



# -------------------------------------------------------------------
# n_ƊpxƋŒ̏I_߂̃eXg
#
def pap_test
	diagram = Diagram.new

	print "----- < pap Test Start > -----\n"
	print "n_ƊpxƋŒ̏I_߂܂\n"
	print "_X ͂ĂB\n"
	gets
	sx = $_.to_f
	print "_Y ͂ĂB\n"
	gets
	sy = $_.to_f
	print "px͂ĂB\n"
	gets
	angle = $_.to_f
	print "͂ĂB\n"
	gets
	length = $_.to_f


	diagram.sx[1] = sx
	diagram.sy[1] = sy
	diagram.Angle = angle
	diagram.Length = length

	diagram.pap

	print " Ans = (",diagram.ex[1]," , ",diagram.ey[1],"\n"
	print "----- < pap Test End > -----\n"
end



# -------------------------------------------------------------------
# Q_Ԃ̋߂̃eXg
#
def pp_test
	diagram = Diagram.new

	print "----- < pp Test Start > -----\n"
	print "Q_Ԃ̋߂܂\n"
	print "_1X ͂ĂB\n"
	gets
	sx = $_.to_f
	print "_1Y ͂ĂB\n"
	gets
	sy = $_.to_f
	print "_2X ͂ĂB\n"
	gets
	ex = $_.to_f
	print "_2Y ͂ĂB\n"
	gets
	ey = $_.to_f


	diagram.sx[1] = sx
	diagram.sy[1] = sy
	diagram.ex[1] = ex
	diagram.ey[1] = ey

	diagram.pp

	print " Ans = ",diagram.Length,"\n"
	print "----- < pp Test End > -----\n"
end





# -------------------------------------------------------------------
# ̃ItZbg̃eXg
#
def lo_test
	# -------------------------------------------------------------------
	# ̃ItZbg
	# 
	#  : 
	#      :     (@sx[1] , @sy[1]) - (@ex[1] , @ey[1])
	#      :    @Length
	# ߒl : 
	#      :     (@sx[2] , @sy[2]) - (@ex[2] , @ey[2]) is  
	#      :     (@sx[3] , @sy[3]) - (@ex[3] , @ey[3]) is  E

	diagram = Diagram.new

	print "----- < lo Test Start > -----\n"
	print "̃ItZbg߂܂\n"
	print "n_X ͂ĂB\n"
	gets
	sx = $_.to_f
	print "n_Y ͂ĂB\n"
	gets
	sy = $_.to_f
	print "I_X ͂ĂB\n"
	gets
	ex = $_.to_f
	print "I_Y ͂ĂB\n"
	gets
	ey = $_.to_f
	print "ItZbg钷͂ĂB\n"
	gets
	length = $_.to_f


	diagram.sx[1] = sx
	diagram.sy[1] = sy
	diagram.ex[1] = ex
	diagram.ey[1] = ey
	diagram.Length = length

	diagram.lo

	print " Ans = is (",sg(diagram.sx[2],10)," , ",diagram.sy[2],") - (",diagram.ex[2]," , ",diagram.ey[2],")\n"
	print " Ans = isE (",sg(diagram.sx[3], 10)," , ",diagram.sy[3],") - (",diagram.ex[3]," , ",diagram.ey[3],")\n"
	print "----- < lo Test End > -----\n"
end





# -------------------------------------------------------------------
# Q̌_̃eXg
#
def llp_test
	# -------------------------------------------------------------------
	# Q̌_
	# 
	#  : 
	#      : 1   (@sx[1] , @sy[1]) - (@ex[1] , @ey[1])
	#      : 2   (@sx[2] , @sy[2]) - (@ex[2] , @ey[2])
	# ߒl : 
	#      : @Type = 1:I   0:G[
	#      : _  (@sx[3] , @sy[3])

	diagram = Diagram.new

	print "----- < llp Test Start > -----\n"
	print "Q̌_߂܂\n"
	print "1n_X ͂ĂB\n"
	gets
	sx1 = $_.to_f
	print "1n_Y ͂ĂB\n"
	gets
	sy1 = $_.to_f
	print "1I_X ͂ĂB\n"
	gets
	ex1 = $_.to_f
	print "1I_Y ͂ĂB\n"
	gets
	ey1 = $_.to_f

	print "2n_X ͂ĂB\n"
	gets
	sx2 = $_.to_f
	print "2n_Y ͂ĂB\n"
	gets
	sy2 = $_.to_f
	print "2I_X ͂ĂB\n"
	gets
	ex2 = $_.to_f
	print "2I_Y ͂ĂB\n"
	gets
	ey2 = $_.to_f


	diagram.sx[1] = sx1
	diagram.sy[1] = sy1
	diagram.ex[1] = ex1
	diagram.ey[1] = ey1
	diagram.sx[2] = sx2
	diagram.sy[2] = sy2
	diagram.ex[2] = ex2
	diagram.ey[2] = ey2

	diagram.llp

	print " Ans = _ (",sg(diagram.sx[3],10)," , ",sg(diagram.sy[3], 10),")\n"
	print "----- < llp Test End > -----\n"
end





# -------------------------------------------------------------------
# _ƒ̍ŋߓ_iP_ʂ鐂j̃eXg
#
def plp_test
	# ----------------------------------------------------------
	# _ƒ̍ŋߓ_iP_ʂ鐂j
	# 
	#  : 
	#      :  1    (@sx[1] , @sy[1]) - (@ex[1] , @ey[1])
	#      : _ 1    (@sx[2] , @sy[2])
	# ߒl : 
	#      : @Type    0 , 1
	#      : _ 1    (@ex[2] , @ey[2])
	#      : _ 2    (@ex[3] , @ey[3]) _Ɗ֌WȂ_

	diagram = Diagram.new

	print "----- < plp Test Start > -----\n"
	print "_ƒ̍ŋߓ_iP_ʂ鐂j߂܂\n\n"
	print "̎n_X ͂ĂB\n"
	gets
	sx1 = $_.to_f
	print "̎n_Y ͂ĂB\n"
	gets
	sy1 = $_.to_f
	print "̏I_X ͂ĂB\n"
	gets
	ex1 = $_.to_f
	print "̏I_Y ͂ĂB\n"
	gets
	ey1 = $_.to_f

	print "_ X ͂ĂB\n"
	gets
	sx2 = $_.to_f
	print "_ Y ͂ĂB\n"
	gets
	sy2 = $_.to_f


	diagram.sx[1] = sx1
	diagram.sy[1] = sy1
	diagram.ex[1] = ex1
	diagram.ey[1] = ey1
	diagram.sx[2] = sx2
	diagram.sy[2] = sy2

	diagram.plp

	print " Ans = ŋߓ_ (",sg(diagram.ex[2],10)," , ",sg(diagram.ey[2], 10),")\n"
	print " Ans =    (",sg(diagram.sx[2],10)," , ",sg(diagram.sy[2], 10),") - (",sg(diagram.ex[3],10)," , ",sg(diagram.ey[3], 10),"\n"
	print "----- < plp Test End > -----\n"
end





# -------------------------------------------------------------------
# Ɖ~̌_̃eXg
#
def lcp_test
	# -------------------------------------------------------------------
	# Ɖ~̌_
	# lcp
	#  : 
	#      :  1  (@sx[1] , @sy[1]) - (@ex[1] , @ey[1])
	#      : ~ 1  (@cx[1] , @cy[1]) , @r[1]
	# ߒl : 
	#      : @Type   0 , 1 , 2
	#      : _ 1  (@sx[2] , @sy[2])
	#      : _ 2  (@sx[3] , @sy[3])

	diagram = Diagram.new

	print "----- < lcp Test Start > -----\n"
	print "Ɖ~̌_߂܂\n\n"
	print "̎n_X ͂ĂB\n"
	gets
	sx = $_.to_f
	print "̎n_Y ͂ĂB\n"
	gets
	sy = $_.to_f
	print "̏I_X ͂ĂB\n"
	gets
	ex = $_.to_f
	print "̏I_Y ͂ĂB\n"
	gets
	ey = $_.to_f

	print "~̒S X ͂ĂB\n"
	gets
	cx = $_.to_f
	print "~̒S Y ͂ĂB\n"
	gets
	cy = $_.to_f
	print "~̔a R ͂ĂB\n"
	gets
	r = $_.to_f


	diagram.sx[1] = sx
	diagram.sy[1] = sy
	diagram.ex[1] = ex
	diagram.ey[1] = ey
	diagram.cx[1] = cx
	diagram.cy[1] = cy
	diagram.r[1]  = r

	diagram.lcp

	if (diagram.Type > 0) 
		(2..diagram.Type+1).each {|i|
			print " Ans = _ (",sg(diagram.sx[i],10)," , ",sg(diagram.sy[i], 10),")\n"
		}
	end
	print "----- < lcp Test End > -----\n"
end





# -------------------------------------------------------------------
# Q~̌_̃eXg
#
def ccp_test
	# -------------------------------------------------------------------
	# Q~̌_
	# ccp
	#  : 
	#      : ~ 1      (@cx[1] , @cy[1]) , @r[1]
	#      : ~ 2      (@cx[2] , @cy[2]) , @r[2]
	# ߒl : 
	#      : @Type       0 , 1 , 2
	#      : _ 1    (@sx[1] , @sy[1])
	#      : _ 2    (@sx[2] , @sy[2])

	diagram = Diagram.new

	print "----- < ccp Test Start > -----\n"
	print "Q~̌_߂܂\n\n"

	print "~1 ̒S X ͂ĂB\n"
	gets
	cx1 = $_.to_f
	print "~1 ̒S Y ͂ĂB\n"
	gets
	cy1 = $_.to_f
	print "~1 ̔a R ͂ĂB\n"
	gets
	r1 = $_.to_f

	print "~2 ̒S X ͂ĂB\n"
	gets
	cx2 = $_.to_f
	print "~2 ̒S Y ͂ĂB\n"
	gets
	cy2 = $_.to_f
	print "~2 ̔a R ͂ĂB\n"
	gets
	r2 = $_.to_f


	diagram.cx[1] = cx1
	diagram.cy[1] = cy1
	diagram.r[1]  = r1
	diagram.cx[2] = cx2
	diagram.cy[2] = cy2
	diagram.r[2]  = r2

	diagram.ccp

	if (diagram.Type > 0) 
		(1..diagram.Type).each {|i|
			print " Ans = _ (",sg(diagram.sx[i],10)," , ",sg(diagram.sy[i], 10),")\n"
		}
	end
	print "----- < ccp Test End > -----\n"
end





# -------------------------------------------------------------------
# P_ʂ~ɐڂ钼̏I_̃eXg
#
def pcl_test
	# -------------------------------------------------------------------
	# P_ʂ~ɐڂ钼̏I_
	# pcl
	#  : 
	#      : _      (@sx[1] , @sy[1])
	#      : ~      (@cx[1] , @cy[1]) , @r[1]
	# ߒl : 
	#      : @Type    0 , 1 , 21])
	#      : _ 1    (@ex[1] , @ey[1])
	#      : _ 2    (@ex[2] , @ey[2])

	diagram = Diagram.new

	print "----- < pcl Test Start > -----\n"
	print "P_ʂ~ɐڂ钼̏I_߂܂\n\n"

	print "~̒S X ͂ĂB\n"
	gets
	cx = $_.to_f
	print "~̒S Y ͂ĂB\n"
	gets
	cy = $_.to_f
	print "~̔a R ͂ĂB\n"
	gets
	r = $_.to_f

	print "_ X ͂ĂB\n"
	gets
	sx = $_.to_f
	print "_ Y ͂ĂB\n"
	gets
	sy = $_.to_f


	diagram.cx[1] = cx
	diagram.cy[1] = cy
	diagram.r[1]  = r
	diagram.sx[1] = sx
	diagram.sy[1] = sy

	diagram.pcl

	if (diagram.Type > 0) 
		(1..diagram.Type).each {|i|
			print " Ans = ڐ",i," (",sg(diagram.ex[i],10)," , ",sg(diagram.ey[i], 10),") - (",sg(diagram.sx[1],10)," , ",sg(diagram.sy[1], 10),")\n"
		}
	else 
		print "ڐ܂B\n"
	end
	print "----- < pcl Test End > -----\n"
end





# -------------------------------------------------------------------
# Q~ɐڂ钼̃eXg
#
def ccl_test
	# -------------------------------------------------------------------
	# Q~ɐڂ钼
	# ccl
	#  : 
	#      : ~ 1    (@cx[1] , @cy[1]) ,@r[1]
	#      : ~ 2    (@cx[2] , @cy[2]) ,@r[2]
	# ߒl : 
	#      : @Type    0, 1 , 2 , 3 , 4
	#      :  1    (@sx[1] , @sy[1]) - (@ex[1] , @ey[1])
	#      :  2    (@sx[2] , @sy[2]) - (@ex[2] , @ey[2])
	#      :  3    (@sx[3] , @sy[3]) - (@ex[3] , @ey[3])
	#      :  4    (@sx[4] , @sy[4]) - (@ex[4] , @ey[4])

	diagram = Diagram.new

	print "----- < ccl Test Start > -----\n"
	print "P_ʂ~ɐڂ钼̏I_߂܂\n\n"

	print "~1 ̒S X ͂ĂB\n"
	gets
	cx1 = $_.to_f
	print "~1 ̒S Y ͂ĂB\n"
	gets
	cy1 = $_.to_f
	print "~1 ̔a R ͂ĂB\n"
	gets
	r1 = $_.to_f

	print "~2 ̒S X ͂ĂB\n"
	gets
	cx2 = $_.to_f
	print "~2 ̒S Y ͂ĂB\n"
	gets
	cy2 = $_.to_f
	print "~2 ̔a R ͂ĂB\n"
	gets
	r2 = $_.to_f


	diagram.cx[1] = cx1
	diagram.cy[1] = cy1
	diagram.r[1]  = r1
	diagram.cx[2] = cx2
	diagram.cy[2] = cy2
	diagram.r[2]  = r2

	diagram.ccl

	if (diagram.Type > 0) 
		(1..diagram.Type).each {|i|
			print " Ans = ڐ",i," (",sg(diagram.sx[i],10)," , ",sg(diagram.sy[i], 10),") - (",sg(diagram.ex[i],10)," , ",sg(diagram.ey[i], 10),")\n"
		}
	else 
		print "ڐ܂B\n"
	end
	print "----- < ccl Test End > -----\n"
end





# -------------------------------------------------------------------
# P_ʂ~ɐڂ~̃eXg
#
def pcc_test
	# -------------------------------------------------------------------
	# P_ʂ~ɐڂ~
	# pcc
	#  : 
	#      : ߂~̔a    @r[2]
	#      : ~̒S         (@cx[1] , @cy[1]) ,@r[1]
	#      : _               (@sx[1] , @sy[1])
	# ߒl : 
	#      : @Type             0 , 1 , 2 , 3 , 4
	#      : ~ 1             (@cx[2] , @cy[2]) , @r[2]
	#      : ~ 2             (@cx[3] , @cy[3]) , @r[3]
	#      : ~ 3             (@cx[4] , @cy[4]) , @r[4]
	#      : ~ 4             (@cx[5] , @cy[5]) , @r[5]

	diagram = Diagram.new

	print "----- < pcc Test Start > -----\n"
	print "P_ʂ~ɐڂ~߂܂\n\n"

	print "~̒S X ͂ĂB\n"
	gets
	cx1 = $_.to_f
	print "~̒S Y ͂ĂB\n"
	gets
	cy1 = $_.to_f
	print "~̔a R ͂ĂB\n"
	gets
	r1 = $_.to_f

	print "_ X ͂ĂB\n"
	gets
	sx1 = $_.to_f
	print "_ Y ͂ĂB\n"
	gets
	sy1 = $_.to_f

	print "߂~̔a R ͂ĂB\n"
	gets
	r2 = $_.to_f


	diagram.cx[1] = cx1
	diagram.cy[1] = cy1
	diagram.r[1]  = r1
	diagram.sx[1] = sx1
	diagram.sy[1] = sy1
	diagram.r[2]  = r2

	diagram.pcc

	if (diagram.Type > 0) 
		diagram.Type.times {|i|
			print " Ans = ڐ",i+1," (",sg(diagram.cx[i+2],10)," , ",sg(diagram.cy[i+2], 10),") , R",sg(diagram.r[i+2],10),"\n"
		}
	else 
		print "ډ~܂B\n"
	end
	print "----- < pcc Test End > -----\n"
end














__END__
