/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : LayerSet.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/03/18
 *    Last                 : 2007/11/08
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "intl.h"

#include "MemoryLeak.h"
#include "List_cad.h"
#include "List_Dimension.h"
#include "List_PolyLine.h"
#include "List_Block.h"
#include "List_Undo.h"
#include "List_Select.h"
#include "Draw.h"
#include "sagcad.h"
#include "global.h"

#define _LAYERSET_
#include "LayerSet.h"





/* -------------------------------------------------------------------
 * sample_table "expose (再描画)" イベントハンドラ
 * 
 */
gint sample_table_expose_event(GtkWidget *widget, GdkEventExpose *event, LAYERSET_DLG *layerset_dlg)
{
	gint w, h, key;
	GdkGC *lds_gc;
	long BackCol = 0;


	/* widget の値を取得 */
	//g_print("sample_table_expose_event() : 1 !\n");
	key = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(widget), "value"));
	//g_print("sample_table_expose_event() : 1 !\n");

	/* 背景色設定 */
	/*  */
	if (key == 0) BackCol = 0xff0000;
	else if (key == 1) BackCol = 0xffff00;
	else if (key == 2) BackCol = 0x808000;
	else if (key == 3) BackCol = 0x0000ff;
	else if (key == 4) BackCol = 0x000080;
	else BackCol = 0xffffff;

	/* GC 作成 */
	lds_gc = create_gc(widget);

	/* ドローイングアレアの大きさ取得 */
	w = widget->allocation.width;
	h = widget->allocation.height;

	PenSet(lds_gc, 1, BackCol);
	gdk_draw_rectangle (widget->window, lds_gc, TRUE, 0, 0, w, h);

	PenSet(lds_gc, 1, 0xe0e0e0);
	gdk_draw_line(widget->window, lds_gc, 0, 0, w, 0);
	gdk_draw_line(widget->window, lds_gc, 0, h, w, h);
	gdk_draw_line(widget->window, lds_gc, 0, 0, 0, h);
	gdk_draw_line(widget->window, lds_gc, w, 0, w, h);

	PenSet(lds_gc, 1, 0x000000);
	gdk_draw_line(widget->window, lds_gc, 1, 1, w-1, 1);
	gdk_draw_line(widget->window, lds_gc, 1, h-1, w-1, h-1);
	gdk_draw_line(widget->window, lds_gc, 1, 1, 1, h-1);
	gdk_draw_line(widget->window, lds_gc, w-1, 1, w-1, h-1);

	/* GC 開放 */
	delete_gc(lds_gc);

	return FALSE;
}





/* -------------------------------------------------------------------
 * OK Button Press
 * 
 */
void layerset_dlg_ok_pushed(GtkWidget *widget, LAYERSET_DLG *layerset_dlg)
{
	layerset_dlg->value = 1;
	return;
}



int layer_no_check(GtkWidget *widget, LAYERSET_DLG *layerset_dlg)
{
	int i;
	for (i = 0; i < layerset_dlg->use_layer; i++) {
		if (layerset_dlg->Layer_widget[i] == widget) {
			return i;
		}
	}
	return -1;
}



/* -------------------------------------------------------------------
 * layer_box "expose (再描画)"
 * 
 */
int layer_area_draw(GtkWidget *widget, LAYERSET_DLG *layerset_dlg)
{
	gint w, h, layerNo = -1;
	GdkGC *ld_gc;
	long BackCol = 0, TextCol = 0;
	GdkFont *font;
	char str[256];
	int locateX = 3, locateY = 18;
	
	
	layerNo = layer_no_check(widget, layerset_dlg);
	if (layerNo < 0) {
		g_print("error : check no = %d !\n", layerNo);
		return FALSE;
	}
	else if (layerNo > layerset_dlg->use_layer && layerNo < 256) {
		//g_print("error : use_layer  : check no = %d !\n", layerNo);
		return FALSE;
	}
	else {
		//g_print("check no = %d !\n", layerNo);
	}
	
	/* widget の値を取得 */
	//g_print("layer_area_draw() : 1 !\n");
	//layerNo = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(widget), "value"));
	//g_print("layer_area_draw() : 2 !\n");


	/* 表示文字列設定 */
	if (layerNo < 10) sprintf(str, "0%d", layerNo);
	else sprintf(str, "%d", layerNo);


	/* 背景色と文字色の設定 */
	if (Layer[layerNo].draw == 1 && Layer[layerNo].data == 1) {
		TextCol = 0x000000;
		BackCol = 0xffff00;
	}
	else if (Layer[layerNo].draw == 1 && Layer[layerNo].data == 0) {
		TextCol = 0xffffff;
		BackCol = 0x808000;
	}
	else if (Layer[layerNo].draw == 0 && Layer[layerNo].data == 1) {
		TextCol = 0xffffff;
		BackCol = 0x0000ff;
	}
	else if (Layer[layerNo].draw == 0 && Layer[layerNo].data == 0) {
		TextCol = 0xffffff;
		BackCol = 0x000080;
	}
	
	if (NowLayer == layerNo) {
		TextCol = 0xffffff;
		BackCol = 0xff0000;
	}

	/* GC 作成 */
	ld_gc = gdk_gc_new(widget->window);

	font = gdk_font_load(
		"-adobe-helvetica-medium-r-normal--*-120-*-*-*-*-*-*");


	/* ドローイングアレアの大きさ取得 */
	w = widget->allocation.width;
	h = widget->allocation.height;

	PenSet(ld_gc, 1, BackCol);
	gdk_draw_rectangle (widget->window, ld_gc, TRUE, 0, 0, w, h);

	PenSet(ld_gc, 1, 0xe0e0e0);
	gdk_draw_line(widget->window, ld_gc, 0, 0, w, 0);
	gdk_draw_line(widget->window, ld_gc, 0, h, w, h);
	gdk_draw_line(widget->window, ld_gc, 0, 0, 0, h);
	gdk_draw_line(widget->window, ld_gc, w, 0, w, h);

	PenSet(ld_gc, 1, 0x000000);
	gdk_draw_line(widget->window, ld_gc, 1, 1, w-1, 1);
	gdk_draw_line(widget->window, ld_gc, 1, h-1, w-1, h-1);
	gdk_draw_line(widget->window, ld_gc, 1, 1, 1, h-1);
	gdk_draw_line(widget->window, ld_gc, w-1, 1, w-1, h-1);

	/* バックカラーも指定 */
	PenSet_with_back(ld_gc, 1, TextCol, BackCol);
	if (layerset_dlg->use_layer < 101) {
		locateX = 5;
	}
	else if (w == 33 && layerNo < 100) {
		locateX = 8;
	}
	gdk_draw_string(widget->window, font, ld_gc, locateX, locateY, str);
	//g_print("w = %d  locate (%d,%d)\n", w, locateX, locateY);

	/* GC 開放 */
	gdk_gc_destroy(ld_gc);

	return FALSE;
}





/* -------------------------------------------------------------------
 * All on "clicked"
 * 
 */
void layerset_dlg_on_pushed(GtkWidget *widget, LAYERSET_DLG *layerset_dlg)
{
	gint i;


	for (i = 0 ; i < 256 ; i++) {
//		if (Layer[i].data == 1) {
			Layer[i].draw = 1;
			layer_area_draw(layerset_dlg->Layer_widget[i], layerset_dlg);
//		}
	}
	if (sagcad_system.RealTimeLayerSet == 1) Redraw();
}





/* -------------------------------------------------------------------
 * All off "clicked"
 * 
 */
void layerset_dlg_off_pushed(GtkWidget *widget, LAYERSET_DLG *layerset_dlg)
{
	gint i;

	for (i = 0 ; i < 256 ; i++) {
//		if (Layer[i].data == 1) {
			if (i != NowLayer) Layer[i].draw = 0;
			layer_area_draw(layerset_dlg->Layer_widget[i], layerset_dlg);
//		}
	}
	if (sagcad_system.RealTimeLayerSet == 1) Redraw();
}





/* -------------------------------------------------------------------
 * layer_area "button_press_event (マウスクリック)" イベントハンドラ
 * 
 */
int layer_area_button_press_event(GtkWidget *widget, GdkEventButton *event, LAYERSET_DLG *layerset_dlg)
{
	int layerNo, old;
	char str[256];


	/* widget の値を取得 */
	//g_print("layer_area_button_press_event() : 1 !\n");
	layerNo = GPOINTER_TO_INT(g_object_get_data(G_OBJECT(widget), "value"));
	//g_print("layer_area_button_press_event() : 2 !\n");


	/* 左ボタン */
	if (event->button == 1) {
		if (layerNo != NowLayer) {
			if (Layer[layerNo].draw == 1) Layer[layerNo].draw = 0;
			else if (Layer[layerNo].draw == 0) Layer[layerNo].draw = 1;
		}
	}
	/* 右ボタン */
	else if (event->button == 3) {
		old = NowLayer;
		Layer[old].draw = sagcad_system.LostCurrent;
		
		NowLayer = layerNo;
		Layer[layerNo].draw = 1; 

		/* テキストエントリーから文字列を取得 */
		strcpy(str, gtk_entry_get_text(GTK_ENTRY(layerset_dlg->entry)));
		strcpy(Layer[old].name ,str);


		gtk_entry_set_text(GTK_ENTRY(layerset_dlg->entry), Layer[NowLayer].name);
		sprintf(str,"Layer-%d [ %s ]", NowLayer, Layer[NowLayer].name);
		gtk_label_set_text(GTK_LABEL(layer), str);

		layer_area_draw(layerset_dlg->Layer_widget[old], layerset_dlg);
	}

	/* 中ボタン */
//	else if (event->button == 3) ;

	layer_area_draw(layerset_dlg->Layer_widget[layerNo], layerset_dlg);
	
	if (sagcad_system.RealTimeLayerSet == 1) Redraw();
	return TRUE;
}





/* -------------------------------------------------------------------
 * layer_area "expose (再描画)" イベントハンドラ
 * 
 */
gint layer_area_expose_event(GtkWidget *widget, GdkEventExpose *event, LAYERSET_DLG *layerset_dlg)
{
	layer_area_draw(widget, layerset_dlg);
	return FALSE;
}





/* -------------------------------------------------------------------
 * レイヤー設定
 * 
 */
gint LayerSetDialog(LAYERSET_DLG *layerset_dlg)
{
	gint i, j, k, max, x, y, l, parent_x, parent_y;
	gchar str[20];
	CAD_LIST *p;
	DIMENSION_LIST *pd;
	POLYLINE_LIST *pld;


//	GtkWidget *dialog;
		GtkWidget *main_vbox;
			GtkWidget *table;
				GtkWidget *layer_area;

			GtkWidget *separator;

			GtkWidget *action_vbox;
				GtkWidget *name_hbox;
					GtkWidget *name_label;
//					GtkWidget *name_entry;
				GtkWidget *sample_table;
					GtkWidget *label;
					GtkWidget *current_draw;
					GtkWidget *on_o_draw;
					GtkWidget *on_x_draw;
					GtkWidget *off_o_draw;
					GtkWidget *off_x_draw;
				GtkWidget *button_hbox;
					GtkWidget *on_buttun;
					GtkWidget *off_buttun;
					GtkWidget *ok_buttun;


	/* 初期化 */
	i = 0;
	while (i < 256 ) {
		Layer[i].data = 0;
		i++;
	}
	/* 図形データがあれば 1 */
	p = cad_list_info.head;
	while (p != NULL) {
		Layer[p->cad->layer].data = 1;
		p = p->next;
	}
	/* 寸法データがあれば 1 */
	pd = dimension_list_info.head;
	while (pd != NULL) {
		Layer[pd->dimension->Layer].data = 1;
		pd = pd->next;
	}
	/* ポリラインデータがあれば 1 */
	pld = polyline_list_info.head;
	while(pld != NULL) {
		Layer[pld->polyline->layer].data = 1;
		pld = pld->next;
	}
	
	/* (use_layer < max) の処理 -> use_layer を増やす */
	i = 0;
	max = 0;
	while (i < 256 ) {
		if (Layer[i].data == 1) {
			if (max < i) max = i;
		}
		i++;
	}
	if (use_layer < max) {
		layerset_dlg->use_layer = max + 1;
		g_print("over use_layer !\n");
	}
	else {
		layerset_dlg->use_layer = use_layer;
		//g_print("in use_layer !\n");
	}
	
	/* カレントレイヤーが layerset_dlg->use_layer を超えている */
	if (NowLayer > layerset_dlg->use_layer - 1) {
		NowLayer = 0;
		//Redraw();
	}


	/* ダイアログ(copy_dlg->dialog)生成 (GTK_WIN_POS_MOUSE  GTK_WIN_POS_CENTER) */
	layerset_dlg->dialog = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(layerset_dlg->dialog), _("Layer Setting") );
	
	//gtk_window_set_position(GTK_WINDOW(layerset_dlg->dialog), GTK_WIN_POS_MOUSE);
	gtk_window_get_position(GTK_WINDOW(MainWindow), &parent_x, &parent_y);
	gtk_window_move(GTK_WINDOW(layerset_dlg->dialog), parent_x + 72, parent_y + 89);
	
	//gtk_window_set_keep_above (GTK_WINDOW(layerset_dlg->dialog), FALSE);
	/* ダイアログを最前面に表示する */
	gtk_window_set_modal(GTK_WINDOW(layerset_dlg->dialog), TRUE);
	/* メインウィンドウを操作できないように設定 */
	gtk_window_set_transient_for(GTK_WINDOW(layerset_dlg->dialog), 
				GTK_WINDOW(layerset_dlg->parent));


		/* ダイアログの中にまず、パッキングボックス(main_vbox)を作成 */
		main_vbox = gtk_vbox_new(FALSE, 2);
		gtk_container_add(GTK_CONTAINER(layerset_dlg->dialog), main_vbox);
		gtk_container_set_border_width(GTK_CONTAINER(layerset_dlg->dialog), 5);
		gtk_widget_show(main_vbox);
		
			/* テーブルコンテナ作成 */
			//g_print("layerset_dlg->use_layer = %d\n", layerset_dlg->use_layer);
			table = gtk_table_new(10, (layerset_dlg->use_layer / 10), FALSE);
			gtk_box_pack_start( GTK_BOX(main_vbox), table, FALSE, FALSE, 0);
			gtk_widget_show(table);
			
			/* y の計算 */
			j = ((layerset_dlg->use_layer + 1) / 10) * 10;
			k = layerset_dlg->use_layer - j;
			if (k > 0) j++;
			
			for (x = 0 ; x < 10 ; x++) {
				for (y = 0 ; y < j; y++) {
					l = y * 10 + x;
					sprintf(str, "%d", l);
					
					if (l < layerset_dlg->use_layer && l < 256 ) {
						layer_area = gtk_drawing_area_new();
						//g_print("Layer_widget[%d] : %d\n", l, (long)layer_area);
						
						layerset_dlg->Layer_widget[l] = layer_area;
						layerset_dlg->layerNo = l;
						/* ドローイングエリアのサイズ設定 */
						if (layerset_dlg->use_layer < 101) {
							gtk_widget_set_size_request( GTK_WIDGET(layer_area), 
										LAYER_AREA_HEIGHT, LAYER_AREA_HEIGHT);
						}
						else {
							gtk_widget_set_size_request( GTK_WIDGET(layer_area), 
										LAYER_AREA_WIDTH, LAYER_AREA_HEIGHT);
						}
						gtk_table_attach_defaults(GTK_TABLE(table), layer_area, x, x+1, y, y+1);
						g_object_set_data(G_OBJECT(layer_area), "value", (gpointer)l);
						
						/* "expose_event" イベントハンドラ設定 */
						g_signal_connect(G_OBJECT(layer_area), "expose_event",
								   G_CALLBACK(layer_area_expose_event), (gpointer)layerset_dlg);
						/* "button_press_event" イベントハンドラ設定 */
						g_signal_connect(G_OBJECT(layer_area), "button_press_event",
								   G_CALLBACK(layer_area_button_press_event), (gpointer)layerset_dlg);
						/* イベントマスク設定 */
						gtk_widget_set_events(layer_area,  GDK_EXPOSURE_MASK
														 | GDK_LEAVE_NOTIFY_MASK
														 | GDK_BUTTON_PRESS_MASK
														 | GDK_POINTER_MOTION_MASK
														 | GDK_POINTER_MOTION_HINT_MASK);
						gtk_widget_show(layer_area);
					}
				}
			}
			
			/* セパレーター(separator) */
			separator = gtk_hseparator_new();
			gtk_box_pack_start( GTK_BOX(main_vbox), separator, FALSE, FALSE, 0);
			gtk_widget_show(separator);
			
			/* パッキングボックス(action_vbox) */
			action_vbox = gtk_vbox_new(FALSE, 2);
			gtk_box_pack_start( GTK_BOX(main_vbox), action_vbox, FALSE, FALSE, 0);
			gtk_widget_show(action_vbox);
			
				/* パッキングボックス(name_hbox) */
				name_hbox = gtk_hbox_new(FALSE, 2);
				gtk_box_pack_start( GTK_BOX(action_vbox), name_hbox, TRUE, TRUE, 0);
				gtk_widget_show(name_hbox);
				
					/* ラベル生成 (name_label) */
					name_label = gtk_label_new( _("Active Layer Name") );
					gtk_box_pack_start((GtkBox *)GTK_BOX(name_hbox), name_label, TRUE, TRUE, 0);
					gtk_label_set_justify(GTK_LABEL(name_label), GTK_JUSTIFY_LEFT);
					gtk_widget_show(name_label);
					
					/* テキストエントリー生成 (name_entry) */
					layerset_dlg->entry = gtk_entry_new();
					gtk_box_pack_start((GtkBox *)GTK_BOX(name_hbox), layerset_dlg->entry, TRUE, TRUE, 1);
					gtk_entry_set_max_length(GTK_ENTRY(layerset_dlg->entry), 256);
					/* 初期値設定 */
					gtk_entry_set_text(GTK_ENTRY(layerset_dlg->entry), Layer[NowLayer].name);
					gtk_widget_show(layerset_dlg->entry);
					
				/* セパレーター(separator) */
				separator = gtk_hseparator_new();
				gtk_box_pack_start( GTK_BOX(action_vbox), separator, FALSE, FALSE, 0);
				gtk_widget_show(separator);
				
				/* テーブルパッキングボックス(sample_table) */
				sample_table = gtk_table_new(4, 3, FALSE);
				gtk_box_pack_start( GTK_BOX(action_vbox), sample_table, FALSE, FALSE, 0);
				gtk_widget_show(sample_table);
				
					/* カレントレイヤーのサンプル */
					current_draw = gtk_drawing_area_new();
					gtk_widget_set_size_request( GTK_WIDGET(current_draw), SAMPLE_LAYER_AREA_WIDTH, SAMPLE_LAYER_AREA_HEIGHT);
					gtk_table_attach(GTK_TABLE(sample_table), current_draw, 
								0, 1, 0, 1, 0, 0, 0, 0);
					g_object_set_data(G_OBJECT(current_draw), "value", (gpointer)0);
					/* "expose_event" イベントハンドラ設定 */
					g_signal_connect(G_OBJECT(current_draw), "expose_event",
									   G_CALLBACK(sample_table_expose_event), (gpointer)layerset_dlg);
					/* イベントマスク設定 */
					gtk_widget_set_events(layer_area, GDK_EXPOSURE_MASK);
					gtk_widget_show(current_draw);

					/* ラベル生成 (label) */
					label = gtk_label_new( _("Active") );
					gtk_table_attach(GTK_TABLE(sample_table), label, 1, 2, 0, 1, GTK_FILL | GTK_EXPAND, 0, 0, 0);
					gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_LEFT);
					gtk_widget_show(label);


					/* on_o のサンプル */
					on_o_draw = gtk_drawing_area_new();
					gtk_widget_set_size_request( GTK_WIDGET(on_o_draw), SAMPLE_LAYER_AREA_WIDTH, SAMPLE_LAYER_AREA_HEIGHT);
					gtk_table_attach(GTK_TABLE(sample_table), on_o_draw, 0, 1, 1, 2, 0,0,0,0);
					g_object_set_data(G_OBJECT(on_o_draw), "value", (gpointer)1);
					/* "expose_event" イベントハンドラ設定 */
					g_signal_connect(G_OBJECT(on_o_draw), "expose_event",
									   G_CALLBACK(sample_table_expose_event), (gpointer)layerset_dlg);
					/* イベントマスク設定 */
					gtk_widget_set_events(on_o_draw, GDK_EXPOSURE_MASK);
					gtk_widget_show(on_o_draw);

					/* ラベル生成 (label) */
					label = gtk_label_new( _("display-on Data-O") );
					gtk_table_attach(GTK_TABLE(sample_table), label, 1, 2, 1, 2, GTK_FILL | GTK_EXPAND, 0, 0, 0);
					gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_LEFT);
					gtk_widget_show(label);


					/* on_x のサンプル */
					on_x_draw = gtk_drawing_area_new();
					gtk_widget_set_size_request( GTK_WIDGET(on_x_draw), SAMPLE_LAYER_AREA_WIDTH, SAMPLE_LAYER_AREA_HEIGHT);
					gtk_table_attach(GTK_TABLE(sample_table), on_x_draw, 2, 3, 1, 2, 0,0,0,0);
					g_object_set_data(G_OBJECT(on_x_draw), "value", (gpointer)2);
					/* "expose_event" イベントハンドラ設定 */
					g_signal_connect(G_OBJECT(on_x_draw), "expose_event",
									   G_CALLBACK(sample_table_expose_event), (gpointer)layerset_dlg);
					/* イベントマスク設定 */
					gtk_widget_set_events(on_x_draw, GDK_EXPOSURE_MASK);
					gtk_widget_show(on_x_draw);

					/* ラベル生成 (label) */
					label = gtk_label_new( _("display-on Data-X") );
					gtk_table_attach(GTK_TABLE(sample_table), label, 3, 4, 1, 2, GTK_FILL | GTK_EXPAND, 0, 0, 0);
					gtk_widget_show(label);


					/* off_o のサンプル */
					off_o_draw = gtk_drawing_area_new();
					gtk_widget_set_size_request( GTK_WIDGET(off_o_draw), SAMPLE_LAYER_AREA_WIDTH, SAMPLE_LAYER_AREA_HEIGHT);
					gtk_table_attach(GTK_TABLE(sample_table), off_o_draw, 0, 1, 2, 3, 0,0,0,0);
					g_object_set_data(G_OBJECT(off_o_draw), "value", (gpointer)3);
					/* "expose_event" イベントハンドラ設定 */
					g_signal_connect(G_OBJECT(off_o_draw), "expose_event",
									   G_CALLBACK(sample_table_expose_event), (gpointer)layerset_dlg);
					/* イベントマスク設定 */
					gtk_widget_set_events(off_o_draw, GDK_EXPOSURE_MASK);
					gtk_widget_show(off_o_draw);

					/* ラベル生成 (label) */
					label = gtk_label_new( _("display-off Data-O") );
					gtk_table_attach(GTK_TABLE(sample_table), label, 1, 2, 2, 3, GTK_FILL | GTK_EXPAND, 0, 0, 0);
					gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_LEFT);
					gtk_widget_show(label);


					/* off_x のサンプル */
					off_x_draw = gtk_drawing_area_new();
					gtk_widget_set_size_request( GTK_WIDGET(off_x_draw), SAMPLE_LAYER_AREA_WIDTH, SAMPLE_LAYER_AREA_HEIGHT);
					gtk_table_attach(GTK_TABLE(sample_table), off_x_draw, 2, 3, 2, 3, 0,0,0,0);
					g_object_set_data(G_OBJECT(off_x_draw), "value", (gpointer)4);
					/* "expose_event" イベントハンドラ設定 */
					g_signal_connect(G_OBJECT(off_x_draw), "expose_event",
									   G_CALLBACK(sample_table_expose_event), (gpointer)layerset_dlg);
					/* イベントマスク設定 */
					gtk_widget_set_events(off_x_draw, GDK_EXPOSURE_MASK);
					gtk_widget_show(off_x_draw);

					/* ラベル生成 (label) */
					label = gtk_label_new( _("display-off Data-X") );
					gtk_table_attach(GTK_TABLE(sample_table), label, 3, 4, 2, 3, GTK_FILL | GTK_EXPAND, 0, 0, 0);
					gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_LEFT);
					gtk_widget_show(label);



				/* セパレーター(separator) */
				separator = gtk_hseparator_new();
				gtk_box_pack_start( GTK_BOX(action_vbox), separator, FALSE, FALSE, 0);
				gtk_widget_show(separator);


				/* パッキングボックス(button_hbox) */
				button_hbox = gtk_hbox_new(FALSE, 2);
				gtk_box_pack_start( GTK_BOX(action_vbox), button_hbox, FALSE, FALSE, 0);
				gtk_widget_show(button_hbox);

					/* ON ボタンの生成 */
					on_buttun = gtk_button_new_with_label("All on");
					gtk_box_pack_start((GtkBox *)GTK_BOX(button_hbox), on_buttun, TRUE, TRUE, 2);
					g_signal_connect(G_OBJECT(on_buttun), "clicked", 
									   G_CALLBACK(layerset_dlg_on_pushed), /*(gpointer)*/layerset_dlg);
					gtk_widget_show(on_buttun);


					/* OFF ボタンの生成 */
					off_buttun = gtk_button_new_with_label("All off");
					gtk_box_pack_start((GtkBox *)GTK_BOX(button_hbox), off_buttun, TRUE, TRUE, 2);
					g_signal_connect(G_OBJECT(off_buttun), "clicked", 
									   G_CALLBACK(layerset_dlg_off_pushed), /*(gpointer)*/layerset_dlg);
					gtk_widget_show(off_buttun);


					/* OKボタンの生成 */
					ok_buttun = gtk_button_new_with_label("OK");
					gtk_box_pack_start((GtkBox *)GTK_BOX(button_hbox), ok_buttun, TRUE, TRUE, 2);
					g_signal_connect(G_OBJECT(ok_buttun), "clicked", G_CALLBACK(layerset_dlg_ok_pushed), layerset_dlg);
					g_signal_connect(G_OBJECT(ok_buttun), "clicked", G_CALLBACK(gtk_main_quit), NULL);
					gtk_widget_show(ok_buttun);


	/* ダイアログを可視状態へ */
	gtk_widget_show(layerset_dlg->dialog);
	/* メインイベントループ */
	gtk_main();
	gtk_widget_destroy(layerset_dlg->dialog);
	return 0; 
}





/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : LayerSet.c
 * ====================================================================
 */
