/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : List_insert.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/03/23
 *    Last                 : 2007/11/08
 * ====================================================================
 */
#ifndef __LIST_INSERT_H__
#define __LIST_INSERT_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 : 前処理  (struct #define etc)
 * -------------------------------------------------------
 */



/* -------------------------------------------------------
 * 2 : 外部変数 (global)
 * -------------------------------------------------------
 */
#ifdef _LIST_INSERT_
#define   GLOBAL
/* 初期値設定 */
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
/* 初期値設定の代入部分を無くす */
#define   GLOBAL_VAL(v)  /* */
#endif


	GLOBAL INSERT_LIST *p_insert_list;
	GLOBAL INSERT_LIST_INFO insert_list_info;


#undef  GLOBAL
#undef  GLOBAL_VAL
#undef _LIST_INSERT_



/* -------------------------------------------------------
 * 3 : 外部関数 (Function)
 * -------------------------------------------------------
 */
int init_insert(INSERT *insert);
INSERT_LIST *r_insert_list_add_first(INSERT *add_insert, INSERT_LIST_INFO *p_insert_list_info);
/* INSERT Data をリストの最初に追加 */
INSERT_LIST *insert_list_add_first(INSERT *add_insert, INSERT_LIST_INFO *p_insert_list_info);
/* INSERT Data をリストの最初に追加して、 Undo Baffer に書込む */
INSERT_LIST *insert_list_add_first_with_undo(INSERT *add_insert, INSERT_LIST_INFO *p_insert_list_info);

/* INSERT Data をリストの最後に追加 */
INSERT_LIST *insert_list_add_last(INSERT *add_insert, INSERT_LIST_INFO *p_insert_list_info);
/* INSERT Data をリストの最後に追加、 Undo Baffer に書込む */
INSERT_LIST *insert_list_add_last_with_undo(INSERT *add_insert, INSERT_LIST_INFO *p_insert_list_info);

/* INSERT Data の削除機能 (メモリの削除ではない) */
int insert_list_delete(INSERT_LIST *del_List, INSERT_LIST_INFO *p_insert_list_info);
/* INSERT Data の削除機能 (メモリの削除ではなく、Undo Buffer へ移す) */
int insert_list_delete_Undo(INSERT_LIST *del_List, INSERT_LIST_INFO *p_insert_list_info);

/* INSERT Data を変更する */
INSERT_LIST *insert_list_edit(INSERT_LIST *point, INSERT *change_insert, INSERT_LIST_INFO *p_insert_list_info);
/* INSERT Data を変更する、 Undo Baffer に書込む */
INSERT_LIST *insert_list_edit_with_undo(INSERT_LIST *point, INSERT *change_insert, INSERT_LIST_INFO *p_insert_list_info);

/* リストの総数を調べる */
long insert_list_num(INSERT_LIST_INFO *p_insert_list_info);
/* n 番目のデータの検索 */
INSERT_LIST *insert_search_num(long search_number, INSERT_LIST_INFO *p_insert_list_info);
/* データの検索(INSERT *p_insert から INSERT_LIST を求める) */
INSERT_LIST *insert_search_insert(INSERT *p_insert, INSERT_LIST_INFO *p_insert_list_info);
/* データの検索(INSERT *p_insert から Data No. の long 値を求める) */
long insert_search_insert_to_num(INSERT *p_insert, INSERT_LIST_INFO *p_insert_list_info);


/* INSERT Data をリストから削除 */
int insert_list_free(INSERT_LIST *del_List, INSERT_LIST_INFO *p_insert_list_info);
/* 全リストを削除 */
void insert_list_all_free(INSERT_LIST_INFO *p_insert_list_info);

/* INSERT リストを表示 */
void insert_list_print(INSERT_LIST_INFO *p_insert_list_info);



#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __LIST_INSERT_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : List_insert.h
 * ====================================================================
 */
