// Code generated by go-swagger; DO NOT EDIT.

package provisioning

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"0xacab.org/leap/bitmask-core/models"
)

// Get5BridgeLocationReader is a Reader for the Get5BridgeLocation structure.
type Get5BridgeLocationReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *Get5BridgeLocationReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGet5BridgeLocationOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGet5BridgeLocationBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewGet5BridgeLocationNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGet5BridgeLocationInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /5/bridge/{location}] Get5BridgeLocation", response, response.Code())
	}
}

// NewGet5BridgeLocationOK creates a Get5BridgeLocationOK with default headers values
func NewGet5BridgeLocationOK() *Get5BridgeLocationOK {
	return &Get5BridgeLocationOK{}
}

/*
Get5BridgeLocationOK describes a response with status code 200, with default header values.

OK
*/
type Get5BridgeLocationOK struct {
	Payload []*models.ModelsBridge
}

// IsSuccess returns true when this get5 bridge location o k response has a 2xx status code
func (o *Get5BridgeLocationOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get5 bridge location o k response has a 3xx status code
func (o *Get5BridgeLocationOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get5 bridge location o k response has a 4xx status code
func (o *Get5BridgeLocationOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get5 bridge location o k response has a 5xx status code
func (o *Get5BridgeLocationOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get5 bridge location o k response a status code equal to that given
func (o *Get5BridgeLocationOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get5 bridge location o k response
func (o *Get5BridgeLocationOK) Code() int {
	return 200
}

func (o *Get5BridgeLocationOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /5/bridge/{location}][%d] get5BridgeLocationOK %s", 200, payload)
}

func (o *Get5BridgeLocationOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /5/bridge/{location}][%d] get5BridgeLocationOK %s", 200, payload)
}

func (o *Get5BridgeLocationOK) GetPayload() []*models.ModelsBridge {
	return o.Payload
}

func (o *Get5BridgeLocationOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGet5BridgeLocationBadRequest creates a Get5BridgeLocationBadRequest with default headers values
func NewGet5BridgeLocationBadRequest() *Get5BridgeLocationBadRequest {
	return &Get5BridgeLocationBadRequest{}
}

/*
Get5BridgeLocationBadRequest describes a response with status code 400, with default header values.

Bad Request
*/
type Get5BridgeLocationBadRequest struct {
	Payload interface{}
}

// IsSuccess returns true when this get5 bridge location bad request response has a 2xx status code
func (o *Get5BridgeLocationBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get5 bridge location bad request response has a 3xx status code
func (o *Get5BridgeLocationBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get5 bridge location bad request response has a 4xx status code
func (o *Get5BridgeLocationBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get5 bridge location bad request response has a 5xx status code
func (o *Get5BridgeLocationBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get5 bridge location bad request response a status code equal to that given
func (o *Get5BridgeLocationBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get5 bridge location bad request response
func (o *Get5BridgeLocationBadRequest) Code() int {
	return 400
}

func (o *Get5BridgeLocationBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /5/bridge/{location}][%d] get5BridgeLocationBadRequest %s", 400, payload)
}

func (o *Get5BridgeLocationBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /5/bridge/{location}][%d] get5BridgeLocationBadRequest %s", 400, payload)
}

func (o *Get5BridgeLocationBadRequest) GetPayload() interface{} {
	return o.Payload
}

func (o *Get5BridgeLocationBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGet5BridgeLocationNotFound creates a Get5BridgeLocationNotFound with default headers values
func NewGet5BridgeLocationNotFound() *Get5BridgeLocationNotFound {
	return &Get5BridgeLocationNotFound{}
}

/*
Get5BridgeLocationNotFound describes a response with status code 404, with default header values.

Not Found
*/
type Get5BridgeLocationNotFound struct {
	Payload interface{}
}

// IsSuccess returns true when this get5 bridge location not found response has a 2xx status code
func (o *Get5BridgeLocationNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get5 bridge location not found response has a 3xx status code
func (o *Get5BridgeLocationNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get5 bridge location not found response has a 4xx status code
func (o *Get5BridgeLocationNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get5 bridge location not found response has a 5xx status code
func (o *Get5BridgeLocationNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get5 bridge location not found response a status code equal to that given
func (o *Get5BridgeLocationNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get5 bridge location not found response
func (o *Get5BridgeLocationNotFound) Code() int {
	return 404
}

func (o *Get5BridgeLocationNotFound) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /5/bridge/{location}][%d] get5BridgeLocationNotFound %s", 404, payload)
}

func (o *Get5BridgeLocationNotFound) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /5/bridge/{location}][%d] get5BridgeLocationNotFound %s", 404, payload)
}

func (o *Get5BridgeLocationNotFound) GetPayload() interface{} {
	return o.Payload
}

func (o *Get5BridgeLocationNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGet5BridgeLocationInternalServerError creates a Get5BridgeLocationInternalServerError with default headers values
func NewGet5BridgeLocationInternalServerError() *Get5BridgeLocationInternalServerError {
	return &Get5BridgeLocationInternalServerError{}
}

/*
Get5BridgeLocationInternalServerError describes a response with status code 500, with default header values.

Internal Server Error
*/
type Get5BridgeLocationInternalServerError struct {
	Payload interface{}
}

// IsSuccess returns true when this get5 bridge location internal server error response has a 2xx status code
func (o *Get5BridgeLocationInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get5 bridge location internal server error response has a 3xx status code
func (o *Get5BridgeLocationInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get5 bridge location internal server error response has a 4xx status code
func (o *Get5BridgeLocationInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get5 bridge location internal server error response has a 5xx status code
func (o *Get5BridgeLocationInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get5 bridge location internal server error response a status code equal to that given
func (o *Get5BridgeLocationInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get5 bridge location internal server error response
func (o *Get5BridgeLocationInternalServerError) Code() int {
	return 500
}

func (o *Get5BridgeLocationInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /5/bridge/{location}][%d] get5BridgeLocationInternalServerError %s", 500, payload)
}

func (o *Get5BridgeLocationInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /5/bridge/{location}][%d] get5BridgeLocationInternalServerError %s", 500, payload)
}

func (o *Get5BridgeLocationInternalServerError) GetPayload() interface{} {
	return o.Payload
}

func (o *Get5BridgeLocationInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
