/*  RipOff - Plugin based CD Ripper
 *  Copyright (C) 2006 Bobby Ryan Newberry
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include <libxml/parser.h>
#ifndef RIPOFFGUI_H
#define RIPOFFGUI_H

#include "RipOff.h"

void ripoff_config_file_set_config_file_pointer(xmlDocPtr ptr);

xmlDocPtr ripoff_config_file_get_config_file_pointer();

gboolean ripoff_config_file_save_int(gchar *module_name, gchar *key, const gint value);

gboolean ripoff_config_file_save_string(gchar *module_name, gchar *key, const gchar *value);

gboolean ripoff_config_file_save_boolean(gchar *module_name, gchar *key, const gboolean value);

gboolean ripoff_config_file_save_double(gchar *module_name, gchar *key, const gdouble value);

gint ripoff_config_file_retrieve_int(gchar *module_name, gchar *key, gint default_val);

/* NOTE: Returned string should always be freed.
A copy of default_val is returned if no value is found, 
instead of returning the original pointer to default_val
Free default_val as needed*/
gchar *ripoff_config_file_retrieve_string(gchar *module_name, gchar *key, const gchar *default_val);

gboolean ripoff_config_file_retrieve_boolean(gchar *module_name, gchar *key, gboolean default_val);

gdouble ripoff_config_file_retrieve_double(gchar *module_name, gchar *key, gdouble default_val );

gboolean ripoff_config_file_write_config_file_to_disc();
#endif
