template <class T>
csr<T> neumann_laplace_assembly (const csr<T>& a, const vec<T>& b) {
  size_t n = a.nrow();
  asr<T> A (n+1, n+1);
  Array<size_t>::const_iterator ia = a.ia().begin();
  Array<size_t>::const_iterator ja = a.ja().begin();
  typename Array<T>::const_iterator va = a.a().begin();
  typename Array<T>::const_iterator vb = b.begin();
  for (size_t i = 0; i < n; i++) {
    for (size_t p = ia[i]; p < ia[i+1]; p++) {
      A.entry(i,ja[p]) = va[p];
    }
    A.entry(i,n) = A.entry(n,i) = vb[i];
  }
  return csr<T>(A);
}
