///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "lumped_mass.h"
using namespace rheolef;
using namespace std;

// TODO : force trapeze quadrature formulae when using non-constant weight
// because quadrature formulae degree is automatically computed
// for an exact approximation !!
// Actually, the lumped weighted matrix does not coincide with
// the local mass matrix with trapeze quadrature formulae

void
lumped_mass::operator() (const geo_element& K, ublas::matrix<Float>& lumped_m) const
{
  build_general_mass (K, lumped_m);
  check_macro (lumped_m.size1() == lumped_m.size2(),
	"lumped_mass: incompatible `" << get_first_basis().name()
	<< "' and `" << get_second_basis().name() << "' basis");
  size_type n = lumped_m.size1();
  for (size_type i = 0; i < n; i++) {
    Float s = 0;
    for (size_type j = 0; j < n; j++) {
      if (i != j) {
	s += lumped_m(i,j);
	lumped_m(i,j) = 0;
      }
    }
    lumped_m (i,i) += s;
  }
}
void
lumped_mass::check_after_initialize () const
{
  check_macro (
	"P0" == get_first_space().get_approx() ||
	"P1" == get_first_space().get_approx() ||
	"P1d" == get_first_space().get_approx(),
	"unsupported continuous approximation space for `lumped_mass' form");
  if (is_weighted()) {
      fem_helper::valued_field_type weight_valued = _wh.get_valued_type();
      check_macro (weight_valued == fem_helper::scalar,
	"unsupported non-scalar weight for `lumped_mass' form");
  }
}
