#include "rheolef.h"
using namespace rheolef;
using namespace std;
#include "elasticity_solve.icc"
#include "elasticity_criterion.icc"
#include "embankment.icc"
int main(int argc, char**argv) {
  environment rheolef (argc, argv);
  const Float lambda = 1;
  geo  omega (argv[1]);
  adapt_option_type options;
  string approx  = (argc > 2) ? argv[2] : "P1";
  options.err    = (argc > 3) ? atof(argv[3]) : 5e-3;
  size_t n_adapt = (argc > 4) ? atoi(argv[4]) : 5;
  options.hmin   = 0.004;
  for (size_t i = 0; true; i++) {
    space Xh = embankment_space (omega, approx);
    field uh = elasticity_solve (Xh, lambda);
    odiststream of (omega.name(), "field");
    of << catchmark("lambda")  << lambda << endl
       << catchmark("u")       << uh;
    if (i == n_adapt) break;
    field ch = elasticity_criterion (lambda,uh);
    omega = adapt(ch, options);
    odiststream og (omega.name(), "geo");
    og << omega;
  }
}
