///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
//
// animations using vtk
//
// author: Pierre.Saramito@imag.fr
//
// date: 4 may 2001
//
#include "rheolef/branch.h"
#include "rheolef/iofem.h"
#include "rheolef/iorheo.h"
#include "rheolef/rheostream.h"
namespace rheolef {
using namespace std;

// extern:
template <class T> odiststream& field_put_vtk (odiststream&, const field_basic<T,sequential>&, std::string, bool);

template<class T>
void
put_header_paraview (odiststream& out, const branch_basic<T,sequential>&)
{
}
template<class T>
void 
put_event_paraview (odiststream& ods, const branch_basic<T,sequential>& b)
{
    // open the data file
    ostream& out = ods.os();
    string basename = iorheo::getbasename(out);
    if (basename == "") basename = "output";
    string data_file_name = basename + "-" + itos(b._count_value) + ".vtk";
    ofstream vtk (data_file_name.c_str());
    odiststream ods_vtk (vtk);
    bool verbose = iorheo::getverbose(clog);
    verbose && clog << "! file `" << data_file_name << "' created" << endl;
    vtk << setbasename(basename)
        << setprecision(numeric_limits<T>::digits10);

    check_macro (b.n_field() > 0, "empty branch (n_field = 0)");
    const field_basic<T,sequential>& u0 = b[0].second;
    string approx = u0.get_approx();
    bool put_geo = true;
    for (size_t i = 0; i < b.n_field(); i++) {
      const string&                     name = b[i].first;
      const field_basic<T,sequential>&  ui   = b[i].second;
      check_macro (ui.get_approx() == approx,
	"field #"<<i<<" name '"<<name<<": approx `"<<ui.get_approx()<<"' incompatible with field #0 approx `"<<approx<<"'");
      field_put_vtk (ods_vtk, ui, name, put_geo);
      put_geo = false;
    }
    vtk.close();
}
template<class T>
void 
put_finalize_paraview (odiststream& out, const branch_basic<T,sequential>& b)
{
}
// ----------------------------------------------------------------------------
// instanciation in library
// ----------------------------------------------------------------------------
template void put_header_paraview   (odiststream&, const branch_basic<Float,sequential>&);
template void put_event_paraview    (odiststream&, const branch_basic<Float,sequential>&);
template void put_finalize_paraview (odiststream&, const branch_basic<Float,sequential>&);

} // namespace rheolef
