# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2024 Raritan Inc. All rights reserved.
#
# This file was generated by IdlC from CardReaderManager.idl.

use strict;

package Raritan::RPC::smartcard::CardReaderManager_1_0_5;

use parent qw(Raritan::RPC::RemoteObject);

use constant typeId => "smartcard.CardReaderManager:1.0.5";

sub new {
    my ($class, $agent, $rid, $typeId) = @_;
    $typeId = $typeId || Raritan::RPC::smartcard::CardReaderManager_1_0_5::typeId;
    return $class->SUPER::new($agent, $rid, $typeId);
}


sub getCardReaders($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getCardReaders', $args);
    my $_ret_;
    $_ret_ = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        $_ret_->[$i0] = Raritan::RPC::ObjectCodec::decode($agent, $rsp->{'_ret_'}->[$i0], 'smartcard.CardReader');
    }
    return $_ret_;
}


sub getCardReaderById($$) {
    my ($self, $readerId) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'readerId'} = "$readerId";
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getCardReaderById', $args);
    my $_ret_;
    $_ret_ = Raritan::RPC::ObjectCodec::decode($agent, $rsp->{'_ret_'}, 'smartcard.CardReader');
    return $_ret_;
}

use Raritan::RPC::smartcard::CardReaderManager_1_0_5::CardReaderSettings;

sub setCardReaderSettings($$$) {
    my ($self, $position, $setting) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'position'} = "$position";
    $args->{'setting'} = Raritan::RPC::smartcard::CardReaderManager_1_0_5::CardReaderSettings::encode($setting);
    my $rsp = $agent->json_rpc($self->{'rid'}, 'setCardReaderSettings', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::smartcard::CardReaderManager_1_0_5::CardReaderSettings;

sub getAllCardReaderSettings($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getAllCardReaderSettings', $args);
    my $_ret_;
    $_ret_ = {};
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        my $key0 = $rsp->{'_ret_'}->[$i0]->{'key'};
        my $value0 = Raritan::RPC::smartcard::CardReaderManager_1_0_5::CardReaderSettings::decode($agent, $rsp->{'_ret_'}->[$i0]->{'value'});
        $_ret_->{$key0} = $value0;
    }
    return $_ret_;
}

sub getSupportedCardFormats($) {
    my ($self) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'getSupportedCardFormats', $args);
    my $_ret_;
    $_ret_ = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'_ret_'}}; $i0++) {
        $_ret_->[$i0] = $rsp->{'_ret_'}->[$i0];
    }
    return $_ret_;
}

Raritan::RPC::Registry::registerProxyClass('smartcard.CardReaderManager', 1, 0, 5, 'Raritan::RPC::smartcard::CardReaderManager_1_0_5');
1;
