// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2024 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from DisplayControl.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.display {
  public class DisplayControl : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("display.DisplayControl:1.0.0", null);

    public DisplayControl(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public DisplayControl(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new DisplayControl StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new DisplayControl(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public const int SUCCESS = 0;

    public const int ERR_INVALID_VALUE = 1;

    public class DefaultViewItem : ICloneable {
      public object Clone() {
        DefaultViewItem copy = new DefaultViewItem();
        copy.id = this.id;
        copy.description = this.description;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["id"] = this.id;
        json["description"] = this.description;
        return json;
      }

      public static DefaultViewItem Decode(LightJson.JsonObject json, Agent agent) {
        DefaultViewItem inst = new DefaultViewItem();
        inst.id = (string)json["id"];
        inst.description = (string)json["description"];
        return inst;
      }

      public string id = "";
      public string description = "";
    }

    public class GetAvailableDefaultViewsResult {
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.display.DisplayControl.DefaultViewItem> _ret_;
    }

    public GetAvailableDefaultViewsResult getAvailableDefaultViews() {
      JsonObject _parameters = null;
      var _result = RpcCall("getAvailableDefaultViews", _parameters);
      var _ret = new GetAvailableDefaultViewsResult();
      _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.display.DisplayControl.DefaultViewItem>(_result["_ret_"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.display.DisplayControl.DefaultViewItem.Decode(_value, agent)));
      return _ret;
    }

    public AsyncRequest getAvailableDefaultViews(AsyncRpcResponse<GetAvailableDefaultViewsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getAvailableDefaultViews(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getAvailableDefaultViews(AsyncRpcResponse<GetAvailableDefaultViewsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getAvailableDefaultViews", _parameters,
        _result => {
          try {
            var _ret = new GetAvailableDefaultViewsResult();
            _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.display.DisplayControl.DefaultViewItem>(_result["_ret_"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.display.DisplayControl.DefaultViewItem.Decode(_value, agent)));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetDefaultViewResult {
      public string _ret_;
    }

    public GetDefaultViewResult getDefaultView() {
      JsonObject _parameters = null;
      var _result = RpcCall("getDefaultView", _parameters);
      var _ret = new GetDefaultViewResult();
      _ret._ret_ = (string)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest getDefaultView(AsyncRpcResponse<GetDefaultViewResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getDefaultView(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getDefaultView(AsyncRpcResponse<GetDefaultViewResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getDefaultView", _parameters,
        _result => {
          try {
            var _ret = new GetDefaultViewResult();
            _ret._ret_ = (string)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetDefaultViewResult {
      public int _ret_;
    }

    public SetDefaultViewResult setDefaultView(string id) {
      var _parameters = new LightJson.JsonObject();
      _parameters["id"] = id;

      var _result = RpcCall("setDefaultView", _parameters);
      var _ret = new SetDefaultViewResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setDefaultView(string id, AsyncRpcResponse<SetDefaultViewResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setDefaultView(id, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setDefaultView(string id, AsyncRpcResponse<SetDefaultViewResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["id"] = id;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setDefaultView", _parameters,
        _result => {
          try {
            var _ret = new SetDefaultViewResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
