% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isOrdered.R
\name{isOrdered}
\alias{isOrdered}
\title{Check If A Vector Is Ordered}
\usage{
isOrdered(x, increasing = TRUE, strictly = TRUE)
}
\arguments{
\item{x}{A numeric vector.}

\item{increasing}{Test for increasing (\code{TRUE}) or decreasing (\code{FALSE}) values?}

\item{strictly}{When \code{TRUE}, vectors with duplicate values are \emph{not}
considered ordered.}
}
\value{
A logical scalar indicating whether or not \code{x} is ordered.
}
\description{
Check if a vector is strictly increasing, strictly decreasing, not
decreasing, or not increasing.
}
\details{
Designed for internal use with \pkg{xts}, this provides highly optimized
tests for ordering.
}
\examples{

# strictly increasing
isOrdered(1:10, increasing=TRUE)
isOrdered(1:10, increasing=FALSE)
isOrdered(c(1,1:10), increasing=TRUE)
isOrdered(c(1,1:10), increasing=TRUE, strictly=FALSE)

# decreasing
isOrdered(10:1, increasing=TRUE)
isOrdered(10:1, increasing=FALSE)

}
\seealso{
\code{\link[=is.unsorted]{is.unsorted()}}
}
\author{
Jeffrey A. Ryan
}
\keyword{misc}
