% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seurat.R
\name{colMeans,Seurat-method}
\alias{colMeans,Seurat-method}
\alias{colSums,Seurat-method}
\alias{rowMeans,Seurat-method}
\alias{rowSums,Seurat-method}
\title{Row and Column Sums and Means}
\usage{
\S4method{colMeans}{Seurat}(x, na.rm = FALSE, dims = 1, ..., slot = "data")

\S4method{colSums}{Seurat}(x, na.rm = FALSE, dims = 1, ..., slot = "data")

\S4method{rowMeans}{Seurat}(x, na.rm = FALSE, dims = 1, ..., slot = "data")

\S4method{rowSums}{Seurat}(x, na.rm = FALSE, dims = 1, ..., slot = "data")
}
\arguments{
\item{x}{A \code{\link{Seurat}} object}

\item{na.rm}{logical.  Should missing values (including \code{NaN})
    be omitted from the calculations?}

\item{dims}{completely ignored by the \code{Matrix} methods.}

\item{...}{potentially further arguments, for method \code{<->}
    generic compatibility.}

\item{slot}{Name of assay expression matrix to calculate column/row
means/sums on}
}
\value{
\code{colMeans}: the column (cell-wise) means of \code{slot}

\code{colSums}: the column (cell-wise) sums of \code{slot}

\code{rowMeans}: the row (feature-wise) means of \code{slot}

\code{rowSums}: the row (feature-wise) sums of \code{slot}
}
\description{
Calculate \code{\link{rowSums}}, \code{\link{colSums}},
\code{\link{rowMeans}}, and \code{\link{colMeans}} on
\code{\link{Seurat}} objects
}
\examples{
head(colMeans(pbmc_small))

head(colSums(pbmc_small))

head(rowMeans(pbmc_small))

head(rowSums(pbmc_small))

}
\seealso{
\code{\link{Seurat}}
}
\concept{seurat}
\keyword{internal}
