% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assay5.R
\docType{class}
\name{Assay5T-class}
\alias{Assay5T-class}
\alias{Assay5T}
\title{The Transposed v5 \code{Assay} Object}
\description{
The Transposed v5 \code{Assay} Object
}
\section{Slots}{

\describe{
\item{\code{layers}}{A named list containing expression matrices; each matrix should
be a two-dimensional object containing some subset of cells and features
defined in the \code{cells} and \code{features} slots. Cell and feature
membership is recorded in the \code{cells} and \code{features} slots,
respectively}

\item{\code{cells}}{A \link[=LogMap]{logical mapping} of cell names
and layer membership; this map contains all the possible cells that this
assay can contain. New layers must have some subset of cells present
in this map}

\item{\code{features}}{A \link[=LogMap]{logical mapping} of feature
names and layer membership; this map contains all the possible features that
this assay can contain. New layers must have some subset of features
present in this map}

\item{\code{default}}{A one-length integer with the end index of the
\link[=DefaultLayer]{default layer}; the default layer be
all layers up to and including the layer at index \code{default}}

\item{\code{assay.orig}}{Original assay that this assay is based off of;
used to track assay provenance}

\item{\code{meta.data}}{A \link[base:data.frame]{data frame} with feature-level
meta data; should have the same number of rows as \code{features}}

\item{\code{misc}}{A named list of unstructured miscellaneous data}

\item{\code{key}}{A one-length character vector with the object's key; keys must
be one or more alphanumeric characters followed by an underscore
\dQuote{\code{_}} (regex pattern
\dQuote{\code{\Sexpr[stage=build]{SeuratObject:::.KeyPattern()}}})}
}}

\section{Lifecycle}{


\Sexpr[stage=build,results=rd]{lifecycle::badge("experimental")}

\strong{Warning}: functionality described here is experimental and prone to
change without notice
}

\keyword{internal}
